/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONGROUP_H__
#define __QZIONGROUP_H__

#include "qzionobject.h"

class QZionGroupPrivate;

/*!
    \class QZionGroup
    \brief An item containing other items.

    A QZionGroup is an QZionObject, but it is also a QZionAbstractCanvas,
    so you can add children items to it. Just an inner canvas, if you prefer.
*/
class QZionGroup : public QZionObject, public QZionAbstractCanvas
{
    Q_OBJECT

public:
    /*! */
    QZionGroup(QZionAbstractCanvas *canvas = NULL);
    /*!
    Destroys the QZionGroup. If the group has items, all the items will
    be deleted.
    */
    virtual ~QZionGroup();

    /*! */
    virtual void changed();

    /*! */
    virtual void paint(QPainter *p);

    /*!
      Returns the bouding rect of all children.
    */
    virtual QRect rect() const;

    virtual QSize size() const;
    virtual void setSize(const QSize &size);

    /*! */
    virtual void ensurePendingUpdate();
    /*! */
    virtual void invalidate(const QRect &r, bool translate = true);
    /*! */
    virtual void invalidate(const QRegion &r, bool translate = true);

    inline virtual QColor color() const;
    virtual void setColor(const QColor &color);

    virtual void setClipper(QZionRectangle *rect);

    virtual int canvasWidth() const;
    virtual int canvasHeight() const;

    virtual QPoint mapToLocal(const QPoint &pt) const;

    virtual void mouseMoveEvent(QMouseEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void wheelEvent(QWheelEvent *e);

    bool contains(const QPoint &point) const;

    /*!
      Returns the cummulative color top-down from parents.
    */
    virtual QColor effectiveColor();

public Q_SLOTS:
    /*! */
    virtual void updateChanges();

protected:
    QZionGroupPrivate *_QZionGroup_data;

    QSize _size;
    mutable QRect _lastChildRect;
    mutable bool _childRectChanged;

    /*! */
    virtual void paintInternal(QPainter *p, const QRect &prect, const QRegion &preg,
                               const QPoint &delta, double cumulativeOpacity);

    friend class QZionGroupPrivate;
};

inline QColor QZionGroup::color() const
{
    return QColor(255, 255, 255);
}

#endif
