/******************************************************************************
 *  Copyright (C) 2012-2020 by                                                *
 *    Ralf Lange (ralf.lange@longsoft.de)                                     *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the                             *
 *  Free Software Foundation, Inc.,                                           *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.                 *
 ******************************************************************************/

#include "grabbercontrolcapabilities.h"


GrabberControlCapabilities::GrabberControlCapabilities()
{
    ctrl_id    = 0;
    ctrl_class = 0;
    minimum    = 0L;
    maximum    = 0L;
    step       = 0L;
    defaultt   = 0L;
    flags      = control_none;
}


GrabberControlCapabilities::~GrabberControlCapabilities()
{
}


bool GrabberControlCapabilities::isCapability()
{
    if (getFlags() != GrabberControlCapabilities::control_none) {
        return true;
    }
    return false;
}


bool GrabberControlCapabilities::isAutomatic()
{
    if (getFlags() == GrabberControlCapabilities::control_Auto) {
        return true;
    }

    return false;
}


unsigned int GrabberControlCapabilities::getControlId()
{
    return ctrl_id;
}


void GrabberControlCapabilities::setControlId(unsigned int id)
{
    ctrl_id = id;
}


unsigned int GrabberControlCapabilities::getControlClass()
{
    return ctrl_class;
}


void GrabberControlCapabilities::setControlClass(unsigned int cl)
{
    ctrl_class = cl;
}


unsigned int GrabberControlCapabilities::getControlType()
{
    return ctrl_type;
}


void GrabberControlCapabilities::setControlType(unsigned int ct)
{
    ctrl_type = ct;
}


int GrabberControlCapabilities::getMinimum()
{
    return minimum;
}


void GrabberControlCapabilities::setMinimum(int mi)
{
    minimum = mi;
}


int GrabberControlCapabilities::getMaximum()
{
    return maximum;
}


void GrabberControlCapabilities::setMaximum(int ma)
{
    maximum = ma;
}


int GrabberControlCapabilities::getStep()
{
    return step;
}


void GrabberControlCapabilities::setStep(int st)
{
    step = st;
}


int GrabberControlCapabilities::getDefault()
{
    return defaultt;
}


void GrabberControlCapabilities::setDefault(int de)
{
    defaultt = de;
}


long GrabberControlCapabilities::getFlags()
{
    return flags;
}


void GrabberControlCapabilities::setFlags(long fl)
{
    flags = fl;
}
