#ifndef TXWIDGET_H
#define TXWIDGET_H

#include <QWidget>
#include "widgets/imageviewer.h"
#include "sstv/sstvparam.h"
#include "txfunctions.h"
#include "drmtx/drmtransmitter.h"

class drmTransmitter;
namespace Ui {
    class txWidget;
}

class txWidget : public QWidget
{
    Q_OBJECT

public:
  explicit txWidget(QWidget *parent = 0);
    ~txWidget();
  void init();
  void start(bool st, bool check=true);
  void writeSettings();
  void readSettings();
  imageViewer *getImagePtr();
  void repeat(QImage *im,esstvMode sm);
  void setImage(QImage *ima);
  void setImage(QString fn);
  void setProgress(uint prg);
  void setupTemplatesComboBox();
  void setPreviewWidget(QString fn);
  void setSettingsTab();
  txFunctions *functionsPtr() {return txFunctionsPtr;}
  imageViewer *getImageViewerPtr(){ return imageViewerPtr;}
  bool prepareFIX(QByteArray bsrByteArray);
//  bool prepareHybrid(QString fn);
  bool prepareText(QString txt);
  void copyProfile(drmTxParams d);
  void setProfileNames();


//  void test();
//  void sendFIX();
  void sendBSR();
  void sendWfText();
  void sendID();

public slots:
  void slotGetParams();
  void slotStart();
  void slotStop();
  void slotDisplayStatusMessage(QString);

  void slotGenerateSignal();
  void slotSweepSignal();
  void slotGenerateRepeaterTone();
  void slotEdit();
//  void slotReplay();
  void slotRepeaterTimer();
  void slotFileOpen();
  void slotModeChanged(int);
  void slotSnapshot();
  void slotSize(int);
  void slotSizeApply();
  void slotTransmissionMode(int rxtxMode);
  void slotProfileChanged(int );
  void slotImageChanged();

private:
    Ui::txWidget *ui;
    txFunctions *txFunctionsPtr;
    void initView();
    void setParams();
    editor *ed;
    QTimer *repeaterTimer;
    int repeaterIndex;
    QImage origImage;
    QImage resultImage;
    void applyTemplate();
    imageViewer *imageViewerPtr;
    etransmissionMode currentTXMode;
    drmTxParams drmParams;
    int sizeRatio;
    bool sizeRatioChanged;
    int drmProfileIdx;

};

extern txWidget *txWidgetPtr;

#endif // TXWIDGET_H







