/**************************************************************************
*   Copyright (C) 2000-2012 by Johan Maes                                 *
*   on4qz@telenet.be                                                      *
*   http://users.telenet.be/on4qz                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "configdialog.h"
#include "configparams.h"

#include <QPushButton>
#include <QComboBox>
#include <QSettings>
#include "sstv/sstvparam.h"
//#include <QImage>
#include <QImageWriter>
#include "qsstvglobal.h"
#include "utils/supportfunctions.h"
#include "videocapt/videocapture.h"
#include "rig/rigcontrol.h"
#include "mainwindow.h"
#include "sound/soundcontrol.h"
#include "txwidget.h"
#include "utils/ftp.h"
#include "utils/hybridcrypt.h"
#include <errno.h>

/**
	\class configDialog 
	
	The configDialog provides access to the application-wide configuration parameters.
*/



/**
  constructor for configDialog
*/
configDialog::configDialog(QWidget *, const char *) :Ui::configForm()
{
	setupUi(this);
  int i=0;
  setModal(false);
  foreach (QByteArray format, QImageWriter::supportedImageFormats())
    {
      QString text = tr("%1").arg(QString(format));
      defaultImageFormatComboBox->addItem(text);
      ftpDefaultImageFormatComboBox->addItem(text);
    }
  for(i=0;i<(NUMSSTVMODES-1);i++) // exclude Calibrate
    {
      repeaterTxModeComboBox->addItem(getSSTVModeNameLong((esstvMode)i));
    }
  rigWidget->attachRigController(rigControllerR1);
//  rigR2Widget->attachRigController(rigControllerR2);
  readSettings();
	connect(rxImagesPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseRxImagesPath()));
	connect(txImagesPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseTxImagesPath()));
	connect(templatesPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseTemplatesPath()));
  connect(audioPathBrowseButton,SIGNAL(clicked()),SLOT(slotBrowseAudioPath()));
  connect(rp1BrowseButton,SIGNAL(clicked()),SLOT(slotRp1BrowseButton()));
  connect(rp2BrowseButton,SIGNAL(clicked()),SLOT(slotRp2BrowseButton()));
  connect(rp3BrowseButton,SIGNAL(clicked()),SLOT(slotRp3BrowseButton()));
  connect(rp4BrowseButton,SIGNAL(clicked()),SLOT(slotRp4BrowseButton()));
  connect(repeaterTemplateBrowseButton,SIGNAL(clicked()),SLOT(slotRepeaterTemplateBrowseButton()));
  connect(idleTemplateBrowseButton,SIGNAL(clicked()),SLOT(slotIdleTemplateBrowseButton()));
  drmProfilePtr=drmProfileWidget;
  tabWidget->setCurrentIndex(0);
  connect(testFTPPushButton,SIGNAL(clicked()),SLOT(slotTestFTPPushButton()));
  connect(testHybridPushButton,SIGNAL(clicked()),SLOT(slotTestHybridPushButton()));
}

/**
	destructor for configDialog
*/
configDialog::~configDialog()
{
}

/** read variables from config file

	Read the config file and initializes the variables. If not found, default values will be used.
	\sa writeSettings
	
*/
void configDialog::readSettings()
{
    QSettings qSettings;
    qSettings.beginGroup("Config");
    myCallsign=qSettings.value("callsign",QString("NOCALL")).toString();
    myQth=qSettings.value("qth",QString("NOWHERE")).toString();
    myLastname=qSettings.value("lastname",QString("NONAME")).toString();
    myFirstname=qSettings.value("firstname",QString("NOFIRSTNAME")).toString();
    myLocator=qSettings.value("locator",QString("NOLOCATOR")).toString();

    rxImagesPath=qSettings.value("rxImagesPath",QString(getenv("HOME"))+"/").toString();
    txImagesPath=qSettings.value("txImagesPath",QString(getenv("HOME"))+"/").toString();
    templatesPath=qSettings.value("templatesPath",QString(getenv("HOME"))+"/").toString();
    docURL=qSettings.value("docURL","http://users.telenet.be/on4qz/qsstv/manual").toString();
    audioPath=qSettings.value("audioPath",QString(getenv("HOME"))+"/").toString();
    defaultImageFormat=qSettings.value("defaultImageFormat","png").toString();
    //	fontString=qSettings.value("fontString","").toString();
    samplingrate=qSettings.value("samplingrate",11025).toInt();
    cwText=qSettings.value("cwtext","").toString();
    cwTone=qSettings.value("cwtone",800).toInt();
    cwWPM=qSettings.value("cwWPM",12).toInt();
    enableFTP=qSettings.value("enableFTP",false).toBool();
    ftpPort=qSettings.value("ftpPort",21).toInt();
    ftpRemoteHost=qSettings.value("ftpRemoteHost","").toString();
    ftpRemoteDirectory=qSettings.value("ftpRemoteDirectory","").toString();
    ftpLogin=qSettings.value("ftpLogin","").toString();
    ftpPassword=qSettings.value("ftpPassword","").toString();
    ftpFilename=qSettings.value("ftpFilename","").toString();
    ftpDefaultImageFormat=qSettings.value("ftpDefaultImageFormat","png").toString();
    ftpSaveFormat=(eftpSaveFormat)qSettings.value("ftpSaveFormat",0).toInt();
    ftpNumImages=qSettings.value("ftpNumImages",30).toInt();


    enableHybridRx=qSettings.value("enableHybridRx",true).toBool();
    enableSpecialServer=qSettings.value("enableSpecialServer",false).toBool();
    hybridFtpPort=qSettings.value("hybridFtpPort",21).toInt();
    hybridFtpRemoteHost=qSettings.value("hybridFtpRemoteHost","").toString();
    hybridFtpRemoteDirectory=qSettings.value("hybridFtpRemoteDirectory","").toString();
    hybridFtpHybridFilesDirectory=qSettings.value("hybridFtpHybridFilesDirectory","HybridFiles1").toString();
    hybridFtpLogin=qSettings.value("hybridFtpLogin","").toString();
    hybridFtpPassword=qSettings.value("hybridFtpPassword","").toString();
    repeaterImageInterval=qSettings.value("repeaterImageInterval",10).toInt();
    repeaterEnable=qSettings.value("repeaterEnable",false).toBool();
    repeaterTxMode=(esstvMode)qSettings.value("repeaterTxMode",0).toInt();
    repeaterImage1=qSettings.value("repeaterImage1","").toString();
    repeaterImage2=qSettings.value("repeaterImage2","").toString();
    repeaterImage3=qSettings.value("repeaterImage3","").toString();
    repeaterImage4=qSettings.value("repeaterImage4","").toString();
    repeaterAcknowledge=qSettings.value("repeaterAcknowledge","").toString();
    repeaterTemplate=qSettings.value("repeaterTemplate","").toString();
    idleTemplate=qSettings.value("idleTemplate","").toString();
    videoDevice=qSettings.value("videoDevice","/dev/video0").toString();
    channelNumber=qSettings.value("channelNumber",0).toInt();
    //	framesPerSecondIndex=qSettings.value("framesPerSecondIndex",0).toInt();
    colorFormatIndex=qSettings.value("colorFormatIndex",0).toInt();
    // DRM
    startPicWF=qSettings.value("startPicWF","START PIC").toString();
    endPicWF=qSettings.value("endPicWF","END PIC").toString();
    fixWF=qSettings.value("fixWF","FIX").toString();
    bsrWF=qSettings.value("bsrWF","BSR").toString();

    sizeIndex=qSettings.value("sizeIndex",0).toInt();
    qSettings.endGroup();
    setParams();
    soundWidget->readSettings();
    rigWidget->readSettings();
}

/**
 write variables to config file
        \sa readSettings

*/
void configDialog::writeSettings()
{
    rigWidget->writeSettings();
    soundWidget->writeSettings();
    getParams();
    QSettings qSettings;
    qSettings.beginGroup("Config");
    qSettings.setValue("callsign",myCallsign);
    qSettings.setValue("qth",myQth);
    qSettings.setValue("locator",myLocator);
    qSettings.setValue("lastname",myLastname);
    qSettings.setValue("firstname",myFirstname);
    qSettings.setValue("rxImagesPath",rxImagesPath);
    qSettings.setValue("txImagesPath",txImagesPath);
    qSettings.setValue("templatesPath",templatesPath);
    qSettings.setValue("audioPath",audioPath);
    qSettings.setValue("docURL",docURL);
    qSettings.setValue("defaultImageFormat",defaultImageFormat);
    //	qSettings.setValue("fontString",fontString);
    qSettings.setValue("samplingrate",samplingrate);
    qSettings.setValue("cwtext",cwText);
    qSettings.setValue("cwtone",cwTone);
    qSettings.setValue("cwWPM",cwWPM);
    qSettings.setValue("enableFTP",enableFTP);
    qSettings.setValue("ftpPort",ftpPort);
    qSettings.setValue("ftpRemoteHost",ftpRemoteHost);
    qSettings.setValue("ftpRemoteDirectory",ftpRemoteDirectory);
    qSettings.setValue("ftpLogin",ftpLogin);
    qSettings.setValue("ftpPassword",ftpPassword);
    qSettings.setValue("ftpFilename",ftpFilename);
    qSettings.setValue("ftpDefaultImageFormat",ftpDefaultImageFormat);
    qSettings.setValue("ftpSaveFormat",(int)ftpSaveFormat);
    qSettings.setValue("ftpNumImages",ftpNumImages);
    qSettings.setValue("repeaterImageInterval",repeaterImageInterval);
    qSettings.setValue("enableHybridRx",enableHybridRx);
    qSettings.setValue("enableSpecialServer",enableSpecialServer);
    qSettings.setValue("hybridFtpPort",hybridFtpPort);
    qSettings.setValue("hybridFtpRemoteHost",hybridFtpRemoteHost);
    qSettings.setValue("hybridFtpRemoteDirectory",hybridFtpRemoteDirectory);
    qSettings.setValue("hybridFtpHybridFilesDirectory",hybridFtpHybridFilesDirectory);
    qSettings.setValue("hybridFtpLogin",hybridFtpLogin);
    qSettings.setValue("hybridFtpPassword",hybridFtpPassword);
    qSettings.setValue("repeaterEnable",repeaterEnable);
    qSettings.setValue("repeaterTxMode",repeaterTxMode);
    qSettings.setValue("repeaterImage1",repeaterImage1);
    qSettings.setValue("repeaterImage2",repeaterImage2);
    qSettings.setValue("repeaterImage3",repeaterImage3);
    qSettings.setValue("repeaterImage4",repeaterImage4);
    qSettings.setValue("repeaterAcknowledge",repeaterAcknowledge);
    qSettings.setValue("repeaterTemplate",repeaterTemplate);
    qSettings.setValue("idleTemplate",idleTemplate);
    qSettings.setValue("videoDevice",videoDevice);
    qSettings.setValue("channelNumber",channelNumber);
    //	qSettings.setValue("framesPerSecondIndex",framesPerSecondIndex);
    qSettings.setValue("colorFormatIndex",colorFormatIndex);
    qSettings.setValue("sizeIndex",sizeIndex);
    qSettings.setValue("startPicWF",startPicWF);
    qSettings.setValue("endPicWF",endPicWF);
    qSettings.setValue("fixWF",fixWF);
    qSettings.setValue("bsrWF",bsrWF);
    qSettings.endGroup();
    drmProfileWidget->writeSettings();
}


/**
    Opens the configuration dialog
*/

int configDialog::exec()
{
    videoCapture vc;
    int i=0;
    colorFormatComboBox->clear();
    sizeComboBox->clear();

    if(vc.open())
    {
        QList <QString> description;
        vc.getFormatList(description);
        for(i=0;i<description.count();i++)
        {
            colorFormatComboBox->addItem(description[i]);
        }

        QList<QSize> sizeList(vc.getSizesList());

        for(i=0;i<sizeList.count();i++)
        {
            sizeComboBox->addItem(QString::number(sizeList[i].width())+ " x " + QString::number(sizeList[i].height()));
        }
        vc.close();
    }
    setParams();
    soundWidget->setParams();
    drmProfileWidget->setParams();
    if(QDialog::exec())
    {
        writeSettings();
        txWidgetPtr->setProfileNames();
        mainWindowPtr->setNewFont();
        return QDialog::Accepted;
    }
    else
    {
        return QDialog::Rejected;
    }
}

/**
 copies the values from the variables to the userinterface
		\sa getParams
	
*/

void configDialog::setParams()
{

    setValue(myCallsign,callsignLineEdit);
    setValue(myLastname,lastnameLineEdit);
    setValue(myFirstname,firstnameLineEdit);
    setValue(myQth,qthLineEdit);
    setValue(myLocator,locatorLineEdit);
    setValue(rxImagesPath, rxImagesPathLineEdit);
    setValue(txImagesPath, txImagesPathLineEdit);
    setValue(templatesPath, templatesPathLineEdit);
    setValue(audioPath, audioPathLineEdit);
    setValue(docURL, docPathLineEdit);
    setValue(defaultImageFormat, defaultImageFormatComboBox);

    QFont fnt;
    //  fnt.fromString(fontString);
    //  fontComboBox->setCurrentFont(fnt);
    //  setValue(fnt.pointSize(),fontSizeSpinBox);

    setValue(cwText,cwTextLineEdit);
    setValue(cwTone,cwToneSpinBox);
    setValue(cwWPM,cwWPMSpinBox);
    setValue(enableFTP,enableFTPCheckBox);
    setValue(ftpPort,ftpPortSpinBox);
    setValue(ftpRemoteHost,remoteHostLineEdit);
    setValue(ftpRemoteDirectory,remoteDirectoryLineEdit);
    setValue(ftpLogin,ftpLoginLineEdit);
    setValue(ftpPassword,ftpPasswordLineEdit);
    if(ftpSaveFormat==FTPIM)
      {
        imageRadioButton->setChecked(true);
      }
    else
      {
        filenameRadioButton->setChecked(true);
      }
    setValue(ftpNumImages,ftpNumImagesSpinBox);
    setValue(enableHybridRx,enableHybridRxCheckBox);
    setValue(enableSpecialServer,enableSpecialServerCheckBox);
    setValue(hybridFtpPort,hybridFtpPortSpinBox);
    setValue(hybridFtpRemoteHost,hybridRemoteHostLineEdit);
    setValue(hybridFtpRemoteDirectory,hybridRemoteDirectoryLineEdit);
    setValue(hybridFtpHybridFilesDirectory,hybridFilesDirectoryLineEdit);
    setValue(hybridFtpLogin,hybridFtpLoginLineEdit);
    setValue(hybridFtpPassword,hybridFtpPasswordLineEdit);

    setValue(ftpDefaultImageFormat,ftpDefaultImageFormatComboBox);
    setValue(repeaterEnable,repeaterEnableCheckBox);
    setIndex(repeaterTxMode,repeaterTxModeComboBox);
    setValue(repeaterImage1,repeaterImage1LineEdit);
    setValue(repeaterImage2,repeaterImage2LineEdit);
    setValue(repeaterImage3,repeaterImage3LineEdit);
    setValue(repeaterImage4,repeaterImage4LineEdit);
    setValue(idleTemplate,idleTemplateLineEdit);
    setValue(repeaterTemplate,repeaterTemplateLineEdit);
    setValue(videoDevice,videoDeviceLineEdit);
    setValue(channelNumber, channelSpinBox);
    setIndex(colorFormatIndex,colorFormatComboBox);
    setIndex(sizeIndex,sizeComboBox);

    setValue(startPicWF,startPicTextEdit);
    setValue(endPicWF,endPicTextEdit);
    setValue(fixWF,fixTextEdit);
    setValue(bsrWF,bsrTextEdit);
}

/**
 copies the values from the userinterface to the variables

		\sa setParams
	
*/

void configDialog::getParams()
{
    getValue(myCallsign,callsignLineEdit);
    getValue(myLastname,lastnameLineEdit);
    getValue(myFirstname,firstnameLineEdit);
    getValue(myQth,qthLineEdit);
    getValue(myLocator,locatorLineEdit);
    getValue(rxImagesPath, rxImagesPathLineEdit);
    getValue(txImagesPath, txImagesPathLineEdit);
    getValue(templatesPath, templatesPathLineEdit);
    getValue(audioPath, audioPathLineEdit);
    getValue(docURL, docPathLineEdit);
    getValue(defaultImageFormat, defaultImageFormatComboBox);
    //	QFont fnt(fontComboBox->currentFont());
    //	fnt.setPointSize(fontSizeSpinBox->value());
    //	fontString=fnt.toString();

    getValue(cwText,cwTextLineEdit);
    getValue(cwTone,cwToneSpinBox);
    getValue(cwWPM,cwWPMSpinBox);
    getValue(enableFTP,enableFTPCheckBox);
    getValue(ftpPort,ftpPortSpinBox);
    getValue(ftpRemoteHost,remoteHostLineEdit);
    getValue(ftpRemoteDirectory,remoteDirectoryLineEdit);
    getValue(ftpLogin,ftpLoginLineEdit);
    getValue(ftpPassword,ftpPasswordLineEdit);
//    getValue(ftpFilename,ftpFilenameLineEdit);
    if(imageRadioButton->isChecked())
      {
       ftpSaveFormat=FTPIM;
      }
    else
      {
        ftpSaveFormat=FTPFILE;
      }
    getValue(ftpNumImages,ftpNumImagesSpinBox);

    getValue(ftpDefaultImageFormat,ftpDefaultImageFormatComboBox);
    getValue(enableHybridRx,enableHybridRxCheckBox);
    getValue(enableSpecialServer,enableSpecialServerCheckBox);
    getValue(hybridFtpPort,hybridFtpPortSpinBox);
    getValue(hybridFtpRemoteHost,hybridRemoteHostLineEdit);
    getValue(hybridFtpRemoteDirectory,hybridRemoteDirectoryLineEdit);
    getValue(hybridFtpHybridFilesDirectory,hybridFilesDirectoryLineEdit);
    getValue(hybridFtpLogin,hybridFtpLoginLineEdit);
    getValue(hybridFtpPassword,hybridFtpPasswordLineEdit);

    getValue(repeaterEnable,repeaterEnableCheckBox);
    int temp;
    getIndex(temp,repeaterTxModeComboBox);
    repeaterTxMode=esstvMode(temp);
    getValue(repeaterImage1,repeaterImage1LineEdit);
    getValue(repeaterImage2,repeaterImage2LineEdit);
    getValue(repeaterImage3,repeaterImage3LineEdit);
    getValue(repeaterImage4,repeaterImage4LineEdit);
    getValue(idleTemplate,idleTemplateLineEdit);
    getValue(repeaterTemplate,repeaterTemplateLineEdit);
    getValue(videoDevice,videoDeviceLineEdit);
    getValue(channelNumber, channelSpinBox);
    getIndex(colorFormatIndex,colorFormatComboBox);
    getIndex(sizeIndex,sizeComboBox);
    getValue(startPicWF,startPicTextEdit);
    getValue(endPicWF,endPicTextEdit);
    getValue(fixWF,fixTextEdit);
    getValue(bsrWF,bsrTextEdit);
}

/**
	Browse function for path where the rximages are stored
*/


void configDialog::slotBrowseRxImagesPath()
{
	browseDir(rxImagesPathLineEdit,rxImagesPath);
}

/**
	Browse function for path where the tximages are stored
*/

void configDialog::slotBrowseTxImagesPath()
{
	browseDir(txImagesPathLineEdit,txImagesPath);
}

/**
	Browse function for path where the templates are stored
*/

void configDialog::slotBrowseTemplatesPath()
{
	browseDir(templatesPathLineEdit,templatesPath);
}

/**
	Browse function for audio path
*/

void configDialog::slotBrowseAudioPath()
{
	browseDir(audioPathLineEdit,audioPath);
}

/**
	Browse function for documentation path
*/



void configDialog::slotRp1BrowseButton()
{
  browseGetFile(repeaterImage1LineEdit,txImagesPath);
}

void configDialog::slotRp2BrowseButton()
{
  browseGetFile(repeaterImage2LineEdit,txImagesPath);
}

void configDialog::slotRp3BrowseButton()
{
  browseGetFile(repeaterImage3LineEdit,txImagesPath);
}

void configDialog::slotRp4BrowseButton()
{
  browseGetFile(repeaterImage4LineEdit,txImagesPath);
}

void configDialog::slotRepeaterTemplateBrowseButton()
{
  browseGetFile(repeaterTemplateLineEdit,templatesPath);
}

void configDialog::slotIdleTemplateBrowseButton()
{
  browseGetFile(idleTemplateLineEdit,templatesPath);
}


void configDialog::slotTestFTPPushButton()
{
  ftpInterface fInt("TestUploadConnection");
  getParams();
  fInt.setupConnection(ftpRemoteHost,ftpPort,ftpLogin,ftpPassword,ftpRemoteDirectory);
  execFTPTest(&fInt);
}


void configDialog::slotTestHybridPushButton()
{
  ftpInterface fInt("TestHybridConnection");
  getParams();
  hybridCrypt hc;
  fInt.setupConnection(hc.host(),hc.port(),hc.user(),hc.passwd(),hc.dir()+"/"+hybridFtpHybridFilesDirectory);
  execFTPTest(&fInt);


}


void configDialog::execFTPTest(ftpInterface *ftpPtr)
{
  eftpError ftpResult;
  QString fn(QString("%1/test.txt").arg(rxImagesPath));
  //checkConnection
  QFile tst(fn);
  if(tst.open(QIODevice::WriteOnly)<=0)
    {
      QMessageBox::critical(this, tr("File Error"),QString("").arg(strerror(errno)));
    }
  tst.write("connection test\n");
  tst.close();
  ftpResult=ftpPtr->uploadFile(fn,QString("test_%1.txt").arg( myCallsign),true);
  switch(ftpResult)
    {
    case FTPCANCELED:
      QMessageBox::information(this, tr("FTP Info"),"Connection Canceled");
    break;
    case FTPOK:
      QMessageBox::information(this, tr("FTP Info"),"Connection OK");
    break;
    case FTPERROR:
       QMessageBox::critical(this, tr("FTP Error"),ftpPtr->getLastError());
    break;
    case FTPNAMEERROR:
     QMessageBox::critical(this, tr("FTP Error"),"Error in filename");
    break;
    case FTPTIMEOUT:
      QMessageBox::critical(this, tr("FTP Error"),"FTP timed out");
      return;
    }
  tst.remove();
}


