/***************************************************************************
                         qgsalgorithmsegmentize.h
                         ---------------------
    begin                : March 2018
    copyright            : (C) 2018 by Nyall Dawson
    email                : nyall dot dawson at gmail dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSALGORITHMSEGMENTIZE_H
#define QGSALGORITHMSEGMENTIZE_H

#define SIP_NO_FILE

#include "qgis_sip.h"
#include "qgsprocessingalgorithm.h"
#include "qgsmaptopixelgeometrysimplifier.h"

///@cond PRIVATE

/**
 * Native segmentize by maximum distance algorithm.
 */
class QgsSegmentizeByMaximumDistanceAlgorithm : public QgsProcessingFeatureBasedAlgorithm
{
  public:
    QgsSegmentizeByMaximumDistanceAlgorithm() = default;
    QString name() const override;
    QString displayName() const override;
    QStringList tags() const override;
    QString group() const override;
    QString groupId() const override;
    QString shortHelpString() const override;
    QgsSegmentizeByMaximumDistanceAlgorithm *createInstance() const override SIP_FACTORY;
    QList<int> inputLayerTypes() const override;
    void initParameters( const QVariantMap &configuration = QVariantMap() ) override;
    bool supportInPlaceEdit( const QgsMapLayer *layer ) const override;

  protected:
    QString outputName() const override;
    bool prepareAlgorithm( const QVariantMap &parameters, QgsProcessingContext &context, QgsProcessingFeedback *feedback ) override;
    QgsFeatureList processFeature( const QgsFeature &feature, QgsProcessingContext &, QgsProcessingFeedback *feedback ) override;

  private:
    double mTolerance = 1.0;
    bool mDynamicTolerance = false;
    QgsProperty mToleranceProperty;
};


/**
 * Native segmentize by maximum angle algorithm.
 */
class QgsSegmentizeByMaximumAngleAlgorithm : public QgsProcessingFeatureBasedAlgorithm
{
  public:
    QgsSegmentizeByMaximumAngleAlgorithm() = default;
    QString name() const override;
    QString displayName() const override;
    QStringList tags() const override;
    QString group() const override;
    QString groupId() const override;
    QString shortHelpString() const override;
    QgsSegmentizeByMaximumAngleAlgorithm *createInstance() const override SIP_FACTORY;
    QList<int> inputLayerTypes() const override;
    void initParameters( const QVariantMap &configuration = QVariantMap() ) override;
    bool supportInPlaceEdit( const QgsMapLayer *layer ) const override;

  protected:
    QString outputName() const override;
    bool prepareAlgorithm( const QVariantMap &parameters, QgsProcessingContext &context, QgsProcessingFeedback *feedback ) override;
    QgsFeatureList processFeature( const QgsFeature &feature, QgsProcessingContext &, QgsProcessingFeedback *feedback ) override;

  private:
    double mTolerance = 1.0;
    bool mDynamicTolerance = false;
    QgsProperty mToleranceProperty;
};

///@endcond PRIVATE

#endif // QGSALGORITHMSEGMENTIZE_H
