/***************************************************************************
                          body.cpp  -  description
                             -------------------
    begin                : Mit Sep 25 13:11:41 CEST 2002
    copyright            : (C) 2002-2007 by Harald Krippel
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**
 * @class Body
 * @brief The Body class implements a body object of the ODE-physik
 */

#include <body.hpp>

Body::Body(QObject *parent)
: QObject(parent)
{
  lvel[0]=0;
  lvel[1]=0;
  lvel[2]=0;
  
  avel[0]=0;
  avel[1]=0;
  avel[2]=0;

  objtrans = NULL;
  odgeom   = NULL;
  odbody   = NULL;
  boxobjtrans = NULL;
  oldtyp=-1;
}

void Body::createOdeBody(dWorldID odworld, dSpaceID odspace,int typ)
{
   // some constants 
   #define MASS 0.1f	

   odbody = dBodyCreate (odworld);
   dBodySetPosition (odbody,0,0,0);
   dMassSetBox(&odm,1,1,1,1);
   dMassTranslate (&odm, 0, 0, 0);  // HEIGHT
   dMassAdjust(&odm,MASS); //Mass of body
   dBodySetMass (odbody,&odm);
   if(odgeom != NULL)
      dGeomDestroy(odgeom);
   if(typ == 0){
    odgeom = dCreateBox (odspace,1,1,1);
   }
   if(typ == 1){
    odgeom = dCreateCCylinder (odspace,0.5,1);
   }
   if(typ == 2){
    odgeom = dCreateSphere (odspace,1);
   }
   dGeomSetBody (odgeom,odbody);
   oldtyp=typ;
}

void Body::typ(dSpaceID odspace,int typ)
{
  if(oldtyp != typ){
    if(odgeom != NULL)
      dGeomDestroy(odgeom);
    if(typ == 0){
      odgeom = dCreateBox (odspace,1,1,1);
    }
    if(typ == 1){
      odgeom = dCreateCCylinder (odspace,0.5,1);
    }
    if(typ == 2){
      odgeom = dCreateSphere (odspace,1);
    }
    dGeomSetBody (odgeom,odbody);
    oldtyp=typ;
  }
}

void Body::adjustMass(float tmpmass)
{
   dMassAdjust(&odm,tmpmass); //Mass of body
   dBodySetMass (odbody,&odm);
}

void Body::Scale(float x, float y, float z)
{
    if(dGeomGetClass(odgeom) == dBoxClass){
      dGeomBoxSetLengths (odgeom, x, y, z);
    }
    if(dGeomGetClass(odgeom) == dSphereClass){
      dGeomSphereSetRadius (odgeom, x/2.0f);
    }
    if(dGeomGetClass(odgeom) == dCCylinderClass){
      dGeomCCylinderSetParams (odgeom, x/2.0f,z);
    }
}

void Body::update(float dt)
{
  Q_UNUSED(dt);

  dVector3 dxyz;
  
  // positon body from ode
    if(objtrans != NULL){
      if(dGeomGetClass(odgeom) == dBoxClass){
        dGeomBoxGetLengths (odgeom, dxyz);
      }
      if(dGeomGetClass(odgeom) == dSphereClass){
        dxyz[0]= dGeomSphereGetRadius (odgeom)*2;
        dxyz[1] = dxyz[2] = dxyz[0];
      }
      if(dGeomGetClass(odgeom) == dCCylinderClass){
        dGeomCCylinderGetParams (odgeom,&dxyz[0],&dxyz[2]);
        dxyz[0] *=2;
        dxyz[1]=dxyz[0];
      }
      setTransform(objtrans,dBodyGetPosition(odbody),dBodyGetRotation(odbody),dxyz);
    }
}

void Body::setTransform (ssgTransform *objtrans, const dReal bodypos[3], const dReal R[12],dVector3 dxyz)
{
  sgMat4 m;
  
  m[0][0] = R[0] ;
  m[0][1] = R[4] ;
  m[0][2] = R[8] ;
  m[0][3] = SG_ZERO ; //x

  m[1][0] = R[1] ;
  m[1][1] = R[5] ;
  m[1][2] = R[9] ;
  m[1][3] = SG_ZERO ;  // y

  m[2][0] = R[2] ;
  m[2][1] = R[6] ;
  m[2][2] = R[10] ;
  m[2][3] = SG_ZERO ;  // z

  m[3][0] =  bodypos [0] ;
  m[3][1] =  bodypos [1] ;
  m[3][2] =  bodypos [2] ;
  m[3][3] =  SG_ONE ;

  sgScaleVec3(m[0], dxyz[0]);
  sgScaleVec3(m[1], dxyz[1]);
  sgScaleVec3(m[2], dxyz[2]);
          
  objtrans->setTransform(m);
  sgSetCoord  ( &pos, m ) ;
}

void Body::getPosition ( sgCoord  *bodypos )
{
   sgCopyCoord ( bodypos, &pos ) ;
}

void Body::setPosition ()
{
  dMatrix3 odR;

  dBodySetPosition (odbody,pos.xyz[0],pos.xyz[1],pos.xyz[2]);
  dRFromEulerAngles(odR,-pos.hpr[1] * SG_DEGREES_TO_RADIANS
                      ,-pos.hpr[2] * SG_DEGREES_TO_RADIANS
                      ,-pos.hpr[0] * SG_DEGREES_TO_RADIANS);
  dBodySetRotation (odbody,odR);

  dBodySetLinearVel (odbody,lvel[0],lvel[1],lvel[2]);
  dBodySetAngularVel (odbody,avel[0],avel[1],avel[2]);
}

void Body::setRotation ()
{
  dMatrix3 odR;

  dRFromEulerAngles(odR,-pos.hpr[1] * SG_DEGREES_TO_RADIANS
                      ,-pos.hpr[2] * SG_DEGREES_TO_RADIANS
                      ,-pos.hpr[0] * SG_DEGREES_TO_RADIANS);
  dBodySetRotation (odbody,odR);
  dBodySetLinearVel (odbody,lvel[0],lvel[1],lvel[2]);
  dBodySetAngularVel (odbody,avel[0],avel[1],avel[2]);
}

void Body::Rotation (float h, float p, float r)
{

  dMatrix3 odR;
  sgMat4 oglM;
  const dReal *odeM;
  sgMat4 mh ;

  sgMakeCoordMat4 ( mh, 0, 0, 0, h, p, r ) ;
  odeM = dBodyGetRotation(odbody);

oglM[0][0]  = odeM[0];
oglM[0][1]  = odeM[4];
oglM[0][2]  = odeM[8];
oglM[0][3]  = 0;
oglM[1][0]  = odeM[1];
oglM[1][1]  = odeM[5];
oglM[1][2]  = odeM[9];
oglM[1][3]  = 0;
oglM[2][0]  = odeM[2];
oglM[2][1]  = odeM[6];
oglM[2][2] = odeM[10];
oglM[2][3] = 0;
oglM[3][0] = 0;
oglM[3][1] = 0;
oglM[3][2] = 0;
oglM[3][3] = 1;

  sgPreMultMat4  ( oglM, mh ) ;

  odR[0]=oglM[0][0];
  odR[4]=oglM[0][1];
  odR[8]=oglM[0][2];

  odR[1]=oglM[1][0];
  odR[5]=oglM[1][1];
  odR[9]=oglM[1][2];

  odR[2]=oglM[2][0];
  odR[6]=oglM[2][1];
  odR[10]=oglM[2][2];
  
  dBodySetRotation (odbody,odR);
}

void Body::setLinearVel ()
{
  dBodySetLinearVel (odbody,lvel[0],lvel[1],lvel[2]);
}
void Body::addRelForce ()
{
  dBodyAddRelForce (odbody,lvel[0],lvel[1],lvel[2]);
}

void Body::setAngularVel ()
{
  dBodySetAngularVel (odbody,lvel[0],lvel[1],lvel[2]);
}
void Body::addRelTorque ()
{
  dBodyAddRelTorque (odbody,lvel[0],lvel[1],lvel[2]);
}

void   Body::setObjtrans (ssgTransform *trans)
{
  objtrans = trans;
}

Body::~Body()
{
}
