

function Vector(_x, _y, _z)
{
	var x, y, z;
	this.x = _x;
	this.y = _y;
	this.z = _z;
	return this;
}

Vector.prototype.add= function(a) {
        this.x += a.x;
        this.y += a.y;
        this.z += a.z; 
}
	
Vector.prototype.sub= function(a) {
        this.x -= a.x;
        this.y -= a.y;
        this.z -= a.z;
}



function QCO (_id)
{
	var id, ref;

	this.id = _id;
	this.ref = QCakeApi.getRef(this.id);
	return this;
}
	
QCO.prototype.getattr= function(args)
{
	return QCakeApi.getAttribute(this.ref, args);
}
QCO.prototype.setattr= function(args)
{
	return QCakeApi.setAttribute(this.ref, args);
}

QCO.prototype.getpos= function()
{
	return new Vector(QCakeApi.getPositionX(this.ref), QCakeApi.getPositionY(this.ref), QCakeApi.getPositionZ(this.ref));
}

QCO.prototype.getrot= function()
{
	return new Vector(QCakeApi.getPositionH(this.ref), QCakeApi.getPositionP(this.ref), QCakeApi.getPositionR(this.ref));
}
	
QCO.prototype.setpos= function(v)
{
	return QCakeApi.setPosition(this.ref, v.x, v.y, v.z, QCakeApi.getPositionH(this.ref), QCakeApi.getPositionP(this.ref), QCakeApi.getPositionR(this.ref));
}
	
QCO.prototype.setrot= function(r)
{
	return QCakeApi.setPosition(this.ref, QCakeApi.getPositionX(this.ref), QCakeApi.getPositionY(this.ref), QCakeApi.getPositionZ(this.ref), r.x, r.y, r.z);
}

QCO.prototype.rotate= function(r)
{
	return QCakeApi.Rotate(this.ref, r.x, r.y, r.z);
}

QCO.prototype.move= function(v)
{
	return this.setpos(this.getpos().add(v));
}

QCO.prototype.getpos_x= function()
{
	return QCakeApi.getPositionX(this.ref);
}
QCO.prototype.getpos_y= function()
{
	return QCakeApi.getPositionY(this.ref);
}
QCO.prototype.getpos_z= function()
{
	return QCakeApi.getPositionZ(this.ref);
}
QCO.prototype.getrot_h= function()
{
	return QCakeApi.getPositionH(this.ref); 
}
QCO.prototype.getrot_p= function()
{
	return QCakeApi.getPositionP(this.ref);
}
QCO.prototype.getrot_r= function()
{
	return QCakeApi.getPositionR(this.ref);
}
QCO.prototype.setsequence= function(s,m)
{
	return QCakeApi.setSequence(this.ref, s, m);
}
QCO.prototype.Ref= function()
{
	return this.ref;
}
