# -*- perl -*-
# generated by perlify.pl from libsbml/src/annotation/test/TestCVTerms.c
# # followed by little human processing to fix syntactic specialties
# # perify.pl is unable to handle right now =;) xtof
use Test::More;
BEGIN { plan tests => 22 };

use LibSBML;
use strict;
#########################

test_CVTerm_create();
test_CVTerm_set_get();
test_CVTerm_createFromNode();
test_CVTerm_addResource();
test_CVTerm_getResources();

#---
sub test_CVTerm_create {
  my $term
      = new LibSBML::CVTerm($LibSBML::MODEL_QUALIFIER); 

  ok( defined $term);
  ok( $term->getQualifierType() eq $LibSBML::MODEL_QUALIFIER );
}

#---
sub test_CVTerm_set_get {
  my $term
      = new LibSBML::CVTerm($LibSBML::MODEL_QUALIFIER);

  ok( $term->getQualifierType() eq $LibSBML::MODEL_QUALIFIER );

  $term->setModelQualifierType($LibSBML::BQM_IS);

  ok( defined $term );
  ok( $term->getQualifierType() eq $LibSBML::MODEL_QUALIFIER );
  ok( $term->getModelQualifierType() eq $LibSBML::BQM_IS );

  $term->setQualifierType($LibSBML::BIOLOGICAL_QUALIFIER);
  $term->setBiologicalQualifierType($LibSBML::BQM_IS);

  ok( $term->getQualifierType() eq $LibSBML::BIOLOGICAL_QUALIFIER );
  ok( $term->getBiologicalQualifierType() eq $LibSBML::BQM_IS );  
}

#---
sub test_CVTerm_createFromNode {
  my $qual_triple = new LibSBML::XMLTriple('is', '', 'bqbiol');
  my $bag_triple  = new LibSBML::XMLTriple();
  my $li_triple   = new LibSBML::XMLTriple();
  my $att         = new LibSBML::XMLAttributes();
  $att->add('', 'This is my resource');
  my $att1        = new LibSBML::XMLAttributes();

  my $li_token   = new LibSBML::XMLToken($li_triple, $att);
  my $bag_token  = new LibSBML::XMLToken($bag_triple,$att1);
  my $qual_token = new LibSBML::XMLToken($qual_triple,$att1);

  my $li   = new LibSBML::XMLNode($li_token);
  my $bag  = new LibSBML::XMLNode($bag_token);
  my $node = new LibSBML::XMLNode($qual_token);

  $bag->addChild($li);
  $node->addChild($bag);

  my $term = new LibSBML::CVTerm($node);

  ok( defined $term);
  ok( $term->getQualifierType() eq $LibSBML::BIOLOGICAL_QUALIFIER );
  ok( $term->getBiologicalQualifierType() eq $LibSBML::BQB_IS );

  my $xa = $term->getResources();

  ok( $xa->getLength() == 1 );
  ok( $xa->getName(0) eq 'rdf:resource' );
  ok( $xa->getValue(0) eq 'This is my resource' );
}

#---
sub test_CVTerm_addResource {
  my $term     = new LibSBML::CVTerm($LibSBML::MODEL_QUALIFIER);
  my $resource = 'GO6666';

  ok( defined $term);
  ok( $term->getQualifierType() eq $LibSBML::MODEL_QUALIFIER );

  $term->addResource($resource);

  my $xa = $term->getResources();

  ok( $xa->getLength() == 1 );
  ok( $xa->getName(0) eq 'rdf:resource' );
  ok( $xa->getValue(0) eq 'GO6666' );
}

#---
sub test_CVTerm_getResources {
  my $term = new LibSBML::CVTerm($LibSBML::MODEL_QUALIFIER);
  my $resource = 'GO6666';
  my $resource1 = 'OtherURI';
  
  $term->addResource($resource);
  $term->addResource($resource1);

  my $number = $term->getNumResources();

  ok( $number == 2 );
  ok( $term->getResourceURI(0) eq $resource );
  ok( $term->getResourceURI(1) eq $resource1 );
}
