<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	/**
	* Default configuration file for MILLE-XTERM Configurateur project.
	*
	* @filesource
	*
	*  Instructions:
	*  To use default value, comment the parameter with //
	*  Otherwise, use the simple quote to define value. Don't forget
	*  to put semicolums ad the end of line.
	*
	* @package MILLE-CONFIGURATOR
	* @author Nicolas Dufresne, Benoit des Ligneris
	*
	*/

	////////////////////////////////////////////////////////////////////
	// Language
	////////////////////////////////////////////////////////////////////

	/**
    * Language to use (default is en)
    * @global
    */
	$CONFIG_DEFAULT['lang'] = 'en';
	//$CONFIG_DEFAULT['lang'] = 'fr';

	/**
    * Charset to use (default is UTF-8)
    * @global
    */
	$CONFIG_DEFAULT['charset'] = 'UTF-8';

	////////////////////////////////////////////////////////////////////
	// LDAP
	////////////////////////////////////////////////////////////////////

	/**
    * Host to bind to, use the URL form (no default)
    * @global
    */
	$CONFIG_DEFAULT['ldap_host'] = 'ldap://ldap_server/';

	/**
    * Search base (no default)
    */
	$CONFIG_DEFAULT['ldap_basedn'] = 'dc=cs,dc=qc,dc=ca';

	/**
    * LDAP Object class
    * Leave empty if not use
    */

	$CONFIG_DEFAULT['ldap_object_class'] = "";
	$CONFIG_DEFAULT['ldap_group_object_class'] = "";

	/** Group base (default is ???)
    */
	$CONFIG_DEFAULT['ldap_group'] = "group";

	/**
    * User to bind to LDAP and get user information (default is to bind as user)
    */
    $CONFIG_DEFAULT['ldap_binddn'] = 'cn=Manager,dc=cs,dc=qc,dc=ca';
    #$CONFIG_DEFAULT['ldap_binddn'] = 'cn=BindUser,ou=System,'.$CONFIG_DEFAULT['ldap_basedn'];

	/**
    * Bind user password (default is to use user password when binding as user)
    */
    #$CONFIG_DEFAULT['ldap_bindpw'] = 'secret';
	$CONFIG_DEFAULT['ldap_bindpw'] = 'uportal';
	/**
	 * Attribute used to search for user.  Typically, the netID.
	 */
	$CONFIG_DEFAULT['ldap_uidAttribute'] = 'uid';
	/**
    LDAP protocol version (default is 3 and recommanded is 3)
    */
	$CONFIG_DEFAULT['ldap_version'] = 3;

	////////////////////////////////////////////////////////////////////
	// Authentification
	////////////////////////////////////////////////////////////////////

	/**
    # htaccess-> set auth_name to EmptyAuth
	# ldap -> set auth_name to LDAPAuth
	#$CONFIG['auth_name']='LDAPAuth';
    */
	$CONFIG_DEFAULT['auth_name']='EmptyAuth';

	////////////////////////////////////////////////////////////////////
	// Terminal security
	////////////////////////////////////////////////////////////////////

	/**
    * Terminal password
    */
	$CONFIG_DEFAULT['terminal_password'] = 'c3g7ms2hbzereycb';

	/**
    Terminal auth
    */
	$CONFIG_DEFAULT['terminal_auth'] = 'false';

	////////////////////////////////////////////////////////////////////
	// Database
	////////////////////////////////////////////////////////////////////

	/**
    * User to bind to database (no default)
    */
	$CONFIG_DEFAULT['db_user'] = 'mille';

	/**
    User database password  (no default)
    */
	$CONFIG_DEFAULT['db_password'] = 'mille';

	/**
    * Server domain name or ip (no default)
    */
	$CONFIG_DEFAULT['db_server'] = 'localhost';

	/**
    * Database name (no default)
    */
	$CONFIG_DEFAULT['db_name'] = 'millev2';

	/** Database type (default is postgres7)
    */
	$CONFIG_DEFAULT['db_type'] = 'postgres7';

	////////////////////////////////////////////////////////////////////
	// Logs and staus
	////////////////////////////////////////////////////////////////////

	/**
    * Maximum Time in seconds that should pass between to boot server change
    * (default to 120 seconds)
    */
	$CONFIG_DEFAULT['bootServRetry_time'] = 120;

	/** Maximum Time in seconds that should pass between the choice of a
     * bootServer and the assignation to an applicationServer
     * (default to 120 seconds)
     */
	$CONFIG_DEFAULT['appServRetry_time'] = 120;

    /**
    * Set automatically the root of the Configurator installation. Do not
    * adjust manually !
    */
    $CONFIG_DEFAULT['rootInstall']= basePathDefault();

    /**
    * Load balancer default value
    */
    $CONFIG_DEFAULT['loadbalancer']= 'localhost:8001';

    /**
    * Use https
    */
    $CONFIG_DEFAULT['use_https']= 'true';


    function basePathDefault()
    {
           return realpath(dirname(__File__)."/../")."/";
    }


?>
