; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -simplifycfg -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s

; s >= t, s != t, s <= t
define void @foo1(i32 %s, i32 %t) {
; CHECK-LABEL: @foo1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[S:%.*]], [[T:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END6:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    call void @bar1(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[S]], [[T]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN2:%.*]], label [[IF_END6]]
; CHECK:       if.then2:
; CHECK-NEXT:    call void @bar2(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[S]], [[T]]
; CHECK-NEXT:    br i1 [[CMP3]], label [[IF_THEN4:%.*]], label [[IF_END6]]
; CHECK:       if.then4:
; CHECK-NEXT:    call void @bar3(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    br label [[IF_END6]]
; CHECK:       if.end6:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp sge i32 %s, %t
  br i1 %cmp, label %if.then, label %if.end6

if.then:
  call void @bar1(i32 %s, i32 %t)
  %cmp1 = icmp ne i32 %s, %t
  br i1 %cmp1, label %if.then2, label %if.end6

if.then2:
  call void @bar2(i32 %s, i32 %t)
  %cmp3 = icmp sle i32 %s, %t
  br i1 %cmp3, label %if.then4, label %if.end6

if.then4:
  call void @bar3(i32 %s, i32 %t)
  br label %if.end6

if.end6:
  ret void
}

; s != t, s >= t, s <= t
define void @foo11(i32 %s, i32 %t) {
; CHECK-LABEL: @foo11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[S:%.*]], [[T:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END6:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    call void @bar1(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sge i32 [[S]], [[T]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN2:%.*]], label [[IF_END6]]
; CHECK:       if.then2:
; CHECK-NEXT:    call void @bar2(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[S]], [[T]]
; CHECK-NEXT:    br i1 [[CMP3]], label [[IF_THEN4:%.*]], label [[IF_END6]]
; CHECK:       if.then4:
; CHECK-NEXT:    call void @bar3(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    br label [[IF_END6]]
; CHECK:       if.end6:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp ne i32 %s, %t
  br i1 %cmp, label %if.then, label %if.end6

if.then:
  call void @bar1(i32 %s, i32 %t)
  %cmp1 = icmp sge i32 %s, %t
  br i1 %cmp1, label %if.then2, label %if.end6

if.then2:
  call void @bar2(i32 %s, i32 %t)
  %cmp3 = icmp sle i32 %s, %t
  br i1 %cmp3, label %if.then4, label %if.end6

if.then4:
  call void @bar3(i32 %s, i32 %t)
  br label %if.end6

if.end6:
  ret void
}

; s >= t, t != s, s <= t
define void @foo2(i32 %s, i32 %t) {
; CHECK-LABEL: @foo2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i32 [[S:%.*]], [[T:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END6:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    call void @bar1(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[T]], [[S]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN2:%.*]], label [[IF_END6]]
; CHECK:       if.then2:
; CHECK-NEXT:    call void @bar2(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[S]], [[T]]
; CHECK-NEXT:    br i1 [[CMP3]], label [[IF_THEN4:%.*]], label [[IF_END6]]
; CHECK:       if.then4:
; CHECK-NEXT:    call void @bar3(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    br label [[IF_END6]]
; CHECK:       if.end6:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp sge i32 %s, %t
  br i1 %cmp, label %if.then, label %if.end6

if.then:
  call void @bar1(i32 %s, i32 %t)
  %cmp1 = icmp ne i32 %t, %s
  br i1 %cmp1, label %if.then2, label %if.end6

if.then2:
  call void @bar2(i32 %s, i32 %t)
  %cmp3 = icmp sle i32 %s, %t
  br i1 %cmp3, label %if.then4, label %if.end6

if.then4:
  call void @bar3(i32 %s, i32 %t)
  br label %if.end6

if.end6:
  ret void
}

; s != t, t <= s, s <= t
define void @foo21(i32 %s, i32 %t) {
; CHECK-LABEL: @foo21(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[S:%.*]], [[T:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END6:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    call void @bar1(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[T]], [[S]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN2:%.*]], label [[IF_END6]]
; CHECK:       if.then2:
; CHECK-NEXT:    call void @bar2(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[S]], [[T]]
; CHECK-NEXT:    br i1 [[CMP3]], label [[IF_THEN4:%.*]], label [[IF_END6]]
; CHECK:       if.then4:
; CHECK-NEXT:    call void @bar3(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    br label [[IF_END6]]
; CHECK:       if.end6:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp ne i32 %s, %t
  br i1 %cmp, label %if.then, label %if.end6

if.then:
  call void @bar1(i32 %s, i32 %t)
  %cmp1 = icmp sle i32 %t, %s
  br i1 %cmp1, label %if.then2, label %if.end6

if.then2:
  call void @bar2(i32 %s, i32 %t)
  %cmp3 = icmp sle i32 %s, %t
  br i1 %cmp3, label %if.then4, label %if.end6

if.then4:
  call void @bar3(i32 %s, i32 %t)
  br label %if.end6

if.end6:
  ret void
}

; t <= s, t != s, s <= t
define void @foo3(i32 %s, i32 %t) {
; CHECK-LABEL: @foo3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sle i32 [[T:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END6:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    call void @bar1(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ne i32 [[T]], [[S]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN2:%.*]], label [[IF_END6]]
; CHECK:       if.then2:
; CHECK-NEXT:    call void @bar2(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[S]], [[T]]
; CHECK-NEXT:    br i1 [[CMP3]], label [[IF_THEN4:%.*]], label [[IF_END6]]
; CHECK:       if.then4:
; CHECK-NEXT:    call void @bar3(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    br label [[IF_END6]]
; CHECK:       if.end6:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp sle i32 %t, %s
  br i1 %cmp, label %if.then, label %if.end6

if.then:
  call void @bar1(i32 %s, i32 %t)
  %cmp1 = icmp ne i32 %t, %s
  br i1 %cmp1, label %if.then2, label %if.end6

if.then2:
  call void @bar2(i32 %s, i32 %t)
  %cmp3 = icmp sle i32 %s, %t
  br i1 %cmp3, label %if.then4, label %if.end6

if.then4:
  call void @bar3(i32 %s, i32 %t)
  br label %if.end6

if.end6:
  ret void
}

; t != s, t <= s, s <= t
define void @foo31(i32 %s, i32 %t) {
; CHECK-LABEL: @foo31(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[T:%.*]], [[S:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_THEN:%.*]], label [[IF_END6:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    call void @bar1(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sle i32 [[T]], [[S]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[IF_THEN2:%.*]], label [[IF_END6]]
; CHECK:       if.then2:
; CHECK-NEXT:    call void @bar2(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[S]], [[T]]
; CHECK-NEXT:    br i1 [[CMP3]], label [[IF_THEN4:%.*]], label [[IF_END6]]
; CHECK:       if.then4:
; CHECK-NEXT:    call void @bar3(i32 [[S]], i32 [[T]])
; CHECK-NEXT:    br label [[IF_END6]]
; CHECK:       if.end6:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp ne i32 %t, %s
  br i1 %cmp, label %if.then, label %if.end6

if.then:
  call void @bar1(i32 %s, i32 %t)
  %cmp1 = icmp sle i32 %t, %s
  br i1 %cmp1, label %if.then2, label %if.end6

if.then2:
  call void @bar2(i32 %s, i32 %t)
  %cmp3 = icmp sle i32 %s, %t
  br i1 %cmp3, label %if.then4, label %if.end6

if.then4:
  call void @bar3(i32 %s, i32 %t)
  br label %if.end6

if.end6:
  ret void
}

declare void @bar1(i32, i32)
declare void @bar2(i32, i32)
declare void @bar3(i32, i32)

