/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model;

import java.util.ArrayList;
import org.lisaac.ldt.model.ILisaacContext;
import org.lisaac.ldt.model.LipParser;
import org.lisaac.ldt.model.LisaacParser;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Section;
import org.lisaac.ldt.model.types.ITypeMono;
import org.lisaac.ldt.model.types.TypeParameter;

public class SectionContext
implements ILisaacContext {
    private LisaacParser parser;
    private boolean firstSection;

    public SectionContext(LisaacParser parser) {
        this.parser = parser;
        this.firstSection = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean parseDefinition(Prototype prototype) {
        this.parser.readSpace();
        if (!this.parser.readThisKeyword("Section")) {
            this.parser.getReporter().syntaxError("`Section' is needed.", this.parser.getLine());
            return false;
        }
        Position sectionPosition = this.parser.getPosition();
        if (this.firstSection) {
            if (!this.parser.readThisKeyword("Header")) {
                this.parser.getReporter().syntaxError("Section `Header' is needed.", this.parser.getLine());
                return false;
            }
            this.firstSection = false;
            if (this.readSectionHeaderContent(prototype)) return true;
            return false;
        }
        if (this.parser.readKeyword()) {
            String section = this.parser.getLastString();
            if (!(section.equals("Inherit") || section.equals("Insert") || section.equals("Interrupt") || section.equals("Private") || section.equals("Public") || section.equals("Mapping") || section.equals("Directory") || section.equals("External"))) {
                this.parser.getReporter().syntaxError("Incorrect type section.", this.parser.getLine());
                return false;
            }
            Section lastSection = new Section(prototype, section, sectionPosition);
            this.parser.setLastSection(lastSection);
            if (prototype.getFirstSection() == null) {
                prototype.setFirstSection(lastSection);
            }
            if (lastSection.isInheritOrInsert() && this.parser.getLastSlot() != null && !this.parser.getLastSlot().getSectionId().isInheritOrInsert()) {
                this.parser.getReporter().syntaxError("`Section Inherit/Insert' must to be first section.", this.parser.getLine());
                return false;
            }
            if (!prototype.isExpanded()) return true;
            if (!section.equals("Inherit")) return true;
            this.parser.getReporter().warning("`Section Inherit' is not possible with Expanded object (Use `Section Insert').", this.parser.getLine());
            return true;
        }
        ITypeMono[] t = this.parser.readTypeList(true);
        if (t == null) {
            this.parser.getReporter().syntaxError("Incorrect type section.", this.parser.getLine());
            return false;
        }
        this.parser.setLastSection(new Section(prototype, t, sectionPosition));
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private boolean readSectionHeaderContent(Prototype prototype) {
        first = true;
        do {
            block32: {
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block33: {
                                            block34: {
                                                result = false;
                                                style = this.parser.readStyle();
                                                if (style == ' ') continue;
                                                result = true;
                                                if (!first && style == '+') {
                                                    this.parser.getReporter().warning("Incorrect style slot ('-').", this.parser.getPosition(1));
                                                }
                                                if (!first) break block33;
                                                first = false;
                                                if (!this.parser.readWord("name")) break block34;
                                                if (!this.parser.readSymbol(":=")) {
                                                    this.parser.getReporter().syntaxError("Added ':='.", this.parser.getLine());
                                                    return false;
                                                }
                                                if (this.parser.readThisKeyword("Expanded") || this.parser.readThisKeyword("Strict")) {
                                                    prototype.setTypeStyle(this.parser.getLastString());
                                                }
                                                prototype.setNameOffset(this.parser.getOffset());
                                                if (!this.parser.readCapIdentifier()) {
                                                    this.parser.getReporter().syntaxError("Prototype identifier is needed.", this.parser.getLine());
                                                    return false;
                                                }
                                                if (this.parser.getLastString().compareTo(prototype.getName()) != 0) {
                                                    len = this.parser.getLastString().length();
                                                    this.parser.getReporter().syntaxError("Incorrect name (filename != name).", this.parser.getPosition(len));
                                                }
                                                if (!this.parser.readCharacter('(')) break block32;
                                                if (this.parser.readIdentifier()) {
                                                    return false;
                                                }
                                                if (!this.parser.readCapIdentifier()) {
                                                    this.parser.getReporter().syntaxError("Identifier parameter type is needed.", this.parser.getLine());
                                                    return false;
                                                }
                                                if (!this.parser.isParameterType) {
                                                    this.parser.getReporter().syntaxError("Identifier parameter type is needed.", this.parser.getLine());
                                                }
                                                genlist = new ArrayList<TypeParameter>();
                                                param = TypeParameter.get(this.parser.getLastString());
                                                genlist.add(param);
                                                if (true) ** GOTO lbl122
                                            }
                                            this.parser.getReporter().syntaxError("Slot `name' must to be first slot.", this.parser.getLine());
                                            break block32;
                                        }
                                        if (!this.parser.readWord("export") && !this.parser.readWord("import")) break block35;
                                        if (!this.parser.readSymbol(":=")) {
                                            this.parser.getReporter().syntaxError("Added ':='.", this.parser.getLine());
                                            return false;
                                        }
                                        if (this.parser.readTypeList(false) == null) {
                                            this.parser.getReporter().syntaxError("Incorrect type list.", this.parser.getLine());
                                            return false;
                                        }
                                        break block32;
                                    }
                                    if (!this.parser.readWord("external")) break block36;
                                    if (!this.parser.readSymbol(":=")) {
                                        this.parser.getReporter().syntaxError("Added ':='.", this.parser.getLine());
                                        return false;
                                    }
                                    if (!this.parser.readExternal()) {
                                        this.parser.getReporter().syntaxError("Incorrect external.", this.parser.getLine());
                                        return false;
                                    }
                                    break block32;
                                }
                                if (!this.parser.readWord("default")) break block37;
                                if (!this.parser.readSymbol(":=")) {
                                    this.parser.getReporter().syntaxError("Added ':='.", this.parser.getLine());
                                    return false;
                                }
                                if (this.parser.readExprPrimary() == null) {
                                    this.parser.getReporter().syntaxError("Incorrect expr.", this.parser.getLine());
                                    return false;
                                }
                                break block32;
                            }
                            if (!this.parser.readWord("type")) break block38;
                            if (!this.parser.readSymbol(":=")) {
                                this.parser.getReporter().syntaxError("Added ':='.", this.parser.getLine());
                                return false;
                            }
                            if (!this.parser.readExternal()) {
                                this.parser.getReporter().syntaxError("Incorrect external.", this.parser.getLine());
                                return false;
                            }
                            break block32;
                        }
                        if (!this.parser.readWord("version")) break block39;
                        if (!this.parser.readSymbol(":=")) {
                            this.parser.getReporter().syntaxError("Added ':='.", this.parser.getLine());
                            return false;
                        }
                        if (!this.parser.readInteger()) {
                            this.parser.getReporter().syntaxError("Incorrect number.", this.parser.getLine());
                            return false;
                        }
                        break block32;
                    }
                    if (!this.parser.readWord("lip")) break block40;
                    if (!this.parser.readSymbol("<-")) {
                        this.parser.getReporter().warning("Added '<-' is needed.", this.parser.getLine());
                    }
                    if (!this.parser.readCharacter('(')) {
                        this.parser.getReporter().warning("Added '(' is needed.", this.parser.getLine());
                    }
                    lipParser = new LipParser(this.parser.getSource(), this.parser.getOffset());
                    if (true) ** GOTO lbl131
                }
                if (!(this.parser.readWord("date") || this.parser.readWord("comment") || this.parser.readWord("author") || this.parser.readWord("bibliography") || this.parser.readWord("language") || this.parser.readWord("copyright") || this.parser.readWord("bug_report"))) {
                    this.parser.getReporter().syntaxError("Incorrect slot.", this.parser.getPosition());
                    return false;
                }
                headerSlot = new String(this.parser.getLastString());
                if (!this.parser.readSymbol(":=")) {
                    this.parser.getReporter().syntaxError("Added ':='.", this.parser.getLine());
                    return false;
                }
                this.parser.readSpace();
                slotPosition = this.parser.getPosition();
                if (!this.parser.readString()) {
                    this.parser.getReporter().syntaxError("Incorrect string.", this.parser.getLine());
                    return false;
                }
                if (headerSlot.equals("comment")) {
                    prototype.setHeaderComment(new String(this.parser.getLastString()));
                    break block32;
                } else {
                    slotPosition.setLength(this.parser.getOffset() - slotPosition.offset);
                    prototype.addHeaderData(headerSlot, new String(this.parser.getLastString()), slotPosition);
                }
                break block32;
                do {
                    if (!this.parser.readCapIdentifier()) {
                        this.parser.getReporter().syntaxError("Identifier parameter type is needed.", this.parser.getLine());
                        return false;
                    }
                    if (!this.parser.isParameterType) {
                        this.parser.getReporter().syntaxError("Identifier parameter type is needed.", this.parser.getLine());
                    }
                    param = TypeParameter.get(this.parser.getLastString());
                    genlist.add(param);
lbl122:
                    // 2 sources

                } while (this.parser.readCharacter(','));
                if (!this.parser.readCharacter(')')) {
                    this.parser.getReporter().syntaxError("Added ')'.", this.parser.getLine());
                    return false;
                }
                prototype.setGenericList(genlist.toArray(new TypeParameter[genlist.size()]));
                break block32;
                do {
                    if (lipParser.readCharacter(';')) continue;
                    this.parser.getReporter().warning("Added ';' is needed.", this.parser.getLine());
lbl131:
                    // 3 sources

                } while (lipParser.readExpr() != null);
                if (!lipParser.readCharacter(')')) {
                    this.parser.getReporter().warning("Added ')' is needed.", this.parser.getLine());
                }
                this.parser.setPosition(lipParser.getOffset());
            }
            if (this.parser.readCharacter(';')) continue;
            this.parser.getReporter().warning("Added ';'.", this.parser.getPosition());
        } while (!this.parser.isEOF() && result);
        return true;
    }

    public ILisaacContext getNextContext() {
        if (this.parser.skipUntilThisKeyword("Section")) {
            return this;
        }
        return null;
    }
}

