from __future__ import absolute_import, division, print_function
from cctbx import miller
from libtbx.test_utils import approx_equal
from cctbx import maptbx
from libtbx.math_utils import ifloor, iceil
from six.moves import zip

pdb_str = """\
REMARK iotbx.pdb.box_around_molecule --buffer-layer=5 "model.pdb"
REMARK Date 2012-05-14 Time 02:40:23 PDT -0700 (1336988423.30 s)
CRYST1   53.915   59.154   55.412  90.00  90.00  90.00 P 1
ATOM      1  O5'A  U A   1      37.906  44.440  32.960  0.50 57.34           O
ATOM      3  C5'A  U A   1      37.818  44.819  34.335  0.50 62.27           C
ATOM      5  C4'A  U A   1      36.577  45.625  34.622  0.50 65.36           C
ATOM      7  O4'A  U A   1      36.554  46.808  33.773  0.50 69.17           O
ATOM      9  C3'A  U A   1      35.248  44.935  34.371  0.50 66.68           C
ATOM     11  O3'A  U A   1      34.874  44.091  35.431  0.50 70.40           O
ATOM     13  C2'A  U A   1      34.289  46.101  34.212  0.50 66.50           C
ATOM     15  O2'A  U A   1      33.904  46.723  35.420  0.50 61.79           O
ATOM     17  C1'A  U A   1      35.180  47.157  33.557  0.50 62.69           C
ATOM     19  N1 A  U A   1      34.917  47.041  32.121  0.50 59.15           N
ATOM     21  C2 A  U A   1      33.758  47.622  31.657  0.50 58.64           C
ATOM     23  O2 A  U A   1      33.000  48.271  32.340  0.50 58.91           O
ATOM     25  N3 A  U A   1      33.487  47.398  30.335  0.50 57.27           N
ATOM     27  C4 A  U A   1      34.288  46.677  29.451  0.50 59.44           C
ATOM     29  O4 A  U A   1      34.020  46.494  28.276  0.50 63.06           O
ATOM     31  C5 A  U A   1      35.487  46.145  29.999  0.50 60.29           C
ATOM     33  C6 A  U A   1      35.759  46.349  31.279  0.50 58.51           C
ATOM      2  O5'B  U A   1      37.861  43.339  34.392  0.50 75.83           O
ATOM      4  C5'B  U A   1      37.933  44.526  35.189  0.50 76.43           C
ATOM      6  C4'B  U A   1      36.780  45.423  34.840  0.50 77.15           C
ATOM      8  O4'B  U A   1      37.168  46.319  33.769  0.50 80.31           O
ATOM     10  C3'B  U A   1      35.582  44.684  34.277  0.50 76.95           C
ATOM     12  O3'B  U A   1      34.818  44.089  35.325  0.50 75.56           O
ATOM     14  C2'B  U A   1      34.871  45.787  33.493  0.50 78.70           C
ATOM     16  O2'B  U A   1      34.112  46.713  34.250  0.50 78.26           O
ATOM     18  C1'B  U A   1      36.064  46.526  32.897  0.50 78.25           C
ATOM     20  N1 B  U A   1      36.426  45.918  31.632  0.50 75.39           N
ATOM     22  C2 B  U A   1      35.598  46.093  30.559  0.50 75.15           C
ATOM     24  O2 B  U A   1      34.576  46.775  30.561  0.50 75.31           O
ATOM     26  N3 B  U A   1      36.021  45.436  29.427  0.50 73.81           N
ATOM     28  C4 B  U A   1      37.159  44.671  29.328  0.50 72.68           C
ATOM     30  O4 B  U A   1      37.393  44.119  28.248  0.50 71.88           O
ATOM     32  C5 B  U A   1      37.978  44.561  30.511  0.50 73.12           C
ATOM     34  C6 B  U A   1      37.571  45.187  31.600  0.50 74.24           C
ATOM     35  P     C A   2      34.355  42.537  35.206  1.00 77.36           P
ATOM     36  OP1   C A   2      33.805  42.117  36.522  1.00 70.22           O
ATOM     37  OP2   C A   2      35.394  41.668  34.557  1.00 71.24           O
ATOM     38  O5'   C A   2      33.113  42.625  34.222  1.00 65.49           O
ATOM     39  C5'   C A   2      32.046  43.494  34.531  1.00 55.96           C
ATOM     40  C4'   C A   2      31.238  43.783  33.290  1.00 57.92           C
ATOM     41  O4'   C A   2      32.099  44.447  32.320  1.00 61.75           O
ATOM     42  C3'   C A   2      30.739  42.562  32.528  1.00 52.12           C
ATOM     43  O3'   C A   2      29.557  42.015  33.115  1.00 50.45           O
ATOM     44  C2'   C A   2      30.524  43.141  31.137  1.00 49.62           C
ATOM     45  O2'   C A   2      29.367  43.928  31.009  1.00 51.41           O
ATOM     46  C1'   C A   2      31.710  44.087  31.011  1.00 50.27           C
ATOM     47  N1    C A   2      32.834  43.453  30.322  1.00 48.99           N
ATOM     48  C2    C A   2      32.758  43.348  28.936  1.00 46.31           C
ATOM     49  O2    C A   2      31.739  43.762  28.373  1.00 47.24           O
ATOM     50  N3    C A   2      33.757  42.782  28.256  1.00 42.87           N
ATOM     51  C4    C A   2      34.808  42.291  28.915  1.00 48.42           C
ATOM     52  N4    C A   2      35.790  41.724  28.195  1.00 45.93           N
ATOM     53  C5    C A   2      34.904  42.358  30.342  1.00 45.21           C
ATOM     54  C6    C A   2      33.906  42.955  30.997  1.00 45.89           C
ATOM     55  P     C A   3      29.284  40.435  33.037  1.00 52.21           P
ATOM     56  OP1   C A   3      28.145  40.094  33.906  1.00 56.93           O
ATOM     57  OP2   C A   3      30.564  39.748  33.222  1.00 53.24           O
ATOM     58  O5'   C A   3      28.812  40.239  31.524  1.00 52.77           O
ATOM     59  C5'   C A   3      27.619  40.851  31.076  1.00 47.20           C
ATOM     60  C4'   C A   3      27.306  40.426  29.670  1.00 48.57           C
ATOM     61  O4'   C A   3      28.212  41.090  28.763  1.00 49.74           O
ATOM     62  C3'   C A   3      27.474  38.946  29.379  1.00 48.08           C
ATOM     63  O3'   C A   3      26.278  38.246  29.628  1.00 49.09           O
ATOM     64  C2'   C A   3      27.700  38.956  27.884  1.00 51.10           C
ATOM     65  O2'   C A   3      26.509  39.200  27.213  1.00 47.92           O
ATOM     66  C1'   C A   3      28.549  40.204  27.714  1.00 52.80           C
ATOM     67  N1    C A   3      29.982  39.872  27.778  1.00 52.62           N
ATOM     68  C2    C A   3      30.576  39.409  26.620  1.00 50.95           C
ATOM     69  O2    C A   3      29.874  39.284  25.628  1.00 51.27           O
ATOM     70  N3    C A   3      31.891  39.122  26.603  1.00 50.11           N
ATOM     71  C4    C A   3      32.621  39.310  27.699  1.00 51.64           C
ATOM     72  N4    C A   3      33.945  39.069  27.621  1.00 51.99           N
ATOM     73  C5    C A   3      32.038  39.764  28.920  1.00 47.65           C
ATOM     74  C6    C A   3      30.720  40.022  28.917  1.00 51.34           C
ATOM     75  P     C A   4      26.340  36.770  30.237  1.00 52.02           P
ATOM     76  OP1   C A   4      24.977  36.407  30.647  1.00 57.69           O
ATOM     77  OP2   C A   4      27.440  36.712  31.208  1.00 47.01           O
ATOM     78  O5'   C A   4      26.715  35.865  28.985  1.00 52.56           O
ATOM     79  C5'   C A   4      25.873  35.843  27.851  1.00 51.03           C
ATOM     80  C4'   C A   4      26.553  35.135  26.694  1.00 53.37           C
ATOM     81  O4'   C A   4      27.733  35.884  26.284  1.00 52.42           O
ATOM     82  C3'   C A   4      27.107  33.758  27.038  1.00 51.19           C
ATOM     83  O3'   C A   4      26.055  32.808  26.914  1.00 49.80           O
ATOM     84  C2'   C A   4      28.183  33.566  25.972  1.00 50.24           C
ATOM     85  O2'   C A   4      27.694  33.165  24.707  1.00 48.16           O
ATOM     86  C1'   C A   4      28.707  34.987  25.809  1.00 50.87           C
ATOM     87  N1    C A   4      29.994  35.244  26.446  1.00 51.20           N
ATOM     88  C2    C A   4      31.118  34.964  25.702  1.00 49.00           C
ATOM     89  O2    C A   4      30.967  34.463  24.600  1.00 54.89           O
ATOM     90  N3    C A   4      32.332  35.222  26.196  1.00 48.65           N
ATOM     91  C4    C A   4      32.454  35.715  27.435  1.00 51.02           C
ATOM     92  N4    C A   4      33.707  35.965  27.889  1.00 49.02           N
ATOM     93  C5    C A   4      31.310  35.975  28.257  1.00 44.38           C
ATOM     94  C6    C A   4      30.105  35.739  27.718  1.00 48.81           C
HETATM   95  P   A2M A   5      25.901  31.632  27.992  1.00 56.44           P
HETATM   96  OP1 A2M A   5      24.550  31.061  27.748  1.00 57.09           O
HETATM   97  OP2 A2M A   5      26.276  32.071  29.359  1.00 52.40           O
HETATM   98  O5' A2M A   5      27.029  30.566  27.615  1.00 55.24           O
HETATM   99  C5' A2M A   5      27.182  30.046  26.283  1.00 56.20           C
HETATM  100  C4' A2M A   5      28.511  29.357  26.200  1.00 59.80           C
HETATM  101  O4' A2M A   5      29.564  30.338  26.227  1.00 57.27           O
HETATM  102  C3' A2M A   5      28.794  28.415  27.359  1.00 60.05           C
HETATM  103  O3' A2M A   5      28.398  27.142  26.878  1.00 68.10           O
HETATM  104  C2' A2M A   5      30.308  28.420  27.417  1.00 59.91           C
HETATM  105  O2' A2M A   5      30.816  27.502  26.460  1.00 60.71           O
HETATM  106  C1' A2M A   5      30.624  29.875  27.030  1.00 56.56           C
HETATM  107  CM' A2M A   5      32.279  27.582  26.276  1.00 58.96           C
HETATM  108  N9  A2M A   5      30.742  30.834  28.125  1.00 53.29           N
HETATM  109  C8  A2M A   5      29.714  31.474  28.766  1.00 51.25           C
HETATM  110  N7  A2M A   5      30.115  32.374  29.632  1.00 51.29           N
HETATM  111  C5  A2M A   5      31.495  32.297  29.576  1.00 53.45           C
HETATM  112  C6  A2M A   5      32.496  33.008  30.232  1.00 58.30           C
HETATM  113  N6  A2M A   5      32.252  33.985  31.103  1.00 60.72           N
HETATM  114  N1  A2M A   5      33.782  32.694  29.955  1.00 61.49           N
HETATM  115  C2  A2M A   5      34.019  31.733  29.057  1.00 58.84           C
HETATM  116  N3  A2M A   5      33.154  31.004  28.362  1.00 57.90           N
HETATM  117  C4  A2M A   5      31.895  31.338  28.673  1.00 53.58           C
ATOM    118  P     G A   6      28.105  25.950  27.893  1.00 69.35           P
ATOM    119  OP1   G A   6      26.631  25.896  28.049  1.00 68.98           O
ATOM    120  OP2   G A   6      28.997  26.088  29.081  1.00 70.91           O
ATOM    121  O5'   G A   6      28.557  24.667  27.086  1.00 67.04           O
ATOM    122  C5'   G A   6      29.929  24.381  26.854  1.00 60.28           C
ATOM    123  C4'   G A   6      30.025  23.013  26.248  1.00 61.96           C
ATOM    124  O4'   G A   6      29.619  23.068  24.842  1.00 59.59           O
ATOM    125  C3'   G A   6      31.464  22.519  26.258  1.00 59.47           C
ATOM    126  O3'   G A   6      31.521  21.171  26.735  1.00 58.45           O
ATOM    127  C2'   G A   6      31.998  22.775  24.847  1.00 55.60           C
ATOM    128  O2'   G A   6      32.751  21.689  24.396  1.00 63.22           O
ATOM    129  C1'   G A   6      30.710  22.730  24.038  1.00 53.09           C
ATOM    130  N9    G A   6      30.565  23.261  22.694  1.00 51.95           N
ATOM    131  C8    G A   6      29.636  22.849  21.763  1.00 50.88           C
ATOM    132  N7    G A   6      29.785  23.420  20.599  1.00 50.13           N
ATOM    133  C5    G A   6      30.875  24.263  20.773  1.00 49.79           C
ATOM    134  C6    G A   6      31.517  25.120  19.859  1.00 49.53           C
ATOM    135  O6    G A   6      31.277  25.274  18.645  1.00 53.13           O
ATOM    136  N1    G A   6      32.543  25.837  20.469  1.00 47.62           N
ATOM    137  C2    G A   6      32.911  25.720  21.796  1.00 46.10           C
ATOM    138  N2    G A   6      33.918  26.499  22.221  1.00 46.33           N
ATOM    139  N3    G A   6      32.339  24.903  22.646  1.00 47.18           N
ATOM    140  C4    G A   6      31.337  24.207  22.076  1.00 50.29           C
ATOM    141  P     U A   7      32.025  20.842  28.231  1.00 64.08           P
ATOM    142  OP1   U A   7      31.581  19.443  28.502  1.00 66.76           O
ATOM    143  OP2   U A   7      31.606  21.925  29.132  1.00 64.46           O
ATOM    144  O5'   U A   7      33.605  20.823  28.120  1.00 59.16           O
ATOM    145  C5'   U A   7      34.222  19.952  27.193  1.00 58.37           C
ATOM    146  C4'   U A   7      35.706  20.168  27.169  1.00 62.94           C
ATOM    147  O4'   U A   7      35.985  21.495  26.648  1.00 66.62           O
ATOM    148  C3'   U A   7      36.382  20.175  28.527  1.00 64.49           C
ATOM    149  O3'   U A   7      36.701  18.875  28.963  1.00 67.36           O
ATOM    150  C2'   U A   7      37.649  20.953  28.241  1.00 66.14           C
ATOM    151  O2'   U A   7      38.595  20.148  27.587  1.00 72.89           O
ATOM    152  C1'   U A   7      37.145  22.010  27.264  1.00 64.87           C
ATOM    153  N1    U A   7      36.809  23.256  27.953  1.00 66.25           N
ATOM    154  C2    U A   7      37.862  23.996  28.410  1.00 66.82           C
ATOM    155  O2    U A   7      39.014  23.648  28.241  1.00 66.77           O
ATOM    156  N3    U A   7      37.524  25.149  29.066  1.00 67.90           N
ATOM    157  C4    U A   7      36.257  25.620  29.292  1.00 67.50           C
ATOM    158  O4    U A   7      36.111  26.720  29.811  1.00 71.39           O
ATOM    159  C5    U A   7      35.215  24.792  28.784  1.00 67.65           C
ATOM    160  C6    U A   7      35.521  23.664  28.145  1.00 65.81           C
ATOM    161  P     C A   8      36.481  18.479  30.501  1.00 72.60           P
ATOM    162  OP1   C A   8      36.926  17.076  30.621  1.00 73.55           O
ATOM    163  OP2   C A   8      35.086  18.844  30.859  1.00 66.70           O
ATOM    164  O5'   C A   8      37.523  19.377  31.293  1.00 69.11           O
ATOM    165  C5'   C A   8      38.905  19.262  31.001  1.00 73.33           C
ATOM    166  C4'   C A   8      39.687  20.336  31.714  1.00 73.96           C
ATOM    167  O4'   C A   8      39.411  21.623  31.109  1.00 74.82           O
ATOM    168  C3'   C A   8      39.318  20.532  33.173  1.00 76.76           C
ATOM    169  O3'   C A   8      40.014  19.634  34.004  1.00 80.65           O
ATOM    170  C2'   C A   8      39.777  21.953  33.433  1.00 76.18           C
ATOM    171  O2'   C A   8      41.168  22.010  33.633  1.00 75.82           O
ATOM    172  C1'   C A   8      39.409  22.629  32.114  1.00 76.03           C
ATOM    173  N1    C A   8      38.060  23.201  32.187  1.00 74.37           N
ATOM    174  C2    C A   8      37.906  24.517  32.653  1.00 74.82           C
ATOM    175  O2    C A   8      38.900  25.144  33.039  1.00 75.85           O
ATOM    176  N3    C A   8      36.682  25.066  32.683  1.00 74.24           N
ATOM    177  C4    C A   8      35.627  24.353  32.296  1.00 74.34           C
ATOM    178  N4    C A   8      34.439  24.949  32.330  1.00 72.43           N
ATOM    179  C5    C A   8      35.747  22.995  31.851  1.00 72.75           C
ATOM    180  C6    C A   8      36.972  22.469  31.807  1.00 71.45           C
ATOM    181  P     C A   9      39.274  19.006  35.275  1.00 84.79           P
ATOM    182  OP1   C A   9      40.195  17.952  35.753  1.00 88.03           O
ATOM    183  OP2   C A   9      37.864  18.647  34.941  1.00 80.94           O
ATOM    184  O5'   C A   9      39.255  20.216  36.311  1.00 84.01           O
ATOM    185  C5'   C A   9      40.464  20.832  36.731  1.00 84.57           C
ATOM    186  C4'   C A   9      40.177  22.003  37.652  1.00 89.03           C
ATOM    187  O4'   C A   9      39.538  23.075  36.896  1.00 87.03           O
ATOM    188  C3'   C A   9      39.195  21.739  38.787  1.00 91.40           C
ATOM    189  O3'   C A   9      39.778  21.078  39.911  1.00 93.63           O
ATOM    190  C2'   C A   9      38.693  23.143  39.115  1.00 90.47           C
ATOM    191  O2'   C A   9      39.599  23.901  39.896  1.00 95.08           O
ATOM    192  C1'   C A   9      38.611  23.766  37.723  1.00 86.03           C
ATOM    193  N1    C A   9      37.260  23.660  37.145  1.00 82.38           N
ATOM    194  C2    C A   9      36.316  24.636  37.472  1.00 79.65           C
ATOM    195  O2    C A   9      36.651  25.555  38.219  1.00 82.76           O
ATOM    196  N3    C A   9      35.071  24.551  36.969  1.00 76.16           N
ATOM    197  C4    C A   9      34.751  23.541  36.161  1.00 76.23           C
ATOM    198  N4    C A   9      33.512  23.494  35.678  1.00 75.12           N
ATOM    199  C5    C A   9      35.689  22.532  35.808  1.00 77.16           C
ATOM    200  C6    C A   9      36.922  22.629  36.315  1.00 80.49           C
ATOM    201  P     A A  10      38.839  20.211  40.903  1.00 98.76           P
ATOM    202  OP1   A A  10      39.749  19.602  41.900  1.00 97.65           O
ATOM    203  OP2   A A  10      37.913  19.337  40.122  1.00 92.07           O
ATOM    204  O5'   A A  10      37.963  21.308  41.658  1.00 96.14           O
ATOM    205  C5'   A A  10      38.594  22.322  42.434  1.00 95.22           C
ATOM    206  C4'   A A  10      37.562  23.244  43.042  1.00 95.17           C
ATOM    207  O4'   A A  10      36.978  24.081  42.007  1.00 91.86           O
ATOM    208  C3'   A A  10      36.366  22.557  43.681  1.00 97.19           C
ATOM    209  O3'   A A  10      36.643  22.122  45.009  1.00100.89           O
ATOM    210  C2'   A A  10      35.310  23.654  43.639  1.00 93.71           C
ATOM    211  O2'   A A  10      35.509  24.611  44.654  1.00 95.51           O
ATOM    212  C1'   A A  10      35.603  24.302  42.288  1.00 88.77           C
ATOM    213  N9    A A  10      34.817  23.683  41.228  1.00 84.63           N
ATOM    214  C8    A A  10      35.228  22.725  40.335  1.00 83.63           C
ATOM    215  N7    A A  10      34.292  22.348  39.497  1.00 83.34           N
ATOM    216  C5    A A  10      33.191  23.113  39.861  1.00 82.21           C
ATOM    217  C6    A A  10      31.877  23.184  39.356  1.00 81.37           C
ATOM    218  N6    A A  10      31.436  22.449  38.332  1.00 81.39           N
ATOM    219  N1    A A  10      31.022  24.048  39.948  1.00 81.70           N
ATOM    220  C2    A A  10      31.470  24.782  40.976  1.00 81.42           C
ATOM    221  N3    A A  10      32.680  24.803  41.538  1.00 81.31           N
ATOM    222  C4    A A  10      33.501  23.937  40.927  1.00 82.32           C
ATOM    223  P     C A  11      35.982  20.762  45.552  1.00103.62           P
ATOM    224  OP1   C A  11      36.828  20.343  46.695  1.00103.61           O
ATOM    225  OP2   C A  11      35.768  19.830  44.407  1.00102.19           O
ATOM    226  O5'   C A  11      34.547  21.207  46.077  1.00101.61           O
ATOM    227  C5'   C A  11      34.424  22.135  47.143  1.00101.79           C
ATOM    228  C4'   C A  11      33.060  22.773  47.123  1.00102.59           C
ATOM    229  O4'   C A  11      32.884  23.444  45.841  1.00100.88           O
ATOM    230  C3'   C A  11      31.882  21.813  47.177  1.00104.06           C
ATOM    231  O3'   C A  11      31.569  21.358  48.485  1.00108.23           O
ATOM    232  C2'   C A  11      30.768  22.646  46.554  1.00102.75           C
ATOM    233  O2'   C A  11      30.217  23.610  47.439  1.00103.58           O
ATOM    234  C1'   C A  11      31.527  23.352  45.431  1.00 98.23           C
ATOM    235  N1    C A  11      31.462  22.568  44.188  1.00 93.91           N
ATOM    236  C2    C A  11      30.271  22.595  43.436  1.00 92.01           C
ATOM    237  O2    C A  11      29.334  23.309  43.819  1.00 91.87           O
ATOM    238  N3    C A  11      30.173  21.845  42.323  1.00 90.30           N
ATOM    239  C4    C A  11      31.197  21.084  41.944  1.00 91.18           C
ATOM    240  N4    C A  11      31.035  20.340  40.849  1.00 91.02           N
ATOM    241  C5    C A  11      32.431  21.047  42.674  1.00 91.53           C
ATOM    242  C6    C A  11      32.519  21.804  43.777  1.00 92.37           C
ATOM    243  P     C A  12      30.796  19.956  48.665  1.00112.22           P
ATOM    244  OP1   C A  12      30.641  19.697  50.117  1.00112.01           O
ATOM    245  OP2   C A  12      31.484  18.957  47.810  1.00111.76           O
ATOM    246  O5'   C A  12      29.347  20.213  48.056  1.00108.28           O
ATOM    247  C5'   C A  12      28.459  21.109  48.695  1.00106.06           C
ATOM    248  C4'   C A  12      27.142  21.176  47.963  1.00106.41           C
ATOM    249  O4'   C A  12      27.372  21.636  46.598  1.00104.55           O
ATOM    250  C3'   C A  12      26.454  19.839  47.744  1.00107.16           C
ATOM    251  O3'   C A  12      25.756  19.349  48.877  1.00110.19           O
ATOM    252  C2'   C A  12      25.533  20.130  46.564  1.00105.41           C
ATOM    253  O2'   C A  12      24.346  20.829  46.895  1.00106.19           O
ATOM    254  C1'   C A  12      26.421  21.036  45.723  1.00101.36           C
ATOM    255  N1    C A  12      27.105  20.256  44.683  1.00 96.70           N
ATOM    256  C2    C A  12      26.362  19.888  43.543  1.00 95.13           C
ATOM    257  O2    C A  12      25.161  20.237  43.469  1.00 91.43           O
ATOM    258  N3    C A  12      26.965  19.162  42.564  1.00 93.33           N
ATOM    259  C4    C A  12      28.246  18.799  42.696  1.00 93.85           C
ATOM    260  N4    C A  12      28.797  18.090  41.711  1.00 93.47           N
ATOM    261  C5    C A  12      29.019  19.152  43.847  1.00 94.03           C
ATOM    262  C6    C A  12      28.414  19.879  44.805  1.00 95.69           C
ATOM    263  P     G A  13      25.551  17.759  49.046  1.00112.02           P
ATOM    264  OP1   G A  13      24.994  17.553  50.412  1.00112.22           O
ATOM    265  OP2   G A  13      26.836  17.106  48.667  1.00110.53           O
ATOM    266  O5'   G A  13      24.433  17.373  47.966  1.00107.61           O
ATOM    267  C5'   G A  13      23.084  17.821  48.131  1.00103.22           C
ATOM    268  C4'   G A  13      22.224  17.406  46.957  1.00 99.90           C
ATOM    269  O4'   G A  13      22.762  17.985  45.738  1.00 97.54           O
ATOM    270  C3'   G A  13      22.174  15.918  46.657  1.00 99.56           C
ATOM    271  O3'   G A  13      21.362  15.173  47.563  1.00100.46           O
ATOM    272  C2'   G A  13      21.781  15.894  45.179  1.00 97.68           C
ATOM    273  O2'   G A  13      20.402  16.100  44.921  1.00 97.87           O
ATOM    274  C1'   G A  13      22.563  17.094  44.650  1.00 91.21           C
ATOM    275  N9    G A  13      23.866  16.727  44.099  1.00 84.79           N
ATOM    276  C8    G A  13      25.097  16.798  44.718  1.00 82.35           C
ATOM    277  N7    G A  13      26.078  16.389  43.952  1.00 80.09           N
ATOM    278  C5    G A  13      25.457  16.023  42.758  1.00 78.41           C
ATOM    279  C6    G A  13      26.005  15.482  41.549  1.00 77.13           C
ATOM    280  O6    G A  13      27.199  15.224  41.277  1.00 76.18           O
ATOM    281  N1    G A  13      25.010  15.240  40.603  1.00 74.49           N
ATOM    282  C2    G A  13      23.669  15.488  40.783  1.00 77.08           C
ATOM    283  N2    G A  13      22.857  15.181  39.749  1.00 76.33           N
ATOM    284  N3    G A  13      23.151  15.997  41.895  1.00 79.00           N
ATOM    285  C4    G A  13      24.094  16.231  42.833  1.00 80.18           C
TER
ATOM    287  O5'   C B   2      26.224  13.476  31.918  1.00103.85           O
ATOM    288  C5'   C B   2      24.979  12.840  31.589  1.00101.65           C
ATOM    289  C4'   C B   2      23.870  13.050  32.606  1.00100.98           C
ATOM    290  O4'   C B   2      24.178  12.312  33.830  1.00 98.41           O
ATOM    291  C3'   C B   2      23.689  14.480  33.104  1.00101.72           C
ATOM    292  O3'   C B   2      23.017  15.346  32.185  1.00103.99           O
ATOM    293  C2'   C B   2      22.987  14.278  34.453  1.00 98.02           C
ATOM    294  O2'   C B   2      21.586  14.040  34.391  1.00 96.50           O
ATOM    295  C1'   C B   2      23.710  13.034  34.974  1.00 92.73           C
ATOM    296  N1    C B   2      24.866  13.385  35.833  1.00 86.15           N
ATOM    297  C2    C B   2      24.617  13.846  37.133  1.00 83.53           C
ATOM    298  O2    C B   2      23.436  13.920  37.523  1.00 82.50           O
ATOM    299  N3    C B   2      25.664  14.199  37.927  1.00 81.28           N
ATOM    300  C4    C B   2      26.919  14.106  37.462  1.00 82.42           C
ATOM    301  N4    C B   2      27.927  14.484  38.268  1.00 81.86           N
ATOM    302  C5    C B   2      27.202  13.626  36.147  1.00 82.13           C
ATOM    303  C6    C B   2      26.155  13.278  35.374  1.00 84.92           C
ATOM    304  P     G B   3      23.377  16.924  32.170  1.00103.37           P
ATOM    305  OP1   G B   3      22.650  17.474  30.999  1.00103.13           O
ATOM    306  OP2   G B   3      24.865  17.125  32.288  1.00 96.01           O
ATOM    307  O5'   G B   3      22.663  17.479  33.485  1.00 99.96           O
ATOM    308  C5'   G B   3      21.271  17.265  33.681  1.00 97.40           C
ATOM    309  C4'   G B   3      20.844  17.733  35.051  1.00 98.00           C
ATOM    310  O4'   G B   3      21.418  16.858  36.059  1.00 95.41           O
ATOM    311  C3'   G B   3      21.327  19.116  35.469  1.00100.94           C
ATOM    312  O3'   G B   3      20.567  20.185  34.902  1.00105.92           O
ATOM    313  C2'   G B   3      21.244  19.032  36.991  1.00 97.36           C
ATOM    314  O2'   G B   3      19.926  19.134  37.495  1.00 98.15           O
ATOM    315  C1'   G B   3      21.733  17.609  37.226  1.00 91.40           C
ATOM    316  N9    G B   3      23.177  17.602  37.412  1.00 86.04           N
ATOM    317  C8    G B   3      24.137  17.173  36.525  1.00 84.91           C
ATOM    318  N7    G B   3      25.353  17.284  36.991  1.00 83.38           N
ATOM    319  C5    G B   3      25.184  17.819  38.262  1.00 82.96           C
ATOM    320  C6    G B   3      26.143  18.146  39.254  1.00 82.52           C
ATOM    321  O6    G B   3      27.384  18.011  39.209  1.00 84.20           O
ATOM    322  N1    G B   3      25.536  18.673  40.392  1.00 81.55           N
ATOM    323  C2    G B   3      24.178  18.861  40.555  1.00 81.91           C
ATOM    324  N2    G B   3      23.784  19.412  41.718  1.00 82.33           N
ATOM    325  N3    G B   3      23.273  18.542  39.644  1.00 81.67           N
ATOM    326  C4    G B   3      23.844  18.031  38.531  1.00 83.91           C
ATOM    327  P     G B   4      21.293  21.588  34.558  1.00106.52           P
ATOM    328  OP1   G B   4      20.285  22.367  33.782  1.00105.17           O
ATOM    329  OP2   G B   4      22.636  21.315  33.975  1.00103.11           O
ATOM    330  O5'   G B   4      21.509  22.262  35.984  1.00101.42           O
ATOM    331  C5'   G B   4      20.438  22.278  36.908  1.00100.43           C
ATOM    332  C4'   G B   4      20.869  22.897  38.201  1.00 99.09           C
ATOM    333  O4'   G B   4      21.642  21.945  38.979  1.00 96.04           O
ATOM    334  C3'   G B   4      21.822  24.057  38.023  1.00 99.81           C
ATOM    335  O3'   G B   4      21.132  25.229  37.623  1.00105.35           O
ATOM    336  C2'   G B   4      22.495  24.124  39.390  1.00 95.87           C
ATOM    337  O2'   G B   4      21.672  24.720  40.371  1.00 93.32           O
ATOM    338  C1'   G B   4      22.641  22.638  39.716  1.00 92.41           C
ATOM    339  N9    G B   4      23.949  22.133  39.322  1.00 85.05           N
ATOM    340  C8    G B   4      24.278  21.493  38.152  1.00 84.17           C
ATOM    341  N7    G B   4      25.549  21.190  38.073  1.00 82.20           N
ATOM    342  C5    G B   4      26.083  21.653  39.267  1.00 80.72           C
ATOM    343  C6    G B   4      27.418  21.623  39.746  1.00 81.39           C
ATOM    344  O6    G B   4      28.437  21.153  39.195  1.00 81.97           O
ATOM    345  N1    G B   4      27.517  22.218  41.000  1.00 81.19           N
ATOM    346  C2    G B   4      26.467  22.767  41.702  1.00 79.78           C
ATOM    347  N2    G B   4      26.775  23.304  42.901  1.00 79.64           N
ATOM    348  N3    G B   4      25.217  22.792  41.266  1.00 79.06           N
ATOM    349  C4    G B   4      25.102  22.229  40.051  1.00 80.96           C
ATOM    350  P     U B   5      21.961  26.484  37.052  1.00106.60           P
ATOM    351  OP1   U B   5      21.070  27.231  36.122  1.00106.25           O
ATOM    352  OP2   U B   5      23.299  26.040  36.578  1.00105.20           O
ATOM    353  O5'   U B   5      22.201  27.331  38.375  1.00102.23           O
ATOM    354  C5'   U B   5      23.326  28.160  38.478  1.00100.44           C
ATOM    355  C4'   U B   5      23.878  28.134  39.874  1.00 98.12           C
ATOM    356  O4'   U B   5      24.119  26.773  40.300  1.00 96.77           O
ATOM    357  C3'   U B   5      25.226  28.800  39.979  1.00 99.87           C
ATOM    358  O3'   U B   5      25.090  30.197  40.004  1.00102.93           O
ATOM    359  C2'   U B   5      25.823  28.154  41.211  1.00 95.31           C
ATOM    360  O2'   U B   5      25.306  28.715  42.402  1.00 93.90           O
ATOM    361  C1'   U B   5      25.356  26.711  41.009  1.00 91.70           C
ATOM    362  N1    U B   5      26.288  25.976  40.133  1.00 86.55           N
ATOM    363  C2    U B   5      27.630  25.841  40.510  1.00 84.98           C
ATOM    364  O2    U B   5      28.087  26.308  41.549  1.00 84.98           O
ATOM    365  N3    U B   5      28.414  25.140  39.614  1.00 81.70           N
ATOM    366  C4    U B   5      28.001  24.582  38.410  1.00 80.83           C
ATOM    367  O4    U B   5      28.814  24.001  37.700  1.00 78.29           O
ATOM    368  C5    U B   5      26.615  24.766  38.104  1.00 81.69           C
ATOM    369  C6    U B   5      25.828  25.436  38.948  1.00 83.47           C
ATOM    370  P     G B   6      25.787  31.046  38.844  1.00104.92           P
ATOM    371  OP1   G B   6      25.145  32.388  38.867  1.00105.88           O
ATOM    372  OP2   G B   6      25.771  30.232  37.592  1.00 99.78           O
ATOM    373  O5'   G B   6      27.284  31.157  39.362  1.00 96.16           O
ATOM    374  C5'   G B   6      27.523  31.596  40.678  1.00 89.27           C
ATOM    375  C4'   G B   6      28.917  31.242  41.098  1.00 86.03           C
ATOM    376  O4'   G B   6      29.039  29.800  41.187  1.00 84.86           O
ATOM    377  C3'   G B   6      29.977  31.617  40.088  1.00 82.81           C
ATOM    378  O3'   G B   6      30.313  32.985  40.174  1.00 84.95           O
ATOM    379  C2'   G B   6      31.118  30.687  40.459  1.00 80.99           C
ATOM    380  O2'   G B   6      31.875  31.126  41.568  1.00 81.46           O
ATOM    381  C1'   G B   6      30.352  29.416  40.818  1.00 78.89           C
ATOM    382  N9    G B   6      30.266  28.520  39.676  1.00 73.16           N
ATOM    383  C8    G B   6      29.181  28.292  38.870  1.00 72.56           C
ATOM    384  N7    G B   6      29.437  27.449  37.904  1.00 73.21           N
ATOM    385  C5    G B   6      30.768  27.097  38.100  1.00 70.41           C
ATOM    386  C6    G B   6      31.596  26.213  37.380  1.00 70.18           C
ATOM    387  O6    G B   6      31.301  25.522  36.395  1.00 72.55           O
ATOM    388  N1    G B   6      32.883  26.157  37.916  1.00 67.63           N
ATOM    389  C2    G B   6      33.303  26.853  39.020  1.00 68.56           C
ATOM    390  N2    G B   6      34.565  26.663  39.408  1.00 65.54           N
ATOM    391  N3    G B   6      32.534  27.676  39.702  1.00 69.43           N
ATOM    392  C4    G B   6      31.289  27.749  39.189  1.00 70.65           C
ATOM    393  P     A B   7      30.862  33.741  38.875  1.00 83.05           P
ATOM    394  OP1   A B   7      31.033  35.157  39.256  1.00 88.02           O
ATOM    395  OP2   A B   7      29.967  33.393  37.735  1.00 79.70           O
ATOM    396  O5'   A B   7      32.318  33.129  38.692  1.00 80.77           O
ATOM    397  C5'   A B   7      33.296  33.308  39.708  1.00 80.33           C
ATOM    398  C4'   A B   7      34.494  32.431  39.451  1.00 80.20           C
ATOM    399  O4'   A B   7      34.074  31.047  39.434  1.00 82.21           O
ATOM    400  C3'   A B   7      35.162  32.625  38.108  1.00 80.41           C
ATOM    401  O3'   A B   7      36.103  33.668  38.167  1.00 82.78           O
ATOM    402  C2'   A B   7      35.857  31.293  37.889  1.00 79.12           C
ATOM    403  O2'   A B   7      37.089  31.216  38.575  1.00 76.90           O
ATOM    404  C1'   A B   7      34.824  30.328  38.465  1.00 78.54           C
ATOM    405  N9    A B   7      33.883  29.863  37.448  1.00 75.68           N
ATOM    406  C8    A B   7      32.588  30.272  37.257  1.00 74.73           C
ATOM    407  N7    A B   7      31.973  29.648  36.283  1.00 74.35           N
ATOM    408  C5    A B   7      32.931  28.773  35.802  1.00 73.47           C
ATOM    409  C6    A B   7      32.897  27.828  34.785  1.00 71.54           C
ATOM    410  N6    A B   7      31.803  27.563  34.076  1.00 68.52           N
ATOM    411  N1    A B   7      34.030  27.141  34.527  1.00 71.59           N
ATOM    412  C2    A B   7      35.115  27.382  35.279  1.00 73.10           C
ATOM    413  N3    A B   7      35.263  28.234  36.286  1.00 74.66           N
ATOM    414  C4    A B   7      34.119  28.908  36.497  1.00 74.10           C
ATOM    415  P     G B   8      36.266  34.625  36.907  1.00 83.61           P
ATOM    416  OP1   G B   8      37.308  35.641  37.208  1.00 83.55           O
ATOM    417  OP2   G B   8      34.885  35.056  36.528  1.00 75.12           O
ATOM    418  O5'   G B   8      36.830  33.647  35.774  1.00 86.85           O
ATOM    419  C5'   G B   8      37.831  32.636  36.039  1.00 85.83           C
ATOM    420  C4'   G B   8      38.082  31.817  34.775  1.00 84.51           C
ATOM    421  O4'   G B   8      36.934  30.951  34.480  1.00 84.19           O
ATOM    422  C3'   G B   8      38.166  32.811  33.624  1.00 80.14           C
ATOM    423  O3'   G B   8      39.265  32.572  32.743  1.00 78.58           O
ATOM    424  C2'   G B   8      36.767  32.827  33.038  1.00 82.00           C
ATOM    425  O2'   G B   8      36.685  33.038  31.637  1.00 80.31           O
ATOM    426  C1'   G B   8      36.275  31.417  33.325  1.00 77.89           C
ATOM    427  N9    G B   8      34.835  31.425  33.499  1.00 75.97           N
ATOM    428  C8    G B   8      34.083  32.256  34.301  1.00 74.85           C
ATOM    429  N7    G B   8      32.800  32.092  34.145  1.00 73.54           N
ATOM    430  C5    G B   8      32.705  31.076  33.208  1.00 74.02           C
ATOM    431  C6    G B   8      31.575  30.481  32.636  1.00 75.48           C
ATOM    432  O6    G B   8      30.382  30.751  32.841  1.00 74.83           O
ATOM    433  N1    G B   8      31.930  29.475  31.722  1.00 76.90           N
ATOM    434  C2    G B   8      33.227  29.104  31.407  1.00 76.03           C
ATOM    435  N2    G B   8      33.375  28.096  30.503  1.00 74.16           N
ATOM    436  N3    G B   8      34.295  29.676  31.939  1.00 74.97           N
ATOM    437  C4    G B   8      33.960  30.643  32.820  1.00 74.92           C
ATOM    438  P     A B   9      39.672  33.646  31.616  1.00 76.40           P
ATOM    439  OP1   A B   9      40.522  34.688  32.233  1.00 76.89           O
ATOM    440  OP2   A B   9      38.490  34.041  30.802  1.00 72.01           O
ATOM    441  O5'   A B   9      40.652  32.803  30.700  1.00 74.00           O
ATOM    442  C5'   A B   9      41.680  32.035  31.291  1.00 69.32           C
ATOM    443  C4'   A B   9      41.998  30.852  30.426  1.00 67.69           C
ATOM    444  O4'   A B   9      40.968  29.848  30.581  1.00 67.77           O
ATOM    445  C3'   A B   9      41.976  31.142  28.939  1.00 68.52           C
ATOM    446  O3'   A B   9      43.210  31.663  28.506  1.00 68.85           O
ATOM    447  C2'   A B   9      41.741  29.766  28.349  1.00 65.15           C
ATOM    448  O2'   A B   9      42.911  28.991  28.448  1.00 69.19           O
ATOM    449  C1'   A B   9      40.771  29.175  29.354  1.00 62.35           C
ATOM    450  N9    A B   9      39.376  29.299  28.971  1.00 62.21           N
ATOM    451  C8    A B   9      38.410  30.070  29.542  1.00 60.88           C
ATOM    452  N7    A B   9      37.226  29.898  29.020  1.00 60.38           N
ATOM    453  C5    A B   9      37.433  28.962  28.032  1.00 59.90           C
ATOM    454  C6    A B   9      36.570  28.343  27.141  1.00 60.91           C
ATOM    455  N6    A B   9      35.254  28.554  27.118  1.00 59.91           N
ATOM    456  N1    A B   9      37.100  27.471  26.263  1.00 62.99           N
ATOM    457  C2    A B   9      38.412  27.238  26.307  1.00 62.04           C
ATOM    458  N3    A B   9      39.324  27.746  27.118  1.00 63.59           N
ATOM    459  C4    A B   9      38.759  28.608  27.969  1.00 61.53           C
ATOM    460  P     A B  10      43.212  32.832  27.422  1.00 72.71           P
ATOM    461  OP1   A B  10      44.630  33.207  27.208  1.00 75.61           O
ATOM    462  OP2   A B  10      42.228  33.852  27.861  1.00 71.52           O
ATOM    463  O5'   A B  10      42.640  32.138  26.106  1.00 69.96           O
ATOM    464  C5'   A B  10      43.441  31.227  25.361  1.00 66.83           C
ATOM    465  C4'   A B  10      42.671  30.698  24.173  1.00 62.38           C
ATOM    466  O4'   A B  10      41.569  29.900  24.655  1.00 59.31           O
ATOM    467  C3'   A B  10      42.006  31.758  23.327  1.00 62.42           C
ATOM    468  O3'   A B  10      42.898  32.269  22.355  1.00 64.28           O
ATOM    469  C2'   A B  10      40.891  30.978  22.672  1.00 61.32           C
ATOM    470  O2'   A B  10      41.394  30.180  21.638  1.00 65.89           O
ATOM    471  C1'   A B  10      40.463  30.052  23.805  1.00 57.55           C
ATOM    472  N9    A B  10      39.339  30.568  24.583  1.00 57.71           N
ATOM    473  C8    A B  10      39.345  31.302  25.744  1.00 56.84           C
ATOM    474  N7    A B  10      38.153  31.652  26.153  1.00 54.78           N
ATOM    475  C5    A B  10      37.302  31.103  25.209  1.00 55.30           C
ATOM    476  C6    A B  10      35.907  31.129  25.057  1.00 53.85           C
ATOM    477  N6    A B  10      35.072  31.693  25.920  1.00 54.75           N
ATOM    478  N1    A B  10      35.381  30.526  23.975  1.00 54.59           N
ATOM    479  C2    A B  10      36.203  29.897  23.138  1.00 55.20           C
ATOM    480  N3    A B  10      37.529  29.775  23.185  1.00 55.21           N
ATOM    481  C4    A B  10      38.021  30.421  24.246  1.00 56.60           C
ATOM    482  P     G B  11      42.721  33.777  21.843  1.00 63.40           P
ATOM    483  OP1   G B  11      43.745  34.065  20.819  1.00 68.96           O
ATOM    484  OP2   G B  11      42.651  34.614  23.060  1.00 65.83           O
ATOM    485  O5'   G B  11      41.306  33.770  21.121  1.00 63.27           O
ATOM    486  C5'   G B  11      41.122  33.050  19.923  1.00 59.49           C
ATOM    487  C4'   G B  11      39.672  33.055  19.529  1.00 59.44           C
ATOM    488  O4'   G B  11      38.905  32.374  20.563  1.00 53.44           O
ATOM    489  C3'   G B  11      39.025  34.427  19.444  1.00 57.48           C
ATOM    490  O3'   G B  11      39.279  35.086  18.219  1.00 56.41           O
ATOM    491  C2'   G B  11      37.551  34.086  19.623  1.00 57.69           C
ATOM    492  O2'   G B  11      36.968  33.539  18.460  1.00 53.90           O
ATOM    493  C1'   G B  11      37.627  32.981  20.676  1.00 55.66           C
ATOM    494  N9    G B  11      37.486  33.501  22.029  1.00 55.80           N
ATOM    495  C8    G B  11      38.510  33.774  22.902  1.00 55.12           C
ATOM    496  N7    G B  11      38.088  34.221  24.054  1.00 54.78           N
ATOM    497  C5    G B  11      36.705  34.258  23.930  1.00 52.40           C
ATOM    498  C6    G B  11      35.728  34.667  24.854  1.00 52.86           C
ATOM    499  O6    G B  11      35.903  35.059  26.014  1.00 52.22           O
ATOM    500  N1    G B  11      34.439  34.565  24.327  1.00 48.11           N
ATOM    501  C2    G B  11      34.153  34.091  23.074  1.00 50.13           C
ATOM    502  N2    G B  11      32.860  34.032  22.730  1.00 48.74           N
ATOM    503  N3    G B  11      35.071  33.695  22.207  1.00 50.45           N
ATOM    504  C4    G B  11      36.314  33.812  22.695  1.00 51.59           C
ATOM    505  P     G B  12      39.131  36.692  18.130  1.00 60.24           P
ATOM    506  OP1   G B  12      39.581  37.142  16.791  1.00 61.86           O
ATOM    507  OP2   G B  12      39.756  37.254  19.353  1.00 60.89           O
ATOM    508  O5'   G B  12      37.570  36.977  18.179  1.00 59.43           O
ATOM    509  C5'   G B  12      36.735  36.509  17.146  1.00 52.53           C
ATOM    510  C4'   G B  12      35.283  36.714  17.487  1.00 51.32           C
ATOM    511  O4'   G B  12      34.947  35.950  18.679  1.00 54.22           O
ATOM    512  C3'   G B  12      34.902  38.118  17.881  1.00 56.34           C
ATOM    513  O3'   G B  12      34.692  38.951  16.771  1.00 60.40           O
ATOM    514  C2'   G B  12      33.615  37.887  18.645  1.00 55.10           C
ATOM    515  O2'   G B  12      32.591  37.544  17.729  1.00 58.43           O
ATOM    516  C1'   G B  12      33.972  36.640  19.434  1.00 49.61           C
ATOM    517  N9    G B  12      34.553  36.995  20.720  1.00 52.52           N
ATOM    518  C8    G B  12      35.878  37.038  21.053  1.00 50.10           C
ATOM    519  N7    G B  12      36.070  37.377  22.303  1.00 48.36           N
ATOM    520  C5    G B  12      34.802  37.586  22.808  1.00 46.17           C
ATOM    521  C6    G B  12      34.383  38.001  24.096  1.00 49.14           C
ATOM    522  O6    G B  12      35.074  38.294  25.079  1.00 50.16           O
ATOM    523  N1    G B  12      33.007  38.088  24.180  1.00 45.72           N
ATOM    524  C2    G B  12      32.152  37.832  23.151  1.00 47.51           C
ATOM    525  N2    G B  12      30.852  37.990  23.403  1.00 49.65           N
ATOM    526  N3    G B  12      32.532  37.459  21.950  1.00 48.66           N
ATOM    527  C4    G B  12      33.858  37.356  21.852  1.00 47.72           C
ATOM    528  P     G B  13      35.045  40.508  16.892  1.00 61.42           P
ATOM    529  OP1   G B  13      34.858  41.052  15.531  1.00 65.30           O
ATOM    530  OP2   G B  13      36.357  40.625  17.564  1.00 59.63           O
ATOM    531  O5'   G B  13      33.896  41.068  17.833  1.00 58.71           O
ATOM    532  C5'   G B  13      32.538  40.935  17.445  1.00 58.31           C
ATOM    533  C4'   G B  13      31.603  41.352  18.559  1.00 59.53           C
ATOM    534  O4'   G B  13      31.791  40.469  19.701  1.00 61.57           O
ATOM    535  C3'   G B  13      31.839  42.743  19.135  1.00 61.46           C
ATOM    536  O3'   G B  13      31.146  43.702  18.326  1.00 71.10           O
ATOM    537  C2'   G B  13      31.196  42.612  20.507  1.00 56.49           C
ATOM    538  O2'   G B  13      29.801  42.627  20.403  1.00 59.75           O
ATOM    539  C1'   G B  13      31.557  41.183  20.897  1.00 53.91           C
ATOM    540  N9    G B  13      32.734  41.124  21.743  1.00 49.46           N
ATOM    541  C8    G B  13      34.001  40.785  21.391  1.00 51.09           C
ATOM    542  N7    G B  13      34.855  40.903  22.380  1.00 50.49           N
ATOM    543  C5    G B  13      34.086  41.329  23.443  1.00 47.04           C
ATOM    544  C6    G B  13      34.455  41.609  24.785  1.00 48.96           C
ATOM    545  O6    G B  13      35.583  41.539  25.308  1.00 48.68           O
ATOM    546  N1    G B  13      33.356  41.991  25.544  1.00 45.84           N
ATOM    547  C2    G B  13      32.073  42.089  25.063  1.00 47.53           C
ATOM    548  N2    G B  13      31.146  42.501  25.930  1.00 47.30           N
ATOM    549  N3    G B  13      31.724  41.815  23.816  1.00 45.21           N
ATOM    550  C4    G B  13      32.773  41.449  23.073  1.00 46.90           C
HETATM  551  P   S9L B  14      31.660  45.241  18.212  1.00 69.84           P
HETATM  552  O1P S9L B  14      31.014  45.645  16.906  1.00 76.30           O
HETATM  553  O2P S9L B  14      33.044  45.058  18.504  1.00 66.21           O
HETATM  554  O5' S9L B  14      30.658  45.866  19.300  1.00 76.43           O
HETATM  555  C12 S9L B  14      29.236  45.722  19.239  1.00 78.69           C
HETATM  556  C22 S9L B  14      28.684  45.865  20.666  1.00 84.29           C
HETATM  557  OH3 S9L B  14      27.924  47.069  20.730  1.00 94.37           O
HETATM  558  C13 S9L B  14      28.692  49.385  20.217  1.00100.58           C
HETATM  559  C23 S9L B  14      28.690  48.191  21.229  1.00 98.80           C
HETATM  560  OH4 S9L B  14      27.497  50.214  20.310  1.00102.60           O
HETATM  561  C14 S9L B  14      26.333  50.989  22.377  1.00 92.67           C
HETATM  562  C24 S9L B  14      27.512  51.199  21.383  1.00 96.17           C
HETATM  563  O3' S9L B  14      25.173  50.426  21.719  1.00 73.20           O
ATOM    564  P     G B  15      24.192  49.178  21.989  1.00 69.55           P
ATOM    565  OP1   G B  15      24.945  48.001  22.522  1.00 76.38           O
ATOM    566  OP2   G B  15      23.305  49.000  20.814  1.00 72.01           O
ATOM    567  O5'   G B  15      23.217  49.700  23.136  1.00 73.84           O
ATOM    568  C5'   G B  15      23.707  50.230  24.358  1.00 65.47           C
ATOM    569  C4'   G B  15      22.565  50.385  25.324  1.00 66.27           C
ATOM    570  O4'   G B  15      21.717  51.499  24.915  1.00 64.75           O
ATOM    571  C3'   G B  15      21.627  49.183  25.402  1.00 64.91           C
ATOM    572  O3'   G B  15      22.166  48.281  26.368  1.00 60.73           O
ATOM    573  C2'   G B  15      20.342  49.832  25.918  1.00 63.91           C
ATOM    574  O2'   G B  15      20.411  50.087  27.310  1.00 64.83           O
ATOM    575  C1'   G B  15      20.369  51.186  25.202  1.00 62.09           C
ATOM    576  N9    G B  15      19.633  51.137  23.952  1.00 60.46           N
ATOM    577  C8    G B  15      20.138  51.020  22.685  1.00 60.90           C
ATOM    578  N7    G B  15      19.210  50.949  21.774  1.00 59.14           N
ATOM    579  C5    G B  15      18.027  51.053  22.490  1.00 58.62           C
ATOM    580  C6    G B  15      16.676  51.059  22.045  1.00 58.04           C
ATOM    581  O6    G B  15      16.246  51.000  20.881  1.00 53.38           O
ATOM    582  N1    G B  15      15.794  51.154  23.111  1.00 56.42           N
ATOM    583  C2    G B  15      16.166  51.270  24.433  1.00 59.99           C
ATOM    584  N2    G B  15      15.180  51.375  25.343  1.00 58.74           N
ATOM    585  N3    G B  15      17.417  51.290  24.845  1.00 58.28           N
ATOM    586  C4    G B  15      18.282  51.170  23.832  1.00 57.37           C
ATOM    587  P     G B  16      21.754  46.732  26.371  1.00 59.34           P
ATOM    588  OP1   G B  16      22.754  46.145  27.283  1.00 68.53           O
ATOM    589  OP2   G B  16      21.473  46.119  25.052  1.00 53.87           O
ATOM    590  O5'   G B  16      20.345  46.633  27.086  1.00 63.40           O
ATOM    591  C5'   G B  16      20.170  47.008  28.430  1.00 62.51           C
ATOM    592  C4'   G B  16      18.703  46.972  28.737  1.00 67.29           C
ATOM    593  O4'   G B  16      18.055  48.071  28.037  1.00 66.52           O
ATOM    594  C3'   G B  16      17.995  45.743  28.198  1.00 67.40           C
ATOM    595  O3'   G B  16      18.115  44.609  29.038  1.00 63.09           O
ATOM    596  C2'   G B  16      16.563  46.235  28.081  1.00 67.38           C
ATOM    597  O2'   G B  16      15.951  46.331  29.347  1.00 69.53           O
ATOM    598  C1'   G B  16      16.785  47.651  27.564  1.00 66.84           C
ATOM    599  N9    G B  16      16.803  47.691  26.105  1.00 67.07           N
ATOM    600  C8    G B  16      17.907  47.642  25.294  1.00 67.63           C
ATOM    601  N7    G B  16      17.611  47.711  24.025  1.00 67.21           N
ATOM    602  C5    G B  16      16.234  47.817  23.997  1.00 66.71           C
ATOM    603  C6    G B  16      15.351  47.958  22.901  1.00 68.16           C
ATOM    604  O6    G B  16      15.617  48.029  21.696  1.00 66.96           O
ATOM    605  N1    G B  16      14.035  48.024  23.317  1.00 67.89           N
ATOM    606  C2    G B  16      13.622  47.969  24.619  1.00 68.48           C
ATOM    607  N2    G B  16      12.309  48.019  24.809  1.00 67.72           N
ATOM    608  N3    G B  16      14.436  47.865  25.654  1.00 67.15           N
ATOM    609  C4    G B  16      15.718  47.791  25.271  1.00 66.73           C
ATOM    610  P     C B  17      18.085  43.153  28.381  1.00 64.27           P
ATOM    611  OP1   C B  17      18.280  42.170  29.466  1.00 67.95           O
ATOM    612  OP2   C B  17      19.008  43.166  27.213  1.00 64.05           O
ATOM    613  O5'   C B  17      16.598  42.954  27.863  1.00 62.34           O
ATOM    614  C5'   C B  17      15.573  42.677  28.799  1.00 65.44           C
ATOM    615  C4'   C B  17      14.235  42.718  28.140  1.00 63.24           C
ATOM    616  O4'   C B  17      14.109  43.980  27.446  1.00 70.12           O
ATOM    617  C3'   C B  17      14.062  41.719  27.028  1.00 66.20           C
ATOM    618  O3'   C B  17      13.712  40.453  27.509  1.00 68.04           O
ATOM    619  C2'   C B  17      12.949  42.342  26.214  1.00 63.42           C
ATOM    620  O2'   C B  17      11.714  42.199  26.881  1.00 66.87           O
ATOM    621  C1'   C B  17      13.360  43.802  26.255  1.00 65.40           C
ATOM    622  N1    C B  17      14.204  44.150  25.098  1.00 66.34           N
ATOM    623  C2    C B  17      13.577  44.382  23.875  1.00 66.75           C
ATOM    624  O2    C B  17      12.345  44.286  23.812  1.00 68.28           O
ATOM    625  N3    C B  17      14.322  44.688  22.793  1.00 66.22           N
ATOM    626  C4    C B  17      15.652  44.746  22.895  1.00 66.26           C
ATOM    627  N4    C B  17      16.349  45.011  21.790  1.00 61.40           N
ATOM    628  C5    C B  17      16.323  44.521  24.134  1.00 64.68           C
ATOM    629  C6    C B  17      15.564  44.228  25.202  1.00 66.43           C
ATOM    630  P     A B  18      14.187  39.166  26.698  1.00 73.68           P
ATOM    631  OP1   A B  18      13.771  37.995  27.519  1.00 75.84           O
ATOM    632  OP2   A B  18      15.621  39.356  26.331  1.00 66.93           O
ATOM    633  O5'   A B  18      13.283  39.194  25.386  1.00 71.96           O
ATOM    634  C5'   A B  18      11.879  39.022  25.505  1.00 73.13           C
ATOM    635  C4'   A B  18      11.199  39.172  24.168  1.00 74.43           C
ATOM    636  O4'   A B  18      11.344  40.538  23.694  1.00 72.35           O
ATOM    637  C3'   A B  18      11.790  38.342  23.050  1.00 75.11           C
ATOM    638  O3'   A B  18      11.330  37.008  23.052  1.00 77.90           O
ATOM    639  C2'   A B  18      11.324  39.090  21.821  1.00 75.43           C
ATOM    640  O2'   A B  18       9.964  38.816  21.563  1.00 76.93           O
ATOM    641  C1'   A B  18      11.481  40.532  22.287  1.00 71.66           C
ATOM    642  N9    A B  18      12.815  40.998  21.951  1.00 69.25           N
ATOM    643  C8    A B  18      13.919  41.126  22.744  1.00 68.88           C
ATOM    644  N7    A B  18      14.977  41.559  22.105  1.00 67.46           N
ATOM    645  C5    A B  18      14.535  41.728  20.807  1.00 66.07           C
ATOM    646  C6    A B  18      15.173  42.160  19.646  1.00 64.95           C
ATOM    647  N6    A B  18      16.442  42.529  19.592  1.00 62.46           N
ATOM    648  N1    A B  18      14.451  42.209  18.518  1.00 67.49           N
ATOM    649  C2    A B  18      13.162  41.850  18.566  1.00 69.21           C
ATOM    650  N3    A B  18      12.446  41.425  19.600  1.00 68.24           N
ATOM    651  C4    A B  18      13.204  41.389  20.701  1.00 68.63           C
ATOM    652  P     G B  19      12.319  35.853  22.544  1.00 79.78           P
ATOM    653  OP1   G B  19      11.734  34.553  22.949  1.00 76.89           O
ATOM    654  OP2   G B  19      13.673  36.237  23.018  1.00 80.55           O
ATOM    655  O5'   G B  19      12.311  36.020  20.953  1.00 75.72           O
ATOM    656  C5'   G B  19      11.084  35.995  20.246  1.00 74.86           C
ATOM    657  C4'   G B  19      11.269  36.332  18.778  1.00 73.27           C
ATOM    658  O4'   G B  19      11.652  37.726  18.624  1.00 72.48           O
ATOM    659  C3'   G B  19      12.376  35.587  18.063  1.00 76.51           C
ATOM    660  O3'   G B  19      11.972  34.281  17.676  1.00 80.09           O
ATOM    661  C2'   G B  19      12.650  36.493  16.868  1.00 75.65           C
ATOM    662  O2'   G B  19      11.678  36.387  15.849  1.00 78.58           O
ATOM    663  C1'   G B  19      12.491  37.871  17.490  1.00 71.68           C
ATOM    664  N9    G B  19      13.781  38.415  17.884  1.00 69.26           N
ATOM    665  C8    G B  19      14.335  38.447  19.140  1.00 68.01           C
ATOM    666  N7    G B  19      15.537  38.959  19.154  1.00 67.97           N
ATOM    667  C5    G B  19      15.788  39.288  17.829  1.00 68.30           C
ATOM    668  C6    G B  19      16.932  39.861  17.226  1.00 67.73           C
ATOM    669  O6    G B  19      17.991  40.182  17.747  1.00 67.79           O
ATOM    670  N1    G B  19      16.760  40.040  15.861  1.00 69.43           N
ATOM    671  C2    G B  19      15.640  39.690  15.157  1.00 68.80           C
ATOM    672  N2    G B  19      15.691  39.930  13.836  1.00 69.15           N
ATOM    673  N3    G B  19      14.562  39.143  15.704  1.00 67.10           N
ATOM    674  C4    G B  19      14.706  38.973  17.034  1.00 68.30           C
ATOM    675  P     A B  20      13.075  33.120  17.531  1.00 82.24           P
ATOM    676  OP1   A B  20      12.376  31.889  17.053  1.00 81.75           O
ATOM    677  OP2   A B  20      13.855  33.084  18.799  1.00 79.17           O
ATOM    678  O5'   A B  20      14.038  33.636  16.366  1.00 79.83           O
ATOM    679  C5'   A B  20      13.604  33.596  15.016  1.00 76.01           C
ATOM    680  C4'   A B  20      14.554  34.344  14.100  1.00 72.11           C
ATOM    681  O4'   A B  20      14.797  35.667  14.644  1.00 73.20           O
ATOM    682  C3'   A B  20      15.949  33.766  13.975  1.00 72.70           C
ATOM    683  O3'   A B  20      16.020  32.695  13.052  1.00 73.55           O
ATOM    684  C2'   A B  20      16.765  34.965  13.521  1.00 71.97           C
ATOM    685  O2'   A B  20      16.621  35.260  12.156  1.00 73.39           O
ATOM    686  C1'   A B  20      16.119  36.082  14.324  1.00 70.90           C
ATOM    687  N9    A B  20      16.867  36.331  15.552  1.00 66.57           N
ATOM    688  C8    A B  20      16.581  35.998  16.850  1.00 65.95           C
ATOM    689  N7    A B  20      17.511  36.360  17.702  1.00 65.88           N
ATOM    690  C5    A B  20      18.461  36.984  16.908  1.00 63.86           C
ATOM    691  C6    A B  20      19.675  37.620  17.200  1.00 62.35           C
ATOM    692  N6    A B  20      20.182  37.739  18.423  1.00 57.73           N
ATOM    693  N1    A B  20      20.364  38.152  16.171  1.00 65.02           N
ATOM    694  C2    A B  20      19.859  38.053  14.941  1.00 65.03           C
ATOM    695  N3    A B  20      18.735  37.488  14.544  1.00 65.04           N
ATOM    696  C4    A B  20      18.075  36.971  15.585  1.00 64.24           C
ATOM    697  P     G B  21      16.973  31.458  13.380  1.00 73.07           P
ATOM    698  OP1   G B  21      16.850  30.410  12.339  1.00 78.35           O
ATOM    699  OP2   G B  21      16.689  31.122  14.794  1.00 73.56           O
ATOM    700  O5'   G B  21      18.430  32.078  13.263  1.00 73.42           O
ATOM    701  C5'   G B  21      18.792  32.803  12.100  1.00 71.93           C
ATOM    702  C4'   G B  21      20.126  33.487  12.283  1.00 72.42           C
ATOM    703  O4'   G B  21      19.997  34.602  13.213  1.00 72.72           O
ATOM    704  C3'   G B  21      21.229  32.632  12.880  1.00 72.34           C
ATOM    705  O3'   G B  21      21.895  31.894  11.875  1.00 73.78           O
ATOM    706  C2'   G B  21      22.168  33.690  13.430  1.00 69.23           C
ATOM    707  O2'   G B  21      22.873  34.291  12.364  1.00 71.22           O
ATOM    708  C1'   G B  21      21.184  34.719  13.973  1.00 67.35           C
ATOM    709  N9    G B  21      20.879  34.492  15.381  1.00 64.39           N
ATOM    710  C8    G B  21      19.851  33.755  15.925  1.00 61.52           C
ATOM    711  N7    G B  21      19.843  33.777  17.234  1.00 59.08           N
ATOM    712  C5    G B  21      20.933  34.570  17.568  1.00 59.54           C
ATOM    713  C6    G B  21      21.424  34.971  18.835  1.00 57.88           C
ATOM    714  O6    G B  21      20.963  34.714  19.951  1.00 58.20           O
ATOM    715  N1    G B  21      22.568  35.759  18.718  1.00 58.26           N
ATOM    716  C2    G B  21      23.153  36.126  17.531  1.00 59.92           C
ATOM    717  N2    G B  21      24.246  36.888  17.616  1.00 59.04           N
ATOM    718  N3    G B  21      22.693  35.770  16.343  1.00 59.79           N
ATOM    719  C4    G B  21      21.591  35.001  16.438  1.00 60.40           C
ATOM    720  P     A B  22      22.044  30.306  12.020  1.00 74.80           P
ATOM    721  OP1   A B  22      20.891  29.738  11.287  1.00 73.81           O
ATOM    722  OP2   A B  22      22.266  29.924  13.437  1.00 74.84           O
ATOM    723  O5'   A B  22      23.381  30.004  11.218  1.00 71.23           O
ATOM    724  C5'   A B  22      24.655  30.172  11.821  1.00 69.82           C
ATOM    725  C4'   A B  22      25.431  31.245  11.092  1.00 73.13           C
ATOM    726  O4'   A B  22      25.053  32.556  11.611  1.00 70.45           O
ATOM    727  C3'   A B  22      26.940  31.192  11.275  1.00 71.20           C
ATOM    728  O3'   A B  22      27.521  30.265  10.361  1.00 70.70           O
ATOM    729  C2'   A B  22      27.342  32.637  10.998  1.00 69.13           C
ATOM    730  O2'   A B  22      27.380  32.972   9.633  1.00 71.43           O
ATOM    731  C1'   A B  22      26.189  33.409  11.637  1.00 66.22           C
ATOM    732  N9    A B  22      26.489  33.750  13.029  1.00 63.81           N
ATOM    733  C8    A B  22      25.911  33.237  14.159  1.00 61.26           C
ATOM    734  N7    A B  22      26.425  33.695  15.271  1.00 61.16           N
ATOM    735  C5    A B  22      27.402  34.581  14.844  1.00 61.59           C
ATOM    736  C6    A B  22      28.312  35.390  15.545  1.00 61.36           C
ATOM    737  N6    A B  22      28.396  35.410  16.875  1.00 63.29           N
ATOM    738  N1    A B  22      29.145  36.177  14.830  1.00 60.36           N
ATOM    739  C2    A B  22      29.060  36.137  13.504  1.00 61.12           C
ATOM    740  N3    A B  22      28.254  35.402  12.729  1.00 62.51           N
ATOM    741  C4    A B  22      27.443  34.638  13.471  1.00 61.70           C
ATOM    742  P     A B  23      28.656  29.243  10.869  1.00 75.13           P
ATOM    743  OP1   A B  23      29.050  28.355   9.751  1.00 79.39           O
ATOM    744  OP2   A B  23      28.228  28.638  12.154  1.00 71.74           O
ATOM    745  O5'   A B  23      29.902  30.199  11.097  1.00 73.14           O
ATOM    746  C5'   A B  23      30.339  31.033  10.050  1.00 67.03           C
ATOM    747  C4'   A B  23      31.299  32.050  10.579  1.00 69.10           C
ATOM    748  O4'   A B  23      30.578  33.009  11.405  1.00 72.14           O
ATOM    749  C3'   A B  23      32.380  31.499  11.492  1.00 69.43           C
ATOM    750  O3'   A B  23      33.464  30.962  10.747  1.00 68.62           O
ATOM    751  C2'   A B  23      32.765  32.743  12.285  1.00 69.06           C
ATOM    752  O2'   A B  23      33.549  33.621  11.508  1.00 68.98           O
ATOM    753  C1'   A B  23      31.397  33.407  12.498  1.00 68.16           C
ATOM    754  N9    A B  23      30.769  32.971  13.756  1.00 64.12           N
ATOM    755  C8    A B  23      29.736  32.089  13.927  1.00 62.06           C
ATOM    756  N7    A B  23      29.481  31.821  15.184  1.00 60.61           N
ATOM    757  C5    A B  23      30.389  32.598  15.881  1.00 57.65           C
ATOM    758  C6    A B  23      30.637  32.743  17.239  1.00 57.35           C
ATOM    759  N6    A B  23      29.997  32.057  18.176  1.00 56.08           N
ATOM    760  N1    A B  23      31.588  33.614  17.618  1.00 57.33           N
ATOM    761  C2    A B  23      32.251  34.276  16.680  1.00 58.55           C
ATOM    762  N3    A B  23      32.122  34.207  15.363  1.00 60.66           N
ATOM    763  C4    A B  23      31.162  33.336  15.026  1.00 58.56           C
ATOM    764  P     A B  24      34.347  29.765  11.362  1.00 71.67           P
ATOM    765  OP1   A B  24      35.377  29.468  10.340  1.00 80.22           O
ATOM    766  OP2   A B  24      33.491  28.658  11.881  1.00 69.61           O
ATOM    767  O5'   A B  24      35.131  30.456  12.557  1.00 66.48           O
ATOM    768  C5'   A B  24      36.078  31.474  12.280  1.00 63.58           C
ATOM    769  C4'   A B  24      36.575  32.078  13.561  1.00 62.51           C
ATOM    770  O4'   A B  24      35.451  32.662  14.270  1.00 63.83           O
ATOM    771  C3'   A B  24      37.173  31.083  14.530  1.00 63.39           C
ATOM    772  O3'   A B  24      38.560  30.887  14.236  1.00 63.05           O
ATOM    773  C2'   A B  24      36.979  31.799  15.849  1.00 62.44           C
ATOM    774  O2'   A B  24      37.917  32.834  15.941  1.00 69.03           O
ATOM    775  C1'   A B  24      35.609  32.451  15.659  1.00 60.21           C
ATOM    776  N9    A B  24      34.505  31.603  16.117  1.00 57.08           N
ATOM    777  C8    A B  24      33.633  30.874  15.351  1.00 55.50           C
ATOM    778  N7    A B  24      32.765  30.186  16.049  1.00 53.07           N
ATOM    779  C5    A B  24      33.088  30.473  17.362  1.00 52.07           C
ATOM    780  C6    A B  24      32.558  30.021  18.593  1.00 52.43           C
ATOM    781  N6    A B  24      31.609  29.073  18.709  1.00 48.96           N
ATOM    782  N1    A B  24      33.071  30.557  19.725  1.00 53.16           N
ATOM    783  C2    A B  24      34.089  31.437  19.620  1.00 50.66           C
ATOM    784  N3    A B  24      34.703  31.888  18.524  1.00 53.29           N
ATOM    785  C4    A B  24      34.142  31.366  17.418  1.00 53.10           C
ATOM    786  P     C B  25      39.222  29.437  14.456  1.00 64.39           P
ATOM    787  OP1   C B  25      40.662  29.467  14.137  1.00 67.18           O
ATOM    788  OP2   C B  25      38.337  28.422  13.821  1.00 60.07           O
ATOM    789  O5'   C B  25      39.157  29.230  16.027  1.00 63.86           O
ATOM    790  C5'   C B  25      39.902  30.063  16.900  1.00 56.77           C
ATOM    791  C4'   C B  25      39.484  29.794  18.326  1.00 56.20           C
ATOM    792  O4'   C B  25      38.068  30.058  18.436  1.00 57.22           O
ATOM    793  C3'   C B  25      39.587  28.343  18.733  1.00 55.69           C
ATOM    794  O3'   C B  25      40.880  28.067  19.219  1.00 57.37           O
ATOM    795  C2'   C B  25      38.582  28.249  19.855  1.00 54.07           C
ATOM    796  O2'   C B  25      39.121  28.884  20.975  1.00 58.23           O
ATOM    797  C1'   C B  25      37.481  29.153  19.338  1.00 52.69           C
ATOM    798  N1    C B  25      36.393  28.458  18.653  1.00 51.87           N
ATOM    799  C2    C B  25      35.367  27.924  19.412  1.00 50.28           C
ATOM    800  O2    C B  25      35.425  28.028  20.642  1.00 54.01           O
ATOM    801  N3    C B  25      34.343  27.305  18.816  1.00 51.33           N
ATOM    802  C4    C B  25      34.316  27.198  17.491  1.00 53.91           C
ATOM    803  N4    C B  25      33.267  26.573  16.928  1.00 48.75           N
ATOM    804  C5    C B  25      35.358  27.724  16.681  1.00 54.57           C
ATOM    805  C6    C B  25      36.377  28.343  17.302  1.00 54.69           C
ATOM    806  P     A B  26      41.407  26.553  19.226  1.00 56.78           P
ATOM    807  OP1   A B  26      42.823  26.533  19.643  1.00 59.26           O
ATOM    808  OP2   A B  26      41.006  26.004  17.908  1.00 57.60           O
ATOM    809  O5'   A B  26      40.573  25.807  20.363  1.00 55.58           O
ATOM    810  C5'   A B  26      40.886  26.026  21.727  1.00 56.68           C
ATOM    811  C4'   A B  26      39.826  25.441  22.621  1.00 52.55           C
ATOM    812  O4'   A B  26      38.537  25.937  22.212  1.00 54.76           O
ATOM    813  C3'   A B  26      39.670  23.949  22.511  1.00 55.32           C
ATOM    814  O3'   A B  26      40.612  23.276  23.315  1.00 61.63           O
ATOM    815  C2'   A B  26      38.260  23.734  23.007  1.00 53.00           C
ATOM    816  O2'   A B  26      38.235  23.851  24.405  1.00 55.34           O
ATOM    817  C1'   A B  26      37.560  24.925  22.385  1.00 52.51           C
ATOM    818  N9    A B  26      37.025  24.602  21.069  1.00 51.77           N
ATOM    819  C8    A B  26      37.553  24.987  19.858  1.00 49.71           C
ATOM    820  N7    A B  26      36.826  24.614  18.829  1.00 49.70           N
ATOM    821  C5    A B  26      35.765  23.912  19.405  1.00 47.43           C
ATOM    822  C6    A B  26      34.653  23.271  18.847  1.00 49.02           C
ATOM    823  N6    A B  26      34.406  23.235  17.533  1.00 49.92           N
ATOM    824  N1    A B  26      33.784  22.676  19.681  1.00 48.65           N
ATOM    825  C2    A B  26      34.029  22.738  20.993  1.00 51.39           C
ATOM    826  N3    A B  26      35.038  23.314  21.638  1.00 49.19           N
ATOM    827  C4    A B  26      35.882  23.889  20.775  1.00 48.12           C
ATOM    828  P     C B  27      41.239  21.903  22.791  1.00 62.83           P
ATOM    829  OP1   C B  27      42.256  21.528  23.785  1.00 63.96           O
ATOM    830  OP2   C B  27      41.629  22.106  21.370  1.00 61.19           O
ATOM    831  O5'   C B  27      40.015  20.880  22.852  1.00 60.03           O
ATOM    832  C5'   C B  27      39.427  20.542  24.104  1.00 57.70           C
ATOM    833  C4'   C B  27      38.106  19.824  23.915  1.00 56.08           C
ATOM    834  O4'   C B  27      37.192  20.662  23.159  1.00 56.53           O
ATOM    835  C3'   C B  27      38.168  18.573  23.072  1.00 55.52           C
ATOM    836  O3'   C B  27      38.585  17.467  23.832  1.00 64.26           O
ATOM    837  C2'   C B  27      36.730  18.415  22.622  1.00 56.29           C
ATOM    838  O2'   C B  27      35.913  17.948  23.662  1.00 58.36           O
ATOM    839  C1'   C B  27      36.342  19.854  22.350  1.00 53.80           C
ATOM    840  N1    C B  27      36.562  20.187  20.938  1.00 51.31           N
ATOM    841  C2    C B  27      35.560  19.899  20.014  1.00 51.01           C
ATOM    842  O2    C B  27      34.526  19.351  20.407  1.00 49.85           O
ATOM    843  N3    C B  27      35.743  20.219  18.705  1.00 49.64           N
ATOM    844  C4    C B  27      36.879  20.799  18.319  1.00 50.84           C
ATOM    845  N4    C B  27      37.016  21.117  17.021  1.00 52.80           N
ATOM    846  C5    C B  27      37.929  21.092  19.242  1.00 49.25           C
ATOM    847  C6    C B  27      37.730  20.772  20.531  1.00 51.40           C
ATOM    848  P     A B  28      39.469  16.315  23.141  1.00 59.94           P
ATOM    849  OP1   A B  28      39.942  15.453  24.240  1.00 61.93           O
ATOM    850  OP2   A B  28      40.448  16.948  22.231  1.00 59.21           O
ATOM    851  O5'   A B  28      38.396  15.509  22.299  1.00 58.26           O
ATOM    852  C5'   A B  28      37.353  14.853  22.973  1.00 55.84           C
ATOM    853  C4'   A B  28      36.362  14.314  21.994  1.00 60.16           C
ATOM    854  O4'   A B  28      35.716  15.426  21.311  1.00 60.21           O
ATOM    855  C3'   A B  28      36.947  13.483  20.866  1.00 57.89           C
ATOM    856  O3'   A B  28      37.149  12.144  21.276  1.00 61.41           O
ATOM    857  C2'   A B  28      35.840  13.588  19.829  1.00 60.07           C
ATOM    858  O2'   A B  28      34.746  12.798  20.237  1.00 57.06           O
ATOM    859  C1'   A B  28      35.429  15.058  19.971  1.00 58.41           C
ATOM    860  N9    A B  28      36.197  15.931  19.079  1.00 54.60           N
ATOM    861  C8    A B  28      37.333  16.633  19.365  1.00 52.35           C
ATOM    862  N7    A B  28      37.782  17.343  18.350  1.00 53.30           N
ATOM    863  C5    A B  28      36.878  17.080  17.334  1.00 51.00           C
ATOM    864  C6    A B  28      36.779  17.554  16.015  1.00 52.82           C
ATOM    865  N6    A B  28      37.642  18.421  15.469  1.00 52.11           N
ATOM    866  N1    A B  28      35.747  17.118  15.269  1.00 53.29           N
ATOM    867  C2    A B  28      34.877  16.256  15.820  1.00 52.82           C
ATOM    868  N3    A B  28      34.866  15.745  17.046  1.00 52.26           N
ATOM    869  C4    A B  28      35.904  16.208  17.761  1.00 50.80           C
ATOM    870  P     C B  29      38.363  11.283  20.654  1.00 61.10           P
ATOM    871  OP1   C B  29      38.362  10.040  21.448  1.00 69.07           O
ATOM    872  OP2   C B  29      39.609  12.058  20.530  1.00 64.84           O
ATOM    873  O5'   C B  29      37.868  10.945  19.180  1.00 59.23           O
ATOM    874  C5'   C B  29      36.738  10.110  18.999  1.00 57.20           C
ATOM    875  C4'   C B  29      36.199  10.228  17.595  1.00 57.71           C
ATOM    876  O4'   C B  29      35.802  11.605  17.368  1.00 59.83           O
ATOM    877  C3'   C B  29      37.176   9.926  16.463  1.00 55.20           C
ATOM    878  O3'   C B  29      37.258   8.524  16.216  1.00 55.93           O
ATOM    879  C2'   C B  29      36.530  10.684  15.306  1.00 55.47           C
ATOM    880  O2'   C B  29      35.379  10.057  14.792  1.00 53.39           O
ATOM    881  C1'   C B  29      36.046  11.946  16.013  1.00 57.14           C
ATOM    882  N1    C B  29      37.080  12.991  15.933  1.00 51.10           N
ATOM    883  C2    C B  29      37.082  13.785  14.804  1.00 49.64           C
ATOM    884  O2    C B  29      36.197  13.579  13.955  1.00 48.64           O
ATOM    885  N3    C B  29      38.033  14.748  14.655  1.00 49.25           N
ATOM    886  C4    C B  29      38.951  14.924  15.611  1.00 51.02           C
ATOM    887  N4    C B  29      39.861  15.888  15.441  1.00 51.30           N
ATOM    888  C5    C B  29      38.973  14.116  16.790  1.00 50.06           C
ATOM    889  C6    C B  29      38.022  13.166  16.907  1.00 50.83           C
ATOM    890  P     G B  30      38.555   7.893  15.491  1.00 57.84           P
ATOM    891  OP1   G B  30      38.279   6.438  15.498  1.00 66.22           O
ATOM    892  OP2   G B  30      39.846   8.397  16.041  1.00 56.10           O
ATOM    893  O5'   G B  30      38.466   8.422  13.991  1.00 51.98           O
ATOM    894  C5'   G B  30      37.374   8.064  13.168  1.00 52.48           C
ATOM    895  C4'   G B  30      37.519   8.678  11.783  1.00 57.66           C
ATOM    896  O4'   G B  30      37.209  10.099  11.859  1.00 59.19           O
ATOM    897  C3'   G B  30      38.890   8.633  11.099  1.00 60.42           C
ATOM    898  O3'   G B  30      39.195   7.411  10.431  1.00 55.09           O
ATOM    899  C2'   G B  30      38.757   9.771  10.106  1.00 56.30           C
ATOM    900  O2'   G B  30      37.858   9.369   9.086  1.00 59.66           O
ATOM    901  C1'   G B  30      38.036  10.817  10.957  1.00 58.74           C
ATOM    902  N9    G B  30      38.979  11.642  11.720  1.00 56.23           N
ATOM    903  C8    G B  30      39.363  11.486  13.030  1.00 57.46           C
ATOM    904  N7    G B  30      40.261  12.360  13.413  1.00 55.59           N
ATOM    905  C5    G B  30      40.460  13.154  12.291  1.00 56.31           C
ATOM    906  C6    G B  30      41.312  14.268  12.093  1.00 55.56           C
ATOM    907  O6    G B  30      42.053  14.820  12.908  1.00 53.00           O
ATOM    908  N1    G B  30      41.248  14.739  10.787  1.00 55.06           N
ATOM    909  C2    G B  30      40.451  14.216   9.805  1.00 59.05           C
ATOM    910  N2    G B  30      40.556  14.761   8.573  1.00 61.11           N
ATOM    911  N3    G B  30      39.617  13.211   9.996  1.00 59.40           N
ATOM    912  C4    G B  30      39.681  12.724  11.243  1.00 56.74           C
ATOM    913  P     A B  31      40.712   6.860  10.419  1.00 58.54           P
ATOM    914  OP1   A B  31      40.545   5.528   9.758  1.00 62.72           O
ATOM    915  OP2   A B  31      41.332   6.928  11.767  1.00 56.87           O
ATOM    916  O5'   A B  31      41.522   7.880   9.490  1.00 52.09           O
ATOM    917  C5'   A B  31      41.048   8.190   8.193  1.00 57.06           C
ATOM    918  C4'   A B  31      41.873   9.278   7.549  1.00 64.03           C
ATOM    919  O4'   A B  31      41.530  10.577   8.115  1.00 67.50           O
ATOM    920  C3'   A B  31      43.376   9.209   7.771  1.00 66.91           C
ATOM    921  O3'   A B  31      44.135   8.241   7.063  1.00 72.10           O
ATOM    922  C2'   A B  31      43.800  10.625   7.456  1.00 65.31           C
ATOM    923  O2'   A B  31      43.685  10.841   6.069  1.00 75.27           O
ATOM    924  C1'   A B  31      42.673  11.426   8.090  1.00 65.32           C
ATOM    925  N9    A B  31      43.063  11.799   9.444  1.00 64.81           N
ATOM    926  C8    A B  31      42.918  11.079  10.594  1.00 64.21           C
ATOM    927  N7    A B  31      43.479  11.633  11.638  1.00 61.57           N
ATOM    928  C5    A B  31      44.000  12.814  11.148  1.00 60.50           C
ATOM    929  C6    A B  31      44.730  13.839  11.751  1.00 58.90           C
ATOM    930  N6    A B  31      45.087  13.841  13.035  1.00 53.05           N
ATOM    931  N1    A B  31      45.107  14.870  10.979  1.00 57.95           N
ATOM    932  C2    A B  31      44.771  14.857   9.698  1.00 57.76           C
ATOM    933  N3    A B  31      44.091  13.952   9.014  1.00 60.27           N
ATOM    934  C4    A B  31      43.732  12.941   9.804  1.00 61.70           C
TER
ATOM    936  O5'   U C  31      47.806  22.684  13.225  1.00 63.78           O
ATOM    937  C5'   U C  31      48.564  23.219  12.144  1.00 61.50           C
ATOM    938  C4'   U C  31      48.304  22.511  10.836  1.00 62.05           C
ATOM    939  O4'   U C  31      48.915  21.193  10.877  1.00 62.32           O
ATOM    940  C3'   U C  31      46.846  22.252  10.486  1.00 61.42           C
ATOM    941  O3'   U C  31      46.291  23.366   9.808  1.00 55.75           O
ATOM    942  C2'   U C  31      46.966  21.074   9.532  1.00 60.66           C
ATOM    943  O2'   U C  31      47.379  21.491   8.246  1.00 60.99           O
ATOM    944  C1'   U C  31      48.101  20.275  10.177  1.00 61.90           C
ATOM    945  N1    U C  31      47.607  19.281  11.141  1.00 63.87           N
ATOM    946  C2    U C  31      47.002  18.129  10.643  1.00 61.48           C
ATOM    947  O2    U C  31      46.897  17.892   9.449  1.00 61.68           O
ATOM    948  N3    U C  31      46.532  17.268  11.596  1.00 61.38           N
ATOM    949  C4    U C  31      46.612  17.428  12.965  1.00 63.05           C
ATOM    950  O4    U C  31      46.197  16.539  13.699  1.00 55.60           O
ATOM    951  C5    U C  31      47.261  18.637  13.394  1.00 61.71           C
ATOM    952  C6    U C  31      47.727  19.493  12.492  1.00 61.42           C
ATOM    953  P     C C  32      44.727  23.707   9.954  1.00 59.66           P
ATOM    954  OP1   C C  32      44.629  25.078   9.388  1.00 67.44           O
ATOM    955  OP2   C C  32      44.223  23.409  11.338  1.00 59.91           O
ATOM    956  O5'   C C  32      43.960  22.768   8.925  1.00 59.20           O
ATOM    957  C5'   C C  32      44.246  22.831   7.541  1.00 54.49           C
ATOM    958  C4'   C C  32      43.752  21.583   6.861  1.00 58.84           C
ATOM    959  O4'   C C  32      44.463  20.408   7.377  1.00 57.84           O
ATOM    960  C3'   C C  32      42.297  21.269   7.137  1.00 55.49           C
ATOM    961  O3'   C C  32      41.453  21.992   6.285  1.00 51.84           O
ATOM    962  C2'   C C  32      42.239  19.777   6.856  1.00 53.92           C
ATOM    963  O2'   C C  32      42.314  19.499   5.484  1.00 54.40           O
ATOM    964  C1'   C C  32      43.563  19.314   7.441  1.00 54.49           C
ATOM    965  N1    C C  32      43.388  18.922   8.840  1.00 57.29           N
ATOM    966  C2    C C  32      42.820  17.673   9.124  1.00 55.54           C
ATOM    967  O2    C C  32      42.392  17.001   8.200  1.00 49.29           O
ATOM    968  N3    C C  32      42.748  17.246  10.403  1.00 55.09           N
ATOM    969  C4    C C  32      43.215  18.016  11.382  1.00 56.51           C
ATOM    970  N4    C C  32      43.224  17.521  12.620  1.00 54.96           N
ATOM    971  C5    C C  32      43.727  19.328  11.130  1.00 58.42           C
ATOM    972  C6    C C  32      43.792  19.737   9.854  1.00 56.98           C
ATOM    973  P     G C  33      39.986  22.367   6.769  1.00 58.33           P
ATOM    974  OP1   G C  33      39.487  23.341   5.778  1.00 60.13           O
ATOM    975  OP2   G C  33      40.007  22.696   8.229  1.00 55.64           O
ATOM    976  O5'   G C  33      39.106  21.053   6.639  1.00 58.22           O
ATOM    977  C5'   G C  33      38.858  20.436   5.384  1.00 57.02           C
ATOM    978  C4'   G C  33      38.100  19.154   5.609  1.00 57.76           C
ATOM    979  O4'   G C  33      38.921  18.226   6.364  1.00 59.83           O
ATOM    980  C3'   G C  33      36.847  19.316   6.441  1.00 59.40           C
ATOM    981  O3'   G C  33      35.786  19.622   5.562  1.00 58.18           O
ATOM    982  C2'   G C  33      36.670  17.925   7.047  1.00 57.60           C
ATOM    983  O2'   G C  33      36.147  17.036   6.112  1.00 52.42           O
ATOM    984  C1'   G C  33      38.117  17.520   7.300  1.00 55.24           C
ATOM    985  N9    G C  33      38.611  17.859   8.632  1.00 56.37           N
ATOM    986  C8    G C  33      39.481  18.873   8.957  1.00 56.54           C
ATOM    987  N7    G C  33      39.832  18.866  10.220  1.00 55.93           N
ATOM    988  C5    G C  33      39.129  17.806  10.765  1.00 53.58           C
ATOM    989  C6    G C  33      39.136  17.290  12.074  1.00 53.97           C
ATOM    990  O6    G C  33      39.800  17.673  13.053  1.00 56.15           O
ATOM    991  N1    G C  33      38.289  16.191  12.192  1.00 54.46           N
ATOM    992  C2    G C  33      37.547  15.654  11.166  1.00 54.20           C
ATOM    993  N2    G C  33      36.815  14.590  11.461  1.00 56.85           N
ATOM    994  N3    G C  33      37.533  16.126   9.939  1.00 52.79           N
ATOM    995  C4    G C  33      38.346  17.190   9.805  1.00 55.20           C
ATOM    996  P     U C  34      34.448  20.270   6.140  1.00 61.76           P
ATOM    997  OP1   U C  34      33.510  20.436   5.000  1.00 62.97           O
ATOM    998  OP2   U C  34      34.869  21.439   6.934  1.00 64.46           O
ATOM    999  O5'   U C  34      33.856  19.175   7.135  1.00 62.43           O
ATOM   1000  C5'   U C  34      33.112  18.099   6.612  1.00 59.64           C
ATOM   1001  C4'   U C  34      32.776  17.093   7.675  1.00 59.02           C
ATOM   1002  O4'   U C  34      33.985  16.686   8.373  1.00 60.00           O
ATOM   1003  C3'   U C  34      31.898  17.602   8.790  1.00 60.08           C
ATOM   1004  O3'   U C  34      30.549  17.572   8.417  1.00 63.51           O
ATOM   1005  C2'   U C  34      32.182  16.595   9.883  1.00 61.80           C
ATOM   1006  O2'   U C  34      31.588  15.364   9.543  1.00 66.21           O
ATOM   1007  C1'   U C  34      33.680  16.412   9.726  1.00 58.05           C
ATOM   1008  N1    U C  34      34.411  17.345  10.589  1.00 59.64           N
ATOM   1009  C2    U C  34      34.578  16.969  11.895  1.00 59.84           C
ATOM   1010  O2    U C  34      34.068  15.969  12.342  1.00 63.95           O
ATOM   1011  N3    U C  34      35.348  17.812  12.663  1.00 55.48           N
ATOM   1012  C4    U C  34      35.937  18.979  12.267  1.00 53.99           C
ATOM   1013  O4    U C  34      36.613  19.606  13.070  1.00 55.17           O
ATOM   1014  C5    U C  34      35.668  19.343  10.913  1.00 53.78           C
ATOM   1015  C6    U C  34      34.926  18.532  10.134  1.00 58.72           C
ATOM   1016  P     G C  35      29.539  18.618   9.072  1.00 64.08           P
ATOM   1017  OP1   G C  35      28.273  18.505   8.310  1.00 62.25           O
ATOM   1018  OP2   G C  35      30.211  19.929   9.175  1.00 58.14           O
ATOM   1019  O5'   G C  35      29.368  18.073  10.564  1.00 64.94           O
ATOM   1020  C5'   G C  35      28.908  16.748  10.798  1.00 63.69           C
ATOM   1021  C4'   G C  35      28.952  16.394  12.280  1.00 62.84           C
ATOM   1022  O4'   G C  35      30.327  16.307  12.751  1.00 62.38           O
ATOM   1023  C3'   G C  35      28.282  17.360  13.232  1.00 62.26           C
ATOM   1024  O3'   G C  35      26.898  17.034  13.313  1.00 66.79           O
ATOM   1025  C2'   G C  35      28.986  17.033  14.541  1.00 63.89           C
ATOM   1026  O2'   G C  35      28.537  15.809  15.058  1.00 59.17           O
ATOM   1027  C1'   G C  35      30.415  16.764  14.088  1.00 61.04           C
ATOM   1028  N9    G C  35      31.331  17.904  14.134  1.00 62.30           N
ATOM   1029  C8    G C  35      31.596  18.772  13.102  1.00 61.25           C
ATOM   1030  N7    G C  35      32.534  19.636  13.387  1.00 60.70           N
ATOM   1031  C5    G C  35      32.898  19.342  14.694  1.00 59.68           C
ATOM   1032  C6    G C  35      33.870  19.942  15.523  1.00 58.90           C
ATOM   1033  O6    G C  35      34.652  20.856  15.249  1.00 58.90           O
ATOM   1034  N1    G C  35      33.890  19.370  16.786  1.00 58.33           N
ATOM   1035  C2    G C  35      33.076  18.356  17.200  1.00 57.54           C
ATOM   1036  N2    G C  35      33.214  17.989  18.472  1.00 56.47           N
ATOM   1037  N3    G C  35      32.181  17.759  16.426  1.00 59.59           N
ATOM   1038  C4    G C  35      32.146  18.300  15.190  1.00 60.51           C
ATOM   1039  P     G C  36      25.835  18.151  13.777  1.00 69.52           P
ATOM   1040  OP1   G C  36      24.509  17.694  13.323  1.00 71.26           O
ATOM   1041  OP2   G C  36      26.361  19.452  13.314  1.00 69.88           O
ATOM   1042  O5'   G C  36      25.858  18.095  15.370  1.00 63.22           O
ATOM   1043  C5'   G C  36      25.651  16.861  16.046  1.00 63.90           C
ATOM   1044  C4'   G C  36      25.986  17.002  17.514  1.00 64.44           C
ATOM   1045  O4'   G C  36      27.313  17.544  17.679  1.00 59.84           O
ATOM   1046  C3'   G C  36      25.039  17.958  18.228  1.00 62.76           C
ATOM   1047  O3'   G C  36      24.987  17.411  19.546  1.00 66.52           O
ATOM   1048  C2'   G C  36      25.762  19.304  18.188  1.00 62.11           C
ATOM   1049  O2'   G C  36      25.552  20.132  19.304  1.00 65.66           O
ATOM   1050  C1'   G C  36      27.224  18.840  18.204  1.00 63.27           C
ATOM   1051  N9    G C  36      28.246  19.680  17.607  1.00 57.77           N
ATOM   1052  C8    G C  36      28.212  20.325  16.394  1.00 58.54           C
ATOM   1053  N7    G C  36      29.276  21.050  16.175  1.00 60.04           N
ATOM   1054  C5    G C  36      30.053  20.861  17.311  1.00 57.15           C
ATOM   1055  C6    G C  36      31.301  21.397  17.650  1.00 55.82           C
ATOM   1056  O6    G C  36      31.992  22.174  16.999  1.00 60.08           O
ATOM   1057  N1    G C  36      31.739  20.944  18.890  1.00 54.41           N
ATOM   1058  C2    G C  36      31.045  20.070  19.695  1.00 54.79           C
ATOM   1059  N2    G C  36      31.621  19.751  20.869  1.00 53.29           N
ATOM   1060  N3    G C  36      29.868  19.552  19.378  1.00 53.27           N
ATOM   1061  C4    G C  36      29.434  19.997  18.189  1.00 56.26           C
ATOM   1062  P     U C  37      23.633  17.357  20.374  1.00 65.66           P
ATOM   1063  OP1   U C  37      23.783  16.225  21.316  1.00 63.06           O
ATOM   1064  OP2   U C  37      22.510  17.399  19.415  1.00 64.38           O
ATOM   1065  O5'   U C  37      23.663  18.692  21.241  1.00 68.57           O
ATOM   1066  C5'   U C  37      22.862  18.818  22.402  1.00 59.95           C
ATOM   1067  C4'   U C  37      23.548  19.692  23.415  1.00 59.04           C
ATOM   1068  O4'   U C  37      24.772  19.041  23.829  1.00 61.12           O
ATOM   1069  C3'   U C  37      23.970  21.017  22.762  1.00 59.21           C
ATOM   1070  O3'   U C  37      23.770  22.118  23.640  1.00 55.19           O
ATOM   1071  C2'   U C  37      25.439  20.835  22.397  1.00 59.71           C
ATOM   1072  O2'   U C  37      26.250  21.970  22.588  1.00 65.13           O
ATOM   1073  C1'   U C  37      25.868  19.822  23.447  1.00 61.32           C
ATOM   1074  N1    U C  37      27.015  18.995  23.113  1.00 62.13           N
ATOM   1075  C2    U C  37      28.168  19.314  23.756  1.00 64.37           C
ATOM   1076  O2    U C  37      28.201  20.157  24.616  1.00 63.78           O
ATOM   1077  N3    U C  37      29.279  18.618  23.353  1.00 67.94           N
ATOM   1078  C4    U C  37      29.321  17.633  22.375  1.00 68.76           C
ATOM   1079  O4    U C  37      30.381  17.111  22.075  1.00 71.41           O
ATOM   1080  C5    U C  37      28.047  17.329  21.790  1.00 68.08           C
ATOM   1081  C6    U C  37      26.960  18.005  22.181  1.00 65.50           C
ATOM   1082  P     C C  38      22.894  23.381  23.210  1.00 58.14           P
ATOM   1083  OP1   C C  38      23.176  24.321  24.317  1.00 58.76           O
ATOM   1084  OP2   C C  38      21.504  22.975  22.911  1.00 61.79           O
ATOM   1085  O5'   C C  38      23.525  23.945  21.856  1.00 60.78           O
ATOM   1086  C5'   C C  38      24.582  24.889  21.882  1.00 54.59           C
ATOM   1087  C4'   C C  38      24.952  25.302  20.481  1.00 57.76           C
ATOM   1088  O4'   C C  38      25.963  26.323  20.558  1.00 56.28           O
ATOM   1089  C3'   C C  38      25.560  24.147  19.706  1.00 56.64           C
ATOM   1090  O3'   C C  38      25.228  24.302  18.319  1.00 61.28           O
ATOM   1091  C2'   C C  38      27.065  24.310  19.903  1.00 56.05           C
ATOM   1092  O2'   C C  38      27.769  23.943  18.745  1.00 59.40           O
ATOM   1093  C1'   C C  38      27.186  25.830  20.092  1.00 54.91           C
ATOM   1094  N1    C C  38      28.222  26.385  20.955  1.00 55.75           N
ATOM   1095  C2    C C  38      29.117  27.328  20.424  1.00 53.93           C
ATOM   1096  O2    C C  38      29.062  27.587  19.218  1.00 57.28           O
ATOM   1097  N3    C C  38      30.012  27.924  21.238  1.00 50.90           N
ATOM   1098  C4    C C  38      30.053  27.585  22.529  1.00 53.72           C
ATOM   1099  N4    C C  38      30.950  28.208  23.344  1.00 54.45           N
ATOM   1100  C5    C C  38      29.181  26.593  23.076  1.00 54.62           C
ATOM   1101  C6    C C  38      28.294  26.026  22.263  1.00 54.13           C
ATOM   1102  P     C C  39      24.018  23.494  17.648  1.00 62.12           P
ATOM   1103  OP1   C C  39      24.126  22.100  18.123  1.00 64.39           O
ATOM   1104  OP2   C C  39      24.111  23.792  16.192  1.00 62.26           O
ATOM   1105  O5'   C C  39      22.682  24.140  18.251  1.00 66.93           O
ATOM   1106  C5'   C C  39      21.865  25.088  17.514  1.00 66.31           C
ATOM   1107  C4'   C C  39      20.469  25.161  18.128  1.00 66.96           C
ATOM   1108  O4'   C C  39      19.887  23.823  18.108  1.00 68.68           O
ATOM   1109  C3'   C C  39      20.600  25.544  19.611  1.00 68.18           C
ATOM   1110  O3'   C C  39      19.543  26.377  20.122  1.00 65.93           O
ATOM   1111  C2'   C C  39      20.605  24.215  20.356  1.00 69.44           C
ATOM   1112  O2'   C C  39      19.994  24.280  21.615  1.00 71.53           O
ATOM   1113  C1'   C C  39      19.753  23.364  19.424  1.00 70.14           C
ATOM   1114  N1    C C  39      19.839  21.911  19.497  1.00 74.53           N
ATOM   1115  C2    C C  39      18.674  21.235  19.856  1.00 77.01           C
ATOM   1116  O2    C C  39      17.622  21.897  19.994  1.00 76.05           O
ATOM   1117  N3    C C  39      18.708  19.892  20.028  1.00 76.64           N
ATOM   1118  C4    C C  39      19.848  19.226  19.819  1.00 77.32           C
ATOM   1119  N4    C C  39      19.838  17.900  20.009  1.00 77.53           N
ATOM   1120  C5    C C  39      21.050  19.891  19.409  1.00 75.75           C
ATOM   1121  C6    C C  39      20.999  21.224  19.262  1.00 75.25           C
ATOM   1122  P     A C  40      19.508  27.964  19.829  1.00 68.29           P
ATOM   1123  OP1   A C  40      18.218  28.474  20.358  1.00 67.25           O
ATOM   1124  OP2   A C  40      19.871  28.232  18.411  1.00 65.75           O
ATOM   1125  O5'   A C  40      20.656  28.527  20.768  1.00 66.04           O
ATOM   1126  C5'   A C  40      20.829  28.003  22.068  1.00 58.77           C
ATOM   1127  C4'   A C  40      22.196  28.370  22.579  1.00 63.55           C
ATOM   1128  O4'   A C  40      23.191  27.787  21.692  1.00 59.07           O
ATOM   1129  C3'   A C  40      22.506  29.862  22.533  1.00 61.57           C
ATOM   1130  O3'   A C  40      22.028  30.523  23.703  1.00 62.50           O
ATOM   1131  C2'   A C  40      24.026  29.863  22.490  1.00 60.74           C
ATOM   1132  O2'   A C  40      24.586  29.667  23.764  1.00 58.93           O
ATOM   1133  C1'   A C  40      24.314  28.635  21.618  1.00 56.65           C
ATOM   1134  N9    A C  40      24.582  28.938  20.218  1.00 54.96           N
ATOM   1135  C8    A C  40      23.759  28.805  19.126  1.00 55.42           C
ATOM   1136  N7    A C  40      24.318  29.180  17.999  1.00 52.45           N
ATOM   1137  C5    A C  40      25.593  29.578  18.378  1.00 52.75           C
ATOM   1138  C6    A C  40      26.676  30.069  17.651  1.00 54.52           C
ATOM   1139  N6    A C  40      26.643  30.274  16.334  1.00 56.08           N
ATOM   1140  N1    A C  40      27.809  30.356  18.322  1.00 53.81           N
ATOM   1141  C2    A C  40      27.833  30.175  19.641  1.00 52.07           C
ATOM   1142  N3    A C  40      26.879  29.727  20.439  1.00 54.22           N
ATOM   1143  C4    A C  40      25.769  29.436  19.733  1.00 53.43           C
ATOM   1144  P     U C  41      21.443  32.024  23.605  1.00 57.86           P
ATOM   1145  OP1   U C  41      20.999  32.338  24.966  1.00 60.76           O
ATOM   1146  OP2   U C  41      20.513  32.155  22.467  1.00 62.84           O
ATOM   1147  O5'   U C  41      22.696  32.937  23.242  1.00 57.02           O
ATOM   1148  C5'   U C  41      23.805  32.990  24.104  1.00 51.32           C
ATOM   1149  C4'   U C  41      24.936  33.748  23.461  1.00 55.96           C
ATOM   1150  O4'   U C  41      25.256  33.182  22.154  1.00 54.71           O
ATOM   1151  C3'   U C  41      24.478  35.176  23.191  1.00 53.31           C
ATOM   1152  O3'   U C  41      25.485  36.048  23.701  1.00 55.57           O
ATOM   1153  C2'   U C  41      24.081  35.207  21.720  1.00 52.50           C
ATOM   1154  O2'   U C  41      24.370  36.381  21.007  1.00 57.99           O
ATOM   1155  C1'   U C  41      24.993  34.132  21.158  1.00 54.14           C
ATOM   1156  N1    U C  41      24.644  33.499  19.882  1.00 54.66           N
ATOM   1157  C2    U C  41      25.454  33.787  18.806  1.00 53.26           C
ATOM   1158  O2    U C  41      26.429  34.472  18.899  1.00 55.43           O
ATOM   1159  N3    U C  41      25.077  33.244  17.616  1.00 54.30           N
ATOM   1160  C4    U C  41      23.990  32.461  17.390  1.00 58.35           C
ATOM   1161  O4    U C  41      23.706  32.142  16.239  1.00 61.08           O
ATOM   1162  C5    U C  41      23.206  32.178  18.561  1.00 59.99           C
ATOM   1163  C6    U C  41      23.565  32.697  19.745  1.00 56.76           C
ATOM   1164  P     U C  42      25.280  37.639  23.770  1.00 54.23           P
ATOM   1165  OP1   U C  42      25.273  37.975  25.192  1.00 53.10           O
ATOM   1166  OP2   U C  42      24.192  38.104  22.895  1.00 53.88           O
ATOM   1167  O5'   U C  42      26.648  38.161  23.186  1.00 52.14           O
ATOM   1168  C5'   U C  42      26.928  39.515  23.030  1.00 53.02           C
ATOM   1169  C4'   U C  42      27.603  39.727  21.703  1.00 55.55           C
ATOM   1170  O4'   U C  42      28.701  38.778  21.532  1.00 54.95           O
ATOM   1171  C3'   U C  42      26.592  39.386  20.603  1.00 57.37           C
ATOM   1172  O3'   U C  42      26.835  40.294  19.537  1.00 65.60           O
ATOM   1173  C2'   U C  42      26.928  37.957  20.183  1.00 57.73           C
ATOM   1174  O2'   U C  42      26.785  37.716  18.810  1.00 60.25           O
ATOM   1175  C1'   U C  42      28.423  37.918  20.455  1.00 52.63           C
ATOM   1176  N1    U C  42      29.033  36.606  20.659  1.00 53.07           N
ATOM   1177  C2    U C  42      29.917  36.126  19.699  1.00 50.70           C
ATOM   1178  O2    U C  42      30.237  36.731  18.707  1.00 49.62           O
ATOM   1179  N3    U C  42      30.419  34.896  19.951  1.00 51.93           N
ATOM   1180  C4    U C  42      30.153  34.102  21.019  1.00 54.10           C
ATOM   1181  O4    U C  42      30.651  32.982  21.076  1.00 55.73           O
ATOM   1182  C5    U C  42      29.253  34.662  21.957  1.00 56.84           C
ATOM   1183  C6    U C  42      28.735  35.871  21.746  1.00 54.68           C
ATOM   1184  P     A C  43      25.670  41.154  18.871  1.00 61.59           P
ATOM   1185  OP1   A C  43      25.439  42.330  19.741  1.00 63.77           O
ATOM   1186  OP2   A C  43      24.539  40.274  18.522  1.00 63.82           O
ATOM   1187  O5'   A C  43      26.446  41.657  17.581  1.00 55.70           O
ATOM   1188  C5'   A C  43      27.728  42.259  17.740  1.00 57.09           C
ATOM   1189  C4'   A C  43      28.564  42.043  16.507  1.00 58.65           C
ATOM   1190  O4'   A C  43      28.928  40.652  16.392  1.00 62.47           O
ATOM   1191  C3'   A C  43      27.918  42.402  15.188  1.00 60.67           C
ATOM   1192  O3'   A C  43      28.171  43.774  14.936  1.00 63.93           O
ATOM   1193  C2'   A C  43      28.691  41.523  14.216  1.00 61.45           C
ATOM   1194  O2'   A C  43      29.970  42.054  13.938  1.00 60.99           O
ATOM   1195  C1'   A C  43      28.872  40.252  15.043  1.00 60.88           C
ATOM   1196  N9    A C  43      27.728  39.364  14.942  1.00 59.55           N
ATOM   1197  C8    A C  43      26.980  38.894  15.981  1.00 60.66           C
ATOM   1198  N7    A C  43      26.017  38.085  15.625  1.00 57.88           N
ATOM   1199  C5    A C  43      26.133  38.027  14.255  1.00 60.61           C
ATOM   1200  C6    A C  43      25.405  37.334  13.290  1.00 62.54           C
ATOM   1201  N6    A C  43      24.399  36.497  13.581  1.00 61.42           N
ATOM   1202  N1    A C  43      25.757  37.511  11.998  1.00 63.39           N
ATOM   1203  C2    A C  43      26.798  38.314  11.719  1.00 61.91           C
ATOM   1204  N3    A C  43      27.579  39.003  12.548  1.00 62.45           N
ATOM   1205  C4    A C  43      27.181  38.819  13.817  1.00 62.32           C
ATOM   1206  P     C C  44      26.953  44.764  14.625  1.00 65.44           P
ATOM   1207  OP1   C C  44      27.655  46.020  14.281  1.00 67.20           O
ATOM   1208  OP2   C C  44      25.968  44.756  15.725  1.00 64.51           O
ATOM   1209  O5'   C C  44      26.228  44.095  13.370  1.00 65.25           O
ATOM   1210  C5'   C C  44      26.803  44.117  12.064  1.00 66.26           C
ATOM   1211  C4'   C C  44      25.917  43.349  11.097  1.00 68.34           C
ATOM   1212  O4'   C C  44      25.987  41.935  11.409  1.00 68.18           O
ATOM   1213  C3'   C C  44      24.433  43.666  11.187  1.00 70.06           C
ATOM   1214  O3'   C C  44      24.083  44.800  10.423  1.00 72.21           O
ATOM   1215  C2'   C C  44      23.787  42.404  10.646  1.00 70.85           C
ATOM   1216  O2'   C C  44      23.755  42.340   9.232  1.00 75.79           O
ATOM   1217  C1'   C C  44      24.717  41.336  11.214  1.00 68.37           C
ATOM   1218  N1    C C  44      24.237  40.881  12.516  1.00 66.24           N
ATOM   1219  C2    C C  44      23.195  39.945  12.561  1.00 67.32           C
ATOM   1220  O2    C C  44      22.668  39.573  11.497  1.00 70.80           O
ATOM   1221  N3    C C  44      22.774  39.483  13.756  1.00 65.57           N
ATOM   1222  C4    C C  44      23.331  39.942  14.875  1.00 63.60           C
ATOM   1223  N4    C C  44      22.889  39.448  16.025  1.00 63.55           N
ATOM   1224  C5    C C  44      24.370  40.922  14.858  1.00 61.79           C
ATOM   1225  C6    C C  44      24.793  41.355  13.668  1.00 62.45           C
ATOM   1226  P     C C  45      22.914  45.766  10.935  1.00 73.99           P
ATOM   1227  OP1   C C  45      22.978  46.954  10.048  1.00 80.68           O
ATOM   1228  OP2   C C  45      23.050  45.950  12.400  1.00 78.98           O
ATOM   1229  O5'   C C  45      21.577  44.942  10.670  1.00 72.99           O
ATOM   1230  C5'   C C  45      21.268  44.479   9.370  1.00 71.55           C
ATOM   1231  C4'   C C  45      20.022  43.638   9.395  1.00 74.15           C
ATOM   1232  O4'   C C  45      20.288  42.392  10.090  1.00 75.99           O
ATOM   1233  C3'   C C  45      18.868  44.235  10.171  1.00 77.03           C
ATOM   1234  O3'   C C  45      18.129  45.164   9.406  1.00 82.40           O
ATOM   1235  C2'   C C  45      18.034  43.014  10.513  1.00 77.62           C
ATOM   1236  O2'   C C  45      17.203  42.592   9.453  1.00 79.92           O
ATOM   1237  C1'   C C  45      19.123  41.983  10.791  1.00 76.51           C
ATOM   1238  N1    C C  45      19.430  41.948  12.221  1.00 75.77           N
ATOM   1239  C2    C C  45      18.629  41.171  13.053  1.00 76.15           C
ATOM   1240  O2    C C  45      17.675  40.535  12.549  1.00 76.42           O
ATOM   1241  N3    C C  45      18.907  41.128  14.377  1.00 74.86           N
ATOM   1242  C4    C C  45      19.933  41.828  14.867  1.00 73.65           C
ATOM   1243  N4    C C  45      20.182  41.742  16.177  1.00 73.39           N
ATOM   1244  C5    C C  45      20.753  42.640  14.040  1.00 72.46           C
ATOM   1245  C6    C C  45      20.473  42.667  12.734  1.00 74.85           C
ATOM   1246  P     U C  46      17.361  46.357  10.153  1.00 83.90           P
ATOM   1247  OP1   U C  46      16.901  47.300   9.117  1.00 86.83           O
ATOM   1248  OP2   U C  46      18.253  46.842  11.237  1.00 80.71           O
ATOM   1249  O5'   U C  46      16.076  45.636  10.744  1.00 78.96           O
ATOM   1250  C5'   U C  46      15.149  45.042   9.865  1.00 79.32           C
ATOM   1251  C4'   U C  46      14.062  44.353  10.638  1.00 80.54           C
ATOM   1252  O4'   U C  46      14.649  43.254  11.383  1.00 78.13           O
ATOM   1253  C3'   U C  46      13.362  45.186  11.702  1.00 81.04           C
ATOM   1254  O3'   U C  46      12.329  46.007  11.167  1.00 84.81           O
ATOM   1255  C2'   U C  46      12.817  44.106  12.629  1.00 81.20           C
ATOM   1256  O2'   U C  46      11.663  43.479  12.118  1.00 79.83           O
ATOM   1257  C1'   U C  46      13.966  43.095  12.622  1.00 78.83           C
ATOM   1258  N1    U C  46      14.912  43.333  13.726  1.00 75.05           N
ATOM   1259  C2    U C  46      14.610  42.790  14.956  1.00 74.16           C
ATOM   1260  O2    U C  46      13.591  42.150  15.158  1.00 72.66           O
ATOM   1261  N3    U C  46      15.537  43.036  15.943  1.00 72.82           N
ATOM   1262  C4    U C  46      16.704  43.769  15.820  1.00 73.91           C
ATOM   1263  O4    U C  46      17.471  43.855  16.775  1.00 74.61           O
ATOM   1264  C5    U C  46      16.933  44.312  14.522  1.00 72.88           C
ATOM   1265  C6    U C  46      16.055  44.076  13.543  1.00 75.33           C
ATOM   1266  P     G C  47      11.867  47.349  11.950  1.00 87.70           P
ATOM   1267  OP1   G C  47      10.952  48.079  11.037  1.00 89.24           O
ATOM   1268  OP2   G C  47      13.034  48.060  12.535  1.00 82.11           O
ATOM   1269  O5'   G C  47      10.983  46.805  13.151  1.00 79.01           O
ATOM   1270  C5'   G C  47       9.788  46.126  12.887  1.00 75.51           C
ATOM   1271  C4'   G C  47       9.198  45.626  14.167  1.00 76.63           C
ATOM   1272  O4'   G C  47      10.110  44.665  14.753  1.00 78.25           O
ATOM   1273  C3'   G C  47       9.059  46.682  15.242  1.00 76.72           C
ATOM   1274  O3'   G C  47       7.884  47.427  15.089  1.00 73.80           O
ATOM   1275  C2'   G C  47       9.030  45.845  16.504  1.00 77.83           C
ATOM   1276  O2'   G C  47       7.769  45.238  16.708  1.00 76.35           O
ATOM   1277  C1'   G C  47      10.073  44.779  16.167  1.00 76.43           C
ATOM   1278  N9    G C  47      11.410  45.132  16.652  1.00 75.66           N
ATOM   1279  C8    G C  47      12.478  45.612  15.924  1.00 74.94           C
ATOM   1280  N7    G C  47      13.545  45.810  16.653  1.00 73.99           N
ATOM   1281  C5    G C  47      13.157  45.439  17.937  1.00 72.60           C
ATOM   1282  C6    G C  47      13.887  45.421  19.138  1.00 71.85           C
ATOM   1283  O6    G C  47      15.076  45.719  19.311  1.00 72.29           O
ATOM   1284  N1    G C  47      13.105  44.995  20.208  1.00 68.32           N
ATOM   1285  C2    G C  47      11.786  44.622  20.119  1.00 71.51           C
ATOM   1286  N2    G C  47      11.174  44.239  21.247  1.00 69.54           N
ATOM   1287  N3    G C  47      11.104  44.620  19.001  1.00 72.67           N
ATOM   1288  C4    G C  47      11.844  45.035  17.955  1.00 73.02           C
ATOM   1289  P     C C  48       7.811  48.903  15.698  1.00 80.02           P
ATOM   1290  OP1   C C  48       6.444  49.333  15.319  1.00 83.11           O
ATOM   1291  OP2   C C  48       8.976  49.745  15.298  1.00 66.18           O
ATOM   1292  O5'   C C  48       7.815  48.629  17.263  1.00 74.49           O
ATOM   1293  C5'   C C  48       6.748  47.889  17.839  1.00 73.20           C
ATOM   1294  C4'   C C  48       6.817  47.941  19.346  1.00 74.85           C
ATOM   1295  O4'   C C  48       7.831  47.011  19.820  1.00 74.13           O
ATOM   1296  C3'   C C  48       7.211  49.278  19.956  1.00 72.94           C
ATOM   1297  O3'   C C  48       6.107  50.144  20.088  1.00 70.60           O
ATOM   1298  C2'   C C  48       7.736  48.846  21.312  1.00 73.19           C
ATOM   1299  O2'   C C  48       6.683  48.501  22.174  1.00 69.66           O
ATOM   1300  C1'   C C  48       8.481  47.563  20.948  1.00 74.90           C
ATOM   1301  N1    C C  48       9.877  47.865  20.585  1.00 74.97           N
ATOM   1302  C2    C C  48      10.849  47.903  21.601  1.00 74.21           C
ATOM   1303  O2    C C  48      10.510  47.653  22.776  1.00 73.23           O
ATOM   1304  N3    C C  48      12.122  48.203  21.277  1.00 73.06           N
ATOM   1305  C4    C C  48      12.445  48.445  20.005  1.00 73.37           C
ATOM   1306  N4    C C  48      13.718  48.725  19.726  1.00 71.31           N
ATOM   1307  C5    C C  48      11.481  48.407  18.959  1.00 72.73           C
ATOM   1308  C6    C C  48      10.224  48.117  19.288  1.00 73.89           C
ATOM   1309  P     C C  49       6.345  51.722  20.212  1.00 72.78           P
ATOM   1310  OP1   C C  49       5.000  52.306  20.399  1.00 75.64           O
ATOM   1311  OP2   C C  49       7.226  52.221  19.114  1.00 70.19           O
ATOM   1312  O5'   C C  49       7.136  51.891  21.583  1.00 73.03           O
ATOM   1313  C5'   C C  49       6.548  51.508  22.821  1.00 70.08           C
ATOM   1314  C4'   C C  49       7.534  51.700  23.961  1.00 67.90           C
ATOM   1315  O4'   C C  49       8.627  50.753  23.812  1.00 67.56           O
ATOM   1316  C3'   C C  49       8.229  53.050  24.038  1.00 66.97           C
ATOM   1317  O3'   C C  49       7.483  54.154  24.562  1.00 67.54           O
ATOM   1318  C2'   C C  49       9.476  52.705  24.834  1.00 64.72           C
ATOM   1319  O2'   C C  49       9.146  52.424  26.181  1.00 61.49           O
ATOM   1320  C1'   C C  49       9.836  51.355  24.232  1.00 64.72           C
ATOM   1321  N1    C C  49      10.759  51.465  23.085  1.00 66.79           N
ATOM   1322  C2    C C  49      12.125  51.414  23.336  1.00 65.69           C
ATOM   1323  O2    C C  49      12.508  51.327  24.491  1.00 66.63           O
ATOM   1324  N3    C C  49      12.995  51.476  22.322  1.00 66.26           N
ATOM   1325  C4    C C  49      12.560  51.609  21.082  1.00 66.97           C
ATOM   1326  N4    C C  49      13.473  51.664  20.124  1.00 66.44           N
ATOM   1327  C5    C C  49      11.167  51.692  20.776  1.00 67.50           C
ATOM   1328  C6    C C  49      10.305  51.614  21.804  1.00 67.55           C
TER
HETATM 1330  S   SO4 A  14      38.243  39.729  29.900  1.00164.99           S
HETATM 1331  O1  SO4 A  14      39.390  38.798  29.931  1.00164.12           O
HETATM 1332  O2  SO4 A  14      38.348  40.574  28.686  1.00163.74           O
HETATM 1333  O3  SO4 A  14      36.989  38.942  29.843  1.00163.73           O
HETATM 1334  O4  SO4 A  14      38.253  40.571  31.126  1.00163.18           O
TER
HETATM 1335 MG    MG B   1      19.137  31.639  18.078  1.00 84.82          MG
TER
HETATM 1336  O   HOH A  15      29.497  31.607  23.319  1.00 52.73           O
HETATM 1337  O   HOH A  16      27.000  23.623  24.819  1.00 59.89           O
HETATM 1338  O   HOH A  17      28.337  45.027  28.611  1.00 60.37           O
HETATM 1339  O   HOH A  18      35.221  36.919  30.275  1.00 75.28           O
HETATM 1340  O   HOH A  19      31.978  31.550  24.842  1.00 51.49           O
HETATM 1341  O   HOH A  20      28.310  21.177  30.198  1.00 81.71           O
HETATM 1342  O   HOH A  21      25.792  42.055  35.245  1.00 79.79           O
HETATM 1343  O   HOH A  22      28.213  43.397  36.242  1.00 73.07           O
TER
HETATM 1344  O   HOH B  32      43.461  10.866  14.207  1.00 54.90           O
HETATM 1345  O   HOH B  33      41.786  11.560  18.231  1.00 68.37           O
HETATM 1346  O   HOH B  34      39.412  22.482  15.604  1.00 68.45           O
HETATM 1347  O   HOH B  35      13.409  38.290  11.249  1.00 71.89           O
HETATM 1348  O   HOH B  36      19.234  40.607  20.266  1.00 68.42           O
HETATM 1349  O   HOH B  37      34.978  26.010  25.001  1.00 57.93           O
HETATM 1350  O   HOH B  38      43.200  31.748  16.937  1.00 65.93           O
HETATM 1351  O   HOH B  39      32.245  26.405   9.391  1.00 81.45           O
HETATM 1352  O   HOH B  40      37.028   6.989   7.187  1.00 77.73           O
HETATM 1353  O   HOH B  41      38.567   5.000   8.142  1.00 68.97           O
HETATM 1354  O   HOH B  42      35.411  24.306  14.558  1.00 78.07           O
HETATM 1355  O   HOH B  43      29.707  28.463  30.368  1.00 65.15           O
HETATM 1356  O   HOH B  44       9.326  43.157  25.603  1.00 58.94           O
HETATM 1357  O   HOH B  45      34.549  25.556   9.268  1.00 90.98           O
HETATM 1358  O   HOH B  46      32.448  13.507  17.596  1.00 69.71           O
TER
HETATM 1359  O   HOH C  50      32.605  30.380  22.809  1.00 57.80           O
HETATM 1360  O   HOH C  51      43.583  19.341  15.147  1.00 66.73           O
HETATM 1361  O   HOH C  52      30.032  24.775  15.187  1.00 78.45           O
HETATM 1362  O   HOH C  53      30.748  15.150  19.459  1.00 67.78           O
HETATM 1363  O   HOH C  54      27.095  23.888  15.066  1.00 80.32           O
HETATM 1364  O   HOH C  55      40.178  21.817  12.100  1.00 72.23           O
HETATM 1365  O   HOH C  56      40.761  19.873  14.154  1.00 84.02           O
HETATM 1366  O   HOH C  57      43.145  22.610  14.971  1.00 82.58           O
HETATM 1367  O   HOH C  58       9.857  51.874  13.578  1.00 70.06           O
HETATM 1368  O   HOH C  59      24.348  35.779   9.152  1.00 85.48           O
TER
END
"""

def write_plor_map(map_data, file_name, n_real, unit_cell):
  import iotbx.xplor.map
  frac_min, frac_max = (0.0, 0.0, 0.0), (1.0, 1.0, 1.0)
  gridding_first=[ifloor(f*n) for f,n in zip(frac_min,n_real)]
  gridding_last=[iceil(f*n) for f,n in zip(frac_max,n_real)]
  gridding = iotbx.xplor.map.gridding(n     = map_data.focus(),
                                      first = gridding_first,
                                      last  = gridding_last)
  iotbx.xplor.map.writer(
    file_name          = file_name,
    is_p1_cell         = True,
    title_lines        = [' None',],
    unit_cell          = unit_cell,
    gridding           = gridding,
    data               = map_data,
    average            = -1,
    standard_deviation = -1)

def exercise():
  import iotbx.pdb
  #
  xrs_orig = iotbx.pdb.input(source_info=None, lines=pdb_str).\
    xray_structure_simple()
  #
  fc_1 = xrs_orig.structure_factors(d_min = 3).f_calc()
  fft_map_1 = fc_1.fft_map(resolution_factor=1./3)
  n_real = fft_map_1.n_real()
  #>>> map 1
  fft_map = miller.fft_map(
    crystal_gridding = fft_map_1,
    fourier_coefficients = fc_1)
  fft_map.apply_sigma_scaling()
  map_data_1 = fft_map.real_map_unpadded()
  #
  write_plor_map(
    map_data=map_data_1,
    file_name="map_1_SigmaScaled.xplor",
    n_real=n_real,
    unit_cell=fc_1.unit_cell())
  #>>> map 2
  fc_2 = fc_1.resolution_filter(d_max=30)
  fft_map = miller.fft_map(
    crystal_gridding = fft_map_1,
    fourier_coefficients = fc_2)
  fft_map.apply_sigma_scaling()
  map_data_2 = fft_map.real_map_unpadded()
  #
  write_plor_map(
    map_data=map_data_2,
    file_name="map_2_SigmaScaled.xplor",
    n_real=n_real,
    unit_cell=fc_2.unit_cell())
  #-----------------------------------------------------------------------------
  result = []
  print("Original (sigma-scaled):")
  cc = maptbx.ccv(
    centered = True,
    modified = False,
    map_1    = map_data_1,
    map_2    = map_data_2)
  print("  CC(centered): %7.5f"%cc)
  result.append(cc)
  #
  cc = maptbx.ccv(
    centered = False,
    modified = False,
    map_1    = map_data_1,
    map_2    = map_data_2)
  print("  CC(non-cen):  %7.5f"%cc)
  result.append(cc)
  assert approx_equal(result, [0.81510, 0.81510], 1.e-4)
  assert approx_equal(result[0], result[1], 1.e-6)
  #-----------------------------------------------------------------------------
  result = []
  print("Percentile:")
  print("  Centered:")
  for p in [None, 0.5,0.6,0.7,0.8,0.9,0.95,0.99]:
    cc = maptbx.ccv(
      centered   = True,
      modified   = True,
      cutoff     = p,
      map_1      = map_data_1,
      map_2      = map_data_2)
    result.append(cc)
    print("    CC%s: %7.5f"%(str(p), cc))
  assert approx_equal(result, [0.17736, 0.12442, 0.19184, 0.32817, 0.57918,
    0.89395, 0.87455, 0.65101], 1.e-4)
  #-----------------------------------------------------------------------------
  result = []
  print("Percentile:")
  print("  Non-centered:")
  for p in [None, 0.5,0.6,0.7,0.8,0.9,0.95,0.99]:
    cc = maptbx.ccv(
      centered   = False,
      modified   = True,
      cutoff     = p,
      map_1      = map_data_1,
      map_2      = map_data_2)
    result.append(cc)
    print("    CC%s: %7.5f"%(str(p), cc))
  assert approx_equal(result, [0.79293, 0.56875, 0.58151, 0.64248, 0.78119,
    0.95907, 0.95905, 0.86516], 1.e-4)

if (__name__ == "__main__"):
  exercise()
