//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/GISASBeamEditor.h
//! @brief     Defines class GISASBeamEditor
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_GISASBEAMEDITOR_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_GISASBEAMEDITOR_H

#include <QGroupBox>

class BeamItem;

//! GISAS beam editor. Operates on GISASInstrumentItem.

class GISASBeamEditor : public QGroupBox {
    Q_OBJECT

public:
    GISASBeamEditor(QWidget* parent, BeamItem* item);

signals:
    void dataChanged();
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_GISASBEAMEDITOR_H
