//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _breitroot_9.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot9(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[9] = {1.020844277720390e+00,2.535325549744191e-01,2.323096077022466e+00,4.199350600657293e+00,6.713974316615029e+00,
    9.972009159539347e+00,1.415405367127805e+01,1.961190281916595e+01,2.725123652302706e+01};
  constexpr double aw[9] = {1.874603923315855e-01,9.928562743400975e-02,1.180374105004125e-01,3.354805250160214e-02,4.504254448322162e-03,
    2.713303693179653e-04,6.352683439554197e-06,4.242154619834280e-08,3.614323582198263e-11};
  constexpr double x[3456] = {  4.899380029235506e-02, -1.196290894649937e-03,  2.137178747682525e-05, -3.278549804673814e-07,  4.492535055104742e-09,
 -5.515220914505886e-11,  5.902991190637585e-13, -5.027447785750422e-15,  2.118462236884408e-17,  3.562565285862611e-19, -1.242546676094503e-20,  2.400748249197140e-22,
  1.915884995890970e-01, -4.351336393236831e-03,  6.648935103347045e-05, -7.487716552841069e-07,  5.095122668797034e-09,  1.853057067237486e-11, -1.260505416971305e-12,
  2.242063206849866e-14, -2.196407567757976e-16,  2.012300518862894e-20,  4.695950975985983e-20, -1.035793918142581e-21,  4.148561784061573e-01, -8.304654185967191e-03,
  9.288523571573907e-05, -3.540332193153588e-07, -8.726073335611472e-09,  1.882238192261682e-10, -1.097723564315297e-12, -2.334273598427344e-14,  6.171800513134831e-16,
 -4.393657162795164e-18, -7.979643122506830e-20,  2.425625841775663e-21,  6.980564713090320e-01, -1.155897842989753e-02,  6.822822522785417e-05,  7.630139047272255e-07,
 -1.636584256451659e-08, -1.763068339899758e-11,  3.640708324736220e-12, -2.643184329062853e-14, -6.667852781354472e-16,  1.259490839665575e-17,  6.537875949297311e-20,
 -4.030911124745207e-21,  1.013952809430373e+00, -1.281862075233095e-02, -1.393466009954178e-06,  1.403549656986148e-06,  1.327172670462559e-10, -2.768702389186049e-10,
  1.745758103581541e-15,  6.640071870172782e-14, -1.070620696921209e-17, -1.766131037143249e-17,  5.729545054813140e-21,  5.004014776735193e-21,  1.330841301282184e+00,
 -1.151167589754561e-02, -7.218720507057267e-05,  7.505253992904804e-07,  1.726505534687926e-08, -1.166966496668234e-11, -3.894577142995293e-12, -2.981002876108208e-14,
  7.281399471098305e-16,  1.418634873891745e-17, -7.424222876028081e-20, -4.656665126857575e-21,  1.615390306345786e+00, -8.091443313151338e-03, -9.646172725698837e-05,
 -4.432262384697522e-07,  8.456832622370157e-09,  2.090814394773072e-10,  1.498648835751948e-12, -2.309677569946571e-14, -7.369486098858049e-16, -6.539483491638469e-18,
  7.966854200179407e-20,  3.101370193676943e-21,  1.836248686812399e+00, -3.939107352318349e-03, -6.455011531251531e-05, -8.014705264835113e-07, -6.692589851658213e-09,
 -3.910884177450946e-12,  1.157890878221939e-12,  2.594821747325522e-14,  3.303594527385459e-16,  1.704422265117925e-18, -3.694794548748012e-20, -1.262399562043703e-21,
  1.968124108326799e+00, -8.247753660379950e-04, -1.574300288794575e-05, -2.610635684883428e-07, -3.936545113976044e-09, -5.470180888522411e-11, -6.982494014123717e-13,
 -8.019000677095048e-15, -7.818717932319572e-17, -5.259871199971873e-19,  1.113078330559604e-21,  1.288840131008838e-22,  4.452728896042191e-02, -1.039910726291864e-03,
  1.783477685596504e-05, -2.640753843142862e-07,  3.520195600751160e-09, -4.258876858748072e-11,  4.603714045735074e-13, -4.222354222350369e-15,  2.719811705742918e-17,
  2.667117082923963e-20, -4.976264698545779e-21,  1.126166850042727e-22,  1.751920584205786e-01, -3.853958261561861e-03,  5.800067780065179e-05, -6.657292252948513e-07,
  5.210001607264514e-09, -4.970838016789438e-12, -7.289000420365574e-13,  1.568711813289997e-14, -1.945778423378399e-16,  1.150746841574564e-18,  1.332542875354843e-20,
 -5.222144067315332e-22,  3.830938324231321e-01, -7.580663533682771e-03,  8.791820999658016e-05, -4.651501339039196e-07, -5.267142796479210e-09,  1.561036746962918e-10,
 -1.501875074082717e-12, -6.549502089001064e-15,  4.244285766722117e-16, -5.768376966435024e-18,  2.736947172458980e-21,  1.298938275758849e-21,  6.529639155774071e-01,
 -1.098097683082917e-02,  7.581623327283729e-05,  5.027974654664323e-07, -1.591527755032814e-08,  5.888291697282288e-11,  2.671754237923749e-12, -4.033451813855919e-14,
 -2.055451664672477e-16,  1.207083069239093e-17, -7.867189021013278e-20, -2.294054808138921e-21,  9.627622006658919e-01, -1.276277971608748e-02,  1.528085305622580e-05,
  1.362000184941489e-06, -5.256325218473583e-09, -2.551318568194736e-10,  1.763337582075408e-12,  5.634686249886192e-14, -5.916267572510402e-16, -1.332907370062170e-17,
  1.975707733056585e-19,  3.205942605055091e-21,  1.283703205708105e+00, -1.204850415302182e-02, -6.154825639270828e-05,  1.019589950504971e-06,  1.604485720657589e-08,
 -1.120814293416838e-10, -4.332724967474165e-12,  6.804762052920695e-16,  1.135183735805593e-15,  7.078082290611551e-18, -2.756138731754940e-19, -3.877763258877145e-21,
  1.581451141106397e+00, -8.881782527071945e-03, -1.008249838889263e-04, -2.727799868553993e-07,  1.293116116752484e-08,  2.344352098328736e-10,  4.924440829827152e-13,
 -4.954026838367980e-14, -8.786433413303119e-16, -2.632435887525597e-19,  2.400135754911948e-19,  3.867009651111891e-21,  1.819395979964926e+00, -4.495794063564823e-03,
 -7.480721246845927e-05, -9.073986945896097e-07, -6.427695619356961e-09,  3.383514360653464e-11,  2.038911917305741e-12,  3.708881661542620e-14,  3.488444421904853e-16,
 -1.206191283955337e-18, -1.171158164856578e-19, -2.425439785399009e-21,  1.964551648790180e+00, -9.644106434499835e-04, -1.929294795321762e-05, -3.337927428976798e-07,
 -5.217881484902828e-09, -7.445376222148964e-11, -9.605152955707097e-13, -1.080113215674587e-14, -9.446154555931068e-17, -3.112247260677898e-19,  1.138935170744336e-20,
  3.739024522237662e-22,  4.063420384127247e-02, -9.090116637255673e-04,  1.497754147183998e-05, -2.140045611737934e-07,  2.769840803871845e-09, -3.286049009194518e-11,
  3.542499054335803e-13, -3.366765644119624e-15,  2.556252132812610e-17, -9.530454011650007e-20, -1.581009220726005e-21,  4.918253773558078e-23,  1.606556245431948e-01,
 -3.420503760632404e-03,  5.050610633296767e-05, -5.839778180501232e-07,  4.967763565211435e-09, -1.785619067788418e-11, -3.700972074982326e-13,  1.018811329685977e-14,
 -1.480876173359443e-16,  1.331935080893188e-18, -1.954999995825807e-21, -2.041404089099447e-22,  3.541407922052001e-01, -6.900853375152878e-03,  8.192733797890231e-05,
 -5.264434457699740e-07, -2.513245477289412e-09,  1.192040638769137e-10, -1.525631292859151e-12,  3.823591642923121e-15,  2.296589338110958e-16, -4.823658363537262e-18,
  3.760532288098056e-20,  3.558599062669765e-22,  6.102853132725660e-01, -1.035453144821988e-02,  8.037101378453755e-05,  2.606657974204324e-07, -1.419010695277223e-08,
  1.090850168768789e-10,  1.510350305668027e-12, -4.072473120267731e-14,  1.539798422517367e-16,  7.553660311880764e-18, -1.318646940367879e-19, -2.110957230797479e-22,
  9.120565796098813e-01, -1.257695697575056e-02,  3.096067118605492e-05,  1.239870113910306e-06, -9.820687028043708e-09, -1.964016445560940e-10,  3.016042662638745e-12,
  3.147826495444480e-14, -9.044572026015891e-16, -3.630155894314580e-18,  2.609297938536339e-19, -3.742407702601070e-22,  1.234607796610606e+00, -1.248779241586929e-02,
 -4.786494542764423e-05,  1.252807302137169e-06,  1.278683071858481e-08, -2.115812073713118e-10, -3.783622377446862e-12,  3.868074020602729e-14,  1.159667654755710e-15,
 -6.299391127552281e-18, -3.616182604784148e-19,  4.162893084105159e-22,  1.544295517477213e+00, -9.697600620056729e-03, -1.027015699925529e-04, -2.825781015829793e-08,
  1.760950435813747e-08,  2.264965975746939e-10, -1.274685990385394e-12, -7.564123232817893e-14, -6.774404258696908e-16,  1.233922004059281e-17,  3.727887590919262e-19,
  1.464475014130463e-21,  1.800144549583840e+00, -5.139484688522393e-03, -8.628109448227443e-05, -1.001794555197263e-06, -5.171323028513980e-09,  9.641428572020993e-11,
  3.219394486742577e-12,  4.642329939085964e-14,  1.922464037523501e-16, -8.360202207616472e-18, -2.475045349150232e-19, -3.342448218493491e-21,  1.960357787025669e+00,
 -1.136317385512927e-03, -2.385287015622059e-05, -4.305530271442144e-07, -6.963772189780185e-09, -1.014831592790740e-10, -1.306100263515067e-12, -1.387546825340756e-14,
 -9.231202718066876e-17,  6.097359428989874e-19,  3.881046720833595e-20,  9.491956536193973e-22,  3.722253486411058e-02, -7.987572534530306e-04,  1.265511621422082e-05,
 -1.745132776024098e-07,  2.190478125526811e-09, -2.540080604162078e-11,  2.708508332980927e-13, -2.612305205063752e-15,  2.141466065688204e-17, -1.259005145938616e-19,
 -1.683830720206005e-22,  1.879213892476247e-23,  1.477391933183867e-01, -3.043164446068612e-03,  4.396217248556162e-05, -5.077452823156043e-07,  4.542340440948495e-09,
 -2.380740491211020e-11, -1.441566689236900e-13,  6.187358962253295e-15, -1.031871194971313e-16,  1.129586839722579e-18, -7.029664261951489e-21, -4.744387231433020e-23,
  3.278074642120970e-01, -6.271219059876237e-03,  7.544110663501778e-05, -5.495227535025738e-07, -4.829932055581378e-10,  8.455455753940493e-11, -1.339597905282379e-12,
  8.703982826370848e-15,  8.518963511374666e-17, -3.183000501715974e-18,  4.084924217950693e-20, -1.375591462615119e-22,  5.701677177379200e-01, -9.702734357887313e-03,
  8.221410000065609e-05,  5.267236395312516e-08, -1.173447491160320e-08,  1.324216362905668e-10,  4.726927878550859e-13, -3.245565919093755e-14,  3.327394105339957e-16,
  2.517527777401307e-18, -1.114894720067980e-19,  9.498068319406691e-22,  8.623342215548833e-01, -1.227270080068353e-02,  4.478011647173426e-05,  1.055487757869167e-06,
 -1.297063527968106e-08, -1.167610339896389e-10,  3.486485752202912e-12,  2.370505901271000e-15, -8.596574170113320e-16,  5.580501977655651e-18,  1.810138280953967e-19,
 -2.904868035560640e-21,  1.183990449510054e+00, -1.280745074678295e-02, -3.175816769411551e-05,  1.419049796072170e-06,  7.755292252553801e-09, -2.855047726102168e-10,
 -2.234353446807585e-12,  6.950027311874877e-14,  6.912531699344182e-16, -1.883880915638215e-17, -2.290113847500091e-19,  5.327989268853856e-21,  1.503866940081857e+00,
 -1.051545002670396e-02, -1.012081079503120e-04,  2.873136287942574e-07,  2.165141895056477e-08,  1.685538107813250e-10, -3.608566331650501e-12, -8.730328395390377e-14,
  3.586493623941129e-17,  2.685292102014219e-17,  3.043956617581035e-19, -5.132180044565632e-21,  1.778128221434128e+00, -5.879050128115217e-03, -9.872061556701033e-05,
 -1.064461179377586e-06, -2.362953644538116e-09,  1.896196532777243e-10,  4.544853166774927e-12,  4.556535534521831e-14, -3.214800460057572e-16, -2.105575141037591e-17,
 -3.770417018173517e-19, -1.873316671427707e-21,  1.955395257304426e+00, -1.349867036710957e-03, -2.976089903727205e-05, -5.600515593860857e-07, -9.339961654365616e-09,
 -1.377922027039511e-10, -1.729978216679634e-12, -1.608001209584670e-14, -2.971338355230495e-17,  3.298561164920703e-18,  1.045621306579648e-19,  2.182578482625977e-21,
  3.421751768750503e-02, -7.053335835877166e-04,  1.075555760995834e-05, -1.432000968793249e-07,  1.741923864647440e-09, -1.970488539952252e-11,  2.066172471525187e-13,
 -1.999543971377328e-15,  1.691486349123155e-17, -1.208803960346297e-19,  3.268255092565614e-22,  6.033998169175370e-24,  1.362330369886847e-01, -2.714640464898985e-03,
  3.828911777131159e-05, -4.390123480793931e-07,  4.043851451700980e-09, -2.552577507173734e-11, -1.142814642710727e-14,  3.479168365608826e-15, -6.786285990184312e-17,
  8.302771717578712e-19, -7.461014349445168e-21,  1.885709910202672e-23,  3.038878521544942e-01, -5.694081069748828e-03,  6.885085079984366e-05, -5.453815953685437e-07,
  9.075176878151691e-10,  5.554181453440940e-11, -1.072788802039658e-12,  9.896056123930101e-15, -2.044265825420434e-18, -1.731567465502658e-18,  3.072673278414654e-20,
 -2.764047474945132e-22,  5.326719716227988e-01, -9.045481219266870e-03,  8.180826334701394e-05, -1.135619251697066e-07, -9.039736848203129e-09,  1.341194950996111e-10,
 -2.789970335415094e-13, -2.112916343667166e-14,  3.542677798156301e-16, -9.975024590764982e-19, -6.300784046290912e-20,  1.132346125825843e-21,  8.140349396575842e-01,
 -1.186747251406896e-02,  5.613838632615510e-05,  8.337916631783094e-07, -1.447883960349706e-08, -3.516833659830206e-11,  3.206365424450393e-12, -2.079302643794181e-14,
 -5.615038417273419e-16,  1.004992482775741e-17,  4.145300436316535e-20, -3.055849945736986e-21,  1.132362749847983e+00, -1.299174171735239e-02, -1.418103563124404e-05,
  1.495238175223554e-06,  1.676646843144338e-09, -3.139551060504998e-10, -9.031004659812314e-14,  7.951071639097902e-14, -8.798411353509028e-17, -2.257148427452900e-17,
  5.187241232542876e-20,  6.617566789298663e-21,  1.460216254528878e+00, -1.130521309497099e-02, -9.558804413571693e-05,  6.551827376955146e-07,  2.396315937505582e-08,
  5.370775978739281e-11, -5.878146241588520e-12, -6.891768480383524e-14,  1.146535274485732e-15,  3.226258357072949e-17, -8.439993635085201e-20, -1.190797747514533e-20,
  1.752951115633932e+00, -6.720223152498815e-03, -1.115755336183066e-04, -1.065599949714258e-06,  2.614179031466878e-09,  3.120367130215418e-10,  5.541442925473663e-12,
  2.016662491131502e-14, -1.356712989509430e-15, -3.613089721141154e-17, -3.220207134497033e-19,  5.676415911213609e-21,  1.949473168782124e+00, -1.617602035944226e-03,
 -3.747682356173836e-05, -7.339468752755457e-07, -1.254743778042744e-08, -1.846781686301608e-10, -2.168672854219088e-12, -1.410232666065050e-14,  1.926536361783006e-16,
  9.988172764053629e-18,  2.465276520879478e-19,  4.462607602143914e-21,  3.155802057262589e-02, -6.257172152446966e-04,  9.192199191746782e-06, -1.182306535807058e-07,
  1.393178738173543e-09, -1.536067332307773e-11,  1.575743306052888e-13, -1.524916348467669e-15,  1.285395199275819e-17, -1.032440273990679e-19,  5.604147656248737e-22,
  6.758690059352599e-24,  1.259552378188472e-01, -2.428338936162001e-03,  3.339236465382093e-05, -3.783807104783364e-07,  3.537325596823811e-09, -2.485082894120288e-11,
  5.968191646524416e-14,  1.730571818078236e-15, -4.303091901343400e-17,  5.609077804170217e-19, -5.698338766223640e-21,  6.191735811956645e-23,  2.821721413977685e-01,
 -5.169129935359373e-03,  6.242577513662840e-05, -5.232801201911981e-07,  1.783075302253166e-09,  3.306286537022916e-11, -8.044309369231315e-13,  9.047149409731215e-15,
 -4.510058853232098e-17, -7.333838899297114e-19,  1.982160596859206e-20, -1.900305241569938e-22,  4.977871416835046e-01, -8.398724302343473e-03,  7.966455052380927e-05,
 -2.372810869673490e-07, -6.465803148279830e-09,  1.215569843705697e-10, -7.202190538400084e-13, -1.075934569140692e-14,  2.844916198957861e-16, -2.579723018224625e-18,
 -1.781416589490978e-20,  9.058214421506996e-22,  7.675210344583366e-01, -1.138230907557964e-02,  6.474363094031657e-05,  6.004542618028295e-07, -1.446889022640327e-08,
  3.310718439781111e-11,  2.427857327302493e-12, -3.289411503316178e-14, -1.989160641184665e-16,  9.405181627863098e-18, -6.194165707794344e-20, -1.465605314395868e-21,
  1.080282542728568e+00, -1.303343679685911e-02,  3.717222686252376e-06,  1.472455794611359e-06, -4.448533863871459e-09, -2.904480960627342e-10,  1.980404808506851e-12,
  6.462891245548468e-14, -7.987065858006508e-16, -1.534875782930068e-17,  2.862770858056498e-19,  3.527965806562246e-21,  1.413525030526008e+00, -1.203192176904798e-02,
 -8.541635414087759e-05,  1.038953227100999e-06,  2.349606545220155e-08, -1.053545735802867e-10, -7.130385685802615e-12, -1.536151267533197e-14,  2.115836100503785e-15,
  1.800976231075958e-17, -6.166244398815084e-19, -1.023325367122157e-20,  1.724205717864976e+00, -7.662743380586343e-03, -1.238821435618802e-04, -9.665335868499258e-07,
  1.019987044505108e-08,  4.456269643057719e-10,  5.288980911610961e-12, -4.582748034364740e-14, -2.793572634438656e-15, -4.002062004043313e-17,  2.375402926175817e-19,
  2.062141728987256e-20,  1.942342139311354e+00, -1.956358659905155e-03, -4.762011402768487e-05, -9.671990522747252e-07, -1.678817526136132e-08, -2.403572980669139e-10,
 -2.407121978162917e-12,  1.557323942104866e-16,  7.851112451966844e-16,  2.466819473384723e-17,  5.100658283562579e-19,  7.518827840051472e-21,  2.919374716451262e-02,
 -5.574978305447001e-04,  7.897666311457134e-06, -9.820574788253724e-08,  1.120550859663393e-09, -1.204804383638370e-11,  1.201114530328570e-13, -1.167994173149490e-15,
  9.636755156127603e-18, -7.209638379542139e-20,  1.076648539466504e-21,  1.738136185570349e-23,  1.167487122306778e-01, -2.178437336896641e-03,  2.917526870382202e-05,
 -3.256679080585799e-07,  3.057827372612662e-09, -2.297535725421319e-11,  9.161725529240703e-14,  6.388857260687181e-16, -2.614941237156281e-17,  4.023956280849795e-19,
 -1.850960824195576e-21,  1.126019281011074e-22,  2.624554076494978e-01, -4.694312328377951e-03,  5.633624019075250e-05, -4.904269015661759e-07,  2.270860550551801e-09,
  1.661401148549263e-11, -5.742726924899277e-13,  7.321445891398837e-15, -5.874078934057728e-17, -5.125447262445099e-20,  1.578724074264976e-20,  1.261327950572509e-23,
  4.654465964303255e-01, -7.774377861150059e-03,  7.627340799624710e-05, -3.223090389829061e-07, -4.226977688597165e-09,  1.015964396642997e-10, -9.085374914417575e-13,
 -3.204827294850172e-15,  1.878459361388901e-16, -2.554081393715508e-18,  1.788390848160337e-20,  7.370437380566594e-22,  7.230678650354466e-01, -1.083940446381757e-02,
  7.059129620399733e-05,  3.770928193911213e-07, -1.330112477237061e-08,  7.989735488419343e-11,  1.464645366108574e-12, -3.441042451271931e-14,  8.499618330672074e-17,
  6.236567644196899e-18, -8.200957289898009e-20,  5.003383065901555e-22,  1.028317912034111e+00, -1.293465301817501e-02,  2.077784589254700e-05,  1.357947599341618e-06,
 -9.652405146655742e-09, -2.245166165949775e-10,  3.366269464221918e-12,  3.266751491044629e-14, -1.119191730033224e-15, -2.042620283334258e-18,  3.496594191170366e-19,
 -4.533665733781076e-22,  1.364118377296559e+00, -1.265921261093090e-02, -7.079300104488348e-05,  1.388732775341735e-06,  1.968424367473239e-08, -2.735841147866680e-10,
 -6.553305477819752e-12,  5.726114219904462e-14,  2.240555165609175e-15, -1.233533809508170e-17, -7.997391938404995e-19,  3.421091370972150e-21,  1.691504036138875e+00,
 -8.696700575601561e-03, -1.341865693362382e-04, -7.257725528004067e-07,  2.022036849505032e-08,  5.458463535326080e-10,  2.562421134584421e-12, -1.543898386565681e-13,
 -3.803514113149403e-15, -8.007455064467039e-18,  1.448702461778462e-18,  3.187642305456964e-20,  1.933674321998899e+00, -2.388696990600292e-03, -6.100681800101871e-05,
 -1.277341329359788e-06, -2.215395644614831e-08, -2.942587965690045e-10, -1.885504744245249e-12,  4.411225053840630e-14,  2.125744874161620e-15,  5.223280023007202e-17,
  8.714962286499632e-19,  7.780655383152400e-21,  2.708306223116474e-02, -4.987429343147196e-04,  6.819296928020506e-06, -8.205851566473746e-08,  9.059388459880664e-10,
 -9.525029585715357e-12,  9.140337540913009e-14, -8.911910588716587e-16,  8.021478184815208e-18, -1.176600450929028e-20,  1.945299690432097e-21,  1.746967774489815e-23,
  1.084781455914555e-01, -1.959869640296302e-03,  2.554604138160302e-05, -2.802947089562487e-07,  2.621324428128881e-09, -2.064330813889044e-11,  9.992603920040803e-14,
  2.984517698509827e-17, -1.172415332309790e-17,  4.346248444602285e-19,  3.449715278115646e-21,  1.082602045383341e-22,  2.445431653143294e-01, -4.266524505421052e-03,
  5.067784079051302e-05, -4.521178422329749e-07,  2.480831518380346e-09,  5.081803693693746e-12, -3.949749733071263e-13,  5.538213806486859e-15, -4.864207634982355e-17,
  6.367032957606769e-19,  1.926395736553972e-20,  9.562365806774590e-23,  4.355435346407832e-01, -7.180664544962567e-03,  7.206306945867647e-05, -3.748893014220901e-07,
 -2.417193595558540e-09,  7.931547066614771e-11, -9.266011053417237e-13,  1.533974249435810e-15,  1.161742438054653e-16, -1.239614928970483e-18,  4.605382977768267e-20,
  4.792002130123892e-22,  6.808634331405430e-01, -1.026005928767032e-02,  7.389754457357567e-05,  1.786486859809108e-07, -1.142731443706271e-08,  1.039806664563729e-10,
  5.688496753427073e-13, -2.866241610252157e-14,  2.595925176568796e-16,  3.794545153629515e-18, -3.315374984851071e-20,  1.429885073930955e-21,  9.770108305136899e-01,
 -1.270618571856206e-02,  3.601329880629109e-05,  1.172214321773259e-06, -1.328160102592548e-08, -1.367701924502321e-10,  3.787282495371596e-12, -1.711672255790359e-15,
 -9.530343945686004e-16,  1.077685336902510e-17,  2.757709672521319e-19, -2.622172226536905e-21,  1.312461327052698e+00, -1.315401142551459e-02, -5.244494232708838e-05,
  1.652045265422468e-06,  1.280900223315862e-08, -4.041401338920819e-10, -4.053840159120435e-12,  1.162687516949094e-13,  1.301330453478909e-15, -3.652604932602929e-17,
 -3.047342614788382e-19,  1.750373689833458e-20,  1.654523965765633e+00, -9.798687177700752e-03, -1.405882124989869e-04, -3.132860306302452e-07,  3.133158157120959e-08,
  5.419160078338974e-10, -3.412599463408545e-12, -2.668882228055463e-13, -2.729577172417660e-15,  7.530606839230555e-17,  2.569703068373264e-18,  1.128589598878726e-20,
  1.923037233380787e+00, -2.944550310429909e-03, -7.866233504208885e-05, -1.680761766646765e-06, -2.834358476020044e-08, -3.150100954538950e-10,  6.358925732802584e-13,
  1.494879080521901e-13,  4.694205802873633e-15,  9.120248129658346e-17,  9.635483377165909e-19, -8.317541859021943e-21,  2.519129251654124e-02, -4.478946959542687e-04,
  5.915642512322794e-06, -6.897627065183170e-08,  7.355041400936691e-10, -7.601608384887552e-12,  7.009353396942141e-14, -6.252316603470806e-16,  9.107149460092830e-18,
  7.217224352810135e-20,  1.914834698570991e-21, -2.900630658175437e-23,  1.010270675791204e-01, -1.768272987294398e-03,  2.242094888967708e-05, -2.415264263545651e-07,
  2.232354562118961e-09, -1.826184514771575e-11,  9.809552603041111e-14, -6.111492939662344e-17,  7.217565495017863e-18,  6.274533724406106e-19,  4.742181010661228e-21,
 -9.170363005925613e-23,  2.282545107025018e-01, -3.882124021225274e-03,  4.549240926761929e-05, -4.120766126892885e-07,  2.499434975516862e-09, -2.686003851737796e-12,
 -2.571591461802483e-13,  4.501815558166548e-15, -1.142558724273622e-17,  1.418070420512111e-18,  1.686673390293365e-20, -3.100633154382628e-22,  4.079446149657800e-01,
 -6.622699341304139e-03,  6.738083871186317e-05, -4.020604467585794e-07, -1.047744325405721e-09,  5.798483411351988e-11, -8.355958642782084e-13,  4.922347537544060e-15,
  1.078852410317241e-16,  8.007766038695812e-19,  4.854949717064488e-20, -5.447726933749204e-22,  6.410149587986137e-01, -9.663250434476398e-03,  7.501463515856792e-05,
  1.293591342148351e-08, -9.270820540537233e-09,  1.090611541327882e-10, -9.801650990717007e-14, -1.831183409851907e-14,  3.858712405982427e-16,  3.510740266080061e-18,
  8.697788250014919e-21,  1.692253871749929e-23,  9.268460545272855e-01, -1.236560175557752e-02,  4.873038378403305e-05,  9.426910858066088e-07, -1.512797050944340e-08,
 -4.946820675455179e-11,  3.384455692714231e-12, -2.412605088970416e-14, -3.986575962163772e-16,  1.900837913944004e-17,  1.213096560571789e-19, -4.663692217521343e-21,
  1.259135790255379e+00, -1.349143159651878e-02, -3.167139770047143e-05,  1.788216130667628e-06,  4.035957319030044e-09, -4.589206859402228e-10, -4.206723773088796e-13,
  1.360936130665156e-13, -3.906319294216009e-17, -3.272376117554444e-17,  4.671808486025876e-19,  1.365817690302088e-20,  1.613069060740932e+00, -1.092912681849753e-02,
 -1.410038488352269e-04,  2.675965769165450e-07,  4.070780589735278e-08,  3.636901243620437e-10, -1.155834104702551e-11, -2.910107346004971e-13,  1.801157034183554e-15,
  1.709127292279177e-16,  1.713712201569184e-18, -5.603616402734907e-20,  1.909861198710145e+00, -3.662699990522076e-03, -1.017529677600393e-04, -2.182061785802989e-06,
 -3.405066127535322e-08, -2.292777364374311e-10,  7.463435578903369e-12,  3.582033651369818e-13,  8.463168053366262e-15,  1.083643741956924e-16, -5.722384728871136e-19,
 -7.310948138028362e-20,  2.348938973132970e-02, -4.036913473568554e-04,  5.153799914544630e-06, -5.833838425333003e-08,  5.990584219320324e-10, -6.093670449701466e-12,
  5.714107762770245e-14, -2.814911290820144e-16,  1.253725535723333e-17,  9.632046358977314e-20, -1.448152271126192e-21, -1.294795479055455e-22,  9.429517647793401e-02,
 -1.599918391159725e-03,  1.972529949465360e-05, -2.086025664658315e-07,  1.890749222654427e-09, -1.588012153688539e-11,  1.031971122786639e-13,  5.534406651636447e-16,
  3.123659291610084e-17,  6.226975221033492e-19, -8.102281723178127e-21, -5.152835037528201e-22,  2.134235272576241e-01, -3.537290627582352e-03,  4.078469337970927e-05,
 -3.728079924128540e-07,  2.394207528539280e-09, -7.335627860288453e-12, -1.278498135635028e-13,  5.041841215279541e-15,  4.620394439305296e-17,  1.563007034432995e-18,
 -1.675815161584909e-20, -1.277758194376329e-21,  3.825010596956965e-01, -6.103155199020258e-03,  6.249041625085287e-05, -4.105820603912449e-07, -7.525413995688908e-11,
  4.001286865127027e-11, -6.428541538036350e-13,  9.132765799990630e-15,  1.610912567739802e-16,  1.724357823704622e-18, -1.704883084472607e-20, -2.536730348581069e-21,
  6.035598309422623e-01, -9.064869908272030e-03,  7.435102109095165e-05, -1.182229567439865e-07, -7.146940013392502e-09,  1.020694942655138e-10, -4.186634766292951e-13,
 -3.929547721520181e-15,  5.099532553631852e-16,  2.885914387110125e-18, -6.748801676302897e-20, -3.716259946329965e-21,  8.782291045300721e-01, -1.193467205644352e-02,
  5.857136674260377e-05,  6.968946998868968e-07, -1.536446346046875e-08,  2.286554302726201e-11,  2.637249765880979e-12, -2.546184939544765e-14,  3.137790301717818e-16,
  1.865071826841366e-17, -1.706580784738824e-19, -8.931018568941782e-21,  1.204799859352215e+00, -1.365856536885744e-02, -1.012651035510126e-05,  1.780096168134849e-06,
 -4.939560614701416e-09, -4.243671205994219e-10,  3.226241532365065e-12,  1.204390380555723e-13, -7.886997876903333e-16, -8.036837074837270e-18,  5.927105623038967e-19,
 -9.885721294299034e-21,  1.567133050611453e+00, -1.203279857772710e-02, -1.337006490157769e-04,  9.594629069945431e-07,  4.460664412359126e-08,  1.037059271997569e-12,
 -1.791499046855274e-11, -1.278586136964378e-13,  8.393292700050741e-15,  1.687472020420909e-16, -2.260862333317081e-18, -1.143957672207419e-19,  1.893403082771767e+00,
 -4.590990432185033e-03, -1.313156326017205e-04, -2.749820676613218e-06, -3.586031611940220e-08,  1.040571331143117e-10,  2.179302957732254e-11,  6.786399349980446e-13,
  1.085162630528711e-14, -1.575115076835565e-17, -6.684650015828308e-18, -2.159618590049855e-19,  2.195286984772439e-02, -3.651070347415984e-04,  4.507463171788891e-06,
 -4.965575428903209e-08,  4.905058970565245e-10, -4.769036822761306e-12,  5.524398881486685e-14,  1.510352233660408e-16,  1.331699116946381e-17, -1.044360636621119e-19,
 -9.156090805733761e-21, -2.041103322079200e-22,  8.819594927809773e-02, -1.451637862863818e-03,  1.739355545122468e-05, -1.807492947863124e-07,  1.599828844753058e-09,
 -1.308724850891780e-11,  1.353165534447858e-13,  1.797120300598492e-15,  4.121119224394069e-17, -2.764187366881588e-19, -3.924513365115676e-20, -8.306949095162373e-22,
  1.998994900521693e-01, -3.228268620415636e-03,  3.653559954237013e-05, -3.357894877890514e-07,  2.229303401069833e-09, -8.498582591984612e-12,  4.083231705958685e-14,
  7.163519874185887e-15,  7.419997245046361e-17, -5.138686055247383e-19, -9.262318061545671e-20, -2.007129513053832e-21,  3.590571263303134e-01, -5.622904427242000e-03,
  5.758016441649850e-05, -4.061242845241166e-07,  5.946487127610525e-10,  2.828206255768844e-11, -3.080152686106346e-13,  1.489543093554750e-14,  1.786894988297972e-16,
 -1.752701498281864e-18, -1.678149514780510e-19, -3.989260591532668e-21,  5.684784382942226e-01, -8.477528857906274e-03,  7.231181662726735e-05, -2.167920737711178e-07,
 -5.205101367430399e-09,  9.261338273482289e-11, -2.905242548867653e-13,  1.314113607527125e-14,  5.154925953008040e-16, -4.186342141397487e-18, -3.082286454393999e-19,
 -6.642635458436713e-21,  8.314746948441051e-01, -1.143677330733387e-02,  6.548474857948788e-05,  4.579460832222565e-07, -1.432370089213596e-08,  7.929171955431868e-11,
  2.151581556728876e-12, -6.844979939530057e-15,  7.556091740407943e-16,  2.697113249234997e-18, -6.505835358309186e-19, -1.198765714006933e-20,  1.150136154911152e+00,
 -1.365608862496116e-02,  1.049699588287817e-05,  1.638464706542056e-06, -1.239481995531220e-08, -3.094550649545332e-10,  6.227145908526291e-12,  9.384273843927286e-14,
 -8.240503186011344e-16, -2.903915109241927e-19, -3.559849643276221e-19, -3.005184406982642e-20,  1.516952500472329e+00, -1.304437034231479e-02, -1.179817153087848e-04,
  1.649366636868825e-06,  4.021541805999828e-08, -4.367877903046802e-10, -1.700290586848167e-11,  2.107021791830291e-13,  1.164994460602017e-14, -1.799058005164323e-17,
 -6.728508651479538e-18, -6.680689657395281e-20,  1.872715797710761e+00, -5.782883241479659e-03, -1.675760460977451e-04, -3.271380683589548e-06, -2.681747208255378e-08,
  8.914717430219572e-10,  4.508211550306183e-11,  9.439191528923711e-13,  2.781490870099667e-15, -5.147488693702006e-16, -1.892195650494969e-17, -2.955444090763203e-19,
  2.056096668147072e-02, -3.313041584610737e-04,  3.955774333410802e-06, -4.249643615874739e-08,  4.089498107891700e-10, -3.350705932497402e-12,  6.427089357398386e-14,
  4.294538041167183e-16,  9.294893636340822e-19, -6.316390719073638e-19, -1.613293430658455e-20, -5.157954998972905e-23,  8.265454743461029e-02, -1.320748883119886e-03,
  1.537013417884220e-05, -1.570499885616107e-07,  1.375321793178298e-09, -9.108560287487517e-12,  2.000394954131676e-13,  2.584902404953080e-15, -5.288971194571936e-18,
 -2.502004247442741e-18, -6.765723338856155e-20, -2.072545011863759e-22,  1.875463050534881e-01, -2.951507564321534e-03,  3.271489913676068e-05, -3.013546406881212e-07,
  2.086585830191803e-09, -4.890202963129931e-12,  2.658003762908195e-13,  8.360798665661492e-15, -3.101142761184400e-17, -5.802781817285943e-18, -1.613604633830452e-19,
 -5.174275293396277e-22,  3.374562084513306e-01, -5.181554206831132e-03,  5.278153715436381e-05, -3.923342655345581e-07,  1.123045448246266e-09,  2.642775110297496e-11,
  1.684513495648583e-13,  1.797781262476963e-14, -4.512035304229261e-17, -1.162546234814849e-17, -3.056363764466436e-19, -1.115979630265668e-21,  5.357070203776653e-01,
 -7.910717072743201e-03,  6.927093643786386e-05, -2.854784883810696e-07, -3.384067790648436e-09,  9.168195927055250e-11,  2.655012569386676e-13,  2.429140801481362e-14,
  7.586851031928478e-17, -2.183117375400942e-17, -5.404435816514690e-19, -1.856513700769380e-21,  7.868048428964027e-01, -1.089467132757076e-02,  6.966638596553646e-05,
  2.442423875878933e-07, -1.222324382404948e-08,  1.312474759382578e-10,  2.271488011434320e-12,  1.288866203709978e-14,  2.668902977954661e-16, -3.256190923961026e-17,
 -1.046554076273175e-18, -2.652874495790612e-21,  1.095798967503808e+00, -1.349725114549884e-02,  2.879304156004385e-05,  1.399593145408210e-06, -1.689257883097966e-08,
 -1.316249871108771e-10,  8.449246752558412e-12,  6.195112706733757e-14, -1.408991098210674e-15, -4.030120467538673e-17, -1.546019563628683e-18, -1.609770532528468e-20,
  1.463027065171826e+00, -1.389891088678654e-02, -9.468148567189484e-05,  2.203492514486786e-06,  2.808490713874975e-08, -7.344927988934970e-10, -6.374181603249579e-12,
  5.176889337959446e-13,  5.796863908840140e-15, -3.068126258468473e-16, -6.640057831587552e-18,  7.844557207471640e-20,  1.846646446977378e+00, -7.286030846613679e-03,
 -2.086038952646443e-04, -3.490145702717452e-06,  3.930959658383960e-09,  2.277757294828502e-09,  6.880458133124519e-11,  5.696043018385011e-13, -3.170998914614488e-14,
 -1.429156653069746e-15, -2.223517028922296e-17,  3.468604326979459e-19,  1.929596373941938e-02, -3.015910874769870e-04,  3.483146936773565e-06, -3.640170674113520e-08,
  3.582467669000766e-10, -1.685974443136047e-12,  7.241961105851064e-14, -2.530128360159293e-17, -3.265567154640634e-17, -1.168830066726023e-18, -5.786636782722039e-21,
  6.262876457200696e-22,  7.760605039702585e-02, -1.204964155381079e-03,  1.361246223966573e-05, -1.362183426237268e-07,  1.246502904330449e-09, -3.559951518384030e-12,
  2.528425585992653e-13,  4.685333145563828e-16, -1.408562074221504e-16, -4.758991583446793e-18, -2.484490069381816e-20,  2.585165004439969e-21,  1.762416049758057e-01,
 -2.703690646846050e-03,  2.929705724213063e-05, -2.683304276006469e-07,  2.069975857736468e-09,  3.948861091828223e-12,  4.458535427308337e-13,  2.816985327914697e-15,
 -3.487147502696705e-16, -1.121218599035532e-17, -6.076755632344851e-20,  6.118550623675969e-21,  3.175451658214914e-01, -4.777786070658803e-03,  4.819994027431225e-05,
 -3.697550058765152e-07,  1.730011275445099e-09,  3.587728113733449e-11,  5.720688402345495e-13,  7.538785342723689e-15, -6.707088031788376e-16, -2.193755477668173e-17,
 -1.166004248960853e-19,  1.170500014460215e-20,  5.051496791674328e-01, -7.371030277888454e-03,  6.558257613323095e-05, -3.243828210339382e-07, -1.433821464181860e-09,
  1.056157013822487e-10,  8.321256238298421e-13,  1.008428218509011e-14, -1.075752757030884e-15, -4.004794678248153e-17, -2.072505547740734e-19,  2.055667544982955e-20,
  7.443549764790381e-01, -1.032872196456686e-02,  7.152042238127336e-05,  7.275546767915595e-08, -9.024560638607919e-09,  1.896895390435437e-10,  2.519051371962366e-12,
 -5.160533863996255e-15, -1.611990449668871e-15, -6.801716228096913e-17, -4.449036405190706e-19,  3.602652114767415e-20,  1.042370363351623e+00, -1.320444712869396e-02,
  4.391663342448973e-05,  1.119746289358833e-06, -1.739039285307971e-08,  8.509199528329670e-11,  9.245766892394901e-12, -1.876164042897755e-14, -3.999710427808438e-15,
 -9.953126272365963e-17, -8.766734133005131e-19,  5.790400491632188e-20,  1.406093259007663e+00, -1.454410097307739e-02, -6.604105868275063e-05,  2.532178736116431e-06,
  1.309840213355771e-08, -7.043885590957261e-10,  8.744830366109246e-12,  4.847091930842473e-13, -8.779412587105759e-15, -4.576451797448447e-16,  2.119694980467942e-19,
  2.318713332182022e-19,  1.813906238791567e+00, -9.117258411150029e-03, -2.483059040674946e-04, -2.970388255459786e-06,  6.647820768713656e-08,  3.953352729108768e-09,
  6.189655763227084e-11, -1.382219880306965e-12, -9.114283939666939e-14, -1.519475680327342e-15,  3.170647484259953e-17,  2.216232378416399e-18,  1.814269815795549e-02,
 -2.753777114960225e-04,  3.079904436194427e-06, -3.084794534947268e-08,  3.410747943156464e-10, -1.132981557825818e-13,  5.083799280742526e-14, -1.716260487764713e-15,
 -6.951614133282136e-17, -5.497084939491937e-19,  4.364014593088689e-20,  1.529050595521574e-21,  7.299411477302585e-02, -1.102267180345376e-03,  1.209621051289083e-05,
 -1.165209267143169e-07,  1.233741406593349e-09,  1.998081967623543e-12,  1.773893265278670e-13, -6.674820658559238e-15, -2.913207725327318e-16, -2.239812307904351e-18,
  1.793872934212078e-19,  6.327275791250327e-21,  1.658760097673346e-01, -2.481621212221956e-03,  2.628030746903229e-05, -2.339982874390173e-07,  2.254237841507441e-09,
  1.396147639729949e-11,  3.084022622536437e-13, -1.456488562076147e-14, -7.041833849306266e-16, -5.302892689504062e-18,  4.247483895894060e-19,  1.509337046645211e-20,
  2.991778617156271e-01, -4.409404699344847e-03,  4.395512718771801e-05, -3.355697687621853e-07,  2.586302185145772e-09,  4.898406435996678e-11,  3.650625466080602e-13,
 -2.610732575617157e-14, -1.367720307428903e-15, -1.054904911239189e-17,  8.201857582902360e-19,  2.929254682163577e-20,  4.766898962995436e-01, -6.862162325519885e-03,
  6.162561294717082e-05, -3.293315428016125e-07,  8.752826425385424e-10,  1.237507941873911e-10,  4.176460017260302e-13, -4.662685737209750e-14, -2.355570014963501e-15,
 -2.004117479552356e-17,  1.447778413036163e-18,  5.207335897819586e-20,  7.041868854606066e-01, -9.755212106287258e-03,  7.166251476770221e-05, -3.818577544563630e-08,
 -4.677771021731737e-09,  2.402947312741778e-10,  1.282926615792041e-12, -9.519893515682488e-14, -3.837665358204731e-15, -3.641034563732504e-17,  2.445985355817053e-18,
  9.130696778817333e-20,  9.903339304587546e-01, -1.280389085119095e-02,  5.577811656500763e-05,  8.666888330072704e-07, -1.360129273729680e-08,  2.828310767783454e-10,
  6.380379315986937e-12, -2.038533228830648e-13, -7.292659770226721e-15, -4.984787994625688e-17,  4.173394171449050e-18,  1.650105444451085e-19,  1.347056379674161e+00,
 -1.494829875679793e-02, -3.481460850444031e-05,  2.644307403108529e-06,  1.981992317291269e-09, -3.780172037256215e-10,  1.604727054582047e-11, -3.554730921178170e-14,
 -2.223540069296437e-14, -2.009027300306925e-16,  1.360569548261892e-17,  3.596959893469524e-19,  1.773272561382770e+00, -1.122176000867950e-02, -2.747493816558359e-04,
 -1.213096107535753e-06,  1.553963323127741e-07,  4.608285031705042e-09, -2.288754221851136e-11, -4.714876642791213e-12, -9.628483539522940e-14,  1.986273183770438e-15,
  1.410631403261431e-16,  1.728181387683219e-18,  1.708825250610896e-02, -2.521262464171897e-04,  2.742556481653867e-06, -2.536353488268363e-08,  3.457951264028711e-10,
  2.757873323974708e-13, -2.817858057850374e-14, -3.791678129494946e-15, -4.239277064642641e-17,  2.408682983174818e-18,  9.379349605481457e-20,  4.026972103527969e-23,
  6.877020900531891e-02, -1.010750777114498e-03,  1.081824644718625e-05, -9.631291274645028e-08,  1.295601434014045e-09,  2.947729991095655e-12, -1.391381560572069e-13,
 -1.536856712811001e-14, -1.785829324309915e-16,  9.966159095074345e-18,  3.878348589727837e-19,  2.070043734461470e-22,  1.563531218004895e-01, -2.281974561411102e-03,
  2.369876085353670e-05, -1.954798102972172e-07,  2.561073287818321e-09,  1.389598430320639e-11, -4.127347891093262e-13, -3.559791278233346e-14, -4.356398042172026e-16,
  2.373743788268214e-17,  9.257525288732278e-19,  6.516041325757676e-22,  2.822191149075748e-01, -4.073091610698814e-03,  4.020954880082509e-05, -2.862147355386298e-07,
  3.568364591064559e-09,  4.396584332518956e-11, -9.760800746898930e-13, -6.713319921322408e-14, -8.574626306799671e-16,  4.579197935182968e-17,  1.803256013518333e-18,
  1.693711734340836e-21,  4.502028127240824e-01, -6.384538460953997e-03,  5.783951043614715e-05, -2.955831415019536e-07,  3.299749660152540e-09,  1.094344314135228e-10,
 -1.946014361745154e-12, -1.179328995687701e-13, -1.499104188918067e-15,  8.005413103580985e-17,  3.221172853292892e-18,  4.060933322968896e-21,  6.663084274035790e-01,
 -9.184646684861587e-03,  7.091613820847735e-05, -7.407329696101049e-08,  1.463496773198999e-10,  2.248814461430519e-10, -3.118609824556614e-12, -2.122667533920774e-13,
 -2.441499089245685e-15,  1.361692239903785e-16,  5.615465478724042e-18,  9.827440250663281e-21,  9.400720831812674e-01, -1.231929204153877e-02,  6.507981483080194e-05,
  7.002189368302644e-07, -7.013691312957372e-09,  3.409468561080061e-10, -2.551244329086323e-12, -4.194056887796054e-13, -4.348905349269841e-15,  2.547000272880282e-16,
  1.007273414868588e-17,  2.316114074375227e-20,  1.286907283831733e+00, -1.509979612413158e-02, -3.078863991475419e-06,  2.634634489115337e-06, -2.235416443800334e-09,
 -8.740718441068223e-11,  4.926065324215531e-12, -7.281670809638638e-13, -1.613050748393685e-14,  6.179349187078816e-16,  2.464949207620135e-17, -2.615183804811221e-20,
  1.723965701738600e+00, -1.342914930213003e-02, -2.715787659004693e-04,  1.930821724390381e-06,  2.300051085503054e-07,  2.233477517835213e-09, -1.791635891818355e-10,
 -5.519058723697735e-12,  7.844061271519957e-14,  7.205174959388383e-15,  5.897145457916014e-17, -6.364088828193195e-18,  1.612183360598142e-02, -2.313091935827434e-04,
  2.471350857128358e-06, -1.986101488356849e-08,  3.355866658046893e-10, -1.723133433781271e-12, -1.355055522646610e-13, -3.113062885246342e-15,  9.991016302492073e-17,
  4.804897683616725e-18, -1.117141736125873e-20, -4.854248766295863e-21,  6.489347907099864e-02, -9.284728756607901e-04,  9.787810603152433e-06, -7.544575461535396e-08,
  1.284750520565673e-09, -5.768115835218265e-12, -5.756752892701039e-13, -1.266098403340064e-14,  4.104294668459059e-16,  1.990066688576466e-17, -4.541784790040536e-20,
 -2.010324190042911e-20,  1.475905520191675e-01, -2.101055023301460e-03,  2.160532691246607e-05, -1.531721804430321e-07,  2.655304113957777e-09, -8.513492680463412e-12,
 -1.428715726292844e-12, -2.945155836095417e-14,  9.699666561050631e-16,  4.756134613950458e-17, -1.048168509084779e-19, -4.808694552592742e-20,  2.665497928261665e-01,
 -3.764127690824296e-03,  3.714060108137411e-05, -2.240298246611551e-07,  4.053348307422971e-09, -3.120463995908411e-12, -2.899465419434465e-12, -5.566561606676382e-14,
  1.868758572382633e-15,  9.252303663994037e-17, -1.926536798263073e-19, -9.387646738530922e-20,  4.255690852720420e-01, -5.934968808033742e-03,  5.467008462051263e-05,
 -2.289929089109033e-07,  4.740331612639382e-09,  2.119527887215119e-11, -5.320435759017827e-12, -9.732136701579819e-14,  3.318504355466444e-15,  1.643237976921218e-16,
 -3.160256294376936e-19, -1.681981683307951e-19,  6.306993301716990e-01, -8.620528321730624e-03,  7.017080973292793e-05, -4.192412449703862e-08,  3.393148715409736e-09,
  7.589876801801065e-11, -9.128237121752044e-12, -1.725853213944253e-13,  5.857742129980180e-15,  2.846171220505837e-16, -5.164159956551185e-19, -2.960762451997378e-19,
  8.918873464628642e-01, -1.176647462542513e-02,  7.301207628371670e-05,  6.350840333608835e-07, -1.793760671016110e-09,  1.342133256584970e-10, -1.434160327316814e-11,
 -3.410363475473469e-13,  1.092690020588609e-14,  5.203281237300150e-16, -1.150723128574217e-18, -5.504585501642108e-19,  1.226658043001225e+00, -1.499870130472857e-02,
  2.826450575539942e-05,  2.583651907596559e-06, -4.643477793318511e-09, -2.452407996466795e-10, -1.810088772640102e-11, -7.210141251606278e-13,  2.037445889677817e-14,
  1.218184921470442e-15, -4.506516066502288e-18, -1.320681031248246e-18,  1.666141191779992e+00, -1.544489089472620e-02, -2.257355965797272e-04,  5.690297141479206e-06,
  2.216494766245630e-07, -3.397253988607432e-09, -2.601145143418233e-10,  9.274713493558441e-13,  2.958082817694548e-13,  2.363195457332521e-15, -3.038020266514441e-16,
 -6.373355120832978e-18,  1.523475283417016e-02, -2.124043169907827e-04,  2.263464265192280e-06, -1.496523639465760e-08,  2.640406639785916e-10, -5.514354435278427e-12,
 -1.551331022068312e-13,  2.313382471194007e-15,  2.092046865045946e-16, -1.862245888025474e-19, -2.206921043285961e-19, -2.337137823131242e-21,  6.133093373416484e-02,
 -8.534564414515669e-04,  8.999311495394147e-06, -5.664916540706266e-08,  1.012796602675477e-09, -2.175094833096037e-11, -6.519289175723565e-13,  9.711008108339271e-15,
  8.634747384525802e-16, -7.617871298585438e-19, -9.147460614638990e-19, -9.714259808573112e-21,  1.395213620854987e-01, -1.934868543095714e-03,  2.000994395484468e-05,
 -1.141106874427796e-07,  2.099726949035260e-09, -4.774822308072848e-11, -1.593101317067821e-12,  2.368401020300295e-14,  2.053887053788447e-15, -1.815247150843024e-18,
 -2.190677009581308e-18, -2.336748338946346e-20,  2.520720222350601e-01, -3.476685116908672e-03,  3.482598421822404e-05, -1.638275980745753e-07,  3.215914717946244e-09,
 -8.184520077500611e-11, -3.181468322822599e-12,  4.715648977226257e-14,  3.978803546278538e-15, -3.676987627333695e-18, -4.281753485274182e-18, -4.591436311819473e-20,
  4.026883296219584e-01, -5.507326769130272e-03,  5.236689037389787e-05, -1.573387224040945e-07,  3.750257567458911e-09, -1.222042416470540e-10, -5.777885682353908e-12,
  8.529819907431457e-14,  7.061449177501280e-15, -7.499877767831274e-18, -7.677868242936366e-18, -8.260658001408692e-20,  5.973381136265707e-01, -8.060219440758708e-03,
  7.000167772756664e-05,  1.145937122523118e-08,  2.475854351540126e-09, -1.713451525903439e-10, -9.985195821020218e-12,  1.469439283475084e-13,  1.229590214636979e-14,
 -1.735463002051323e-17, -1.352529602787752e-17, -1.442456571311100e-19,  8.460373193127622e-01, -1.115231188069378e-02,  8.048218425744480e-05,  6.068292613254810e-07,
 -3.052543096697611e-09, -2.693446717339539e-10, -1.654195394000893e-11,  2.475738304069239e-13,  2.243704412231353e-14, -4.844030832376282e-17, -2.521112224630731e-17,
 -2.524265783239327e-19,  1.167309326531126e+00, -1.465038610371076e-02,  5.856973662291191e-05,  2.441458658815827e-06, -1.498923123906082e-08, -8.119718825615719e-10,
 -2.352003325790993e-11,  4.764329996138181e-13,  4.611844711017100e-14, -1.629352858049076e-16, -5.812557030335989e-17, -4.171557154822127e-19,  1.601257997974861e+00,
 -1.692459750946870e-02, -1.394437499251678e-04,  8.382121543894578e-06,  9.890764283215434e-08, -8.272439573786363e-09, -1.073488980241485e-10,  9.147810976824454e-12,
  1.393730406685815e-13, -1.032159356663515e-14, -1.922586810685363e-16,  1.157704871857336e-17,  1.442030251834541e-02, -1.949526488069464e-04,  2.105026101669130e-06,
 -1.179023623406897e-08,  1.254240557714753e-10, -7.772325027000171e-12, -1.000791949763236e-14,  7.189962822346363e-15,  4.862113482975995e-17, -7.775215075671227e-18,
 -7.846756557470636e-20,  8.114249781641551e-21,  5.805713080409510e-02, -7.839435351487243e-04,  8.400022591837031e-06, -4.462893465883889e-08,  4.584246507857564e-10,
 -3.129586554211880e-11, -4.856367135813146e-14,  2.981244351974351e-14,  1.982711082958475e-16, -3.220473051008630e-17, -3.236754063970862e-19,  3.371871963076880e-20,
  1.320940701961570e-01, -1.779779612101472e-03,  1.880487012942191e-05, -8.987995869918484e-08,  8.520000643494347e-10, -7.127749470995599e-11, -1.423914122223648e-13,
  7.138133825770554e-14,  4.614930328531266e-16, -7.704615092299229e-17, -7.676702487149545e-19,  8.112894752227344e-20,  2.387110874782180e-01, -3.205214359114923e-03,
  3.310314676236274e-05, -1.289225418765803e-07,  9.918282156658588e-10, -1.293009307654980e-10, -3.383968370875514e-13,  1.391783891519388e-13,  8.638185627906316e-16,
 -1.504191874104133e-16, -1.473559637901354e-18,  1.597633230494133e-19,  3.814860756355944e-01, -5.095152714830874e-03,  5.073706438215324e-05, -1.231747798958208e-07,
  2.359228799653367e-10, -2.090975345341045e-10, -6.965202370702251e-13,  2.475063199700678e-13,  1.453348540834066e-15, -2.694433371829131e-16, -2.552654659180023e-18,
  2.898104027411085e-19,  5.662186465805713e-01, -7.499317523062908e-03,  7.022726283016320e-05,  1.279096105105678e-08, -2.800819757927858e-09, -3.215456733952047e-10,
 -1.211663200071746e-12,  4.260589118368850e-13,  2.316983252528617e-15, -4.738612928577031e-16, -4.183735138751166e-18,  5.194743804394089e-19,  8.027600382736509e-01,
 -1.048068909733764e-02,  8.723321842560102e-05,  4.970489365562768e-07, -1.146135433227435e-08, -5.107062633714395e-10, -1.216942848355165e-12,  7.452294911756615e-13,
  3.529694612275098e-15, -8.751382061507818e-16, -6.507153046000279e-18,  9.918589695181786e-19,  1.109822855812689e+00, -1.407011474758477e-02,  8.581216964158211e-05,
  2.048354312235489e-06, -3.501227122282858e-08, -1.070896754226812e-09,  6.475744906275609e-12,  1.431577330668556e-12,  2.776410469362853e-15, -1.896432096199760e-15,
 -7.145417164549984e-18,  2.337794486365255e-18,  1.531986358092105e+00, -1.762393346639353e-02, -3.502687303217236e-05,  8.592520798795330e-06, -7.051592258035422e-08,
 -7.640344951723341e-09,  1.511891978260896e-10,  7.288624574471368e-12, -2.337649268970082e-13, -6.821237835601147e-15,  3.241774618721102e-16,  6.015124207265194e-18,
  1.367330917897390e-02, -1.786558138059347e-04,  1.970599220959933e-06, -1.097184394874022e-08, -1.632708172931746e-11, -5.683101573874467e-12,  1.709159047042372e-13,
  4.387237829114546e-15, -1.994502666122548e-16, -3.833493758140117e-18,  2.359653132723628e-19,  2.960508490299807e-21,  5.505247974929162e-02, -7.188074202048639e-04,
  7.888399683943043e-06, -4.208209462092159e-08, -1.124575592519665e-10, -2.281302455616858e-11,  7.004343433575598e-13,  1.812216042427646e-14, -8.273807201923433e-16,
 -1.576498819444749e-17,  9.800034287507797e-19,  1.215692794632801e-20,  1.252691857239223e-01, -1.633529313994748e-03,  1.776231394402931e-05, -8.716193502880699e-08,
 -4.482725447703555e-10, -5.163636087424102e-11,  1.645947771382985e-12,  4.308644350933263e-14, -1.983863111653217e-15, -3.721454831611181e-17,  2.355492494825296e-18,
  2.859595602988776e-20,  2.264102084352819e-01, -2.946500514876940e-03,  3.156813677006338e-05, -1.328667953593355e-07, -1.365176938084282e-09, -9.259053323597483e-11,
  3.133247258653410e-12,  8.303345898581623e-14, -3.882314472111552e-15, -7.103803826337664e-17,  4.630430168812551e-18,  5.415255722996932e-20,  3.619075748988713e-01,
 -4.695416471286570e-03,  4.914708005029522e-05, -1.514296868784141e-07, -3.563219832150215e-09, -1.464223979365584e-10,  5.435780574348858e-12,  1.448152526074021e-13,
 -6.963075546329606e-15, -1.225239313986819e-16,  8.373741739854675e-18,  9.171409573013109e-20,  5.373442764343433e-01, -6.938126253697644e-03,  6.990553670538363e-05,
 -8.104678702561763e-08, -8.580337765164700e-09, -2.148656865616923e-10,  9.227794789731790e-12,  2.406658475586506e-13, -1.221713672402478e-14, -2.013079105851053e-16,
  1.491681068995654e-17,  1.440175342085378e-19,  7.622653940306213e-01, -9.762834219985639e-03,  9.177443008334393e-05,  2.373182717754337e-07, -2.033451916024285e-08,
 -3.055055198133496e-10,  1.663762537409936e-11,  3.895361798129428e-13, -2.233177595846849e-14, -3.221316389969061e-16,  2.803643339707982e-17,  1.999525790344063e-19,
  1.055055624933537e+00, -1.329632698473781e-02,  1.063877499822399e-04,  1.338279924587904e-06, -5.183638014641199e-08, -4.846054957205334e-10,  3.827613251568861e-11,
  5.642703032790697e-13, -4.788281692380328e-14, -4.345692878789075e-16,  6.255519254599589e-17,  6.064166742371693e-20,  1.461542788005536e+00, -1.752094474643387e-02,
  5.705836823047297e-05,  6.491170567789357e-06, -1.754908566080030e-07, -2.539491585679876e-09,  2.326752749258465e-10, -1.462830895491231e-12, -2.365107648704237e-13,
  5.628356229371083e-15,  1.808817762831053e-16, -9.392497121154476e-18,  1.298936600245959e-02, -1.634291488163194e-04,  1.834421451650854e-06, -1.189167970811992e-08,
 -8.304220507907804e-11, -8.884863623819191e-13,  1.970129905907451e-13, -2.350267570127725e-15, -1.696193458828075e-16,  4.647288601493206e-18,  1.171616091340980e-19,
 -6.392536961659065e-21,  5.230018556493223e-02, -6.577788704563507e-04,  7.360853362867767e-06, -4.650340747155505e-08, -3.761824869525269e-10, -3.150783745261784e-12,
  8.072590242433230e-13, -9.751739630792627e-15, -6.994381398047872e-16,  1.933129829172497e-17,  4.811216040290040e-19, -2.658031221103572e-20,  1.190123849518554e-01,
 -1.495799570889537e-03,  1.664699781426221e-05, -1.001779446017461e-07, -1.028138277611695e-09, -5.398988884847669e-12,  1.894994265204196e-12, -2.342377509395740e-14,
 -1.658933751057029e-15,  4.658511230961574e-17,  1.132438073124845e-18, -6.400869882758725e-20,  2.151185258336513e-01, -2.700815714615774e-03,  2.979631520541254e-05,
 -1.649177994824067e-07, -2.354484051720570e-09, -4.584073092945322e-12,  3.594427110185732e-12, -4.611628612328873e-14, -3.189877160128469e-15,  9.190734215882839e-17,
  2.150175055751258e-18, -1.261413513270523e-19,  3.438991559688106e-01, -4.310649267066576e-03,  4.691678613019498e-05, -2.238838376957134e-07, -4.997452506407234e-09,
  5.796748998425440e-12,  6.174991247055003e-12, -8.401872814464895e-14, -5.563133382597474e-15,  1.669496716756197e-16,  3.671784419268711e-18, -2.287155313140132e-19,
  5.107004833151110e-01, -6.385346500753615e-03,  6.801067238160046e-05, -2.392260149647678e-07, -1.035868199487555e-08,  4.074768810180340e-11,  1.022573119088309e-11,
 -1.528948233343812e-13, -9.312121206405751e-15,  2.988886706752068e-16,  5.913378335372828e-18, -4.079934620433017e-19,  7.246922562289907e-01, -9.023089638536975e-03,
  9.254526862698360e-05, -1.130251400044849e-07, -2.200285725355520e-08,  1.408765049280022e-10,  1.730708405073730e-11, -3.034664218061408e-13, -1.554448283303852e-14,
  5.646639813025038e-16,  9.027803389904054e-18, -7.632792052248011e-19,  1.003653779725981e+00, -1.239548549021328e-02,  1.173197610641244e-04,  4.835078857278689e-07,
 -5.195853289014066e-08,  4.523253546639329e-10,  3.346118220291725e-11, -7.865722644902663e-13, -2.609200584863152e-14,  1.275584125484018e-15,  1.018411730930293e-17,
 -1.648684497375973e-18,  1.392795129660874e+00, -1.680264616187618e-02,  1.173428798535228e-04,  3.553823749494773e-06, -1.772640922432105e-07,  1.915307744235406e-09,
  1.215760339398113e-10, -5.176020369872573e-12,  2.346869475812276e-15,  5.490200881669427e-15, -1.349159416382863e-16, -2.750280235670022e-18,  1.236406463660003e-02,
 -1.493469950588386e-04,  1.683912083474721e-06, -1.313682767403793e-08, -6.129898961306521e-11,  2.610214931321655e-12,  8.368000086677323e-14, -4.731371961094586e-15,
  1.772631908912451e-17,  4.264628614546620e-18, -1.027555862289116e-19, -2.136055565133761e-21,  4.978316657951148e-02, -6.012250931757527e-04,  6.767685854691652e-06,
 -5.210303453781232e-08, -2.776130534252172e-10,  1.113746380253660e-11,  3.389506478145299e-13, -1.950257645860123e-14,  7.622213097694881e-17,  1.757573373063079e-17,
 -4.281511737514530e-19, -8.711849584408173e-21,  1.132875379248090e-01, -1.367705405425228e-03,  1.534978069167565e-05, -1.153300010992081e-07, -7.581681302768170e-10,
  2.793940296054379e-11,  7.791467339847970e-13, -4.625321164351444e-14,  1.945431278841409e-16,  4.164775329028000e-17, -1.034772612282658e-18, -2.024325677090776e-20,
  2.047785918294388e-01, -2.470981057198425e-03,  2.760182258328397e-05, -1.992395399632112e-07, -1.733426909345384e-09,  5.803935859641684e-11,  1.428663415725281e-12,
 -8.906689397045567e-14,  4.180031244308354e-16,  7.997933536440700e-17, -2.050227326941004e-18, -3.760247853727376e-20,  3.273883645223329e-01, -3.947364757547170e-03,
  4.377744501631054e-05, -2.959479096502167e-07, -3.668319095415802e-09,  1.117422446113999e-10,  2.325854641789713e-12, -1.562114178520265e-13,  8.553620370911380e-16,
  1.392565106168298e-16, -3.745744060388372e-18, -6.182228941749841e-20,  4.862252887600061e-01, -5.855422176886983e-03,  6.421047573687269e-05, -3.870356600816864e-07,
 -7.564920279612487e-09,  2.118587439453318e-10,  3.522639455824649e-12, -2.658243780947494e-13,  1.801803732775767e-15,  2.326566227562742e-16, -6.753487643377035e-18,
 -9.257277906531074e-20,  6.900640286312050e-01, -8.293794288910115e-03,  8.923299909855442e-05, -4.236097150300087e-07, -1.592656805474470e-08,  4.178210496213279e-10,
  5.046954426307811e-12, -4.653266715297977e-13,  4.257108332091507e-15,  3.876407808613427e-16, -1.284016454979253e-17, -1.176578906757507e-19,  9.559669607127956e-01,
 -1.144692289477686e-02,  1.185503580717397e-04, -2.404631729596926e-07, -3.697281250525926e-08,  9.388746381995776e-10,  6.496867185506500e-12, -9.274904808497565e-13,
  1.327807387679606e-14,  6.513416951983566e-16, -2.875538159568255e-17, -1.507957507396312e-20,  1.327668898585599e+00, -1.573783124579581e-02,  1.446190959706081e-04,
  1.135406551996153e-06, -1.208457969497037e-07,  3.244984376865829e-09, -6.030355783593428e-13, -3.061189958281311e-12,  9.657512164243451e-14,  4.853815793127172e-17,
 -9.643519075147575e-17,  2.814487680147220e-18,  1.179260317511663e-02, -1.365184765253151e-04,  1.522344717911091e-06, -1.363323169282115e-08,  1.079135661371184e-12,
  3.203910221879934e-12, -2.395198998579474e-14, -2.575784640837538e-15,  9.075723357191422e-17, -3.270900927289904e-20, -8.096354620656316e-20,  2.084874817927823e-21,
  4.748250760925857e-02, -5.496411416393526e-04,  6.124099501029490e-06, -5.449532561663905e-08, -1.430708001618036e-11,  1.345151991218050e-11, -1.035036762645496e-13,
 -1.054350755519221e-14,  3.750947482219168e-16, -2.161182763038641e-19, -3.331763534913397e-19,  8.677809395378632e-21,  1.080533183402344e-01, -1.250602235095940e-03,
  1.391362765116237e-05, -1.223873193744820e-07, -1.088915009281286e-10,  3.287847433818018e-11, -2.650355115928030e-13, -2.469071704844975e-14,  8.936417010907954e-16,
 -8.634433816835356e-19, -7.873541592340098e-19,  2.093033256795353e-20,  1.953206155946436e-01, -2.260105142020766e-03,  2.508669085423069e-05, -2.166176691210154e-07,
 -4.148645106052899e-10,  6.596673043209638e-11, -5.661718269946907e-13, -4.658829749871273e-14,  1.732202304981848e-15, -2.748958510263916e-18, -1.505357651050766e-18,
  4.132451720124158e-20,  3.122756841594305e-01, -3.612165910819514e-03,  3.995366421532596e-05, -3.351122185020545e-07, -1.197895045107527e-09,  1.217065109322723e-10,
 -1.129503983004172e-12, -7.914126632310440e-14,  3.064988585904980e-15, -7.807099348274985e-18, -2.602634631330176e-18,  7.504163506729257e-20,  4.637990957657396e-01,
 -5.362033673635919e-03,  5.898806732805201e-05, -4.719168152460314e-07, -3.025751148978324e-09,  2.194010624023109e-10, -2.239754965199986e-12, -1.278561427483551e-13,
  5.274060471812759e-15, -2.145253860758510e-17, -4.297056986203567e-18,  1.337990627236578e-19,  6.582791355627751e-01, -7.603938146120252e-03,  8.290666387907309e-05,
 -6.090253517199118e-07, -7.293043503002181e-09,  4.073070679250327e-10, -4.686163789805728e-12, -2.039162370959058e-13,  9.348484270988459e-15, -6.225450013354787e-17,
 -7.000694652742024e-18,  2.486241153996956e-19,  9.120455045236402e-01, -1.051867633362722e-02,  1.127409162867654e-04, -6.811002146878828e-07, -1.842737829769464e-08,
  8.452678393347217e-10, -1.148707114746623e-11, -3.306240133675772e-13,  1.875377960780338e-14, -2.220541139344182e-16, -1.111904414065375e-17,  5.247106829890706e-19,
  1.267077715023464e+00, -1.455444151878198e-02,  1.487170243869301e-04, -3.027683333074469e-07, -6.129980862921658e-08,  2.532066768180313e-09, -4.672511526569073e-11,
 -4.534916803694247e-13,  5.707251783101099e-14, -1.573025094649622e-15,  3.092917102562284e-18,  1.276883998345918e-18,  1.126985711767827e-02, -1.249892517398401e-04,
  1.360809749026949e-06, -1.315338784331772e-08,  5.519165284029206e-11,  2.072868253581097e-12, -5.899223645919242e-14, -1.342073611349735e-16,  5.333786549897375e-17,
 -1.494274390677532e-18,  6.650529381529881e-22,  1.195620055169668e-21,  4.537780685553448e-02, -5.032488452554849e-04,  5.477005662337448e-06, -5.278378219472585e-08,
  2.126747462764669e-10,  8.700797955814684e-12, -2.458051943895494e-13, -4.852082894426165e-16,  2.188614060234830e-16, -6.182530963097190e-18,  4.304659681743206e-21,
  4.906699454148554e-21,  1.032642461018297e-01, -1.145150631496611e-03,  1.245459978476740e-05, -1.193936954871917e-07,  4.450035992617826e-10,  2.125203030460561e-11,
 -5.935170087368930e-13, -8.668335836040129e-16,  5.146907277941483e-16, -1.475632801197802e-17,  1.690288526382554e-20,  1.153761498286546e-20,  1.866650838273790e-01,
 -2.069828392524702e-03,  2.248764833123169e-05, -2.137744894371152e-07,  6.936824859344774e-10,  4.257011165974068e-11, -1.171748255136303e-12, -8.343491830171539e-16,
  9.772437125418134e-16, -2.867453870154998e-17,  5.300477335580538e-20,  2.188120856279988e-20,  2.984405788374769e-01, -3.308775346673403e-03,  3.589127722975021e-05,
 -3.368415114920937e-07,  8.397360222852332e-10,  7.827087538514393e-11, -2.120868887887951e-12,  6.707941192368295e-16,  1.674673788923958e-15, -5.088975279426562e-17,
  1.481112194212395e-19,  3.734571361872053e-20,  4.432581525778881e-01, -4.913294342808960e-03,  5.316739835860598e-05, -4.890379403530086e-07,  6.268683268081468e-10,
  1.401376576695139e-10, -3.744785614056986e-12,  6.428259865080502e-15,  2.738485601196256e-15, -8.782686507485506e-17,  3.985728505999104e-19,  6.034475831117742e-20,
  6.291415604034162e-01, -6.971329661158036e-03,  7.514332709644725e-05, -6.680302224194814e-07, -5.735443467110153e-10,  2.566296864015262e-10, -6.812965283006002e-12,
  2.518912783763665e-14,  4.443677039179657e-15, -1.558176791996843e-16,  1.120673515918715e-18,  9.439466658231701e-20,  8.717173718252150e-01, -9.653277641629269e-03,
  1.033021259359352e-04, -8.577185692647519e-07, -4.717513321980848e-09,  5.168632329287833e-10, -1.392271181867912e-11,  9.512640922908048e-14,  7.406878508791379e-15,
 -3.094884309943543e-16,  3.767523841840004e-18,  1.350324180036143e-19,  1.211197436604233e+00, -1.339246747393104e-02,  1.406685491656380e-04, -9.406129958192384e-07,
 -2.204651802694020e-08,  1.415266603451879e-09, -4.173142372355568e-11,  5.664109851558215e-13,  1.114946035794363e-14, -8.588984817378039e-16,  2.234561806653534e-17,
 -1.302041499531756e-19,  1.079069813379559e-02, -1.147164676670149e-04,  1.209389911829544e-06, -1.201401416346960e-08,  8.297968235855278e-11,  7.573284870353286e-13,
 -4.644863715196079e-14,  7.918554277592057e-16,  8.502736082502856e-18, -8.632849947184394e-19,  2.163585922292236e-20, -5.991811600729155e-23,  4.344852850834785e-02,
 -4.618974052501448e-04,  4.868737357530521e-06, -4.830232336769661e-08,  3.298459994050312e-10,  3.233648348761238e-12, -1.926958460434046e-13,  3.296520187929075e-15,
  3.405046093301423e-17, -3.543865822687142e-18,  8.950847885688822e-20, -2.702789419354722e-22,  9.887405047499918e-02, -1.051096341046422e-03,  1.107615984457795e-05,
 -1.096281083277999e-07,  7.332506427718249e-10,  8.110660816113689e-12, -4.617664557881816e-13,  7.949609309819470e-15,  7.653537304018441e-17, -8.339910823956528e-18,
  2.135763206783568e-19, -7.399207752970823e-22,  1.787296651601117e-01, -1.899944742601477e-03,  2.001220033487025e-05, -1.973484493174930e-07,  1.276361710465997e-09,
  1.679879080484346e-11, -9.013497307412409e-13,  1.567418878295518e-14,  1.347199699759087e-16, -1.584973744191079e-17,  4.147414353396789e-19, -1.722967798553888e-21,
  2.857545950913604e-01, -3.037483707943734e-03,  3.197272816735377e-05, -3.135534426771916e-07,  1.922131659530569e-09,  3.206065543079515e-11, -1.605238635894431e-12,
  2.835030326091418e-14,  2.030296519246678e-16, -2.718952380577253e-17,  7.349313211562428e-19, -3.809066184657047e-21,  4.244189693718410e-01, -4.511076282509006e-03,
  4.743631347468030e-05, -4.612653941437782e-07,  2.584955642839989e-09,  5.961116018491944e-11, -2.769429115041424e-12,  5.010397384126394e-14,  2.601892726226017e-16,
 -4.449969740175240e-17,  1.264003279245499e-18, -8.508221123711180e-21,  6.024079886262479e-01, -6.402069994681315e-03,  6.721371655700887e-05, -6.445635134937509e-07,
  3.043730697115562e-09,  1.129235201819717e-10, -4.865710044579303e-12,  9.156270622851663e-14,  2.205119316342347e-16, -7.219891080655262e-17,  2.224239991121038e-18,
 -2.044661483023428e-20,  8.346909916647967e-01, -8.868640579393197e-03,  9.284231238646864e-05, -8.673884515583069e-07,  2.593197794481752e-09,  2.323958492090775e-10,
 -9.367572762814616e-12,  1.893415161728705e-13, -3.603953329211493e-16, -1.198637498831585e-16,  4.318222719976915e-18, -5.892490941059998e-20,  1.159800736746616e+00,
 -1.231643887842278e-02,  1.280383272055551e-04, -1.115523363253962e-06, -2.363845378560391e-09,  6.215193407617382e-10, -2.439713267085080e-11,  5.826551004202600e-13,
 -6.065085446079426e-15, -1.769349016075608e-16,  1.083343544157809e-17, -2.748640594408070e-19,  1.035030236983919e-02, -1.055946543833160e-04,  1.073512670209619e-06,
 -1.061795537936838e-08,  8.883239092539983e-11, -8.366817421825468e-14, -2.402160074916844e-14,  7.201697156926075e-16, -8.832644303563920e-18, -1.698020396335428e-19,
  1.157208455743057e-20, -2.759442009743156e-22,  4.167529898851598e-02, -4.251728568971695e-04,  4.322183213051014e-06, -4.272635733170387e-08,  3.559706697573411e-10,
 -2.547269077765844e-13, -9.970153754573280e-14,  2.978425307113096e-15, -3.683135606074249e-17, -6.861025829459506e-19,  4.748674252181894e-20, -1.140481579408494e-21,
  9.483884529587078e-02, -9.675409658775275e-04,  9.834629283349192e-06, -9.712287379575932e-08,  8.031276091997444e-10, -2.455353125386065e-13, -2.390456038588133e-13,
  7.100792052603441e-15, -8.908242713922166e-17, -1.568380520091529e-18,  1.116730133701958e-19, -2.716428542945588e-21,  1.714355980034303e-01, -1.748954040907331e-03,
  1.777424582412273e-05, -1.752619102447173e-07,  1.432239365640381e-09,  5.007191372324481e-13, -4.666837070890664e-13,  1.376226529607191e-14, -1.764551086787455e-16,
 -2.842120429935096e-18,  2.119739953712633e-19, -5.259543208599721e-21,  2.740931807229557e-01, -2.796193136243433e-03,  2.840973880200258e-05, -2.794894481963004e-07,
  2.243040421982491e-09,  3.080245669131137e-12, -8.303170075622975e-13,  2.428995322057049e-14, -3.213537895851004e-16, -4.511716780571212e-18,  3.628890828212256e-19,
 -9.276211897001722e-21,  4.070996745195901e-01, -4.152953878379133e-03,  4.217823901228642e-05, -4.135014636618885e-07,  3.225922774877044e-09,  9.763754474901446e-12,
 -1.427355149447376e-12,  4.145684965958878e-14, -5.736814683887271e-16, -6.447695456829261e-18,  5.917989260623479e-19, -1.582971061070667e-20,  5.778274896909563e-01,
 -5.894336698329703e-03,  5.982748982479851e-05, -5.832800693257046e-07,  4.338088958061370e-09,  2.586729748013273e-11, -2.484313426873313e-12,  7.193873243864165e-14,
 -1.064141532917659e-15, -7.850702373264637e-18,  9.536409835437336e-19, -2.746358161269433e-20,  8.006373569904369e-01, -8.166548787260980e-03,  8.280118945975739e-05,
 -7.991906092587055e-07,  5.402574378726668e-09,  6.695864967572499e-11, -4.670387642135088e-12,  1.365712821281018e-13, -2.250580335634628e-15, -3.804461200045845e-18,
  1.559128271476710e-18, -5.171914562568547e-20,  1.112498923589168e+00, -1.134555657915698e-02,  1.147463596675165e-04, -1.080613698262960e-06,  5.403511362844339e-09,
  2.063951370162158e-10, -1.128551933596681e-11,  3.492604547261877e-13, -7.144062302344325e-15,  5.982172788672521e-17,  2.187099291643575e-18, -1.172113021595413e-19,
  9.944326716557400e-03, -9.749235161935217e-05,  9.544856737493770e-07, -9.235112207868904e-09,  8.284799522896077e-11, -4.531550245064576e-13, -8.223737780570283e-15,
  4.073444254135579e-16, -9.218019431627099e-18,  8.729993417387888e-20,  2.371693325261099e-21, -1.322838114473641e-22,  4.004065056670097e-02, -3.925505338101524e-04,
  3.843122144123285e-06, -3.717581710404335e-08,  3.329580151105572e-10, -1.791990481308485e-12, -3.443308625184112e-14,  1.681648812285822e-15, -3.808210694334405e-17,
  3.651221414693617e-19,  9.603585832207943e-21, -5.424125850145691e-22,  9.111895989975946e-02, -8.933094666917059e-04,  8.745253091163610e-06, -8.456243795572563e-08,
  7.551590677991804e-10, -3.945650219644831e-12, -8.372695619586954e-14,  3.996191480398733e-15, -9.062899489101677e-17,  8.876638642647899e-19,  2.204095079681450e-20,
 -1.273770127207562e-21,  1.647113966051862e-01, -1.614785668392927e-03,  1.580728579026214e-05, -1.527557038096479e-07,  1.357942851749807e-09, -6.760112562573938e-12,
 -1.665226427488696e-13,  7.705242929361243e-15, -1.752195157697455e-16,  1.771688252202394e-18,  4.021216940175055e-20, -2.412334243414328e-21,  2.633425827339058e-01,
 -2.581721905760118e-03,  2.527030202116917e-05, -2.439814470426346e-07,  2.154121796378121e-09, -9.916197017807882e-12, -3.028434969721901e-13,  1.349170798826138e-14,
 -3.083012537844554e-16,  3.260528464141882e-18,  6.458598613694440e-20, -4.115096147203498e-21,  3.911325300096588e-01, -3.834494034672710e-03,  3.752731026474232e-05,
 -3.618298144517016e-07,  3.161519727096806e-09, -1.271984964517389e-11, -5.330546144178899e-13,  2.274219294424830e-14, -5.242624973949769e-16,  5.903035461855296e-18,
  9.443331962922495e-20, -6.672463169520372e-21,  5.551647484065406e-01, -5.442512877621212e-03,  5.325286592888535e-05, -5.123569834736264e-07,  4.402147637755490e-09,
 -1.348378953098388e-11, -9.490047292684101e-13,  3.865940857671222e-14, -9.059054032624830e-16,  1.115486598843680e-17,  1.221107545965372e-19, -1.064534199084552e-20,
  7.692374084864029e-01, -7.540962845601320e-03,  7.375721779905401e-05, -7.069706618749864e-07,  5.889250770167421e-09, -7.174722043595976e-12, -1.811881017558657e-12,
  7.062190365426509e-14, -1.711172340064274e-15,  2.416297388779198e-17,  9.556725920316038e-20, -1.705314384515632e-20,  1.068872898511499e+00, -1.047775257275094e-02,
  1.023943136149439e-04, -9.729607054726487e-07,  7.491463857624520e-09,  2.944658759622194e-11, -4.310124199616764e-12,  1.640944537128618e-13, -4.333337244851147e-15,
  7.857579018694578e-17, -5.624122487997078e-19, -2.244996681412469e-20,  9.568958050819934e-03, -9.027795846711551e-05,  8.512931580841451e-07, -7.989452927907893e-09,
  7.257671828599542e-11, -5.436680080949081e-13, -3.989122349852966e-16,  1.719439575219435e-16, -5.417471149773848e-18,  1.032822262503982e-19, -8.014758960477798e-22,
 -2.641460783352438e-23,  3.852923700656126e-02, -3.635023768232028e-04,  3.427686305198282e-06, -3.216640261313070e-08,  2.920145749894923e-10, -2.177230968686139e-12,
 -2.124864910026267e-15,  7.105436869728365e-16, -2.232086704585405e-17,  4.265141813810473e-19, -3.363151659755952e-21, -1.069710055500595e-22,  8.767950072111880e-02,
 -8.272075760658381e-04,  7.800131980461587e-06, -7.318780977834227e-08,  6.636612723956792e-10, -4.906758057047173e-12, -6.937962816446395e-15,  1.691005000086151e-15,
 -5.286617800866671e-17,  1.014357766833645e-18, -8.222037561220308e-21, -2.455626471608529e-22,  1.584940675887178e-01, -1.495301660806437e-03,  1.409958958046922e-05,
 -1.322645982740075e-07,  1.197252562253233e-09, -8.735556651155236e-12, -1.845364412806899e-14,  3.265940059725717e-15, -1.014533807345562e-16,  1.959343432708005e-18,
 -1.654199962062471e-20, -4.482215600189190e-22,  2.534022821186363e-01, -2.390701754821020e-03,  2.254180238271008e-05, -2.113871091714454e-07,  1.908454288616032e-09,
 -1.364706401761393e-11, -4.365907966305223e-14,  5.725964600872376e-15, -1.765417060714785e-16,  3.443549120672050e-18, -3.076697543265017e-20, -7.206521470531117e-22,
  3.763686757701169e-01, -3.550806354873144e-03,  3.347872694885232e-05, -3.137907042698774e-07,  2.821861084096414e-09, -1.955685412203466e-11, -9.667664248793271e-14,
  9.650375244171849e-15, -2.952471552865101e-16,  5.847641100379429e-18, -5.645260071887032e-20, -1.056564839313875e-21,  5.342094588586119e-01, -5.039912631626424e-03,
  4.751515488837966e-05, -4.450034957163299e-07,  3.977097118757077e-09, -2.615987191843157e-11, -2.095106607668232e-13,  1.634047656890988e-14, -4.969160915900219e-16,
  1.008720199809456e-17, -1.084245766279119e-19, -1.379385224258452e-21,  7.402021741500122e-01, -6.983261152961199e-03,  6.582814079428111e-05, -6.156819849212243e-07,
  5.442508532131360e-09, -3.231729303924987e-11, -4.715957050313443e-13,  2.944094256090017e-14, -8.959154616988475e-16,  1.900250757769430e-17, -2.391549586322982e-19,
 -1.166727321700978e-21,  1.028529150183846e+00, -9.703247534429431e-03,  9.144285368929717e-05, -8.526942931658203e-07,  7.347565512575029e-09, -3.210479239375387e-11,
 -1.269910502736282e-12,  6.516572192212444e-14, -2.037552351245008e-15,  4.769362891490809e-17, -7.859553256278405e-19,  5.149397721693311e-21,  9.220886493125724e-03,
 -8.383218898990944e-05,  7.620302972079925e-07, -6.914406532359595e-09,  6.190998960404324e-11, -5.118828416655840e-13,  2.494720818766074e-15,  5.051624855482634e-17,
 -2.424408542997455e-18,  6.165156169345833e-20, -1.041645499940082e-21,  7.089513538652700e-24,  3.712773361593334e-02, -3.375487448503834e-04,  3.068292287797320e-06,
 -2.783981366431204e-08,  2.492106687475543e-10, -2.057094777724460e-12,  9.859078798129335e-15,  2.104671667471107e-16, -9.981864359853114e-18,  2.537743467851116e-19,
 -4.300746303896748e-21,  2.981964878922735e-23,  8.449015527623772e-02, -7.681464688960322e-04,  6.982358578429786e-06, -6.335029188673155e-08,  5.668419599305309e-10,
 -4.665140061498752e-12,  2.168442117641373e-14,  5.075794256892505e-16, -2.360955631750794e-17,  6.000927161454550e-19, -1.022493662075328e-20,  7.318953572765587e-23,
  1.527288444708283e-01, -1.388541296265362e-03,  1.262157801745228e-05, -1.145050338791622e-07,  1.023881539884886e-09, -8.387975181890241e-12,  3.709361983922922e-14,
  9.979808668541147e-16, -4.520275952613838e-17,  1.148959331662353e-18, -1.974144844719889e-20,  1.480621471994391e-22,  2.441847838290857e-01, -2.220015702046435e-03,
  2.017930151878898e-05, -1.830479011333070e-07,  1.635173875929540e-09, -1.330428317170736e-11,  5.429975306838582e-14,  1.788032712330157e-15, -7.835289311916961e-17,
  1.993144578262792e-18, -3.467391055016692e-20,  2.773126542159104e-22,  3.626783057321118e-01, -3.297301106077235e-03,  2.997103116780806e-05, -2.718210998962316e-07,
  2.424655019328339e-09, -1.952464841428978e-11,  6.949854822423884e-14,  3.087847489379524e-15, -1.301739755400502e-16,  3.319799918194206e-18, -5.883022043428556e-20,
  5.130395216276577e-22,  5.147777038914628e-01, -4.680110672865790e-03,  4.253911975946833e-05, -3.857015001861683e-07,  3.432700285253794e-09, -2.719057508360910e-11,
  7.368664951119474e-14,  5.361931733663893e-15, -2.165214728482301e-16,  5.557251743003456e-18, -1.013434040629855e-19,  9.941627253389682e-22,  7.132776095320830e-01,
 -6.484760336304803e-03,  5.893975821742874e-05, -5.341581418321128e-07,  4.735448810431464e-09, -3.641742994253135e-11,  4.100518713272325e-14,  9.874280582500672e-15,
 -3.813375861301026e-16,  9.941211308343416e-18, -1.903585901260417e-19,  2.208956107998586e-21,  9.911171877036067e-01, -9.010692445151071e-03,  8.189075142437437e-05,
 -7.414198623743016e-07,  6.516393380112519e-09, -4.667201892608202e-11, -1.401019054391083e-13,  2.192029481541595e-14, -8.165530668918692e-16,  2.226372961501299e-17,
 -4.726799908084726e-19,  7.217767168535342e-21,  8.897247503517428e-03, -7.805175370525705e-05,  6.846744590761972e-07, -6.002148065242491e-09,  5.234804162470136e-11,
 -4.420216017760693e-13,  3.103608028832484e-15,  1.151414426320368e-18, -8.606457302875328e-19,  2.806551188668220e-20, -6.220420673791720e-22,  9.606411643778344e-24,
  3.582460717638315e-02, -3.142739679082959e-04,  2.756826835160970e-06, -2.416727058820243e-08,  2.107574872147553e-10, -1.778525167327692e-12,  1.243471043655246e-14,
  7.134586952919009e-18, -3.549501669616794e-18,  1.153679353692562e-19, -2.559077176462387e-21,  3.965569786649663e-23,  8.152468108828564e-02, -7.151811220091577e-04,
  6.273594516855426e-06, -5.499544089572573e-08,  4.795284013044574e-10, -4.042218852749931e-12,  2.804743872399964e-14,  2.633351389473936e-17, -8.418241059501990e-18,
  2.721367401085460e-19, -6.045649136332465e-21,  9.425037277639990e-23,  1.473682989534505e-01, -1.292798816668571e-03,  1.134045070446152e-05, -9.940963634424789e-08,
  8.665866675497905e-10, -7.292728782482397e-12,  5.000325686897468e-14,  7.585740570203606e-17, -1.617433199115682e-17,  5.190129429311492e-19, -1.155917680755099e-20,
  1.818814270214365e-22,  2.356142801107249e-01, -2.066942517855330e-03,  1.813118784533324e-05, -1.589303125013984e-07,  1.384959760162918e-09, -1.162624242618583e-11,
  7.829736337074134e-14,  1.884324854409460e-16, -2.814674546882230e-17,  8.949805456119321e-19, -2.001379351054205e-20,  3.192236903393995e-22,  3.499488722269447e-01,
 -3.069949736037566e-03,  2.692941486199046e-05, -2.360377453372834e-07,  2.055825544368933e-09, -1.719449094531077e-11,  1.126499176604387e-13,  4.292173995705140e-16,
 -4.693271475427424e-17,  1.476914763109479e-18, -3.324803830593327e-20,  5.410061374074687e-22,  4.967098385051389e-01, -4.357418194072028e-03,  3.822271666868673e-05,
 -3.349936302954952e-07,  2.915377831194138e-09, -2.424431013587211e-11,  1.518411075882009e-13,  9.426659513228418e-16, -7.820224501463206e-17,  2.435117920807032e-18,
 -5.545003024138177e-20,  9.301441270103127e-22,  6.882427546336189e-01, -6.037648447214627e-03,  5.296080670526028e-05, -4.640913272698601e-07,  4.033437100804881e-09,
 -3.321157454446558e-11,  1.910786631917567e-13,  2.118834227975494e-15, -1.371533692095531e-16,  4.237390506006477e-18, -9.860581264869762e-20,  1.739903918183927e-21,
  9.563307303462684e-01, -8.389453406917951e-03,  7.358835216392114e-05, -6.446439048106092e-07,  5.586498674213331e-09, -4.499724426948172e-11,  2.056970161977545e-13,
  5.539855833759331e-15, -2.860974987098162e-16,  8.892966663658133e-18, -2.179072298470012e-19,  4.263124596451184e-21,  8.595558365585902e-03, -7.284886818769534e-05,
  6.173953878236835e-07, -5.231290354178550e-09,  4.424240222943664e-11, -3.694789959803703e-13,  2.872418487521083e-15, -1.426120759972927e-17, -2.059457245638662e-19,
  1.055149393776547e-20, -2.830274966979439e-22,  5.669550824869888e-24,  3.460986132043397e-02, -2.933246546394498e-04,  2.485930728661570e-06, -2.106362010111766e-08,
  1.781351337286144e-10, -1.487318802145845e-12,  1.154632782611178e-14, -5.660089642129827e-17, -8.585761111820773e-19,  4.337478303034795e-20, -1.162423967140821e-21,
  2.331526087329075e-23,  7.876033079592086e-02, -6.675076224897098e-04,  5.657134150016582e-06, -4.793336352855699e-08,  4.053507646389392e-10, -3.383099459464337e-12,
  2.619737507912676e-14, -1.254914966466805e-16, -2.072354820656038e-18,  1.023073863810110e-19, -2.737943486169782e-21,  5.504291542831761e-23,  1.423713144540547e-01,
 -1.206621823331846e-03,  1.022612526620850e-05, -8.664601939782165e-08,  7.326654776670589e-10, -6.111210028718179e-12,  4.713840561194509e-14, -2.176087021489217e-16,
 -4.077528526403425e-18,  1.950424609436118e-19, -5.210515812602434e-21,  1.051329965952017e-22,  2.276250397056085e-01, -1.929161966949241e-03,  1.634963886618010e-05,
 -1.385287604582038e-07,  1.171235921966470e-09, -9.760685853703139e-12,  7.485373518008427e-14, -3.260861883445631e-16, -7.306014579271202e-18,  3.359588940193388e-19,
 -8.958606688075885e-21,  1.817633667270739e-22,  3.380827612456325e-01, -2.865310215805818e-03,  2.428345366186195e-05, -2.057471790820048e-07,  1.739246642188091e-09,
 -1.447535568902121e-11,  1.100547532572773e-13, -4.361688251502938e-16, -1.259836655549471e-17,  5.529751860300911e-19, -1.472569401573582e-20,  3.013265751368861e-22,
  4.798673422530503e-01, -4.066958710083437e-03,  3.446732377135804e-05, -2.920238852855247e-07,  2.467903985160287e-09, -2.049862920650519e-11,  1.537539776528108e-13,
 -5.128940738221053e-16, -2.177228067940163e-17,  9.065441916845420e-19, -2.414991435350544e-20,  5.009719907425014e-22,  6.649057472196700e-01, -5.635190075729326e-03,
  4.775784530486710e-05, -4.046082050408923e-07,  3.417816968345076e-09, -2.829256054848825e-11,  2.072543598960773e-13, -4.570204897489349e-16, -3.960655727621026e-17,
  1.556971730746626e-18, -4.169364510970431e-20,  8.860987434977032e-22,  9.239033948954721e-01, -7.830236424763437e-03,  6.636020636096203e-05, -5.621538652801127e-07,
  4.744201748434560e-09, -3.898980250483397e-11,  2.706619041347178e-13,  1.434498792479558e-16, -8.488184218574987e-17,  3.150233086174513e-18, -8.621556150443056e-20,
  1.933188676101357e-21,  8.313659919403601e-03, -6.814931107658839e-05,  5.586350563592313e-07, -4.578928273224452e-09,  3.750724990505842e-11, -3.057936789381732e-13,
  2.424873927495917e-15, -1.653535579856917e-17,  2.056912181697859e-20,  3.179924236071289e-21, -1.082699919702881e-22,  2.553678188399510e-24,  3.347480230146724e-02,
 -2.744019755692076e-04,  2.249333829456835e-06, -1.843695156632711e-08,  1.510205600697328e-10, -1.231162771670211e-12,  9.757927411842277e-15, -6.632479944845256e-17,
  7.329992318372613e-20,  1.310957030787875e-20, -4.443949025417750e-22,  1.048237711571344e-23,  7.617732066354484e-02, -6.244460220456967e-04,  5.118721766075303e-06,
 -4.195617831497610e-08,  3.436648349512617e-10, -2.801268320745159e-12,  2.218249576085632e-14, -1.499085525587722e-16,  1.284293088366523e-19,  3.106720904881491e-20,
 -1.045480320564103e-21,  2.466620837061630e-23,  1.377021296537222e-01, -1.128781445918476e-03,  9.252868490208336e-06, -7.584196318991468e-08,  6.212077059341408e-10,
 -5.062498164327420e-12,  4.003379266910118e-14, -2.681362879665538e-16,  1.252413609909298e-19,  5.960747351125194e-20, -1.985736376865562e-21,  4.687510710377841e-23,
  2.201598888463096e-01, -1.804709879344486e-03,  1.479359716104936e-05, -1.212565441681966e-07,  9.931505517174916e-10, -8.091129537735453e-12,  6.385542667212728e-14,
 -4.220050423574016e-16, -5.217275578949998e-20,  1.034791137513983e-19, -3.403376353527771e-21,  8.043454887496684e-23,  3.269950588637245e-01, -2.680466469411602e-03,
  2.197235345081579e-05, -1.800965499431997e-07,  1.474993125614372e-09, -1.201124530037002e-11,  9.451261653735033e-14, -6.121241239213513e-16, -6.333917371841903e-19,
  1.718204147536697e-19, -5.565483024350902e-21,  1.318536599293379e-22,  4.641296989794751e-01, -3.804595880666304e-03,  3.118706026629704e-05, -2.556226777392805e-07,
  2.093369024275718e-09, -1.703515189305701e-11,  1.334354615470941e-13, -8.368400713704124e-16, -2.121853037815379e-18,  2.841354695434861e-19, -9.046729969959676e-21,
  2.153990125519034e-22,  6.430996201368376e-01, -5.271660139819287e-03,  4.321284278035440e-05, -3.541860471925857e-07,  2.900113444594525e-09, -2.357327141824137e-11,
  1.832316085787805e-13, -1.084409394244150e-15, -5.848296116223961e-18,  4.909145628049547e-19, -1.535747096997196e-20,  3.696143535858784e-22,  8.936032353171395e-01,
 -7.325104719604403e-03,  6.004520630295361e-05, -4.921350813543365e-07,  4.028473444592572e-09, -3.266803701930762e-11,  2.497872949155809e-13, -1.283805935911219e-15,
 -1.697226866127276e-17,  9.864802501672816e-19, -3.049120742120585e-20,  7.548134067029752e-22,  8.049666652360066e-03, -6.389026224589156e-05,  5.070966074522182e-07,
 -4.024732206330437e-09,  3.193658387972972e-11, -2.529975394196201e-13,  1.983446335569786e-15, -1.469686849742568e-17,  7.891927477247114e-20,  5.390539575598916e-22,
 -3.517092422326195e-23,  9.772316156409972e-25,  3.241183815714394e-02, -2.572529928138994e-04,  2.041815330781855e-06, -1.620550641583731e-08,  1.285916200884128e-10,
 -1.018659583685414e-12,  7.984662345214054e-15, -5.910171219436828e-17,  3.148538197990560e-19,  2.268349312590233e-21, -1.444747016293291e-22,  4.007567644132164e-24,
  7.375837403580014e-02, -5.854207446518466e-04,  4.646480456788836e-06, -3.687822591239141e-08,  2.926291597387950e-10, -2.318002353498047e-12,  1.816377396862175e-14,
 -1.341943475259895e-16,  7.047820479249412e-19,  5.556244958908072e-21, -3.403170759317846e-22,  9.414183252860333e-24,  1.333295145871161e-01, -1.058237312131208e-03,
  8.399221816409853e-06, -6.666295932509158e-08,  5.289667637369562e-10, -4.189805821541617e-12,  3.281549764177551e-14, -2.417422912844477e-16,  1.241458610429208e-18,
  1.114130116995405e-20, -6.473989037301381e-22,  1.784220281649194e-23,  2.131688971986195e-01, -1.691923056590945e-03,  1.342877975836282e-05, -1.065814333979747e-07,
  8.457068562122963e-10, -6.697928781046130e-12,  5.242310296259822e-14, -3.845462632656186e-16,  1.908399093184347e-18,  2.040110486611091e-20, -1.111390024296963e-21,
  3.048969640506599e-23,  3.166116066037343e-01, -2.512948563339263e-03,  1.994525010227711e-05, -1.583010232531596e-07,  1.256070574198308e-09, -9.946481452425970e-12,
  7.776940936845116e-14, -5.668977164185487e-16,  2.667257234582016e-18,  3.599175579714435e-20, -1.819570309438600e-21,  4.966255494477233e-23,  4.493916521883691e-01,
 -3.566824693416972e-03,  2.830985011157994e-05, -2.246884027960184e-07,  1.782785212325868e-09, -1.411419635441248e-11,  1.101852161314069e-13, -7.954461444584547e-16,
  3.421872748626308e-18,  6.357176327386338e-20, -2.956638120137737e-21,  8.029493369992724e-23,  6.226785352170224e-01, -4.942203828203240e-03,  3.922620797535225e-05,
 -3.113275524633592e-07,  2.470110965275686e-09, -1.954844506042254e-11,  1.522170989809889e-13, -1.080901622348577e-15,  3.890247437216117e-18,  1.176514557399579e-19,
 -4.995539502501934e-21,  1.352499538366372e-22,  8.652276215283033e-01, -6.867317411450848e-03,  5.450577769400032e-05, -4.325936466156399e-07,  3.431945946384590e-09,
 -2.714008286463884e-11,  2.102168680831470e-13, -1.440554023425174e-15,  2.899331611341017e-18,  2.526068265213691e-19, -9.727121727631984e-21,  2.648429801435471e-22
  };
  constexpr double w[3456] = {  7.441493760603368e-03, -3.547501698281847e-04,  1.201121122365350e-05, -3.494083608571382e-07,  9.249165628568092e-09,
 -2.286034790876296e-10,  5.352974278676593e-12, -1.198766022724601e-13,  2.584407605734985e-15, -5.389856102138222e-17,  1.091387444110341e-18, -2.151074966108015e-20,
  2.631924358158544e-02, -2.036242319442095e-03,  1.083542711805162e-04, -4.713659428371970e-06,  1.789353444721994e-07, -6.133591517498334e-09,  1.938199279284525e-10,
 -5.723886164240812e-12,  1.595071521334842e-13, -4.224302184641772e-15,  1.068992384209588e-16, -2.594547674884583e-18,  4.853832194251376e-02, -6.012202586232270e-03,
  4.672732574704841e-04, -2.810698743422985e-05,  1.420917649497270e-06, -6.302582406773013e-08,  2.517591865171992e-09, -9.215036475467083e-11,  3.128848430042305e-12,
 -9.944878655685109e-14,  2.979715547234430e-15, -8.456680784910764e-17,  6.601889685158817e-02, -1.204032849127303e-02,  1.278571749507392e-03, -1.005573745928791e-04,
  6.440016610483977e-06, -3.530494099666559e-07,  1.708092950090899e-08, -7.443615641413017e-10,  2.964620946819258e-11, -1.090872869882918e-12,  3.739636755620301e-14,
 -1.201257569122874e-15,  7.401358253196895e-02, -1.822598265629726e-02,  2.493901639405310e-03, -2.444627791658539e-04,  1.902183685948930e-05, -1.241216861755460e-06,
  7.026354324914985e-08, -3.530553136188246e-09,  1.600726856897852e-10, -6.629803423288485e-12,  2.532447962966144e-13, -8.980362049723482e-15,  7.150607882638925e-02,
 -2.202390228675868e-02,  3.677093432396460e-03, -4.296351115613369e-04,  3.907933984640080e-05, -2.932668014077757e-06,  1.882863338149254e-07, -1.060139172570063e-08,
  5.329230609279030e-10, -2.424310767969373e-11,  1.008578866324180e-12, -3.865289192533601e-14,  5.984804584577461e-02, -2.159484526383410e-02,  4.180125569785724e-03,
 -5.577287787121458e-04,  5.713197989194144e-05, -4.770025410498738e-06,  3.371185208978400e-07, -2.069997243375085e-08,  1.125424771747863e-09, -5.496401528562433e-11,
  2.438729590767182e-12, -9.907310927772849e-14,  4.134458667244802e-02, -1.653040845454269e-02,  3.536171317539201e-03, -5.167822700088935e-04,  5.746520221127931e-05,
 -5.165671611129045e-06,  3.901972713641088e-07, -2.544065692736369e-08,  1.460154429975130e-09, -7.488893161846580e-11,  3.473158969597521e-12, -1.468472722409876e-13,
  1.853510846294793e-02, -7.825308231030961e-03,  1.767965359823588e-03, -2.716987388189745e-04,  3.162050491035624e-05, -2.961675599981524e-06,  2.321559015354722e-07,
 -1.565029960554931e-08,  9.256961614619863e-10, -4.878483819553379e-11,  2.318680874627938e-12, -1.002244785576647e-13,  6.191261931069685e-03, -2.732234898194484e-04,
  8.575205210164520e-06, -2.320114112438202e-07,  5.731585150011540e-09, -1.325972190416716e-10,  2.913386438959892e-12, -6.134855149177468e-14,  1.245934108208876e-15,
 -2.451836946286307e-17,  4.691655092594588e-19, -8.751032895366867e-21,  1.960790631428054e-02, -1.354908266532444e-03,  6.561135071788822e-05, -2.624990056294864e-06,
  9.227514644949156e-08, -2.944088537617923e-09,  8.695206415396977e-11, -2.408445178952515e-12,  6.314125422817687e-14, -1.577444770447977e-15,  3.774929982731925e-17,
 -8.684321263520761e-19,  3.027147491191263e-02, -3.314787114387047e-03,  2.334492565645268e-04, -1.288273317074259e-05,  6.025635714073627e-07, -2.488803102879502e-08,
  9.305962202316683e-10, -3.202479120829951e-11,  1.026223345335740e-12, -3.088797698353714e-14,  8.790517136418377e-16, -2.376373059498798e-17,  3.258495477465367e-02,
 -5.307449861083891e-03,  5.137002828772740e-04, -3.726960567796130e-05,  2.221016403413510e-06, -1.140668938634774e-07,  5.198707423918587e-09, -2.144155798095400e-10,
  8.114955221299407e-12, -2.847626768008047e-13,  9.339270256014001e-15, -2.878527725311093e-16,  2.783716953296648e-02, -6.259057262366135e-03,  7.922473825011577e-04,
 -7.254550069755803e-05,  5.313166821099600e-06, -3.283196653935732e-07,  1.768989590794692e-08, -8.496784564299657e-10,  3.696300323704404e-11, -1.473718438274981e-12,
  5.434828839646715e-14, -1.865662808656719e-15,  2.025311515499924e-02, -5.851819013580960e-03,  9.225002909367961e-04, -1.024519209472119e-04,  8.907550293273382e-06,
 -6.419474024629259e-07,  3.973795781540354e-08, -2.164622766068908e-09,  1.055859257659721e-10, -4.672885963840783e-12,  1.895685403819566e-13, -7.099280105054522e-15,
  1.302543605072215e-02, -4.525215970319066e-03,  8.452658897477763e-04, -1.092300803903258e-04,  1.087400378884571e-05, -8.849281867831540e-07,  6.111681642877821e-08,
 -3.675416738278247e-09,  1.960912992068136e-10, -9.413905264962492e-12,  4.112095041784203e-13, -1.646883782573590e-14,  7.295359640888524e-03, -2.866368401395112e-03,
  6.027509731175234e-04, -8.672095330888096e-05,  9.508207616072127e-06, -8.439200237299406e-07,  6.301928032246996e-08, -4.066325864445949e-09,  2.311911430732377e-10,
 -1.175585210350641e-11,  5.409400501695604e-13, -2.270774501140343e-14,  2.879472224840363e-03, -1.209151002640284e-03,  2.716721415980467e-04, -4.153312822103702e-05,
  4.810383697090481e-06, -4.485529087450614e-07,  3.501619317667613e-08, -2.351571640439764e-09,  1.386022397706685e-10, -7.280490346798284e-12,  3.449750857255675e-13,
 -1.486902002769654e-14,  5.219901501406353e-03, -2.143788734242452e-04,  6.264671272200432e-06, -1.582348370778312e-07,  3.659956111283276e-09, -7.948628805493475e-11,
  1.643152649810610e-12, -3.261652370448126e-14,  6.254585733385998e-16, -1.163893828235663e-17,  2.108853620756399e-19, -3.729439999816458e-21,  1.506889591983769e-02,
 -9.347557074430003e-04,  4.134002644173507e-05, -1.525659670147059e-06,  4.978958576994143e-08, -1.481800955856722e-09,  4.097889247041421e-11, -1.066239542256611e-12,
  2.633197938907584e-14, -6.212384381379805e-16,  1.407106551643304e-17, -3.070355905680222e-19,  1.995829796211650e-02, -1.932894619139076e-03,  1.235104156647508e-04,
 -6.259540031016807e-06,  2.710762673530275e-07, -1.043058252231682e-08,  3.651464752003008e-10, -1.181393745346085e-11,  3.572103067665646e-13, -1.017736735622536e-14,
  2.749634646681929e-16, -7.075448609754368e-18,  1.741140939154974e-02, -2.520355934491466e-03,  2.218297345774744e-04, -1.481836306709144e-05,  8.202635817682110e-07,
 -3.939689199385099e-08,  1.688464406637874e-09, -6.579056919854740e-11,  2.361822564683617e-12, -7.889213481574897e-14,  2.470734643189859e-15, -7.293138262376962e-17,
  1.149507382760786e-02, -2.339454552240761e-03,  2.723602999183176e-04, -2.318943739156746e-05,  1.592109693224086e-06, -9.282511581062422e-08,  4.744150809696678e-09,
 -2.171273110405825e-10,  9.035467115431285e-12, -3.457896871675481e-13,  1.227787334056367e-14, -4.069361480059585e-16,  6.279488468134735e-03, -1.685785426949873e-03,
  2.491031789999390e-04, -2.613818223191956e-05,  2.160976203722515e-06, -1.488762667558163e-07,  8.849012036523160e-09, -4.646038395118259e-10,  2.191525584443602e-11,
 -9.406290421737099e-13,  3.710231946095608e-14, -1.354134207515720e-15,  3.038574865990713e-03, -1.008771374467978e-03,  1.806827969979191e-04, -2.249344761451666e-05,
  2.166160901297907e-06, -1.711338622728377e-07,  1.150890813036493e-08, -6.757149966985166e-10,  3.527677973090553e-11, -1.660511083235483e-12,  7.124295260258505e-14,
 -2.807005222557579e-15,  1.337794163994811e-03, -5.144764583680268e-04,  1.059639585041990e-04, -1.496216160372227e-05,  1.613115121122845e-06, -1.410325899328717e-07,
  1.038972287387200e-08, -6.622499974573139e-10,  3.723788972448271e-11, -1.874586370908979e-12,  8.547301072307539e-14, -3.558257364633468e-15,  4.532093884108955e-04,
 -1.890844277501629e-04,  4.220429097537200e-05, -6.412605493154017e-06,  7.385225435655995e-07, -6.850862140168936e-08,  5.322699995172112e-09, -3.558912463028740e-10,
  2.089161910280390e-11, -1.093292073042628e-12,  5.162430021367629e-14, -2.217932961666466e-15,  4.451856867516161e-03, -1.709695576969361e-04,  4.670928495663630e-06,
 -1.105249374649802e-07,  2.400847389010827e-09, -4.908411972157200e-11,  9.570896524309513e-13, -1.795159119758799e-14,  3.257557476787468e-16, -5.744335138597296e-18,
  9.874159708474241e-20, -1.658715375346649e-21,  1.189189625568110e-02, -6.656738098657501e-04,  2.698289626444601e-05, -9.213466295975648e-07,  2.798696561728403e-08,
 -7.786949313519406e-10,  2.020330935482435e-11, -4.946357083507854e-13,  1.152382814626053e-14, -2.570669352226801e-16,  5.516794937195220e-18, -1.142783169020091e-19,
  1.381366452683260e-02, -1.184774498341591e-03,  6.881793305960257e-05, -3.207986180196403e-06,  1.287793710876282e-07, -4.620281216870878e-09,  1.515217050748563e-10,
 -4.610670444562674e-12,  1.315640615933839e-13, -3.548161833118108e-15,  9.098654113874962e-17, -2.227862412477401e-18,  1.000394997218331e-02, -1.282051080736334e-03,
  1.024815041709187e-04, -6.296529584660010e-06,  3.234074840164075e-07, -1.451007454997222e-08,  5.840737723612256e-10, -2.147274707876266e-11,  7.301778849444608e-13,
 -2.318345222287104e-14,  6.922777451186506e-16, -1.953996018741810e-17,  5.198430527348497e-03, -9.498140290300273e-04,  1.012060674053041e-04, -7.980367744908642e-06,
  5.118328173886196e-07, -2.806577991660368e-08,  1.356521904170283e-09, -5.898817450909705e-11,  2.341701541258910e-12, -8.579426771094586e-14,  2.925500307942323e-15,
 -9.338721918290054e-17,  2.140183099357669e-03, -5.284361066013675e-04,  7.265772919677775e-05, -7.160021238063900e-06,  5.599937874205191e-07, -3.671190755419330e-08,
  2.086643464615168e-09, -1.051992949806185e-10,  4.782031781980046e-12, -1.984199414703351e-13,  7.587115924596487e-15, -2.691204376695551e-16,  7.664258974056245e-04,
 -2.410097032905360e-04,  4.109798754425900e-05, -4.899497391366853e-06,  4.540953360120519e-07, -3.467192504289585e-08,  2.261562908706850e-09, -1.291803016530968e-10,
  6.578510984903406e-12, -3.027533370438880e-13,  1.272564808185353e-14, -4.921197695231281e-16,  2.568373765382352e-04, -9.619197065206510e-05,  1.931883246553234e-05,
 -2.666900225932594e-06,  2.818033474058944e-07, -2.419994403305335e-08,  1.754410888707776e-09, -1.102275757621295e-10,  6.118008985333246e-12, -3.043863567677032e-13,
  1.373142524342353e-14, -5.661313419228580e-16,  7.245343805879745e-05, -2.999122388366396e-05,  6.641259781869476e-06, -1.001714216630865e-06,  1.145957495400289e-07,
 -1.056585048006819e-08,  8.163514244634618e-10, -5.430668679649331e-11,  3.173073381476800e-12, -1.653395394360151e-13,  7.776242784202310e-15, -3.328667234223132e-16,
  3.835146431122146e-03, -1.383215657851143e-04,  3.546337033359750e-06, -7.886870522970477e-08,  1.613518166302582e-09, -3.113474915990671e-11,  5.740036549086506e-13,
 -1.019651282551303e-14,  1.754513088236408e-16, -2.937994362673165e-18,  4.799657834571299e-20, -7.671461082601561e-22,  9.600281833319907e-03, -4.874559503146823e-04,
  1.817361169576742e-05, -5.758567701841854e-07,  1.632395141503716e-08, -4.255834884538751e-10,  1.037985647133368e-11, -2.395450623335488e-13,  5.272933764799488e-15,
 -1.113698096559095e-16,  2.267222318985831e-18, -4.463013317827044e-20,  9.973426076011449e-03, -7.591132623536425e-04,  4.017336803332165e-05, -1.725809317680446e-06,
  6.431801232155078e-08, -2.154168624652840e-09,  6.624228933311285e-11, -1.897073977372799e-12,  5.111033814062959e-14, -1.305135811557130e-15,  3.176997983568466e-17,
 -7.401936509156195e-19,  6.137214747730139e-03, -6.944239923461005e-04,  5.039824073224134e-05, -2.847191039760693e-06,  1.356386717764309e-07, -5.681662661318949e-09,
  2.146556052047124e-10, -7.439684072353849e-12,  2.394123318634278e-13, -7.217840672751443e-15,  2.052712117014270e-16, -5.533486329792727e-18,  2.563952549383910e-03,
 -4.174478653257185e-04,  4.055016409815258e-05, -2.951839474279141e-06,  1.763554921133361e-07, -9.070769398676716e-09,  4.135704670466965e-10, -1.704522343438343e-11,
  6.439597738140998e-13, -2.253368027457866e-14,  7.362185374741348e-16, -2.258396002390445e-17,  8.036947725600438e-04, -1.806109435559161e-04,  2.294327639802076e-05,
 -2.111178985204475e-06,  1.554310481547584e-07, -9.653731379692566e-09,  5.225999587687190e-10, -2.520638603730334e-11,  1.100428609245737e-12, -4.399984437333177e-14,
  1.626127660425114e-15, -5.590073719014369e-17,  2.108188641992233e-04, -6.215806160338089e-05,  1.001167562223934e-05, -1.135515038778971e-06,  1.007234482382850e-07,
 -7.396748813888075e-09,  4.659544186888740e-10, -2.579459928456175e-11,  1.276948074398842e-12, -5.727874573075634e-14,  2.352068666126204e-15, -8.904631524643602e-17,
  5.207679032263695e-05, -1.887410851468690e-05,  3.676017514793251e-06, -4.938337539435120e-07,  5.094153731755299e-08, -4.282284473582237e-09,  3.046068656247361e-10,
 -1.881544306293832e-11,  1.028490177754284e-12, -5.046993197610649e-14,  2.248589328130357e-15, -9.166642679452011e-17,  1.180335038767300e-05, -4.838566755420324e-06,
  1.061156934627791e-06, -1.586483742038505e-07,  1.800489745983674e-08, -1.648126861654419e-09,  1.265090316914454e-10, -8.365916394138516e-12,  4.861629930291447e-13,
 -2.520684111926565e-14,  1.180120600311240e-15, -5.030387148781329e-17,  3.333170324518815e-03, -1.133405918411885e-04,  2.736445725501831e-06, -5.737226365174122e-08,
  1.108365963424744e-09, -2.023620555351858e-11,  3.535068966884170e-13, -5.960928365953893e-15,  9.743255184638055e-17, -1.552510483385656e-18,  2.416079245993806e-20,
 -3.672273832393411e-22,  7.902984686710591e-03, -3.658370922396982e-04,  1.258789151252902e-05, -3.712109802039848e-07,  9.844986168473199e-09, -2.410493546366857e-10,
  5.537758844379010e-12, -1.206826106909895e-13,  2.513942846045232e-15, -5.034517405385041e-17,  9.734847247955686e-19, -1.823013644682404e-20,  7.469578263479880e-03,
 -5.058616552986836e-04,  2.445383856640912e-05, -9.702241489161074e-07,  3.362866010623156e-08, -1.052954382970585e-09,  3.039659061658052e-11, -8.200508545894858e-13,
  2.087541420740959e-14, -5.050101372966579e-16,  1.167383909996947e-17, -2.588556051720826e-19,  3.992129873792176e-03, -3.981246593237292e-04,  2.624829978597506e-05,
 -1.363977226074422e-06,  6.027875754248885e-08, -2.357293425180926e-09,  8.357095044392243e-11, -2.729570410192151e-12,  8.308229251366457e-14, -2.376813438204782e-15,
  6.432779357308270e-17, -1.654685856789831e-18,  1.371767443581204e-03, -1.977135791776820e-04,  1.745835953540378e-05, -1.170483765536097e-06,  6.500214055108994e-08,
 -3.129684473737638e-09,  1.343345237104705e-10, -5.237049960447982e-12,  1.879163957845009e-13, -6.267842248343515e-15,  1.958215059614851e-16, -5.760992701731307e-18,
  3.326407796135023e-04, -6.732471510989116e-05,  7.849658485231920e-06, -6.709089378446843e-07,  4.628513290584678e-08, -2.712420519880237e-09,  1.393269546886412e-10,
 -6.406762347547244e-12,  2.677453134529146e-13, -1.028464991975523e-14,  3.663023494599933e-16, -1.217018005438574e-17,  6.373614927482477e-05, -1.741857094161695e-05,
  2.627545160761892e-06, -2.815683729918502e-07,  2.376341569779093e-08, -1.669829218294708e-09,  1.011286318612456e-10, -5.403689427731136e-12,  2.590912096903812e-13,
 -1.128971936925748e-14,  4.515272009784810e-16, -1.668851472826125e-17,  1.126516408715885e-05, -3.919437013025033e-06,  7.353687466672547e-07, -9.560283884177534e-08,
  9.582333516141222e-09, -7.853425990227828e-10,  5.462029664174292e-11, -3.306893354968251e-12,  1.775445152943782e-13, -8.572902246408600e-15,  3.764245982053699e-16,
 -1.514478383023973e-17,  1.967706014625258e-06, -7.968535807048332e-07,  1.726914319126160e-07, -2.554170287875173e-08,  2.870892384865569e-09, -2.605335471607816e-10,
  1.984353561095620e-11, -1.303054588731479e-12,  7.524303821317499e-14, -3.878692950297559e-15,  1.806310073206385e-16, -7.662346762354828e-18,  2.919619313167262e-03,
 -9.392944137929989e-05,  2.142377892649737e-06, -4.246623917384204e-08,  7.765877894021102e-10, -1.344827460714220e-11,  2.230157881409327e-13, -3.578300151211453e-15,
  5.565669972686234e-17, -8.441279931333785e-19,  1.260360995546810e-20, -1.808270599378284e-22,  6.616180815222628e-03, -2.805988369962344e-04,  8.939989839898344e-06,
 -2.460422980962277e-07,  6.120093960872429e-09, -1.410423318592490e-10,  3.058124289925987e-12, -6.304765740007532e-14,  1.244882987098281e-15, -2.367183055507397e-17,
  4.353910174460556e-19, -7.764545445643622e-21,  5.774742232519074e-03, -3.490315856663957e-04,  1.545447052317519e-05, -5.676373118659403e-07,  1.833389177783507e-08,
 -5.375409110771441e-10,  1.458743554397709e-11, -3.711512343866753e-13,  8.935535421864746e-15, -2.049423045156364e-16,  4.501400958149099e-18, -9.503977787418337e-20,
  2.735121908495577e-03, -2.401985290241186e-04,  1.440462939521610e-05, -6.891505206543979e-07,  2.827129152847851e-08, -1.032592095563642e-09,  3.435828714919944e-11,
 -1.057546472761947e-12,  3.044155779941575e-14, -8.261263408632956e-16,  2.126868098853043e-17, -5.217483021367085e-19,  7.911607142590063e-04, -1.003741363626696e-04,
  8.042885461521984e-06, -4.958809234315010e-07,  2.556163467528103e-08, -1.150419424528386e-09,  4.641779584955055e-11, -1.709098552684204e-12,  5.815457427170830e-14,
 -1.845931319554353e-15,  5.505639142266045e-17, -1.550804713680412e-18,  1.514722112611859e-04, -2.732875132488880e-05,  2.907834384532253e-06, -2.297866427162513e-07,
  1.479561642273183e-08, -8.151377790174771e-10,  3.959571827510337e-11, -1.730347264354495e-12,  6.901394440021096e-14, -2.539398684031768e-15,  8.692195944961308e-17,
 -2.783768381248289e-18,  2.131555776453131e-05, -5.331777375653462e-06,  7.466368461783837e-07, -7.506054037939363e-08,  5.991198463436198e-09, -4.007269272364277e-10,
  2.322304549540606e-11, -1.192713642829233e-12,  5.517641551337339e-14, -2.327418763304288e-15,  9.037016457240303e-17, -3.251207420324240e-18,  2.629558499311821e-06,
 -8.695397710217988e-07,  1.559055656785610e-07, -1.948658569347383e-08,  1.887340863773490e-09, -1.500991517890277e-10,  1.016569473360325e-11, -6.011090756388622e-13,
  3.160001800383099e-14, -1.497265649786001e-15,  6.463362732344171e-17, -2.560839238228049e-18,  3.375197447695543e-07, -1.345785316399843e-07,  2.873472057313539e-08,
 -4.193904549591350e-09,  4.658826473472938e-10, -4.183953810445933e-11,  3.157155015010027e-12, -2.055948112590097e-13,  1.178279700701471e-14, -6.032685159556899e-16,
  2.792096777118414e-17, -1.177753277135849e-18,  2.575225609087657e-03, -7.863627339915321e-05,  1.699316524143602e-06, -3.193251875791784e-08,  5.539629966838678e-10,
 -9.121898612114002e-12,  1.438024832364369e-13, -2.199810707022777e-15,  3.271638668443382e-17, -4.681717061125449e-19,  6.833095113082637e-21, -9.239205455931706e-23,
  5.620222914486353e-03, -2.194154416592696e-04,  6.493375971825563e-06, -1.672280232007209e-07,  3.910517874866423e-09, -8.501178477203999e-11,  1.742972088932272e-12,
 -3.405476672144145e-14,  6.384830418975852e-16, -1.154092998182162e-17,  2.022718849238356e-19, -3.439309762135728e-21,  4.588846746732487e-03, -2.483645224222987e-04,
  1.010129307438406e-05, -3.443081566104801e-07,  1.038429568008236e-08, -2.855892308451786e-10,  7.296500405977788e-12, -1.753037313885536e-13,  3.995751474190207e-15,
 -8.697079086965352e-17,  1.816300574778256e-18, -3.653749673596206e-20,  1.961527332771457e-03, -1.516723924823231e-04,  8.289077840327083e-06, -3.656108154257506e-07,
  1.393748381298386e-08, -4.758095263995333e-10,  1.486744298830128e-11, -4.313994114601187e-13,  1.174537567809163e-14, -3.023760512851074e-16,  7.403953117497209e-18,
 -1.731695215138314e-19,  4.885860382556182e-04, -5.430370963188404e-05,  3.946215701034582e-06, -2.235800416870160e-07,  1.068981748895730e-08, -4.493279035099621e-10,
  1.702630762364221e-11, -5.914647318280766e-13,  1.906277593721110e-14, -5.751274113707389e-16,  1.635465056899443e-17, -4.404651109646677e-19,  7.560761226324383e-05,
 -1.204167824567961e-05,  1.163872383855792e-06, -8.471501582928269e-08,  5.074154492581222e-09, -2.620090878838178e-10,  1.200095012720553e-11, -4.970223267090363e-13,
  1.886835701857404e-14, -6.633220349233729e-16,  2.176575947231918e-17, -6.702817673706386e-19,  7.920744580275781e-06, -1.788957667391825e-06,  2.305395319995658e-07,
 -2.159195334986325e-08,  1.620341890305441e-09, -1.026263947250638e-10,  5.664691269513984e-12, -2.784559677385012e-13,  1.238069230657977e-14, -5.037380053714788e-16,
  1.892645949889213e-17, -6.607612267638951e-19,  6.705470828908706e-07, -2.081615140919702e-07,  3.533255862102987e-08, -4.213643345885663e-09,  3.918644647177765e-10,
 -3.007891272640765e-11,  1.974523308906943e-12, -1.135698839815587e-13,  5.824936960792123e-15, -2.699723455444446e-16,  1.142526454793803e-17, -4.446716503455082e-19,
  5.999909403918831e-08, -2.344690403113225e-08,  4.912844587312070e-09, -7.052585566211476e-10,  7.721599910890623e-11, -6.846693503956119e-12,  5.108515957247985e-13,
 -3.293498256009277e-14,  1.870682703677609e-15, -9.500844766001793e-17,  4.365364639507545e-18, -1.829292558317403e-19,  2.285638567383652e-03, -6.643656713032008e-05,
  1.363841216871098e-06, -2.436009232098590e-08,  4.016000530218627e-10, -6.305339965662687e-12,  9.466553175756960e-14, -1.376849868770738e-15,  1.993649180451468e-17,
 -2.619546144988643e-19,  3.763346913806793e-21, -5.282062082802350e-23,  4.835093929911460e-03, -1.745476260043290e-04,  4.812508380802564e-06, -1.162758724275065e-07,
  2.561844218707966e-09, -5.264870357573667e-11,  1.022647604018640e-12, -1.896341838887754e-14,  3.384036508244619e-16, -5.817044557235986e-18,  9.729291982343817e-20,
 -1.582719135919403e-21,  3.734326062340049e-03, -1.816360655875026e-04,  6.804812898568637e-06, -2.157806889294305e-07,  6.090082056072302e-09, -1.573864208568385e-10,
  3.791726896342235e-12, -8.614554961418139e-14,  1.860899391377125e-15, -3.848661611090087e-17,  7.648162125175383e-19, -1.466617910599784e-20,  1.464212094853996e-03,
 -9.973304638112857e-05,  4.978884626749377e-06, -2.028075867153563e-07,  7.194289147612149e-09, -2.298010728113664e-10,  6.748676901476640e-12, -1.847210063603850e-13,
  4.758620902340569e-15, -1.162548959767513e-16,  2.707638572806731e-18, -6.037456605093996e-20,  3.208757590128029e-04, -3.112057889041295e-05,  2.051983083550085e-06,
 -1.068308274409321e-07,  4.737050760332381e-09, -1.859036318922791e-10,  6.612611141668968e-12, -2.165939614575673e-13,  6.607212085022673e-15, -1.893125345443261e-16,
  5.127771623167632e-18, -1.319065313021849e-19,  4.115231970459491e-05, -5.732765526931348e-06,  5.016874546615008e-07, -3.353810313686191e-08,  1.863959513253432e-09,
 -8.998994723968568e-11,  3.877535316803966e-12, -1.518410328982394e-13,  5.474072002470875e-15, -1.834500402606808e-16,  5.757700156595623e-18, -1.701199726665447e-19,
  3.276685423958022e-06, -6.588272463908929e-07,  7.749631166727031e-08, -6.717999936992352e-09,  4.713689716366598e-10, -2.813164385175804e-11,  1.472386313216607e-12,
 -6.898982202304807e-14,  2.936936303659651e-15, -1.148566126438116e-16,  4.161962068103825e-18, -1.405673286636022e-19,  1.891643467813069e-07, -5.431124399255023e-08,
  8.633937693150243e-09, -9.740826666357255e-10,  8.637051219969162e-11, -6.360271019040665e-12,  4.025823803506401e-13, -2.242127751389842e-14,  1.117468137203842e-15,
 -5.048105320962092e-17,  2.087751831364883e-18, -7.959107626844597e-20,  1.115896539294237e-08, -4.246596796340280e-09,  8.685317359253558e-10, -1.221016218386963e-10,
  1.312913079180213e-11, -1.146011224307744e-12,  8.433905662363754e-14, -5.371832735593942e-15,  3.018480353638082e-16, -1.518361138141749e-17,  6.916494454595180e-19,
 -2.875922725705507e-20,  2.040004906608400e-03, -5.659472888934078e-05,  1.106279139970384e-06, -1.883181487631465e-08,  2.954293230524977e-10, -4.431679026658820e-12,
  6.381019738082885e-14, -8.649003377639753e-16,  1.270893790076837e-17, -1.522974985133349e-19,  1.828578812755133e-21, -3.755554785708517e-23,  4.205954751914391e-03,
 -1.410041561102249e-04,  3.632261273681007e-06, -8.253738036767479e-08,  1.716887476518063e-09, -3.342286933342522e-11,  6.164530853420430e-13, -1.085177579230357e-14,
  1.850021599450535e-16, -3.027111390056730e-18,  4.814956876731414e-20, -7.577665649320443e-22,  3.102318689140872e-03, -1.361092681314259e-04,  4.710252317629923e-06,
 -1.392903795400252e-07,  3.687013026505357e-09, -8.969748091133770e-11,  2.040818895356035e-12, -4.392520870399549e-14,  8.998288017725279e-16, -1.770864823625877e-17,
  3.354292104755518e-19, -6.125883047100000e-21,  1.131893467282706e-03, -6.797963516515038e-05,  3.108528332209339e-06, -1.171589126374023e-07,  3.873880890680662e-09,
 -1.159227659149242e-10,  3.202724526326712e-12, -8.278159933128670e-14,  2.018532495610223e-15, -4.682524875488652e-17,  1.037915956215636e-18, -2.205876258590307e-20,
  2.226123871908285e-04, -1.877940200167170e-05,  1.125254349561191e-06, -5.386057402760835e-08,  2.215898795540090e-09, -8.120474403855310e-11,  2.711244537759153e-12,
 -8.372353072941153e-14,  2.416292322547618e-15, -6.571880467310679e-17,  1.694566190287783e-18, -4.160304322421693e-20,  2.426886343703885e-05, -2.931992938729685e-06,
  2.319195275992620e-07, -1.421123942545782e-08,  7.316013982171794e-10, -3.296681471490932e-11,  1.333919034560938e-12, -4.930131144741860e-14,  1.684771231442044e-15,
 -5.372248674227428e-17,  1.609720919758267e-18, -4.554605428375422e-20,  1.507875078704433e-06, -2.660201830387429e-07,  2.836178022620844e-08, -2.262521302276982e-09,
  1.476999964937137e-10, -8.269278935898790e-12,  4.087214996627188e-13, -1.818517180962993e-14,  7.385670141663733e-16, -2.766827523016505e-17,  9.638492698938141e-19,
 -3.139693909750717e-20,  5.973713092343715e-08, -1.558480579489134e-08,  2.293404095816051e-09, -2.425327574882978e-10,  2.034801892686350e-11, -1.428206803639492e-12,
  8.667480635850258e-14, -4.650945308164318e-15,  2.242559560995302e-16, -9.835338170012332e-18,  3.961019149824164e-19, -1.474431167372532e-20,  2.198844975391750e-09,
 -8.074873958693763e-10,  1.600449040275178e-10, -2.190838193649265e-11,  2.302877336088902e-12, -1.971299420792575e-13,  1.426410931528626e-14, -8.951855993779211e-16,
  4.965004077132479e-17, -2.468819854263414e-18,  1.113081811812024e-19, -4.585830478046624e-21,  1.830000438022805e-03, -4.857429939253677e-05,  9.059825623607755e-07,
 -1.473827345141020e-08,  2.203661915798182e-10, -3.149523731110534e-12,  4.454505430814296e-14, -5.348964738482876e-16,  8.168400302033161e-18, -1.095759474238259e-19,
  3.759167176107618e-22, -2.785523416164804e-23,  3.694379779076630e-03, -1.154869150862499e-04,  2.786922834234203e-06, -5.970342921592127e-08,  1.174840693880762e-09,
 -2.169408363260538e-11,  3.814160342832060e-13, -6.360404270315952e-15,  1.039119514909406e-16, -1.634800409985177e-18,  2.421764190398712e-20, -3.762160896541117e-22,
  2.623915147582168e-03, -1.042312326338019e-04,  3.341124626359683e-06, -9.235489713617845e-08,  2.297853450330190e-09, -5.273093745867537e-11,  1.134003355147098e-12,
 -2.318902432205020e-14,  4.506686146126517e-16, -8.435253347326480e-18,  1.531998976093794e-19, -2.655277522576158e-21,  9.020925350590826e-04, -4.783385070257102e-05,
  2.009657545008370e-06, -7.022233715140413e-08,  2.168353493243766e-09, -6.088493724369820e-11,  1.583475806905342e-12, -3.872230934672442e-14,  8.940225062744362e-16,
 -1.969345401866481e-17,  4.163354543304182e-19, -8.425563315931539e-21,  1.621183858326860e-04, -1.186381543092438e-05,  6.476585042352636e-07, -2.852736123730214e-08,
  1.089953085889035e-09, -3.732256776013922e-11,  1.169781871462142e-12, -3.407067814599054e-14,  9.301276373261901e-16, -2.400672388659796e-17,  5.892699651288349e-19,
 -1.379832489799761e-20,  1.539826388995623e-05, -1.600542252961311e-06,  1.144337865546944e-07, -6.419804619897694e-09,  3.058449582646922e-10, -1.284954693023644e-11,
  4.876221980642098e-13, -1.698928251512605e-14,  5.495519584272051e-16, -1.664921135328583e-17,  4.755606349985779e-19, -1.286490427387964e-20,  7.692824287432052e-07,
 -1.173577398656285e-07,  1.128076919665778e-08, -8.241284286868522e-10,  4.985036669790359e-11, -2.608348560053641e-12,  1.213126837335634e-13, -5.108027552742174e-15,
  1.972772152324096e-16, -7.057397842341874e-18,  2.356429947784865e-19, -7.381960201235309e-21,  2.132499661813232e-08, -4.953463206676600e-09,  6.666890419230457e-10,
 -6.546289557559298e-11,  5.156091731519666e-12, -3.426238122611392e-13,  1.981850152005967e-14, -1.019245124362857e-15,  4.732215411101599e-17, -2.006414584750338e-18,
  7.838650720282438e-20, -2.839125703184436e-21,  4.666769368821713e-10, -1.632374374573849e-10,  3.104997961824678e-11, -4.107634102379728e-12,  4.195620241741891e-13,
 -3.505037349240365e-14,  2.483657009867372e-15, -1.530649792441142e-16,  8.355856439809966e-18, -4.097268090567890e-19,  1.824560366232515e-20, -7.434855738504066e-22,
  1.649157608580649e-03, -4.197836958897361e-05,  7.483751728429498e-07, -1.166285834167698e-08,  1.669907696525014e-10, -2.234226213286127e-12,  3.264254103077011e-14,
 -3.358336940395642e-16,  4.243996185860258e-18, -1.138025910939488e-19, -4.163340499103047e-22, -4.020055099223975e-24,  3.272896821330558e-03, -9.576775939398383e-05,
  2.170408824467581e-06, -4.393409257349568e-08,  8.198066044340517e-10, -1.434986922833599e-11,  2.421955119412666e-13, -3.818191840645117e-15,  5.911773611762118e-17,
 -9.318911406399668e-19,  1.232016151855016e-20, -1.832198899112306e-22,  2.254216835992242e-03, -8.138178655276622e-05,  2.422907707127077e-06, -6.274211124189393e-08,
  1.470171822475456e-09, -3.192008668200518e-11,  6.482325979053111e-13, -1.263905658306908e-14,  2.340597065820031e-16, -4.124357897328859e-18,  7.278634771166145e-20,
 -1.204869596079643e-21,  7.383003076296928e-04, -3.461822027337271e-05,  1.340772470182810e-06, -4.352328184204801e-08,  1.257161704758435e-09, -3.321528929081449e-11,
  8.125023862427119e-13, -1.884925490118814e-14,  4.130572825384857e-16, -8.603121308887668e-18,  1.744720799804229e-19, -3.366300175324011e-21,  1.232121046625578e-04,
 -7.803609179891792e-06,  3.895138619392380e-07, -1.580700439355434e-08,  5.614805351118366e-10, -1.799334620043257e-11,  5.292280141226390e-13, -1.455431059787539e-14,
  3.760795608887141e-16, -9.201004894627940e-18,  2.152361252147916e-19, -4.805801859620766e-21,  1.043519706503713e-05, -9.261119282174144e-07,  5.996716569866423e-08,
 -3.078331155372017e-09,  1.356741955202890e-10, -5.313420410385778e-12,  1.889267368347359e-13, -6.201220842764455e-15,  1.897053327291065e-16, -5.453781937167943e-18,
  1.483561381344631e-19, -3.832253882108964e-21,  4.326774462043172e-07, -5.624546598524387e-08,  4.860329326823265e-09, -3.239342753212179e-10,  1.809850149059170e-11,
 -8.824054037552197e-13,  3.850282743612693e-14, -1.529916355729893e-15,  5.603060958642158e-17, -1.908826225890543e-18,  6.092477240873004e-20, -1.830631428339824e-21,
  8.661106924418868e-09, -1.750699086689474e-09,  2.130867040523804e-10, -1.924850519096312e-11,  1.412449089448254e-12, -8.826825918992350e-14,  4.837630310814351e-15,
 -2.371829832165091e-16,  1.055238590453059e-17, -4.306283332370860e-19,  1.625461155767098e-20, -5.707494441859482e-22,  1.089627901334374e-10, -3.562842865189658e-11,
  6.420499062798743e-12, -8.128743232112423e-13,  8.006567542226137e-14, -6.487510042977326e-15,  4.479044017274872e-16, -2.699333775422914e-17,  1.445248886752027e-18,
 -6.967471044793317e-20,  3.056680968149914e-21, -1.229221479203912e-22,  1.492391732963824e-03, -3.650889831691339e-05,  6.231071003173130e-07, -9.308886970721690e-09,
  1.294416270308561e-10, -1.552193914487376e-12,  2.450350738644956e-14, -2.683447391508314e-16, -7.165011729719907e-20, -1.198694123158500e-19,  5.306798017822425e-22,
  5.305075116171673e-23,  2.921501764267481e-03, -8.031026389402878e-05,  1.713362402946252e-06, -3.283021264892885e-08,  5.832609914498205e-10, -9.634263178085784e-12,
  1.573261539337321e-13, -2.381447634254452e-15,  3.285929523130293e-17, -5.611349035356692e-19,  7.119787988991738e-21, -5.873501933559978e-23,  1.963194647431380e-03,
 -6.465382728612470e-05,  1.792514161259764e-06, -4.358795578877146e-08,  9.625381273325200e-10, -1.988227518076018e-11,  3.803514139063324e-13, -7.052743217168836e-15,
  1.272616060093202e-16, -2.056847056726588e-18,  3.489135519689098e-20, -6.070218804289841e-22,  6.183959045637089e-04, -2.568360695727809e-05,  9.202577708135246e-07,
 -2.781945397922653e-08,  7.517660119916561e-10, -1.879929823713676e-11,  4.313638023330117e-13, -9.484460903414666e-15,  1.999547793398188e-16, -3.882020382058181e-18,
  7.544703100677087e-20, -1.435237543801705e-21,  9.721302060026785e-05, -5.316978615736405e-06,  2.437645878866647e-07, -9.129636779618319e-09,  3.015360348310213e-10,
 -9.077716073112510e-12,  2.502131798577582e-13, -6.498359107176337e-15,  1.596577678236740e-16, -3.686791336575869e-18,  8.224607685667106e-20, -1.761837775604941e-21,
  7.499431945126802e-06, -5.639568970499661e-07,  3.320712071189874e-08, -1.560002460175730e-09,  6.358574346784947e-11, -2.324188739260340e-12,  7.734973045327048e-14,
 -2.390953974422465e-15,  6.919878697567207e-17, -1.884725490720029e-18,  4.880099689844673e-20, -1.203456104263779e-21,  2.663608805902713e-07, -2.906384316527127e-08,
  2.258309557403482e-09, -1.369294709985159e-10,  7.049558344844497e-12, -3.196838668560309e-13,  1.305465819062012e-14, -4.884263292095387e-16,  1.692554405160659e-17,
 -5.477739302602990e-19,  1.667487136720534e-20, -4.794731636382409e-22,  4.010963977033006e-09, -6.878778642546907e-10,  7.503307227706491e-11, -6.182868066568674e-12,
  4.197289256784121e-13, -2.451639081901666e-14,  1.265901690494731e-15, -5.886440953584671e-17,  2.497655534815077e-18, -9.767003955555932e-20,  3.547433573520257e-21,
 -1.202991151280652e-22,  2.872506394844299e-11, -8.547345526662955e-12,  1.435403781852772e-12, -1.717975810011415e-13,  1.616273094705450e-14, -1.260538226776486e-15,
  8.426521331312060e-17, -4.940207853995644e-18,  2.582875186920506e-19, -1.219710729702541e-20,  5.254976070507170e-22, -2.079890039789967e-23,  1.355665218695558e-03,
 -3.193782457961177e-05,  5.228988097292332e-07, -7.456827267262022e-09,  1.036526919107001e-10, -1.058236873982637e-12,  1.637093140794982e-14, -3.297555455617813e-16,
 -3.252437777545302e-18, -3.164147583249846e-20,  4.291281825889573e-21,  1.058217145312543e-22,  2.625385627306853e-03, -6.803398374908949e-05,  1.369641553911586e-06,
 -2.485511978956346e-08,  4.234746023958505e-10, -6.556574024430752e-12,  1.027013928150315e-13, -1.601423582327263e-15,  1.743649907868572e-17, -2.985839089425821e-19,
  6.631995332790943e-21,  2.488514773687014e-23,  1.730280340218803e-03, -5.217142672148711e-05,  1.350181389424999e-06, -3.093218573629308e-08,  6.423004821974551e-10,
 -1.272336279611938e-11,  2.304014522769820e-13, -3.942500083615689e-15,  7.271668935331300e-17, -1.108780453170752e-18,  1.430231854204354e-20, -3.554129648515849e-22,
  5.285264406656645e-04, -1.947771926819322e-05,  6.477897704244161e-07, -1.831534221789295e-08,  4.610523446642539e-10, -1.102134479553306e-11,  2.378932005225297e-13,
 -4.845661577139419e-15,  1.018776033693446e-16, -1.855603295011147e-18,  3.128585851593703e-20, -6.794940958769952e-22,  7.925142555181874e-05, -3.735014800742570e-06,
  1.580749538905305e-07, -5.484068654204059e-09,  1.678298811928757e-10, -4.781930056021601e-12,  1.236093662631229e-13, -3.004082539718458e-15,  7.123898114577441e-17,
 -1.551021826925935e-18,  3.222814497574304e-20, -6.881007186110887e-22,  5.676823949570012e-06, -3.588593436864098e-07,  1.933120766556109e-08, -8.325852022658328e-10,
  3.131227909935360e-11, -1.072341482323014e-12,  3.338964790330807e-14, -9.692048462613499e-16,  2.664386903189363e-17, -6.864292147608900e-19,  1.684723676506281e-20,
 -3.990502101848758e-22,  1.780138887064758e-07, -1.604712651825512e-08,  1.125579463726978e-09, -6.200648897805873e-11,  2.934207897476061e-12, -1.237491900339743e-13,
  4.720537086522675e-15, -1.659430344864896e-16,  5.435779521309481e-18, -1.667573058693536e-19,  4.830989572251870e-21, -1.327676858741589e-22,  2.112891096813259e-09,
 -2.990069885569832e-10,  2.908430912189750e-11, -2.170685658325638e-12,  1.354875538928096e-13, -7.358716269558139e-15,  3.561476572621728e-16, -1.563207800035172e-17,
  6.297877855278048e-19, -2.349885215149677e-20,  8.179920198455503e-22, -2.669054597424755e-23,  8.804704511525692e-12, -2.296002803536321e-12,  3.523680750085647e-13,
 -3.928396621228048e-14,  3.490045376368827e-15, -2.595953619469396e-16,  1.667605693218775e-17, -9.451124719864406e-19,  4.799687306579201e-20, -2.210211628484599e-21,
  9.315766907838525e-23, -3.616987935133827e-24,  1.235751419064200e-03, -2.808585455524356e-05,  4.427291657731299e-07, -5.949705401696646e-09,  8.560885077332965e-11,
 -7.875483451517951e-13,  5.794673777586940e-15, -4.106848484466216e-16, -3.352869194984052e-19,  2.117537480493545e-19,  6.783256833307898e-21, -4.677989490510670e-23,
  2.373425451714734e-03, -5.816387935038549e-05,  1.108100984088857e-06, -1.900887535711005e-08,  3.136499831798106e-10, -4.574813720980868e-12,  6.443521322544338e-14,
 -1.162049264204678e-15,  1.171588238002238e-17, -1.573912745703151e-20,  6.981615884144707e-21, -4.967745724596168e-23,  1.541070087922353e-03, -4.269757100366770e-05,
  1.033139675701423e-06, -2.242391365312604e-08,  4.354025384248124e-10, -8.289088167811687e-12,  1.472162280189488e-13, -2.170615314120842e-15,  3.991482107918660e-17,
 -7.833275256138863e-19,  3.864561780981033e-21, -9.257511624610187e-23,  4.597454798728587e-04, -1.506407292972388e-05,  4.658857977371834e-07, -1.243192626302121e-08,
  2.883990392034606e-10, -6.626047963596743e-12,  1.392364540737708e-13, -2.463299235650425e-15,  5.161177773561897e-17, -1.070162852437035e-18,  1.110608763904438e-20,
 -2.451282485593924e-22,  6.647980610949225e-05, -2.694347271907785e-06,  1.056755796203652e-07, -3.427260898579811e-09,  9.618484943861088e-11, -2.611060432703799e-12,
  6.449435419805318e-14, -1.418734388234181e-15,  3.272163681683131e-17, -7.179604700522441e-19,  1.246625542708207e-20, -2.637065527068662e-22,  4.497592177769484e-06,
 -2.370435754723388e-07,  1.175786088868904e-08, -4.673694481448879e-10,  1.609638599525906e-11, -5.192115975172948e-13,  1.523342409386471e-14, -4.099601370320567e-16,
  1.076158850229442e-17, -2.661466735077940e-19,  6.029479706588834e-21, -1.381346733762496e-22,  1.280431786102824e-07, -9.375423120887663e-09,  5.978531158509650e-10,
 -2.998947898634578e-11,  1.297919070196479e-12, -5.100807778634615e-14,  1.818585911976038e-15, -5.979838541022980e-17,  1.853050347904547e-18, -5.390703649896706e-20,
  1.477874642208543e-21, -3.885846924016922e-23,  1.257584276263956e-09, -1.424422621175949e-10,  1.236441277121827e-11, -8.318814671984677e-13,  4.745782943191214e-14,
 -2.388433416073001e-15,  1.078967923882363e-16, -4.450031208133859e-18,  1.696185236755132e-19, -6.015611711329795e-21,  1.998897529734873e-22, -6.255233359730532e-24,
  3.228450806511848e-12, -7.013278315417553e-13,  9.640314407977589e-14, -9.846948581773412e-15,  8.155031137667452e-16, -5.725341135981328e-17,  3.503551383374020e-18,
 -1.905461625041757e-19,  9.341093925089758e-21, -4.172220194494432e-22,  1.712508131469516e-23, -6.496950645327664e-25,  1.130070823931458e-03, -2.480748859532030e-05,
  3.790453412853564e-07, -4.702239763941590e-09,  7.034695945829911e-11, -7.789778596201024e-13, -4.389614781266985e-15, -2.574503238082828e-16,  1.070146818535546e-17,
  3.340497400490694e-19, -3.328901357681369e-21, -3.942743625777019e-22,  2.157166773602929e-03, -5.013264431742502e-05,  9.073293041212854e-07, -1.464871194557165e-08,
  2.352058148294906e-10, -3.375230696196273e-12,  3.740051161710432e-14, -7.507796993249618e-16,  1.500101074711282e-17,  1.473331368845267e-19, -7.026804486165904e-22,
 -2.946958744126539e-22,  1.385257861755109e-03, -3.540181733657964e-05,  8.009514789774873e-07, -1.661014874073198e-08,  3.006686675754382e-10, -5.365961193310953e-12,
  1.002799029764156e-13, -1.316172515128972e-15,  1.450533791938526e-17, -6.018477644584813e-19,  7.759932665412449e-21,  2.439054234635787e-22,  4.060973596005496e-04,
 -1.186427074093318e-05,  3.405470006317410e-07, -8.716666905333274e-09,  1.845314271242190e-10, -3.958324473551153e-12,  8.812180498154273e-14, -1.355709749649227e-15,
  1.966442169394656e-17, -7.126862471110699e-19,  9.784985167648782e-21,  1.582027431432724e-22,  5.716507256216321e-05, -1.990770674103807e-06,  7.229893233183103e-08,
 -2.233625878006768e-09,  5.674573517216832e-11, -1.442483578653934e-12,  3.612171343387855e-14, -7.069036594545191e-16,  1.376440211898559e-17, -3.752743993896080e-19,
  6.309728556510390e-21, -3.915519899092177e-23,  3.707306004380186e-06, -1.617132314826093e-07,  7.407149996723534e-09, -2.763385457619137e-10,  8.607166889472536e-12,
 -2.598832998704326e-13,  7.409413599702664e-15, -1.820212708420375e-16,  4.383936611865220e-18, -1.120428843010045e-19,  2.355356833645084e-21, -4.349960391051517e-23,
  9.824057988980159e-08, -5.743590225508817e-09,  3.352875822622072e-10, -1.548088687453857e-11,  6.068728957983298e-13, -2.220874148492518e-14,  7.480210858958847e-16,
 -2.281106254244510e-17,  6.637747622699847e-19, -1.861708391025387e-20,  4.792782077419822e-22, -1.177703838951637e-23,  8.367998063542647e-10, -7.343806222738312e-11,
  5.723316116651616e-12, -3.474480310580554e-13,  1.797748222241798e-14, -8.366425916767885e-16,  3.523915312063974e-17, -1.358269327673994e-18,  4.881771318697589e-20,
 -1.643662943173982e-21,  5.187397792954582e-23, -1.550394334985791e-24,  1.444398513645949e-12, -2.453209625617860e-13,  2.973476383408992e-14, -2.737452706849858e-15,
  2.084091507507006e-16, -1.366202154442780e-17,  7.889230299344642e-19, -4.083415938853950e-20,  1.918940916425540e-21, -8.263130089546368e-23,  3.285114282177793e-24,
 -1.212232810752054e-25,  1.036573619155349e-03, -2.198292912849577e-05,  3.288343636522712e-07, -3.708677216485459e-09,  5.337101335174009e-11, -9.228042253246452e-13,
 -5.380295873534712e-15,  2.172564046858578e-16,  1.615717768089610e-17, -1.302136108360933e-19, -1.755172623217986e-20, -7.343596838580261e-23,  1.970124078981732e-03,
 -4.351801689296099e-05,  7.520377898570955e-07, -1.138280137415032e-08,  1.752728840889653e-10, -2.671582008823386e-12,  2.370539518364534e-14, -2.175268634994980e-16,
  1.660519759766781e-17, -1.369831841150664e-19, -1.203703452462974e-20, -8.916086242646112e-23,  1.255309146096593e-03, -2.971707664593706e-05,  6.273434605418381e-07,
 -1.253905620129192e-08,  2.146272188699572e-10, -3.366359334813211e-12,  6.722256527442362e-14, -1.116941006796419e-15,  1.067066804140166e-18, -8.302846657631120e-20,
  1.645854889239687e-20,  8.343074536700570e-24,  3.634903569101628e-04, -9.513432130311140e-06,  2.513889586871811e-07, -6.294486260322740e-09,  1.237173925981231e-10,
 -2.248429523759572e-12,  5.574491786554974e-14, -1.045460973353743e-15,  3.018914542169604e-18, -1.620719664445674e-19,  1.672441853524291e-20,  1.624890958608426e-23,
  5.020826533252502e-05, -1.506075248041714e-06,  5.012700379842959e-08, -1.515366209732258e-09,  3.517246014621734e-11, -7.740973743192262e-13,  2.080135319024881e-14,
 -4.353785557334977e-16,  4.647317159831651e-18, -1.318948737959169e-19,  6.015452195446510e-21, -1.832583543196900e-23,  3.160819883650591e-06, -1.137189751552342e-07,
  4.773009191689928e-09, -1.720329455998801e-10,  4.843162451327877e-12, -1.305181714691600e-13,  3.782488597429752e-15, -9.102154135044560e-17,  1.703727708123633e-18,
 -4.383892297173970e-20,  1.262009284775661e-21, -1.479812518549113e-23,  7.964965462716523e-08, -3.667649580941250e-09,  1.957741846931957e-10, -8.529682928943204e-12,
  3.006768136886461e-13, -1.002871369795402e-14,  3.274625178079822e-16, -9.403040912577937e-18,  2.438083511337186e-19, -6.674249678719635e-21,  1.757372101968752e-22,
 -3.670226281624822e-24,  6.137520151064412e-10, -4.046567742489921e-11,  2.847471127736259e-12, -1.580560139703071e-13,  7.344965115976646e-15, -3.138414063176683e-16,
  1.241535010906058e-17, -4.459584854267807e-19,  1.493031088483757e-20, -4.792473147101332e-22,  1.444462451198107e-23, -4.046894665946568e-25,  7.900275462911139e-13,
 -9.775853779544596e-14,  1.038434816948799e-14, -8.519628806097752e-16,  5.872171447823487e-17, -3.556734512230553e-18,  1.921873469520771e-19, -9.381277103892593e-21,
  4.192787792060069e-22, -1.730183910369093e-23,  6.623154447518965e-25, -2.363231296271712e-26,  9.536399979503688e-04, -1.951718785413215e-05,  2.888300428353823e-07,
 -3.006388539528403e-09,  3.438265461781550e-11, -9.295517562526155e-13,  6.311092323678320e-15,  5.331752222504477e-16,  4.387712249271681e-19, -6.375327001822757e-19,
 -2.044452314469746e-21,  6.752519379264070e-22,  1.807281719396209e-03, -3.800428098538889e-05,  6.306040063675290e-07, -8.976058187029569e-09,  1.273160711771967e-10,
 -2.123554875752860e-12,  2.366189735680607e-14,  1.458668014869264e-16,  3.820026237129068e-18, -5.043589902958736e-19, -1.876179324870958e-21,  4.894204475996252e-22,
  1.145601690655858e-03, -2.524642491089249e-05,  4.955122737942647e-07, -9.566535919840531e-09,  1.609244060355432e-10, -2.122873629190548e-12,  3.682811926697001e-14,
 -1.014807375960188e-15,  8.203086361062531e-18,  3.859969943569219e-19,  2.694885542145627e-21, -5.481872404768346e-22,  3.290240078860115e-04, -7.773798730902932e-06,
  1.864567135090683e-07, -4.611846479905253e-09,  8.980636279562728e-11, -1.251849322841322e-12,  2.782278932201670e-14, -9.225663265380551e-16,  7.739590073903556e-18,
  3.394683126971566e-19,  4.152293276784791e-21, -5.270175104021809e-22,  4.488298169354463e-05, -1.169249782136558e-06,  3.488543802861828e-08, -1.053220409163747e-09,
  2.376942637031527e-11, -4.071566863306546e-13,  1.028926005898630e-14, -3.201736085742205e-16,  3.664988906519297e-18,  5.123370862838849e-20,  2.105087253863917e-21,
 -1.511404831780301e-22,  2.770871434637533e-06, -8.264539218125087e-08,  3.101257516137041e-09, -1.112640812387493e-10,  2.960977470311311e-12, -6.530259211468147e-14,
  1.821917312274935e-15, -5.330718105475599e-17,  8.718858540388475e-19, -7.248955110271882e-21,  5.186451525839834e-22, -2.036996154405328e-23,  6.756156912732604e-08,
 -2.441954752688357e-09,  1.168354560098845e-10, -4.972514761801129e-12,  1.611361037602312e-13, -4.627730660532143e-15,  1.453917797351850e-16, -4.352175462182213e-18,
  9.879532679995589e-20, -2.089674240937615e-21,  6.656197034742310e-23, -1.787057902697647e-24,  4.877388964855731e-10, -2.366436136778994e-11,  1.491582925107821e-12,
 -7.800667097899022e-14,  3.259923203589320e-15, -1.244000771164641e-16,  4.654601705784364e-18, -1.600783247440410e-19,  4.881262174755064e-21, -1.440373223679160e-22,
  4.339100074521453e-24, -1.183663332214331e-25,  5.174328078312171e-13, -4.373734203181120e-14,  4.070974186890689e-15, -2.988202793441498e-16,  1.836170308070584e-17,
 -1.013271465766352e-18,  5.100366388489949e-20, -2.333698441077537e-21,  9.808205958697386e-23, -3.849374191213448e-24,  1.415875371953131e-25, -4.855825212077459e-27,
  8.799754789382256e-04, -1.734283714367277e-05,  2.554806245218577e-07, -2.591926021340450e-09,  1.843630546583062e-11, -6.176927506529122e-13,  1.820575200889599e-14,
  2.207455469187277e-16, -1.720752193852821e-17, -1.905558473173686e-19,  1.999165292541118e-20,  1.018883381578311e-22,  1.664716974165221e-03, -3.335868993132828e-05,
  5.338159818868879e-07, -7.246489083566957e-09,  9.085637581078574e-11, -1.509083830374385e-12,  2.687033845577153e-14,  5.077855739246018e-18, -1.063114478681043e-17,
 -1.813920066807794e-19,  1.504225108163141e-20,  1.007955554899312e-22,  1.051875009187290e-03, -2.170070899435672e-05,  3.948922947929504e-07, -7.292346089615359e-09,
  1.252108711897860e-10, -1.537877138738481e-12,  1.405943504239324e-14, -5.544526575719900e-16,  1.862362932954430e-17,  7.277363670114953e-20, -1.473445538800837e-20,
 -7.606974599151933e-23,  3.005938437736925e-04, -6.480794466431372e-06,  1.390048050844125e-07, -3.347092078814035e-09,  6.954755524312308e-11, -8.547858729842292e-13,
  7.262340643007559e-15, -4.919623812144028e-16,  1.757692108764777e-17,  8.323348671777165e-20, -1.379864781931256e-20, -1.136163432501561e-22,  4.069250894876870e-05,
 -9.348013592609667e-07,  2.429569631747130e-08, -7.274221466529973e-10,  1.744634835595681e-11, -2.525807715886977e-13,  3.283574319627075e-15, -1.701168711948552e-16,
  5.455115968542975e-18,  1.089275910260086e-20, -3.320251627118020e-21, -4.582651618784218e-23,  2.482476701903398e-06, -6.245674324938698e-08,  2.013683808662579e-09,
 -7.241386625541941e-11,  1.986937218813048e-12, -3.647630140273214e-14,  6.991618874070964e-16, -2.730255582176348e-17,  7.755436282713537e-19, -3.163511422273965e-21,
 -2.239535946614044e-22, -8.271932545988932e-24,  5.933913738931123e-08, -1.708107401097306e-09,  7.009480812553136e-11, -2.980926835801310e-12,  9.521152347761931e-14,
 -2.298092524188814e-15,  5.932691007474955e-17, -2.019475185331195e-18,  5.483493848699700e-20, -7.411240469527663e-22,  8.257444123618860e-24, -7.627780118973550e-25,
  4.120625539765472e-10, -1.474543167002972e-11,  8.024994573897434e-13, -4.094005382120028e-14,  1.600514890550072e-15, -5.263447865325707e-17,  1.769120907971104e-18,
 -6.161911005986510e-20,  1.846935762216960e-21, -4.509971157341183e-23,  1.173331672329399e-24, -3.858320095522553e-26,  3.903641240744931e-13, -2.171570683615352e-14,
  1.746255790965137e-15, -1.178082337459255e-16,  6.448808890992055e-18, -3.159589076774797e-19,  1.466123299602465e-20, -6.342300873867250e-22,  2.497701633852068e-23,
 -9.109825751646979e-25,  3.187261139329366e-26, -1.067698570741623e-27,  8.145008771275829e-04, -1.541916880534583e-05,  2.258196001400072e-07, -2.371081109063589e-09,
  1.062384500142151e-11, -1.697374737164276e-13,  1.671129525678602e-14, -2.938110473788699e-16, -1.115086019029608e-17,  4.306606932560414e-19,  6.264454824629184e-21,
 -5.346860983171305e-22,  1.539304685165712e-03, -2.941334949197020e-05,  4.546962109459629e-07, -5.999881320479416e-09,  6.692590013753789e-11, -9.028481727934498e-13,
  2.208049657060468e-14, -3.279925504367826e-16, -7.223300264318925e-18,  3.023916970268790e-19,  5.322736413218296e-21, -4.044459823862224e-22,  9.708813546232254e-04,
 -1.885978565189740e-05,  3.184372553927032e-07, -5.520774307767936e-09,  9.691381482284888e-11, -1.320958702235328e-12,  6.489759038140181e-15, -2.354179513553540e-17,
  1.180095796929731e-17, -3.772141557507102e-19, -4.122940752734236e-21,  4.073270852120401e-22,  2.766654117509244e-04, -5.511755858864993e-06,  1.049727399859687e-07,
 -2.365169001073146e-09,  5.340534398673460e-11, -7.832606421197850e-13,  1.062740734912587e-15,  1.548468950690433e-17,  1.141661023326195e-17, -3.599500615438358e-19,
 -4.512376626237510e-21,  3.954109421197515e-22,  3.729297073529298e-05, -7.709693607900604e-07,  1.708506709881847e-08, -4.856809974218448e-10,  1.289700338987218e-11,
 -2.117895435131376e-13,  8.362528825138403e-16, -1.509497580278622e-17,  3.531582223420035e-18, -1.028534413583824e-19, -1.228472699563230e-21,  1.044761300540893e-22,
  2.260061225369332e-06, -4.933330442250510e-08,  1.313749216120075e-09, -4.575887884772641e-11,  1.377076304619253e-12, -2.624231972290064e-14,  2.506979110116967e-16,
 -6.317575857373153e-18,  4.772067015084950e-19, -1.252036464064286e-20, -1.056356045935128e-22,  9.978103731800970e-24,  5.343416288547031e-08, -1.267608389773614e-09,
  4.215324199198091e-11, -1.763836427086877e-12,  5.983240638360605e-14, -1.378081931222667e-15,  2.352339591228635e-17, -6.708430252923051e-19,  2.941922736775494e-20,
 -7.170049012723960e-22,  5.603642793692196e-25,  2.509506000057051e-25,  3.633343339394614e-10, -9.922717893240156e-12,  4.362520905929100e-13, -2.192944492252661e-14,
  8.617688366673506e-16, -2.544511542015950e-17,  6.763065538388061e-19, -2.199093774506864e-20,  7.728377041789512e-22, -2.008055231196399e-23,  3.167059159310299e-25,
 -5.774854135067609e-27,  3.244575737690388e-13, -1.202693024675307e-14,  7.917513057413429e-16, -5.079226347085060e-17,  2.574045509217466e-18, -1.102266049469897e-19,
  4.496117922052313e-21, -1.833834249701847e-22,  7.046705966371678e-24, -2.406998618792315e-25,  7.510572781488314e-27, -2.348365587625004e-28,  7.562610114292210e-04,
 -1.372366680191335e-05,  1.983361069834417e-07, -2.209796796899751e-09,  1.042863887147633e-11,  1.072675443309175e-13,  5.915507687275975e-15, -3.963104420347077e-16,
  3.865842318975144e-18,  2.962039178667692e-19, -9.605100500467428e-21, -9.992144374660171e-23,  1.428494540853842e-03, -2.604677246344235e-05,  3.886105444526549e-07,
 -5.048185437213893e-09,  5.333473892379318e-11, -4.985376261069771e-13,  1.139961771625007e-14, -3.761390010870912e-16,  3.653314306050268e-18,  2.179020043054010e-19,
 -7.062813735444508e-21, -8.599412679918736e-23,  9.001522678995402e-04, -1.655287566292993e-05,  2.606481449280591e-07, -4.172665701532223e-09,  7.216459412158256e-11,
 -1.143310091618800e-12,  9.037696185656939e-15,  1.368483204765475e-16, -9.701611340370256e-19, -2.519304907152057e-19,  7.757449459034106e-21,  6.899870044948917e-23,
  2.561371524870635e-04, -4.772154154165125e-06,  8.120700565596305e-08, -1.633888358286243e-09,  3.819093064335031e-11, -7.236832493713608e-13,  4.600623873901874e-15,
  1.701495162175148e-16, -1.042871912782910e-18, -2.507511039294175e-19,  7.503302157583876e-21,  7.905889773431595e-23,  3.445007961374250e-05, -6.544083003335558e-07,
  1.235882005431609e-08, -3.120841645131651e-10,  8.878623227218924e-12, -1.875655408685522e-13,  1.421499289095428e-15,  3.767536936581878e-17, -4.233229195431113e-20,
 -7.322013660141081e-20,  2.075317994221849e-21,  2.358505925476223e-23,  2.080748967320211e-06, -4.068312798660282e-08,  8.804795171257393e-10, -2.763206770041061e-11,
  9.051823916687810e-13, -2.104709064289571e-14,  2.189518533506966e-16,  1.766116292997451e-18,  5.132198642399022e-20, -8.833969338262948e-21,  2.311897286232903e-22,
  2.585858153594151e-24,  4.892456400936864e-08, -1.000692559527749e-09,  2.590744730383581e-11, -1.001108272518599e-12,  3.684597026502274e-14, -9.556419652499055e-16,
  1.421014138058709e-17, -1.139133749598025e-19,  6.963937771536514e-21, -4.577474862901238e-22,  1.094914866862411e-23,  7.983959022005095e-26,  3.292429465254444e-10,
 -7.284722781294368e-12,  2.414234354948982e-13, -1.149730022990287e-14,  4.772035950029036e-16, -1.439698142380303e-17,  3.136995116793007e-19, -6.678531773177507e-21,
  2.450676348888095e-22, -9.719144644090268e-24,  2.305321220270020e-25, -1.292238098995288e-27,  2.859644760439685e-13, -7.567370146276430e-15,  3.717389320985121e-16,
 -2.275372837694199e-17,  1.136603448913192e-18, -4.479328760872638e-20,  1.537130351625170e-21, -5.378710904798031e-23,  2.024239691337915e-24, -7.229556922200005e-26,
  2.170772171995448e-27, -5.493937701502610e-29,  7.043760388631303e-04, -1.224001579268248e-05,  1.729059966249317e-07, -2.021483784004390e-09,  1.319906158525537e-11,
  1.372058874018879e-13, -2.383132925647923e-15, -1.764782803520679e-16,  7.766435290214996e-18, -5.049002189558501e-20, -5.627530877166277e-21,  1.877573225318259e-22,
  1.330161140524409e-03, -2.316637170998738e-05,  3.328625220169925e-07, -4.263000638001497e-09,  4.533851560680954e-11, -3.328802138416766e-13,  3.284410643227084e-15,
 -1.892174169869853e-16,  6.445583535355897e-18, -4.230970253574594e-20, -4.280467191418797e-21,  1.416733219362674e-22,  8.378195366557413e-04, -1.465000504725416e-05,
  2.167907648179839e-07, -3.188022923585929e-09,  5.173203656253959e-11, -8.901448237774301e-13,  1.150122397640092e-14,  2.025776056800046e-17, -4.640377052559624e-18,
  2.426038379077991e-20,  4.477568555494621e-21, -1.467249276913192e-22,  2.382369457173791e-04, -4.191590379915823e-06,  6.481254834918755e-08, -1.131157571942585e-09,
  2.516015679209693e-11, -5.660924060315908e-13,  7.960999615598102e-15,  5.072353351463914e-17, -4.762149751751334e-18,  2.227762561258057e-20,  4.510783799921862e-21,
 -1.445838845814071e-22,  3.200951986872490e-05, -5.683741720900671e-07,  9.349286065469413e-09, -1.978525278792002e-10,  5.544941555442179e-12, -1.427901880380718e-13,
  2.178252297952466e-15,  1.042347743691127e-17, -1.194917249994714e-18,  3.436903005918930e-21,  1.290834693676374e-21, -3.998139187250746e-23,  1.930311943746823e-06,
 -3.474947217068623e-08,  6.228730548334151e-10, -1.621413602834445e-11,  5.407462162368458e-13, -1.524140315575713e-14,  2.566488272915145e-16,  1.377720846014828e-19,
 -1.007821255375883e-19, -2.239874058211732e-22,  1.481906372556313e-22, -4.348983851645884e-24,  4.527260903591610e-08, -8.328003909965972e-10,  1.685842382495823e-11,
 -5.467417466374946e-13,  2.096189187681406e-14, -6.398624172720458e-16,  1.226967895936660e-17, -7.049563995286000e-20, -1.844555182546271e-21, -6.038308574288670e-23,
  6.930594237000070e-24, -1.878475711745229e-25,  3.032504554733885e-10, -5.794895530043496e-12,  1.409472673592329e-13, -5.807675467048256e-15,  2.528331171665607e-16,
 -8.489325351467533e-18,  1.956999537105076e-19, -2.813585362332749e-21,  4.035716604866015e-23, -2.386893220918327e-24,  1.222017161855882e-25, -3.070546012828372e-27,
  2.602740592011082e-13, -5.433643327328250e-15,  1.835984175970747e-16, -1.013666584857644e-17,  5.171421398769185e-19, -2.055967852788263e-20,  6.434907749686767e-22,
 -1.769238572044181e-23,  5.379412853886356e-25, -1.977166787365451e-26,  7.019562033162428e-28, -1.955061584431818e-29,  6.580341489784453e-04, -1.095002693542553e-05,
  1.499923445704977e-07, -1.792661934274256e-09,  1.510458850676952e-11,  4.595323026724601e-14, -4.338021057727248e-15,  1.487074815000028e-17,  3.743003784489944e-18,
 -1.296367787513217e-19,  8.295700353642808e-22,  8.056145344718375e-23,  1.242514234952970e-03, -2.069624897241851e-05,  2.858492134964139e-07, -3.587971645913228e-09,
  3.915115896265725e-11, -2.966183111664006e-13,  4.777667156515767e-16, -2.871693507982604e-17,  3.243938930126766e-18, -1.023903008563956e-19,  6.499041913496601e-22,
  6.206467582448611e-23,  7.824640827402108e-04, -1.305588869907336e-05,  1.829616935046375e-07, -2.487824897310005e-09,  3.665560377371088e-11, -6.223483196318405e-13,
  1.029709323828459e-14, -9.164464354968022e-17, -1.979715420297865e-18,  8.986019445864355e-20, -5.394009071650454e-22, -6.259944933331374e-23,  2.224302305067305e-04,
 -3.721333805844996e-06,  5.331465327295630e-08, -8.085963076367577e-10,  1.578170153699811e-11, -3.735193219427234e-13,  7.547006361460066e-15, -6.587812920456050e-17,
 -2.140855974001136e-18,  8.961435103580083e-20, -5.068020632789120e-22, -6.347618351193365e-23,  2.987244155884080e-05, -5.017669768320881e-07,  7.422422527229642e-09,
 -1.291136610600239e-10,  3.214740908422686e-12, -9.094346613800182e-14,  2.005068685020786e-15, -1.917151721677816e-17, -5.397505872718060e-19,  2.350443931916962e-20,
 -1.146370867412450e-22, -1.805156660509614e-23,  1.800227568391578e-06, -3.041869531326766e-08,  4.712280825185288e-10, -9.671162478342762e-12,  2.960307753395183e-13,
 -9.375632333324969e-15,  2.201825366490931e-16, -2.433678088014735e-18, -4.575684436039823e-20,  2.237472613259253e-21, -6.806153761400168e-24, -2.031875824409778e-24,
  4.217648321419267e-08, -7.193474715730189e-10,  1.193723561966959e-11, -2.985310021883106e-13,  1.091218142886634e-14, -3.762357795030878e-16,  9.432669095336545e-18,
 -1.264079983156964e-19, -9.127274500431231e-22,  6.687928507490296e-23,  2.011226269354155e-25, -9.038215531789139e-26,  2.819666575447378e-10, -4.888685985414969e-12,
  9.068231027546087e-14, -2.890340531849398e-15,  1.241532108498225e-16, -4.643886994503663e-18,  1.273571204040537e-19, -2.200442258622524e-21,  1.274468759125667e-23,
  1.532748086468731e-25,  1.755205627219689e-26, -1.413055650547370e-27,  2.408700434292361e-13, -4.337270676378670e-15,  1.003617198233660e-16, -4.453077420103364e-18,
  2.281095861690376e-19, -9.615486499371332e-21,  3.124267981034906e-22, -7.841511515474689e-24,  1.672880030435464e-25, -4.318468976222344e-27,  1.660977443902602e-28,
 -6.373552375658435e-30,  6.165035242207378e-04, -9.831992896614590e-06,  1.299433062514768e-07, -1.548959615700276e-09,  1.506916450987570e-11, -4.358308586787491e-14,
 -2.872005215310337e-15,  7.101959732502343e-17,  1.869256467277766e-19, -6.153236665113282e-20,  1.874902670600092e-21, -1.522430574671185e-23,  1.164044584551617e-03,
 -1.857147624442218e-05,  2.463579859905255e-07, -3.008492405787032e-09,  3.331547778687809e-11, -2.861984118060611e-13,  6.307452697651499e-16,  2.470722277531928e-17,
  4.219080219335695e-19, -4.945656591665454e-20,  1.456243175621230e-21, -1.177645229616721e-23,  7.329917730480037e-04, -1.170250388272583e-05,  1.562568628273469e-07,
 -1.988448821222788e-09,  2.644690329378869e-11, -4.104290465929671e-13,  7.278371595175077e-15, -1.110232616635463e-16,  4.651015216636958e-19,  4.085636609527134e-20,
 -1.372317752685086e-21,  1.103033655193302e-23,  2.083418642765282e-04, -3.329843943994921e-06,  4.490992675445925e-08, -6.067413572415191e-10,  9.944979670330480e-12,
 -2.195281744348805e-13,  5.177622808096373e-15, -9.037005388512410e-17,  3.106799405028575e-19,  4.130814121825229e-20, -1.364923841028241e-21,  1.079624377079495e-23,
  2.797539214585567e-05, -4.478329055182499e-07,  6.129557987141586e-09, -8.982231785808574e-11,  1.826626394816138e-12, -5.049404922202562e-14,  1.340830960609802e-15,
 -2.484758743940925e-17,  1.061661604108179e-19,  1.082479217114920e-20, -3.666156616042117e-22,  2.804007102312886e-24,  1.685454514030318e-06, -2.704507559255568e-08,
  3.782667405937646e-10, -6.172891289145166e-12,  1.552853028656165e-13, -5.005179103312808e-15,  1.425326600026617e-16, -2.782313943293974e-18,  1.640720260772286e-20,
  1.029857878397211e-21, -3.678801513656222e-23,  2.590193332641725e-25,  3.947093025022927e-08, -6.357090446899265e-10,  9.190590835821584e-12, -1.730686064657857e-13,
  5.356704858130854e-15, -1.934944294050717e-16,  5.823703378066901e-18, -1.210341414269614e-19,  1.021186849835079e-21,  3.136023292731727e-23, -1.265814916819410e-24,
  6.673062388491038e-27,  2.636827698945810e-10, -4.274274231042484e-12,  6.533488194276669e-14, -1.500863368734765e-15,  5.712012567628501e-17, -2.273035115937727e-18,
  7.270706744043518e-20, -1.658072456725705e-21,  2.072696196943400e-23,  1.206359818208387e-25, -9.150615224766672e-27, -4.026830062721658e-29,  2.248595677555200e-13,
 -3.698379173619268e-15,  6.361572611633994e-17, -1.999645784680439e-18,  9.564498699603511e-20, -4.255969930607065e-21,  1.510576071629560e-22, -4.111494094386641e-24,
  8.308685838417641e-26, -1.266538695294346e-27,  2.435911222651672e-29, -1.110018057193647e-30,  5.791425972341887e-04, -8.862784943670722e-06,  1.127633635414225e-07,
 -1.317904562276416e-09,  1.366585239006241e-11, -8.954427548374361e-14, -1.039634053333606e-15,  5.423856471164388e-17, -9.075412849970035e-19, -6.442436526406428e-21,
  8.279806993434623e-22, -2.360141223255397e-23,  1.093483989744232e-03, -1.673638664249285e-05,  2.132688065751369e-07, -2.520168728793949e-09,  2.780118819363563e-11,
 -2.625091490157561e-13,  1.316240664099382e-15,  1.957553714147375e-17, -4.873522860958080e-19, -6.604131446456144e-21,  6.465792514644674e-22, -1.824072500474202e-23,
  6.885401498041588e-04, -1.054126823039626e-05,  1.346914561887512e-07, -1.622488778243333e-09,  1.974650865356555e-11, -2.703587816062514e-13,  4.531108312174568e-15,
 -8.187746695694827e-17,  1.117298914041003e-18,  7.165973878851444e-22, -5.935307272838167e-22,  1.766426060386222e-23,  1.956983641276883e-04, -2.997277037347890e-06,
  3.845845953071973e-08, -4.768205471823493e-10,  6.602448395159669e-12, -1.234780898360603e-13,  2.942237774016601e-15, -6.586193767108709e-17,  9.829375723638848e-19,
  1.353718837007069e-21, -5.903874473507559e-22,  1.761682552365197e-23,  2.627592011608417e-05, -4.026775951294113e-07,  5.198762371398600e-09, -6.715286166610882e-11,
  1.085359809353253e-12, -2.601194518697520e-14,  7.330260514914173e-16, -1.769570252050779e-17,  2.768546746365778e-19,  9.586256045768207e-23, -1.573471471041465e-22,
  4.798051609232047e-24,  1.582908306323198e-06, -2.427952911553284e-08,  3.163290375432524e-10, -4.328367644118737e-12,  8.349679266201313e-14, -2.435023222051736e-15,
  7.571927923525142e-17, -1.913609983982558e-18,  3.145612153337406e-20, -4.774445515344119e-23, -1.559755058143503e-23,  4.948194030771263e-25,  3.706371506188638e-08,
 -5.692847748344459e-10,  7.521938392066816e-12, -1.118020223052174e-13,  2.632315857302571e-15, -8.998161612324226e-17,  2.998389584250367e-18, -7.895336586057953e-20,
  1.385427585848624e-21, -5.997197575686684e-24, -5.279661800761994e-25,  1.811733306860165e-26,  2.475350314477871e-10, -3.811011769185646e-12,  5.157514412682845e-14,
 -8.702263709748951e-16,  2.574399076911272e-17, -1.008666410763991e-18,  3.573753960463720e-20, -9.913168636793129e-22,  1.921138648040325e-23, -1.662087974780884e-25,
 -3.812121321558132e-27,  1.659818529511819e-28,  2.109615275776393e-13, -3.264784325581397e-15,  4.653601467070896e-17, -9.875260849662769e-19,  3.884725850225651e-20,
 -1.748738160218905e-21,  6.725831491767750e-23, -2.056922535954603e-24,  4.800851689172845e-26, -7.859450358979467e-28,  7.123336271375125e-30, -3.482382364852068e-32,
  5.454005705110174e-04, -8.020362937504689e-06,  9.819820654820820e-08, -1.114477251419484e-09,  1.173128117054968e-11, -9.958469579903525e-14,  7.258201567827129e-17,
  2.608839490961168e-17, -7.564579074993487e-19,  1.004148889696869e-20,  1.024055356894074e-22, -9.411724187219241e-24,  1.029769375859679e-03, -1.514402943715124e-05,
  1.855284293868798e-07, -2.115481496791642e-09,  2.290179497123812e-11, -2.261809559138335e-13,  1.637685620143045e-15,  3.785002001947350e-18, -4.242061518326551e-19,
  6.410555688952076e-21,  8.633950431240538e-23, -7.258825636102331e-24,  6.484139158800099e-04, -9.536621127428635e-06,  1.169560014139888e-07, -1.344601292434927e-09,
  1.526159730810718e-11, -1.851884811410499e-13,  2.718223453755657e-15, -4.895408286528582e-17,  8.751658684196005e-19, -1.058817878434753e-20, -5.177391987657362e-23,
  6.969699452728953e-24,  1.842906687699382e-04, -2.710866496780002e-06,  3.329981977308185e-08, -3.876649961096833e-10,  4.707726972212754e-12, -7.152336475893761e-14,
  1.521188761382114e-15, -3.685148354034379e-17,  7.654180523167107e-19, -9.876337022201125e-21, -5.140008180253824e-23,  6.895654089361927e-24,  2.474365785527083e-05,
 -3.640497077850463e-07,  4.482633419794641e-09, -5.314391244294518e-11,  7.059728618866262e-13, -1.339488703456688e-14,  3.555852746164738e-16, -9.632708623879436e-18,
  2.102216694732859e-19, -2.830915084839839e-21, -1.105540646987758e-23,  1.853355331157404e-24,  1.490550388983005e-06, -2.193708938825655e-08,  2.710720753109095e-10,
 -3.299510757104026e-12,  4.919744845165278e-14, -1.151920393499466e-15,  3.533519866455544e-17, -1.017511078655048e-18,  2.295676566025209e-20, -3.251996444950591e-22,
 -5.828588024575697e-25,  1.871969951321826e-25,  3.489928837916723e-08, -5.138745226225658e-10,  6.384449088113450e-12, -8.083733470309599e-14,  1.397858939136352e-15,
 -3.984891168505439e-17,  1.354962714011867e-18, -4.078032966571309e-20,  9.521715912419163e-22, -1.445973960526945e-23,  1.831157736417893e-26,  6.616349602409262e-27,
  2.330582437852923e-10, -3.434451568987495e-12,  4.306613844472650e-14, -5.813734349062219e-16,  1.223214998049542e-17, -4.208360786539594e-19,  1.555281600140083e-20,
 -4.890910617302755e-22,  1.198313078502699e-23, -2.022963089926553e-25,  1.173083064690991e-27,  5.623975185633194e-29,  1.985839404491547e-13, -2.931504914174350e-15,
  3.749829197318166e-17, -5.748376580679238e-19,  1.614268726921353e-20, -6.762736909087360e-22,  2.730449883949454e-23, -9.192952222461075e-25,  2.475105653789547e-26,
 -5.068732394276861e-28,  6.832441827547353e-30, -2.145335598347482e-32,  5.148098970970168e-04, -7.285230990022294e-06,  8.588583299383685e-08, -9.424120867930899e-10,
  9.803505221287338e-12, -9.146648959175444e-14,  5.204165841045950e-16,  7.838961874932671e-18, -3.924249139269590e-19,  8.877061857004432e-21, -1.009308375712791e-22,
 -1.175261911082863e-24,  9.720092949838614e-04, -1.375544566952311e-05,  1.621989001514202e-07, -1.783094890795893e-09,  1.877282735488840e-11, -1.869142441004146e-13,
  1.590191855093571e-15, -5.906658908651755e-18, -1.861773773371384e-19,  5.805387919655566e-21, -7.065683484323275e-23, -9.190939905067291e-25,  6.120420534747455e-04,
 -8.661623379742946e-06,  1.021740103513218e-07, -1.126914988977599e-09,  1.211402164948427e-11, -1.335895002409113e-13,  1.682176658030984e-15, -2.699313541273425e-17,
  5.089950265215530e-19, -8.809723160730114e-21,  9.560177099503904e-23,  7.482853060054301e-25,  1.739522161276419e-04, -2.461892738957438e-06,  2.905815370327972e-08,
 -3.221067526269251e-10,  3.571663399950522e-12, -4.495996391042571e-14,  7.786848160636045e-16, -1.799571732657194e-17,  4.243952766958050e-19, -8.143117383016822e-21,
  9.318454670293316e-23,  7.029595846303970e-25,  2.335538977259178e-05, -3.305652752598249e-07,  3.905120946051007e-09, -4.360708231924461e-11,  5.050970112941594e-13,
 -7.431296176224911e-15,  1.648438527454977e-16, -4.501937943313729e-18,  1.140873637704647e-19, -2.266222764743649e-21,  2.704115561148096e-23,  1.627274726657916e-25,
  1.406905330306934e-06, -1.991500166018524e-08,  2.355667169097211e-10, -2.658912462406619e-12,  3.271535207411403e-14, -5.734062285161438e-16,  1.540995510299621e-17,
 -4.627610931829058e-19,  1.219780358213849e-20, -2.488488067617332e-22,  3.129415754907625e-24,  1.172355157882300e-26,  3.294026714214665e-08, -4.663496923071865e-10,
  5.527093782639886e-12, -6.341284900948534e-14,  8.493901488678202e-16, -1.805375946316887e-17,  5.649528491299482e-19, -1.808542862670159e-20,  4.917692144867475e-22,
 -1.034753199698474e-23,  1.399679816927710e-25,  7.954605163141560e-29,  2.199693063589177e-10, -3.115029386711227e-12,  3.704086110003716e-14, -4.366707590249180e-16,
  6.635708705261022e-18, -1.748874880028740e-19,  6.216640722801366e-21, -2.098230540269658e-22,  5.909777352746114e-24, -1.302226518489015e-25,  1.966438074675089e-27,
 -7.875980255953302e-30,  1.874192947266575e-13, -2.655554192059300e-15,  3.179846034650090e-17, -3.964927695283504e-19,  7.482998580753978e-21, -2.553877467368683e-22,
  1.027011503838084e-23, -3.692686656991164e-25,  1.105570791740747e-26, -2.670123953263543e-28,  4.905361227237824e-30, -5.618426544448971e-32,  4.869751102899944e-04,
 -6.640847893829804e-06,  7.546000493838998e-08, -7.994594246548635e-10,  8.110667583195088e-12, -7.749549429170564e-14,  6.063130305959894e-16, -4.244927573271602e-19,
 -1.490577480061969e-19,  4.721199159971120e-21, -9.191213175343211e-23,  9.457647162380873e-25,  9.194540302669877e-04, -1.253860777195906e-05,  1.424871286490419e-07,
 -1.510628393030042e-09,  1.540005775714350e-11, -1.512349334870030e-13,  1.368707048143222e-15, -9.098110529747239e-18, -3.097502481718279e-20,  2.870403180418051e-21,
 -6.469228421008810e-23,  6.991302132839503e-25,  5.789490991955384e-04, -7.895218160698557e-06,  8.973228291858466e-08, -9.524987530638042e-10,  9.793100758645171e-12,
 -1.007123868971962e-13,  1.112122386467278e-15, -1.502324509333609e-17,  2.619184068769460e-19, -5.013258255847795e-21,  8.310197082542506e-23, -8.303939643027015e-25,
  1.645463843301635e-04, -2.243979632818401e-06,  2.550895925632368e-08, -2.712852478005185e-10,  2.825411734641784e-12, -3.102801021975634e-14,  4.261134636304765e-16,
 -8.370831639156082e-18,  1.992140376437915e-19, -4.470345183644390e-21,  7.963122853299915e-23, -8.354630407851029e-25,  2.209247706535497e-05, -3.012901460307502e-07,
  3.426015722111881e-09, -3.653590852177168e-11,  3.876629910744266e-13, -4.642964426537133e-15,  7.914388290732284e-17, -1.945854761853408e-18,  5.193596342024700e-20,
 -1.221509516427596e-21,  2.233635502990222e-23, -2.442782049291739e-25,  1.330823868600348e-06, -1.814995716294846e-08,  2.064767434708876e-10, -2.210826684199801e-12,
  2.409205608216145e-14, -3.223606433755375e-16,  6.742361824945923e-18, -1.918246571590088e-19,  5.439153661910991e-21, -1.314522475082355e-22,  2.459750652420441e-24,
 -2.836819776633400e-26,  3.115877760798677e-08, -4.249691191322311e-10,  4.837749642625204e-12, -5.211872359394381e-14,  5.907541844509421e-16, -9.099604969134807e-18,
  2.303955778786266e-19, -7.264932567385309e-21,  2.146146719410615e-22, -5.313463114716263e-24,  1.023448997029174e-25, -1.270699622222117e-27,  2.080709091529258e-10,
 -2.838079475705471e-12,  3.234403031882685e-14, -3.520382974654962e-16,  4.248034802748354e-18, -7.863207000703933e-20,  2.386800630258240e-21, -8.158955881053316e-23,
  2.500540059121589e-24, -6.383006164071627e-26,  1.285580730106489e-27, -1.782527243988259e-29,  1.772781729283413e-13, -2.418478856676245e-15,  2.762564281576610e-17,
 -3.071322010889739e-19,  4.176034760067797e-21, -1.006490370464374e-22,  3.680643762301122e-24, -1.362004746245061e-25,  4.390026184602047e-27, -1.185956573786266e-28,
  2.610388410018683e-30, -4.390806275734771e-32,  4.615612854793813e-04, -6.073448514766720e-06,  6.659649950312381e-08, -6.813093496706273e-10,  6.703105301092304e-12,
 -6.349181687660252e-14,  5.486363630665915e-16, -3.098856825063643e-18, -3.470258016020536e-20,  1.919716859205209e-21, -4.899319114877545e-23,  8.593649384471012e-25,
  8.714702101042171e-04, -1.146725080578643e-05,  1.257437206669583e-07, -1.286727833604088e-09,  1.268298056354991e-11, -1.214757498137861e-13,  1.112422872890220e-15,
 -8.872076707360305e-18,  3.359214363584185e-20,  9.290424444782709e-22, -3.303723270674367e-23,  6.295550355059233e-25,  5.487351229745106e-04, -7.220560422642977e-06,
  7.918030898439464e-08, -8.106008220938420e-10,  8.015954398468906e-12, -7.826781758420369e-14,  7.858243933327358e-16, -8.962052271700861e-18,  1.321469781774121e-19,
 -2.442757932279329e-21,  4.628677604006215e-23, -7.329632313115302e-25,  1.559590183668366e-04, -2.052205040211281e-06,  2.250590693419029e-08, -2.305559230506310e-10,
  2.291299758980336e-12, -2.302208353709742e-14,  2.607385146709457e-16, -4.030224699220796e-18,  8.650379055694786e-20, -2.035884486888812e-21,  4.309433249043577e-23,
 -7.188343702767324e-25,  2.093949630872996e-05, -2.755367662089048e-07,  3.022026910804710e-09, -3.098858118129203e-11,  3.102039343977995e-13, -3.244516101515249e-15,
  4.242169853524102e-17, -8.364660986195349e-19,  2.141548741799298e-20, -5.439382153014753e-22,  1.188809534027576e-23, -2.025388969878322e-25,  1.261368312759613e-06,
 -1.659815052841522e-08,  1.820711347544626e-10, -1.869661587246004e-12,  1.891331967917616e-14, -2.090836379502426e-16,  3.217764752431665e-18, -7.694515735029493e-20,
  2.178435410371823e-21, -5.755193563570216e-23,  1.283627328588859e-24, -2.232806603935115e-26,  2.953255481605931e-08, -3.886203088123694e-10,  4.263845027213027e-12,
 -4.387936528996035e-14,  4.509350790264586e-16, -5.386258646109704e-18,  9.937728289865065e-20, -2.774845638870548e-21,  8.395592283397206e-23, -2.281320114012657e-24,
  5.192112510669459e-26, -9.282628124236015e-28,  1.972108359485272e-10, -2.595172185913220e-12,  2.848378320036441e-14, -2.941765414636684e-16,  3.102074324427455e-18,
 -4.152602092876803e-20,  9.393354302450555e-22, -2.986836564674853e-23,  9.519576533505508e-25, -2.660475799516967e-26,  6.225644320223898e-28, -1.161961165054270e-29,
  1.680243602648247e-13, -2.211207415720148e-15,  2.428712177864119e-17, -2.526751050622347e-19,  2.805149255538253e-21, -4.551359423629054e-23,  1.315591035759632e-24,
 -4.727523817732319e-26,  1.592491459236953e-27, -4.647528935578725e-29,  1.147167870611688e-30, -2.331319102577210e-32,  4.382837083250735e-04, -5.571648135559171e-06,
  5.902461375736759e-08, -5.835339938111912e-10,  5.557492199198439e-12, -5.143921375457951e-14,  4.544067989357646e-16, -3.415210401003965e-18,  7.123416851465561e-21,
  5.930682365094934e-22, -2.034086988201131e-23,  4.528809257001712e-25,  8.275199532959011e-04, -1.051978983376906e-05,  1.114448528594458e-07, -1.101867625735164e-09,
  1.050105490981122e-11, -9.761412586198549e-14,  8.825499406117368e-16, -7.468466465441859e-18,  4.907378918762461e-20,  6.797303261298630e-23, -1.228727677509221e-23,
  3.219708429357789e-25,  5.210610897505720e-04, -6.623959152140703e-06,  7.017407883852406e-08, -6.939213361282464e-10,  6.621036541009735e-12, -6.201136844026925e-14,
  5.830807137390750e-16, -5.840037599931436e-18,  7.068857678231977e-20, -1.134616412649452e-21,  2.158802027251707e-23, -3.984473610442507e-25,  1.480936067640378e-04,
 -1.882634190415874e-06,  1.994501445306936e-08, -1.972721592881259e-10,  1.885662704084891e-12, -1.786296166412389e-14,  1.776717870465705e-16, -2.157745807071307e-18,
  3.756080638536985e-20, -8.413444010127597e-22,  1.912093174521467e-23, -3.813257228152994e-25,  1.988345956901425e-05, -2.527682342085196e-07,  2.677962471874811e-09,
 -2.649589556630870e-11,  2.539318036962766e-13, -2.445220232507558e-15,  2.621320894262935e-17, -3.883332982254571e-19,  8.518855116161522e-21, -2.167595490487069e-22,
  5.183509939869986e-24, -1.057736281431499e-25,  1.197753628734850e-06, -1.522647446649984e-08,  1.613247635425300e-10, -1.596918077250434e-12,  1.536313378049038e-14,
 -1.514375144418713e-16,  1.788304166516840e-18, -3.219108736126934e-20,  8.252423681404791e-22, -2.245120384902776e-23,  5.514982414117900e-25, -1.143779202708476e-26,
  2.804312355803729e-08, -3.565005609295843e-10,  3.777386354473146e-12, -3.741841783096232e-14,  3.620603580334720e-16, -3.693332933737116e-18,  4.938691815769098e-20,
 -1.072328902486598e-21,  3.073250699861005e-23, -8.732270257596066e-25,  2.190223440585041e-26, -4.623979504490267e-28,  1.872646468593192e-10, -2.380634986473613e-12,
  2.522737489139844e-14, -2.501948660816581e-16,  2.443840419969102e-18, -2.631108855565387e-20,  4.145921237565688e-22, -1.080163839311583e-23,  3.376219078740675e-25,
 -9.940748916989612e-27,  2.551851794196821e-28, -5.528406149887044e-30,  1.595499189562348e-13, -2.028335754826758e-15,  2.149881498847575e-17, -2.137228684406517e-19,
  2.127607830463796e-21, -2.533913640910432e-23,  5.067176710536653e-25, -1.595352858114715e-26,  5.403040739228252e-28, -1.659543254267583e-29,  4.429087816572829e-31,
 -1.009174181648226e-32,  4.168991966679548e-04, -5.126023716001507e-06,  5.252360734845397e-08, -5.022836912816997e-10,  4.630219046014740e-12, -4.164023108766862e-14,
  3.642598861790251e-16, -2.969376437386745e-18,  1.778346254434857e-20,  8.742506334872539e-23, -6.865245776924910e-24,  1.881536503296442e-25,  7.871440154570201e-04,
 -9.678405606512496e-06,  9.916965861077165e-08, -9.483860688879377e-10,  8.744562207463530e-12, -7.876540525581628e-14,  6.952489346321486e-16, -5.930336813253763e-18,
  4.545518857097546e-20, -2.077615304192901e-22, -2.928068977752829e-24,  1.253403112028028e-25,  4.956377244956650e-04, -6.094163399911190e-06,  6.244403595355420e-08,
 -5.971976626004937e-10,  5.508683430633185e-12, -4.975661867658472e-14,  4.461003950255507e-16, -4.094506424149280e-18,  4.185884894622055e-20, -5.470604251514538e-22,
  9.384052821683699e-24, -1.790964279868337e-25,  1.408678876289055e-04, -1.732055977810261e-06,  1.774768215840525e-08, -1.697463565162556e-10,  1.566750965703276e-12,
 -1.421145582177721e-14,  1.304141520372712e-16, -1.320988946037950e-18,  1.768804838586280e-20, -3.381196673301199e-22,  7.611482277684978e-24, -1.650665179076186e-25,
  1.891331321297474e-05, -2.325507790122035e-07,  2.382877114011495e-09, -2.279326256489184e-11,  2.105709890266606e-13, -1.921759453301478e-15,  1.822228254415920e-17,
 -2.083661376822484e-19,  3.520840940193363e-21, -8.169705573842732e-23,  2.009975038257789e-24, -4.513676795505861e-26,  1.139313174729271e-06, -1.400856602056322e-08,
  1.435434861908101e-10, -1.373267007414287e-12,  1.270330386869751e-14, -1.169666157863649e-16,  1.160521963944575e-18, -1.529886332893400e-20,  3.141723942329525e-22,
 -8.175484611515868e-24,  2.103486683217599e-25, -4.816059322909496e-27,  2.667484779957377e-08, -3.279843128851689e-10,  3.360870359521000e-12, -3.216051377124694e-14,
  2.980847542580577e-16, -2.781096313665044e-18,  2.940839510464575e-20, -4.566695774669594e-22,  1.104425683675855e-23, -3.101123459060510e-25,  8.219243388622304e-27,
 -1.913248959317807e-28,  1.781276197023445e-10, -2.190197530902315e-12,  2.244379499308593e-14, -2.148470600127679e-16,  1.997751529057060e-18, -1.904002453453311e-20,
  2.212548002545415e-22, -4.156420038331446e-24,  1.157358737280452e-25, -3.442347054121620e-27,  9.365801669470909e-29, -2.224579335198526e-30,  1.517650848937631e-13,
 -1.866060078429732e-15,  1.912346380049143e-17, -1.831973944654900e-19,  1.714393229614303e-21, -1.703315633062209e-23,  2.323163103545918e-25, -5.530181465639708e-27,
  1.758319161608012e-28, -5.526956330873981e-30,  1.556954266995811e-31, -3.832686174962915e-33,  3.971990042400244e-04, -4.728745397521929e-06,  4.691468575744934e-08,
 -4.344147187118807e-10,  3.878441163695688e-12, -3.383003829008332e-14,  2.892594134189091e-16, -2.389556198876279e-18,  1.756703709470420e-20, -6.561224156714971e-23,
 -1.670858391797725e-24,  6.558495485897107e-26,  7.499482373853742e-04, -8.928306449887383e-06,  8.857930797315605e-08, -8.202225280581279e-10,  7.323481785767721e-12,
 -6.391514888203401e-14,  5.483301364654519e-16, -4.609299875664217e-18,  3.689386685655996e-20, -2.465726053969814e-22,  3.504900932550780e-25,  3.697620494974338e-26,
  4.722168086082129e-04, -5.621850272094479e-06,  5.577544215809750e-08, -5.164745386559385e-10,  4.612042183963687e-12, -4.029054578073283e-14,  3.476853521901796e-16,
 -3.010727221087613e-18,  2.737466633301184e-20, -2.919285607618799e-22,  4.132365223971756e-24, -7.385791529817834e-26,  1.342113003824119e-04, -1.597816744143194e-06,
  1.585227341250721e-08, -1.467936649501695e-10,  1.311114715504315e-12, -1.147086294599500e-14,  9.986895104819448e-17, -9.028729541475746e-19,  9.587510623259617e-21,
 -1.427216964901185e-22,  2.889616170234244e-24, -6.373672501639765e-26,  1.801958103429219e-05, -2.145273391134784e-07,  2.128376452976070e-09, -1.970963102720336e-11,
  1.760925849903714e-13, -1.543951190138791e-15,  1.361454479636484e-17, -1.304853733456557e-19,  1.643207291640430e-21, -3.097423657151740e-23,  7.284937078447385e-25,
 -1.708922097626175e-26,  1.085475893390960e-06, -1.292284825668607e-08,  1.282111480110011e-10, -1.187343675038517e-12,  1.061269846332205e-14, -9.334130377478721e-17,
  8.381788664498760e-19, -8.676050331897461e-21,  1.304773789904824e-22, -2.916427812740280e-24,  7.436073389922227e-26, -1.798920149751190e-27,  2.541434945650230e-08,
 -3.025639728000565e-10,  3.001838630060408e-12, -2.780152627606753e-14,  2.486548405227811e-16, -2.197201727452983e-18,  2.026204093823622e-20, -2.321152530850279e-22,
  4.181303133651291e-24, -1.061544160721395e-25,  2.849901417409789e-27, -7.043550529227223e-29,  1.697103330553703e-10, -2.020443678069011e-12,  2.004568984050315e-14,
 -1.856742090111931e-16,  1.662383106036812e-18, -1.480073589533172e-20,  1.423053920552110e-22, -1.871164054998437e-24,  4.053705365199924e-26, -1.138268231325201e-27,
  3.178868351287572e-29, -8.020299078587966e-31,  1.445935233990443e-13, -1.721423672183475e-15,  1.707929552764321e-17, -1.582326654725464e-19,  1.419582841569566e-21,
 -1.282781829312667e-23,  1.332858822829214e-25, -2.156080702907108e-27,  5.704067767053463e-29, -1.753308406441416e-30,  5.099966565743566e-32, -1.326013360123507e-33
  };
  int offset = -9;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 9;
    if (std::isnan(t)) {
      fill_n(rr+offset, 9, 0.5);
      fill_n(ww+offset, 9, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 9; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=9; ++j) {
        const int boxof = it*108+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
