/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfilePhotoshop
extends TiffProfile {
    public TiffProfilePhotoshop() {
        this._profileText = "Adobe Photoshop 'Advanced TIFF'";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int n = nisoImageMetadata.getCompressionScheme();
        if (n == 6 || n == 8) {
            return true;
        }
        return tiffIFD.getImageSourceData() != null;
    }
}

