/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITSD
extends TiffProfileClassIT {
    public TiffProfileClassITSD() {
        this._profileText = "TIFF/IT-SD (ISO 12639:2003)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray[0] != 1) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tiffIFD, new int[]{2, 3})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tiffIFD, new int[]{1, 4})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, 5)) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 4, 8})) {
            return false;
        }
        if (!this.satisfiesPlanarConfiguration(tiffIFD, 2)) {
            return false;
        }
        int n = tiffIFD.getInkSet();
        if (n != 1) {
            return false;
        }
        String string = tiffIFD.getColorSequence();
        return string == null || "CMYK".equals(string) || "YMCK".equals(string);
    }
}

