/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.ByteArrayXMPSource;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.XMPHandler;
import edu.harvard.hul.ois.jhove.module.jpeg.ArithConditioning;
import edu.harvard.hul.ois.jhove.module.jpeg.JpegExif;
import edu.harvard.hul.ois.jhove.module.jpeg.JpegStrings;
import edu.harvard.hul.ois.jhove.module.jpeg.QuantizationTable;
import edu.harvard.hul.ois.jhove.module.jpeg.SRS;
import edu.harvard.hul.ois.jhove.module.jpeg.Spiff;
import edu.harvard.hul.ois.jhove.module.jpeg.SpiffDir;
import edu.harvard.hul.ois.jhove.module.jpeg.Tiling;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JpegModule
extends ModuleBase {
    private static final String NAME = "JPEG-hul";
    private static final String RELEASE = "1.2";
    private static final int[] DATE = new int[]{2007, 2, 13};
    private static final String[] FORMAT = new String[]{"JPEG", "ISO/IEC 10918-1:1994", "Joint Photographic Experts Group", "JFIF", "JPEG File Interchange Format", "SPIFF", "ISO/IEC 10918-3:1997", "Still Picture Interchange File Format", "JTIP", "ISO/IEC 10918-3:1997", "JPEG Tiled Image Pyramid", "JPEG-LS", "ISO/IEC 14495"};
    private static final String COVERAGE = "JPEG (ISO/IEC 10918-1:1994), JFIF 1.02, SPIFF (ISO/IEC 10918-3:1997), Exif 2.0, 2.1 (JEIDA-49-1998), and 2.2 (JEITA CP-3451), JTIP (ISO/IEC 10918-3:1997), JPEG-LS (ISO/IEC 14495)";
    private static final String[] MIMETYPE = new String[]{"image/jpeg"};
    private static final String WELLFORMED = "A JPEG file is well-formed if the first three bytes are 0xFFD8FF, it consists of one or more correctly formatted segments (using markers 0xC0 through 0xFE), and the data streams following RSTn and SOS markers are correctly terminated";
    private static final String VALIDITY = "A JPEG file is valid if well-formed; the first non-comment segment is APP0 (with identifier 0x4A46494600, indicating JFIF or JTIP), APP1 (with identifier (0x457869660000, indicating Exif), APP8 (with identifier 0x545049464600, indicating SPIFF), or JPG7 (or SOF55, indicating JPEG-LS); D8 marker occurs only at the beginning of the file; any DTT segments are preceded by DTI segments; and all DTI segment tiling type have a value of 0, 1, or 2";
    private static final String REPINFO = "Additional representation information includes: NISO Z39.87 Digital Still Image Technical Metadata and segment-specific metadata";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2003-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    protected String jfifProfileName = "JFIF";
    protected String spiffProfileName = "SPIFF";
    protected String exifProfileName = "Exif";
    protected String jpeglProfileName = "JPEG-L";
    protected NumberFormat minorFmt = NumberFormat.getInstance();
    protected Checksummer _ckSummer;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected Property _metadata;
    protected Property _imageProp;
    protected Property _exifProp;
    protected Property _xmpProp;
    protected NisoImageMetadata _niso;
    protected List _propList;
    protected List _imageList;
    protected Tiling _tiling;
    protected List _quantTables;
    protected List _arithCondTables;
    protected List _srsList;
    protected List _primaryImageList;
    protected int _numSegments;
    protected int _numScans;
    protected int _restartInterval;
    protected boolean _seenJFIF;
    protected boolean _seenSPIFF;
    protected boolean _seenJPEGL;
    protected boolean _reportedSigMatch;
    protected SpiffDir _spiffDir;
    protected boolean _seenExif;
    protected boolean _exifProfileOK;
    protected boolean _reportedJFIF;
    protected boolean _seenSOF;
    protected List _commentsList;
    protected List _jpegExtsList;
    protected List _appSegsList;
    protected List _expList;
    protected Set _compressSet;
    protected int _capability0;
    protected int _capability1;
    protected static final int[] sigByte = new int[]{255, 216, 255};
    protected int _units;
    protected int _xDensity;
    protected int _yDensity;

    public JpegModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this.minorFmt.setMinimumIntegerDigits(2);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        Document document = new Document("Eric Hamilton, JPEG File Interchange Format, Version 1.02, September 1, 1992", DocumentType.WEB);
        agent = new Agent("C-Cube Microsystems", AgentType.COMMERCIAL);
        agent.setAddress("1778 McCarthy Boulevard, Milipitas, CA 95035");
        agent.setTelephone("+1 (408) 944-6314");
        agent.setFax("+1 (408) 944-6314");
        document.setPublisher(agent);
        document.setDate("1992-09-01");
        document.setIdentifier(new Identifier("http://www.w3.org/Graphics/JPEG/jfif3.pdf", IdentifierType.URL));
        this._specification.add(document);
        document = new Document("ISO/IEC 10918-1:1994(E), Information technology -- Digital compression and coding of continuous-tone still images: Requirements and guidelines", DocumentType.STANDARD);
        Agent agent2 = new Agent("ISO", AgentType.STANDARD);
        agent2.setAddress("1, rue de Varembe, Casa postale 56, CH-1211, Geneva 20, Switzerland");
        agent2.setTelephone("+41 22 749 01 11");
        agent2.setFax("+41 22 733 34 30");
        agent2.setEmail("iso@iso.ch");
        agent2.setWeb("http://www.iso.org");
        document.setPublisher(agent2);
        document.setIdentifier(new Identifier("CCITT REc. T.81 (1992 E)", IdentifierType.CCITT));
        this._specification.add(document);
        document = new Document("ISO/IEC 10918-3:1997(E), Digital compressionand coding of continuous-tone still-images: Extensions", DocumentType.STANDARD);
        document.setPublisher(agent2);
        document.setIdentifier(new Identifier("ITU-T Rec. T.84 (1996 E)", IdentifierType.CCITT));
        this._specification.add(document);
        document = new Document("ISO/IEC 14495-1:1999(E), Information technology -- Lossless and near-lossless compression of continuous-tone still images: Baseline", DocumentType.STANDARD);
        document.setPublisher(agent2);
        this._specification.add(document);
        document = new Document("ISO/IEC 14495-2:2003(E), Information technology -- Lossless and near-lossless compression of continuous-tone still images: Extensions", DocumentType.STANDARD);
        document.setPublisher(agent2);
        this._specification.add(document);
        document = new Document("Exchangeable image file format for digital still cameras: Exif Version 2.2", DocumentType.STANDARD);
        Agent agent3 = new Agent("Japan Electronics and Information Technology Industries Association", AgentType.STANDARD);
        agent3.setWeb("http://www.jeita.or.jp/");
        agent3.setAddress("Mitsui Sumitomo Kaijo Building Annex, 11, Kanda Surugadai 3-chome, Chiyoda-ku, Tokyo 101-0062, Japan");
        agent3.setTelephone("+81(03) 3518-6421");
        agent3.setFax("+81(03) 3295-8721");
        document.setPublisher(agent3);
        document.setDate("2002-04");
        Identifier identifier = new Identifier("JEITA CP-3451", IdentifierType.JEITA);
        document.setIdentifier(identifier);
        identifier = new Identifier("http://www.exif.org/Exif2-2.PDF", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("Digital Still Camera Image File Format Standard (Exchangeable image file format for Digital Still Camera:Exif)", DocumentType.STANDARD);
        document.setPublisher(agent3);
        document.setDate("1998-12");
        identifier = new Identifier("JEITA JEIDA-49-1998", IdentifierType.JEITA);
        document.setIdentifier(identifier);
        identifier = new Identifier("http://www.exif.org/dcf-exif.PDF", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        InternalSignature internalSignature = new InternalSignature(sigByte, SignatureType.MAGIC, SignatureUseType.MANDATORY, 0, "");
        this._signature.add(internalSignature);
        internalSignature = new ExternalSignature(".jpg", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(internalSignature);
        internalSignature = new ExternalSignature(".jls", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "Generally used for JPEG-LS (ISO/IEC 14495)");
        this._signature.add(internalSignature);
        internalSignature = new ExternalSignature(".spf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "Generally used for SPIFF (ISO/IEC 10918-3:1997)");
        this._signature.add(internalSignature);
        this._bigEndian = true;
    }

    public void checkSignatures(File file, InputStream inputStream, RepInfo repInfo) throws IOException {
        this._dstream = JpegModule.getBufferedDataStream((InputStream)inputStream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        for (int i = 0; i < 3; ++i) {
            int n;
            try {
                n = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n == sigByte[i]) continue;
            repInfo.setWellFormed(false);
            return;
        }
        repInfo.setModule((Module)this);
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setSigMatch(this._name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int parse(InputStream inputStream, RepInfo repInfo, int n) throws IOException {
        Object object2;
        Property property;
        this.initParse();
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule((Module)this);
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(inputStream, this._ckSummer);
            this._dstream = JpegModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = JpegModule.getBufferedDataStream((InputStream)inputStream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        }
        this._propList = new LinkedList();
        this._metadata = new Property("JPEGMetadata", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._propList);
        if (!this.readHeader(repInfo)) {
            return 0;
        }
        this._niso = new NisoImageMetadata();
        Property property2 = new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)this._niso);
        this._primaryImageList.add(property2);
        this.initNiso();
        boolean bl = false;
        try {
            block26: while (true) {
                int n2 = 0;
                boolean bl2 = false;
                if (!bl) {
                    n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                    if (n2 != 255) {
                        repInfo.setMessage((Message)new ErrorMessage("Expected marker byte 255, got " + n2, this._nByte));
                        repInfo.setWellFormed(false);
                        return 0;
                    }
                    while (n2 == 255) {
                        n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                    }
                } else {
                    while (true) {
                        if ((n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this)) == 255) {
                            bl2 = true;
                            continue;
                        }
                        if (!bl2) continue;
                        if ((n2 & 0x80) != 0) {
                            bl = false;
                            break;
                        }
                        bl2 = false;
                    }
                }
                ++this._numSegments;
                if (!(this._seenJFIF || this._seenSPIFF || this._seenExif || this._seenJPEGL || this._numSegments < 2 || this._reportedJFIF)) {
                    repInfo.setMessage((Message)new ErrorMessage("File does not begin with SPIFF, Exif or JFIF segment", this._nByte));
                    repInfo.setValid(false);
                    this._reportedJFIF = true;
                }
                if (n2 >= 208 && n2 <= 215) {
                    bl = true;
                    continue;
                }
                if (n2 >= 247 && n2 <= 253) {
                    this.readJPEGExtension(n2, repInfo);
                    continue;
                }
                switch (n2) {
                    case 0: {
                        continue block26;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 205: 
                    case 206: 
                    case 207: {
                        this.readSOF(n2, repInfo);
                        continue block26;
                    }
                    case 196: {
                        this.skipSegment(repInfo);
                        continue block26;
                    }
                    case 204: {
                        this.readDAC(repInfo);
                        continue block26;
                    }
                    case 217: {
                        break block26;
                    }
                    case 218: {
                        this.skipSegment(repInfo);
                        ++this._numScans;
                        bl = true;
                        continue block26;
                    }
                    case 219: {
                        this.readDQT(repInfo);
                        continue block26;
                    }
                    case 220: {
                        this.skipSegment(repInfo);
                        continue block26;
                    }
                    case 221: {
                        this.readDRI(repInfo);
                        continue block26;
                    }
                    case 222: {
                        this.readDHP(repInfo);
                        continue block26;
                    }
                    case 223: {
                        this.readEXP(repInfo);
                        continue block26;
                    }
                    case 224: {
                        this.readAPP0(repInfo);
                        continue block26;
                    }
                    case 232: {
                        this.readAPP8(repInfo);
                        continue block26;
                    }
                    case 225: {
                        this.readAPP1(repInfo);
                        continue block26;
                    }
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 237: 
                    case 238: 
                    case 239: {
                        this.reportAppExt(n2, repInfo);
                        this.skipSegment(repInfo);
                        continue block26;
                    }
                    case 240: {
                        this.readVer(repInfo);
                        continue block26;
                    }
                    case 241: {
                        this.readDTI(repInfo);
                        continue block26;
                    }
                    case 242: {
                        this.readDTT(repInfo);
                        continue block26;
                    }
                    case 244: {
                        this.readSRS(repInfo);
                        continue block26;
                    }
                    case 254: {
                        --this._numSegments;
                        this.readComment(repInfo);
                        continue block26;
                    }
                    default: {
                        ErrorMessage errorMessage = new ErrorMessage("Marker not valid in context", this._nByte);
                        repInfo.setMessage((Message)errorMessage);
                        repInfo.setValid(false);
                        break block26;
                    }
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            ErrorMessage errorMessage = new ErrorMessage("Unexpected end of file", this._nByte);
            repInfo.setMessage((Message)errorMessage);
            repInfo.setWellFormed(false);
            return 0;
        }
        repInfo.setProperty(this._metadata);
        if (this._units == 0) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property("PixelAspectRatioX", PropertyType.INTEGER, (Object)new Integer(this._xDensity)));
            arrayList.add(new Property("PixelAspectRatioY", PropertyType.INTEGER, (Object)new Integer(this._yDensity)));
            this._primaryImageList.add(new Property("PixelAspectRatio", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        }
        if (this._tiling != null && (property = this.buildTilingProp(repInfo)) != null) {
            this._primaryImageList.add(property);
        }
        if (this._restartInterval >= 0) {
            this._primaryImageList.add(new Property("RestartInterval", PropertyType.INTEGER, (Object)new Integer(this._restartInterval)));
        }
        this._primaryImageList.add(new Property("Scans", PropertyType.INTEGER, (Object)new Integer(this._numScans)));
        if (!this._quantTables.isEmpty()) {
            LinkedList<Property> linkedList = new LinkedList<Property>();
            ListIterator listIterator = this._quantTables.listIterator();
            while (listIterator.hasNext()) {
                object2 = (QuantizationTable)listIterator.next();
                linkedList.add(((QuantizationTable)object2).makeProperty(this._je.getShowRawFlag()));
            }
            this._primaryImageList.add(new Property("QuantizationTables", PropertyType.PROPERTY, PropertyArity.LIST, linkedList));
        }
        if (!this._arithCondTables.isEmpty()) {
            LinkedList<Property> linkedList = new LinkedList<Property>();
            ListIterator listIterator = this._arithCondTables.listIterator();
            while (listIterator.hasNext()) {
                object2 = (ArithConditioning)listIterator.next();
                linkedList.add(((ArithConditioning)object2).makeProperty(this._je.getShowRawFlag()));
            }
            this._primaryImageList.add(new Property("ArithmeticConditioning", PropertyType.PROPERTY, PropertyArity.LIST, linkedList));
        }
        if (!this._srsList.isEmpty()) {
            LinkedList<Property> linkedList = new LinkedList<Property>();
            ListIterator listIterator = this._srsList.listIterator();
            while (listIterator.hasNext()) {
                object2 = (SRS)listIterator.next();
                linkedList.add(((SRS)object2).makeProperty());
            }
            this._primaryImageList.add(new Property("SelectivelyRefinedScans", PropertyType.PROPERTY, PropertyArity.LIST, linkedList));
        }
        if (this._ckSummer != null) {
            try {
                int n3;
                while ((n3 = this.skipBytes(this._dstream, 2048, this)) != 0) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            repInfo.setSize(this._cstream.getNBytes());
            repInfo.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            String string = this._ckSummer.getMD5();
            if (string != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.MD5));
            }
            if ((string = this._ckSummer.getSHA1()) != null) {
                repInfo.setChecksum(new Checksum(string, ChecksumType.SHA1));
            }
        }
        this._imageList.add(new Property("Image", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._primaryImageList));
        if (this._seenJFIF) {
            repInfo.setProfile(this.jfifProfileName);
        }
        if (this._seenExif && this._exifProfileOK) {
            repInfo.setProfile(this.exifProfileName);
        }
        if (this._seenSPIFF) {
            repInfo.setProfile(this.spiffProfileName);
            if (this._spiffDir != null) {
                this._spiffDir.appendThumbnailProps(this._imageList);
            }
        }
        if (this._seenJPEGL) {
            repInfo.setProfile(this.jpeglProfileName);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Property("Number", PropertyType.INTEGER, PropertyArity.SCALAR, (Object)new Integer(this._imageList.size())));
        for (Object object2 : this._imageList) {
            arrayList.add(object2);
        }
        this._propList.add(new Property("Images", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        if (!this._commentsList.isEmpty()) {
            this._propList.add(new Property("Comments", PropertyType.STRING, PropertyArity.LIST, (Object)this._commentsList));
        }
        if (!this._jpegExtsList.isEmpty()) {
            this._propList.add(new Property("Extensions", PropertyType.STRING, PropertyArity.LIST, (Object)this._jpegExtsList));
        }
        if (!this._appSegsList.isEmpty()) {
            this._propList.add(new Property("ApplicationSegments", PropertyType.STRING, PropertyArity.LIST, (Object)this._appSegsList));
        }
        if (!this._expList.isEmpty()) {
            this._propList.add(this.buildExpandProp(repInfo));
        }
        if (this._exifProp != null) {
            this._primaryImageList.add(this._exifProp);
        }
        if (this._xmpProp != null) {
            this._primaryImageList.add(this._xmpProp);
        }
        return 0;
    }

    public int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        return JpegModule.readUnsignedShort((DataInputStream)dataInputStream, (boolean)true, (ModuleBase)this);
    }

    public long readUnsignedInt(DataInputStream dataInputStream) throws IOException {
        return JpegModule.readUnsignedInt((DataInputStream)dataInputStream, (boolean)true, (ModuleBase)this);
    }

    protected void initParse() {
        super.initParse();
        this._imageList = new LinkedList();
        this._tiling = null;
        this._restartInterval = -1;
        this._seenSOF = false;
        this._seenJFIF = false;
        this._seenSPIFF = false;
        this._seenJPEGL = false;
        this._spiffDir = null;
        this._seenExif = false;
        this._reportedSigMatch = false;
        this._exifProfileOK = false;
        this._reportedJFIF = false;
        this._numSegments = 0;
        this._numScans = 0;
        this._commentsList = new LinkedList();
        this._jpegExtsList = new LinkedList();
        this._appSegsList = new LinkedList();
        this._primaryImageList = new LinkedList();
        this._quantTables = new LinkedList();
        this._arithCondTables = new LinkedList();
        this._srsList = new LinkedList();
        this._compressSet = new HashSet();
        this._expList = new LinkedList();
        this._exifProp = null;
        this._xmpProp = null;
        this._capability0 = -1;
        this._capability1 = -1;
    }

    protected void initNiso() {
        this._niso.setMimeType("image/jpeg");
        this._niso.setByteOrder("big-endian");
        this._niso.setCompressionScheme(6);
    }

    protected boolean readHeader(RepInfo repInfo) {
        boolean bl = true;
        try {
            for (int i = 0; i < 2; ++i) {
                int n = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                if (n == sigByte[i]) continue;
                bl = false;
                break;
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (!bl) {
            repInfo.setMessage((Message)new ErrorMessage("Invalid JPEG header", 0L));
            repInfo.setWellFormed(false);
            return false;
        }
        return true;
    }

    protected void readAPP0(RepInfo repInfo) throws IOException {
        int n;
        int[] nArray = new int[]{74, 70, 88, 88, 0};
        int[] nArray2 = new int[]{74, 70, 73, 70, 0};
        if (!this._reportedSigMatch) {
            repInfo.setSigMatch(this._name);
            this._reportedSigMatch = true;
        }
        this.reportAppExt(224, repInfo);
        int[] nArray3 = new int[5];
        int n2 = this.readUnsignedShort(this._dstream);
        if (this._seenSPIFF) {
            this.skipBytes(this._dstream, n2 - 2, this);
            return;
        }
        for (n = 0; n < 5; ++n) {
            nArray3[n] = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        }
        if (JpegModule.equalArray(nArray3, nArray2)) {
            if (this._numSegments > 1) {
                repInfo.setMessage((Message)new ErrorMessage("JFIF APP0 marker not at beginning of file", this._nByte));
                repInfo.setValid(false);
                this.skipBytes(this._dstream, n2 - 7, this);
            }
            this._seenJFIF = true;
            n = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            int n3 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            String string = Integer.toString(n) + "." + this.minorFmt.format(n3);
            repInfo.setVersion(string);
            this._units = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            if (this._units >= 0 && this._units <= 2) {
                this._niso.setSamplingFrequencyUnit(this._units + 1);
            }
            this._xDensity = this.readUnsignedShort(this._dstream);
            this._yDensity = this.readUnsignedShort(this._dstream);
            if (this._units != 0) {
                this._niso.setXSamplingFrequency(new Rational(this._xDensity, 1));
                this._niso.setYSamplingFrequency(new Rational(this._yDensity, 1));
            }
            int n4 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            int n5 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            if (n4 > 0 && n5 > 0) {
                NisoImageMetadata nisoImageMetadata = new NisoImageMetadata();
                nisoImageMetadata.setImageWidth((long)n4);
                nisoImageMetadata.setImageLength((long)n5);
                nisoImageMetadata.setColorSpace(2);
                nisoImageMetadata.setCompressionScheme(1);
                nisoImageMetadata.setPixelSize(8.0);
                LinkedList<Property> linkedList = new LinkedList<Property>();
                linkedList.add(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)nisoImageMetadata));
                Property property = new Property("ThumbImage", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
                this._imageList.add(property);
            }
            this._niso.setColorSpace(6);
            this.skipBytes(this._dstream, 3 * n4 * n5, this);
        } else if (JpegModule.equalArray(nArray3, nArray)) {
            n = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            switch (n) {
                case 17: 
                case 19: {
                    int n6 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                    int n7 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                    this.skipBytes(this._dstream, n2 - 4, this);
                    NisoImageMetadata nisoImageMetadata = new NisoImageMetadata();
                    nisoImageMetadata.setImageWidth((long)n6);
                    nisoImageMetadata.setImageLength((long)n7);
                    nisoImageMetadata.setColorSpace(n == 19 ? 2 : 3);
                    nisoImageMetadata.setCompressionScheme(1);
                    nisoImageMetadata.setPixelSize(8.0);
                    LinkedList<Property> linkedList = new LinkedList<Property>();
                    linkedList.add(new Property("NisoImageMetadata", PropertyType.NISOIMAGEMETADATA, (Object)nisoImageMetadata));
                    Property property = new Property("ThumbImage", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
                    this._imageList.add(property);
                }
            }
            this.skipBytes(this._dstream, n2 - 2, this);
        } else {
            this.skipBytes(this._dstream, n2 - 2, this);
        }
    }

    protected void readAPP1(RepInfo repInfo) throws IOException {
        int n;
        int[] nArray = new int[]{69, 120, 105, 102, 0, 0};
        int[] nArray2 = new int[]{104, 116, 116, 112, 58, 47};
        this.reportAppExt(225, repInfo);
        int[] nArray3 = new int[6];
        int n2 = this.readUnsignedShort(this._dstream);
        if (n2 < 8) {
            this.skipBytes(this._dstream, n2 - 2, this);
            return;
        }
        for (n = 0; n < 6; ++n) {
            nArray3[n] = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        }
        if (JpegModule.equalArray(nArray3, nArray)) {
            if (!this._reportedSigMatch) {
                repInfo.setSigMatch(this._name);
                this._reportedSigMatch = true;
            }
            this._seenExif = true;
            if (!JpegExif.isTiffAvailable()) {
                repInfo.setMessage((Message)new InfoMessage("TIFF-HUL module required to report Exif data", this._nByte));
                this.skipBytes(this._dstream, n2 - 8, this);
                return;
            }
            JpegExif jpegExif = new JpegExif();
            RepInfo repInfo2 = jpegExif.readExifData(this._dstream, this._je, n2);
            if (repInfo2 != null) {
                List list = repInfo2.getMessage();
                int n3 = list.size();
                for (int i = 0; i < n3; ++i) {
                    repInfo.setMessage((Message)list.get(i));
                }
                this._exifProp = repInfo2.getProperty("Exif");
                Property property = repInfo2.getProperty("NisoImageMetadata");
                if (property != null) {
                    this.extractExifNisoData((NisoImageMetadata)property.getValue());
                }
            }
            this._exifProfileOK = jpegExif.isExifProfileOK();
        } else if (JpegModule.equalArray(nArray3, nArray2) && n2 >= 32) {
            n = 1;
            for (int i = 6; i < 28; ++i) {
                int n4 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                --n2;
                if (n4 == "http://ns.adobe.com/xap/1.0/".charAt(i)) continue;
                n = 0;
                break;
            }
            if (n == 0) {
                this.skipBytes(this._dstream, n2 - 8, this);
                return;
            }
            JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            byte[] byArray = new byte[--n2 - 8];
            JpegModule.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)this);
            this._xmpProp = this.readXMP(byArray);
        } else {
            this.skipBytes(this._dstream, n2 - 8, this);
        }
    }

    protected void readAPP8(RepInfo repInfo) throws IOException {
        int n;
        int[] nArray = new int[]{83, 80, 73, 70, 70, 0};
        if (!this._reportedSigMatch) {
            repInfo.setSigMatch(this._name);
            this._reportedSigMatch = true;
        }
        this.reportAppExt(232, repInfo);
        int n2 = this.readUnsignedShort(this._dstream);
        int[] nArray2 = new int[6];
        if (this._spiffDir != null) {
            this._spiffDir.readDirEntry(this._dstream, n2);
            return;
        }
        for (n = 0; n < 6; ++n) {
            nArray2[n] = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        }
        if (JpegModule.equalArray(nArray2, nArray)) {
            int n3;
            if (this._numSegments > 1) {
                repInfo.setMessage((Message)new ErrorMessage("SPIFF marker not at beginning of file", this._nByte));
                repInfo.setValid(false);
            }
            this._seenSPIFF = true;
            this._spiffDir = new SpiffDir(this);
            n = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            int n4 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            String string = Integer.toString(n) + "." + this.minorFmt.format(n4);
            repInfo.setVersion(string);
            int n5 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            int n6 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            long l = this.readUnsignedInt(this._dstream);
            this._niso.setImageLength(l);
            long l2 = this.readUnsignedInt(this._dstream);
            this._niso.setImageWidth(l2);
            int n7 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            int n8 = Spiff.colorSpaceToNiso(n7);
            if (n8 >= 0) {
                this._niso.setColorSpace(n8);
            }
            int n9 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            int n10 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            int n11 = Spiff.compressionTypeToNiso(n10);
            if (n11 >= 0) {
                this._niso.setCompressionScheme(n11);
            }
            if ((n3 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this)) > 0 && n3 <= 2) {
                this._niso.setSamplingFrequencyUnit(n3 + 1);
            }
            long l3 = this.readUnsignedInt(this._dstream);
            long l4 = this.readUnsignedInt(this._dstream);
        } else {
            this.skipBytes(this._dstream, n2 - 8, this);
        }
    }

    protected void readVer(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        int n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        int n3 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        String string = Integer.toString(n2) + "." + this.minorFmt.format(n3);
        repInfo.setVersion(string);
        int n4 = n - 4;
        if (n2 <= 1) {
            this._capability0 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            --n4;
            if (n2 == 1) {
                this._capability1 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
                --n4;
            }
        }
        this.skipBytes(this._dstream, n4, this);
        this._seenJPEGL = false;
    }

    protected void readDTI(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        this._tiling = new Tiling();
        this._tiling.setTilingType(JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this));
        this._tiling.setVertScale(this.readUnsignedShort(this._dstream));
        this._tiling.setHorScale(this.readUnsignedShort(this._dstream));
        this._tiling.setRefGridHeight(this.readUnsignedInt(this._dstream));
        this._tiling.setRefGridWidth(this.readUnsignedInt(this._dstream));
        this._seenJPEGL = false;
    }

    protected void readDTT(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        if (this._tiling == null) {
            repInfo.setMessage((Message)new ErrorMessage("DTT segment without previous DTI", this._nByte));
            repInfo.setValid(false);
            return;
        }
        long l = this.readUnsignedInt(this._dstream);
        long l2 = this.readUnsignedInt(this._dstream);
        long l3 = this.readUnsignedInt(this._dstream);
        long l4 = this.readUnsignedInt(this._dstream);
        this._tiling.addTile(l, l2, l3, l4);
        this._seenJPEGL = false;
    }

    protected void readSRS(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        int n2 = this.readUnsignedShort(this._dstream);
        int n3 = this.readUnsignedShort(this._dstream);
        int n4 = this.readUnsignedShort(this._dstream);
        int n5 = this.readUnsignedShort(this._dstream);
        this._srsList.add(new SRS(n2, n3, n4, n5));
    }

    protected void reportAppExt(int n, RepInfo repInfo) {
        String string = "APP";
        string = n <= 233 ? string + (char)(n - 224 + 48) : string + "1" + (char)(n - 234 + 48);
        this._appSegsList.add(string);
    }

    protected void readSOF(int n, RepInfo repInfo) throws IOException {
        int n2 = this.readUnsignedShort(this._dstream);
        int n3 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        int n4 = this.readUnsignedShort(this._dstream);
        int n5 = this.readUnsignedShort(this._dstream);
        int n6 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        this.skipBytes(this._dstream, n2 - 8, this);
        if (!this._seenSOF) {
            this._niso.setImageLength((long)n4);
            this._niso.setImageWidth((long)n5);
            int[] nArray = new int[n6];
            for (int i = 0; i < n6; ++i) {
                nArray[i] = n3;
            }
            this._niso.setBitsPerSample(nArray);
            this._niso.setSamplesPerPixel(n6);
            this._propList.add(new Property("CompressionType", PropertyType.STRING, (Object)JpegStrings.COMPRESSION_TYPE[n - 192]));
            this._seenSOF = true;
        }
    }

    protected void readDHP(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        int n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        int n3 = this.readUnsignedShort(this._dstream);
        int n4 = this.readUnsignedShort(this._dstream);
        int n5 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        this.skipBytes(this._dstream, n - 8, this);
        if (!this._seenSOF) {
            this._niso.setImageLength((long)n3);
            this._niso.setImageWidth((long)n4);
            int[] nArray = new int[n5];
            for (int i = 0; i < n5; ++i) {
                nArray[i] = n2;
            }
            this._niso.setBitsPerSample(nArray);
            this._niso.setSamplesPerPixel(n5);
            this._seenSOF = true;
        }
    }

    protected void readEXP(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        int n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        boolean[] blArray = new boolean[]{(n2 & 0xF0) != 0, (n2 & 0xF) != 0};
        this._expList.add(blArray);
    }

    protected void readDRI(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        this._restartInterval = this.readUnsignedShort(this._dstream);
    }

    protected void readDQT(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        int n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        int n3 = n2 >> 4;
        int n4 = n2 & 0xF;
        this._quantTables.add(new QuantizationTable(n3, n4));
        this.skipBytes(this._dstream, n - 3, this);
        this._seenJPEGL = false;
    }

    protected void readDAC(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        int n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
        int n3 = n2 >> 4;
        int n4 = n2 & 0xF;
        this._arithCondTables.add(new ArithConditioning(n3, n4));
        this.skipBytes(this._dstream, n - 3, this);
        this._seenJPEGL = false;
    }

    protected void readJPEGExtension(int n, RepInfo repInfo) throws IOException {
        String string = n <= 249 ? "JPG" + (char)(n - 240 + 48) : "JPG1" + (char)(n - 250 + 48);
        this._jpegExtsList.add(string);
        if (n != 247 && n != 248) {
            this._seenJPEGL = false;
        }
        if (!(n != 247 || this._seenSPIFF || this._seenJFIF || this._seenExif || this._seenJPEGL)) {
            if (!this._reportedSigMatch) {
                repInfo.setSigMatch(this._name);
                this._reportedSigMatch = true;
            }
            int n2 = this.readUnsignedShort(this._dstream);
            int n3 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            int n4 = this.readUnsignedShort(this._dstream);
            int n5 = this.readUnsignedShort(this._dstream);
            int n6 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            this.skipBytes(this._dstream, n2 - 8, this);
            this._seenJPEGL = true;
            this._niso.setImageLength((long)n4);
            this._niso.setImageWidth((long)n5);
            int[] nArray = new int[n6];
            for (int i = 0; i < n6; ++i) {
                nArray[i] = n3;
            }
            this._niso.setBitsPerSample(nArray);
            this._niso.setSamplesPerPixel(n6);
            this._seenSOF = true;
            return;
        }
        int n7 = this.readUnsignedShort(this._dstream);
        this.skipBytes(this._dstream, n7 - 2, this);
    }

    protected void readComment(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < n - 2; ++i) {
            int n2 = JpegModule.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this);
            if (n2 == 0) {
                bl = false;
            }
            if (!bl) continue;
            stringBuffer.append((char)n2);
        }
        if (stringBuffer.length() > 0) {
            this._commentsList.add(stringBuffer.toString());
        }
    }

    protected Property buildCapProp(RepInfo repInfo) {
        if (this._capability0 < 0) {
            return null;
        }
        try {
            Property property;
            ArrayList<Property> arrayList = new ArrayList<Property>(3);
            Property property2 = this._je.getShowRawFlag() ? new Property("Version0", PropertyType.INTEGER, (Object)new Integer(this._capability0)) : new Property("Version0", PropertyType.STRING, (Object)JpegStrings.CAPABILITY_V0[this._capability0]);
            arrayList.add(property2);
            if (this._capability1 >= 0) {
                if (this._je.getShowRawFlag()) {
                    property = new Property("Version1", PropertyType.INTEGER, (Object)new Integer(this._capability1));
                    arrayList.add(property);
                } else {
                    property = new Property[]{JpegStrings.CAPABILITY_V1[this._capability1 & 0x1F], JpegStrings.TILING_CAPABILITY_V1[this._capability1 >> 5]};
                    Property property3 = new Property("Version1", PropertyType.STRING, PropertyArity.ARRAY, (Object)property);
                    arrayList.add(property3);
                }
            }
            property = new Property("CapabilityIndicator", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
            return property;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Property buildTilingProp(RepInfo repInfo) {
        if (this._tiling == null) {
            return null;
        }
        try {
            Property[] propertyArray = new Property[6];
            int n = this._tiling.getTilingType();
            propertyArray[0] = this._je.getShowRawFlag() ? new Property("TilingType", PropertyType.INTEGER, (Object)new Integer(n)) : new Property("TilingType", PropertyType.STRING, (Object)JpegStrings.TILING_TYPE[n]);
            propertyArray[1] = new Property("VerticalScale", PropertyType.INTEGER, (Object)new Integer(this._tiling.getVertScale()));
            propertyArray[2] = new Property("HorizontalScale", PropertyType.INTEGER, (Object)new Integer(this._tiling.getHorScale()));
            propertyArray[3] = new Property("RefGridHeight", PropertyType.LONG, (Object)new Long(this._tiling.getRefGridHeight()));
            propertyArray[4] = new Property("RefGridWidth", PropertyType.LONG, (Object)new Long(this._tiling.getRefGridWidth()));
            propertyArray[5] = this._tiling.buildTileListProp();
            return new Property("Tiling", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray);
        }
        catch (Exception exception) {
            repInfo.setMessage((Message)new ErrorMessage("Unrecognized tiling data"));
            repInfo.setValid(false);
            return null;
        }
    }

    protected Property buildExpandProp(RepInfo repInfo) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        Property property = new Property("ExpansionSegments", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
        ListIterator listIterator = this._expList.listIterator();
        while (listIterator.hasNext()) {
            boolean[] blArray = (boolean[])listIterator.next();
            Property[] propertyArray = new Property[]{new Property("Horizontal", PropertyType.BOOLEAN, (Object)new Boolean(blArray[0])), new Property("Vertical", PropertyType.BOOLEAN, (Object)new Boolean(blArray[1]))};
            linkedList.add(new Property("Expansion", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray));
        }
        return property;
    }

    protected Property readXMP(byte[] byArray) {
        Property property = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ByteArrayXMPSource byteArrayXMPSource = new ByteArrayXMPSource(byteArrayInputStream);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            XMPHandler xMPHandler = new XMPHandler();
            xMLReader.setContentHandler((ContentHandler)xMPHandler);
            xMLReader.setErrorHandler((ErrorHandler)xMPHandler);
            try {
                xMLReader.parse((InputSource)byteArrayXMPSource);
                property = byteArrayXMPSource.makeProperty();
                return property;
            }
            catch (SAXException sAXException) {
                String string = sAXException.getMessage();
                if (string != null && string.startsWith("ENC=")) {
                    String string2 = string.substring(5);
                    try {
                        byteArrayXMPSource = new ByteArrayXMPSource(byteArrayInputStream, string2);
                        xMLReader.parse((InputSource)byteArrayXMPSource);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return null;
                    }
                }
                property = byteArrayXMPSource.makeProperty();
                return property;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void extractExifNisoData(NisoImageMetadata nisoImageMetadata) {
        int n = -1;
        if (nisoImageMetadata.getAutoFocus() != n) {
            this._niso.setAutoFocus(nisoImageMetadata.getAutoFocus());
        }
        if (nisoImageMetadata.getBackLight() != n) {
            this._niso.setBackLight(nisoImageMetadata.getBackLight());
        }
        if (nisoImageMetadata.getBrightness() != (double)n) {
            this._niso.setBrightness(nisoImageMetadata.getBrightness());
        }
        if (nisoImageMetadata.getColorTemp() != (double)n) {
            this._niso.setColorTemp(nisoImageMetadata.getColorTemp());
        }
        if (nisoImageMetadata.getDeviceSource() != null) {
            this._niso.setDeviceSource(nisoImageMetadata.getDeviceSource());
        }
        if (nisoImageMetadata.getDigitalCameraManufacturer() != null) {
            this._niso.setDigitalCameraManufacturer(nisoImageMetadata.getDigitalCameraManufacturer());
        }
        if (nisoImageMetadata.getDigitalCameraModel() != null) {
            this._niso.setDigitalCameraModel(nisoImageMetadata.getDigitalCameraModel());
        }
        if (nisoImageMetadata.getExposureBias() != (double)n) {
            this._niso.setExposureBias(nisoImageMetadata.getExposureBias());
        }
        if (nisoImageMetadata.getExposureIndex() != (double)n) {
            this._niso.setExposureIndex(nisoImageMetadata.getExposureIndex());
        }
        if (nisoImageMetadata.getExposureTime() != (double)n) {
            this._niso.setExposureTime(nisoImageMetadata.getExposureTime());
        }
        if (nisoImageMetadata.getFlash() != n) {
            this._niso.setFlash(nisoImageMetadata.getFlash());
        }
        if (nisoImageMetadata.getFlashEnergy() != (double)n) {
            this._niso.setFlashEnergy(nisoImageMetadata.getFlashEnergy());
        }
        if (nisoImageMetadata.getFlashReturn() != n) {
            this._niso.setFlashReturn(nisoImageMetadata.getFlashReturn());
        }
        if (nisoImageMetadata.getFNumber() != (double)n) {
            this._niso.setFNumber(nisoImageMetadata.getFNumber());
        }
        if (nisoImageMetadata.getHostComputer() != null) {
            this._niso.setHostComputer(nisoImageMetadata.getHostComputer());
        }
        if (nisoImageMetadata.getImageIdentifier() != null) {
            this._niso.setImageIdentifier(nisoImageMetadata.getImageIdentifier());
        }
        if (nisoImageMetadata.getImageProducer() != null) {
            this._niso.setImageProducer(nisoImageMetadata.getImageProducer());
        }
        if (nisoImageMetadata.getMeteringMode() != n) {
            this._niso.setMeteringMode(nisoImageMetadata.getMeteringMode());
        }
        if (nisoImageMetadata.getOS() != null) {
            this._niso.setOS(nisoImageMetadata.getOS());
        }
        if (nisoImageMetadata.getOSVersion() != null) {
            this._niso.setOSVersion(nisoImageMetadata.getOSVersion());
        }
        if (nisoImageMetadata.getPerformanceData() != null) {
            this._niso.setPerformanceData(nisoImageMetadata.getPerformanceData());
        }
        if (nisoImageMetadata.getProcessingAgency() != null) {
            this._niso.setProcessingAgency(nisoImageMetadata.getProcessingAgency());
        }
        if (nisoImageMetadata.getProcessingSoftwareName() != null) {
            this._niso.setProcessingSoftwareName(nisoImageMetadata.getProcessingSoftwareName());
        }
        if (nisoImageMetadata.getProcessingSoftwareVersion() != null) {
            this._niso.setProcessingSoftwareVersion(nisoImageMetadata.getProcessingSoftwareVersion());
        }
        if (nisoImageMetadata.getScannerManufacturer() != null) {
            this._niso.setScannerManufacturer(nisoImageMetadata.getScannerManufacturer());
        }
        if (nisoImageMetadata.getScannerModelName() != null) {
            this._niso.setScannerModelName(nisoImageMetadata.getScannerModelName());
        }
        if (nisoImageMetadata.getScannerModelNumber() != null) {
            this._niso.setScannerModelNumber(nisoImageMetadata.getScannerModelNumber());
        }
        if (nisoImageMetadata.getScannerModelSerialNo() != null) {
            this._niso.setScannerModelSerialNo(nisoImageMetadata.getScannerModelSerialNo());
        }
        if (nisoImageMetadata.getSceneIlluminant() != n) {
            this._niso.setSceneIlluminant(nisoImageMetadata.getSceneIlluminant());
        }
        if (nisoImageMetadata.getSubjectDistance() != null) {
            this._niso.setSubjectDistance(nisoImageMetadata.getSubjectDistance());
        }
    }

    protected boolean skipSegment(RepInfo repInfo) throws IOException {
        int n = this.readUnsignedShort(this._dstream);
        this.skipBytes(this._dstream, n - 2, this);
        return true;
    }

    protected static boolean equalArray(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }
}

