/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class InteroperabilityIFD
extends IFD {
    private static final int INTEROPERABILITYINDEX = 1;
    private String _interoperabilityIndex;

    public InteroperabilityIFD(long l, RepInfo repInfo, RandomAccessFile randomAccessFile, boolean bl) {
        super(l, repInfo, randomAccessFile, bl);
    }

    public String getInteroperabilityIndex() {
        return this._interoperabilityIndex;
    }

    @Override
    public Property getProperty(boolean bl) {
        LinkedList<Property> linkedList = new LinkedList<Property>();
        linkedList.add(new Property("Index", PropertyType.STRING, this._interoperabilityIndex));
        return this.propertyHeader("Exif Interoperability", linkedList);
    }

    @Override
    public void lookupTag(int n, int n2, long l, long l2) throws TiffException {
        try {
            if (n == 1) {
                InteroperabilityIFD.checkType(n, n2, 2);
                this._interoperabilityIndex = this.readASCII(l, l2);
            } else {
                this._info.setMessage(new ErrorMessage("Unknown Exif Interoperability IFD tag", "Tag = " + n, l2));
            }
        }
        catch (IOException iOException) {
            throw new TiffException("Read error for tag " + n, l2);
        }
    }
}

