/*
 * Decompiled with CFR 0.152.
 */
import edu.harvard.hul.ois.jhove.Dump;
import edu.harvard.hul.ois.jhove.module.pdf.ArrayEnd;
import edu.harvard.hul.ois.jhove.module.pdf.ArrayStart;
import edu.harvard.hul.ois.jhove.module.pdf.Comment;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryEnd;
import edu.harvard.hul.ois.jhove.module.pdf.DictionaryStart;
import edu.harvard.hul.ois.jhove.module.pdf.FileTokenizer;
import edu.harvard.hul.ois.jhove.module.pdf.Keyword;
import edu.harvard.hul.ois.jhove.module.pdf.Literal;
import edu.harvard.hul.ois.jhove.module.pdf.Name;
import edu.harvard.hul.ois.jhove.module.pdf.Numeric;
import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.Token;
import java.io.RandomAccessFile;

public class PDump
extends Dump {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("usage: java PDump file");
            System.exit(-1);
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[0], "r");
            FileTokenizer fileTokenizer = new FileTokenizer(randomAccessFile);
            Token token = null;
            long l = 0L;
            while ((token = fileTokenizer.getNext()) != null) {
                System.out.print(PDump.leading(l, 8) + l + ": ");
                if (token instanceof ArrayEnd) {
                    System.out.println("ArrayEnd");
                } else if (token instanceof ArrayStart) {
                    System.out.println("ArrayStart");
                } else if (token instanceof Comment) {
                    System.out.println("Comment \"" + ((Comment)token).getValue() + "\"");
                } else if (token instanceof DictionaryEnd) {
                    System.out.println("DictionaryEnd");
                } else if (token instanceof DictionaryStart) {
                    System.out.println("DictionaryStart");
                } else if (token instanceof Keyword) {
                    System.out.println("Keyword \"" + ((Keyword)token).getValue() + "\"");
                } else if (token instanceof Literal) {
                    System.out.println("Literal[" + (((Literal)token).isPDFDocEncoding() ? "PDF" : "UTF-16") + "] \"" + ((Literal)token).getValue() + "\"");
                } else if (token instanceof Name) {
                    System.out.println("Name \"" + ((Name)token).getValue() + "\"");
                } else if (token instanceof Numeric) {
                    Numeric numeric = (Numeric)token;
                    if (numeric.isReal()) {
                        System.out.println("Numeric " + numeric.getValue());
                    } else {
                        System.out.println("Numeric " + numeric.getIntegerValue());
                    }
                } else if (token instanceof Stream) {
                    System.out.println("Stream " + ((Stream)token).getLength());
                } else {
                    System.out.println(token);
                }
                l = fileTokenizer.getOffset();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(-2);
        }
    }
}

