if(NATPMP_PREFER_STATIC_LIB)
    set(NATPMP_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})
    if(WIN32)
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a .lib ${CMAKE_FIND_LIBRARY_SUFFIXES})
    else()
        set(CMAKE_FIND_LIBRARY_SUFFIXES .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
    endif()
endif()

if(UNIX)
    find_package(PkgConfig QUIET)
    pkg_check_modules(_NATPMP QUIET libnatpmp)
endif()

find_path(NATPMP_INCLUDE_DIR
    NAMES natpmp.h
    HINTS ${_NATPMP_INCLUDEDIR})
find_library(NATPMP_LIBRARY
    NAMES natpmp
    HINTS ${_NATPMP_LIBDIR})

set(NATPMP_INCLUDE_DIRS ${NATPMP_INCLUDE_DIR})
set(NATPMP_LIBRARIES ${NATPMP_LIBRARY})

include(FindPackageHandleStandardArgs)

find_package_handle_standard_args(NATPMP
    REQUIRED_VARS
        NATPMP_LIBRARY
        NATPMP_INCLUDE_DIR)

mark_as_advanced(NATPMP_INCLUDE_DIR NATPMP_LIBRARY)

if(NATPMP_PREFER_STATIC_LIB)
    set(CMAKE_FIND_LIBRARY_SUFFIXES ${NATPMP_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
    unset(NATPMP_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES)
endif()
