/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.Set;
import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.FigureVisitor;
import org.jhotdraw.framework.Handle;
import org.jhotdraw.standard.FigureEnumerator;
import org.jhotdraw.util.CollectionsFactory;

public class DeleteFromDrawingVisitor
implements FigureVisitor {
    private Set myDeletedFigures = CollectionsFactory.current().createSet();
    private Drawing myDrawing;

    public DeleteFromDrawingVisitor(Drawing drawing) {
        this.setDrawing(drawing);
    }

    private void setDrawing(Drawing drawing) {
        this.myDrawing = drawing;
    }

    protected Drawing getDrawing() {
        return this.myDrawing;
    }

    public void visitFigure(Figure figure) {
        if (!this.myDeletedFigures.contains(figure) && this.getDrawing().containsFigure(figure)) {
            Figure figure2 = this.getDrawing().orphan(figure);
            this.myDeletedFigures.add(figure2);
        }
    }

    public void visitHandle(Handle handle) {
    }

    public void visitFigureChangeListener(FigureChangeListener figureChangeListener) {
    }

    public FigureEnumeration getDeletedFigures() {
        return new FigureEnumerator(this.myDeletedFigures);
    }
}

