/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2023 Intel Corporation
 */

#ifndef VRB2_PF_ENUM_H
#define VRB2_PF_ENUM_H

/*
 * VRB2 Register mapping on PF BAR0
 * This is automatically generated from RDL, format may change with new RDL
 * Release.
 * Variable names are as is
 */
enum {
	VRB2_PfQmgrEgressQueuesTemplate             = 0x0007FC00,
	VRB2_PfQmgrIngressAq                        = 0x00100000,
	VRB2_PfQmgrSoftReset                        = 0x00A00034,
	VRB2_PfQmgrAramAllocEn	                    = 0x00A000a0,
	VRB2_PfQmgrAramAllocSetupN0                 = 0x00A000b0,
	VRB2_PfQmgrAramAllocSetupN1                 = 0x00A000b4,
	VRB2_PfQmgrAramAllocSetupN2                 = 0x00A000b8,
	VRB2_PfQmgrAramAllocSetupN3                 = 0x00A000bc,
	VRB2_PfQmgrDepthLog2Grp                     = 0x00A00200,
	VRB2_PfQmgrTholdGrp                         = 0x00A00300,
	VRB2_PfQmgrGrpTmplateReg0Indx               = 0x00A00600,
	VRB2_PfQmgrGrpTmplateReg1Indx               = 0x00A00700,
	VRB2_PfQmgrGrpTmplateReg2Indx               = 0x00A00800,
	VRB2_PfQmgrGrpTmplateReg3Indx               = 0x00A00900,
	VRB2_PfQmgrGrpTmplateReg4Indx               = 0x00A00A00,
	VRB2_PfQmgrGrpTmplateReg5Indx               = 0x00A00B00,
	VRB2_PfQmgrGrpTmplateReg6Indx               = 0x00A00C00,
	VRB2_PfQmgrGrpTmplateReg7Indx               = 0x00A00D00,
	VRB2_PfQmgrGrpTmplateEnRegIndx              = 0x00A00E00,
	VRB2_PfQmgrArbQDepthGrp                     = 0x00A02F00,
	VRB2_PfQmgrGrpFunction0                     = 0x00A02F80,
	VRB2_PfQmgrGrpPriority                      = 0x00A02FC0,
	VRB2_PfQmgrVfBaseAddr                       = 0x00A08000,
	VRB2_PfQmgrAqEnableVf                       = 0x00A10000,
	VRB2_PfQmgrRingSizeVf                       = 0x00A20010,
	VRB2_PfQmgrGrpDepthLog20Vf                  = 0x00A20020,
	VRB2_PfQmgrGrpDepthLog21Vf                  = 0x00A20024,
	VRB2_PfFabricM2iBufferReg                   = 0x00B30000,
	VRB2_PfFecUl5gIbDebug0Reg                   = 0x00B401FC,
	VRB2_PfFftConfig0                           = 0x00B58004,
	VRB2_PfFftParityMask8                       = 0x00B5803C,
	VRB2_PfDmaConfig0Reg                        = 0x00B80000,
	VRB2_PfDmaConfig1Reg                        = 0x00B80004,
	VRB2_PfDmaQmgrAddrReg                       = 0x00B80008,
	VRB2_PfDmaAxcacheReg                        = 0x00B80010,
	VRB2_PfDmaAxiControl                        = 0x00B8002C,
	VRB2_PfDmaQmanen                            = 0x00B80040,
	VRB2_PfDmaQmanenSelect                      = 0x00B80044,
	VRB2_PfDmaCfgRrespBresp                     = 0x00B80814,
	VRB2_PfDmaDescriptorSignature               = 0x00B80868,
	VRB2_PfDmaErrorDetectionEn                  = 0x00B80870,
	VRB2_PfDmaFec5GulDescBaseLoRegVf            = 0x00B88020,
	VRB2_PfDmaFec5GulDescBaseHiRegVf            = 0x00B88024,
	VRB2_PfDmaFec5GulRespPtrLoRegVf             = 0x00B88028,
	VRB2_PfDmaFec5GulRespPtrHiRegVf             = 0x00B8802C,
	VRB2_PfDmaFec5GdlDescBaseLoRegVf            = 0x00B88040,
	VRB2_PfDmaFec5GdlDescBaseHiRegVf            = 0x00B88044,
	VRB2_PfDmaFec5GdlRespPtrLoRegVf             = 0x00B88048,
	VRB2_PfDmaFec5GdlRespPtrHiRegVf             = 0x00B8804C,
	VRB2_PfDmaFec4GulDescBaseLoRegVf            = 0x00B88060,
	VRB2_PfDmaFec4GulDescBaseHiRegVf            = 0x00B88064,
	VRB2_PfDmaFec4GulRespPtrLoRegVf             = 0x00B88068,
	VRB2_PfDmaFec4GulRespPtrHiRegVf             = 0x00B8806C,
	VRB2_PfDmaFec4GdlDescBaseLoRegVf            = 0x00B88080,
	VRB2_PfDmaFec4GdlDescBaseHiRegVf            = 0x00B88084,
	VRB2_PfDmaFec4GdlRespPtrLoRegVf             = 0x00B88088,
	VRB2_PfDmaFec4GdlRespPtrHiRegVf             = 0x00B8808C,
	VRB2_PfDmaFftDescBaseLoRegVf                = 0x00B880A0,
	VRB2_PfDmaFftDescBaseHiRegVf                = 0x00B880A4,
	VRB2_PfDmaFftRespPtrLoRegVf                 = 0x00B880A8,
	VRB2_PfDmaFftRespPtrHiRegVf                 = 0x00B880AC,
	VRB2_PfDmaMldDescBaseLoRegVf                = 0x00B880C0,
	VRB2_PfDmaMldDescBaseHiRegVf                = 0x00B880C4,
	VRB2_PfQosmonAEvalOverflow0                 = 0x00B90008,
	VRB2_PfPermonACntrlRegVf                    = 0x00B98000,
	VRB2_PfQosmonBEvalOverflow0                 = 0x00BA0008,
	VRB2_PfPermonBCntrlRegVf                    = 0x00BA8000,
	VRB2_PfPermonCCntrlRegVf                    = 0x00BB8000,
	VRB2_PfHiInfoRingBaseLoRegPf                = 0x00C84014,
	VRB2_PfHiInfoRingBaseHiRegPf                = 0x00C84018,
	VRB2_PfHiInfoRingPointerRegPf               = 0x00C8401C,
	VRB2_PfHiInfoRingIntWrEnRegPf               = 0x00C84020,
	VRB2_PfHiBlockTransmitOnErrorEn             = 0x00C84038,
	VRB2_PfHiCfgMsiIntWrEnRegPf                 = 0x00C84040,
	VRB2_PfHiMsixVectorMapperPf                 = 0x00C84060,
	VRB2_PfHiPfMode                             = 0x00C84108,
	VRB2_PfHiClkGateHystReg                     = 0x00C8410C,
	VRB2_PfHiMsiDropEnableReg                   = 0x00C84114,
	VRB2_PfHiSectionPowerGatingReq              = 0x00C84128,
	VRB2_PfHiSectionPowerGatingAck              = 0x00C8412C,
};

/* TIP PF Interrupt numbers */
enum {
	VRB2_PF_INT_QMGR_AQ_OVERFLOW = 0,
	VRB2_PF_INT_DOORBELL_VF_2_PF = 1,
	VRB2_PF_INT_ILLEGAL_FORMAT = 2,
	VRB2_PF_INT_QMGR_DISABLED_ACCESS = 3,
	VRB2_PF_INT_QMGR_AQ_OVERTHRESHOLD = 4,
	VRB2_PF_INT_DMA_DL_DESC_IRQ = 5,
	VRB2_PF_INT_DMA_UL_DESC_IRQ = 6,
	VRB2_PF_INT_DMA_FFT_DESC_IRQ = 7,
	VRB2_PF_INT_DMA_UL5G_DESC_IRQ = 8,
	VRB2_PF_INT_DMA_DL5G_DESC_IRQ = 9,
	VRB2_PF_INT_DMA_MLD_DESC_IRQ = 10,
	VRB2_PF_INT_ARAM_ACCESS_ERR = 11,
	VRB2_PF_INT_ARAM_ECC_1BIT_ERR = 12,
	VRB2_PF_INT_PARITY_ERR = 13,
	VRB2_PF_INT_QMGR_OVERFLOW = 14,
	VRB2_PF_INT_QMGR_ERR = 15,
	VRB2_PF_INT_ATS_ERR = 22,
	VRB2_PF_INT_ARAM_FUUL = 23,
	VRB2_PF_INT_EXTRA_READ = 24,
	VRB2_PF_INT_COMPLETION_TIMEOUT = 25,
	VRB2_PF_INT_CORE_HANG = 26,
	VRB2_PF_INT_DMA_HANG = 28,
	VRB2_PF_INT_DS_HANG = 27,
};

#endif /* VRB2_PF_ENUM_H */
