/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2014-2023 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_template_db_tbl.h"

/* Define the template structures */
/*
 * Classification signature table:
 * maps hash id to ulp_class_match_list[] index
 */
uint16_t ulp_class_sig_tbl[BNXT_ULP_CLASS_SIG_TBL_MAX_SZ] = {
	[BNXT_ULP_CLASS_HID_00b8] = 1,
	[BNXT_ULP_CLASS_HID_0cc2] = 2,
	[BNXT_ULP_CLASS_HID_10e4] = 3,
	[BNXT_ULP_CLASS_HID_1d0e] = 4,
	[BNXT_ULP_CLASS_HID_0286] = 5,
	[BNXT_ULP_CLASS_HID_0e98] = 6,
	[BNXT_ULP_CLASS_HID_1666] = 7,
	[BNXT_ULP_CLASS_HID_02de] = 8,
	[BNXT_ULP_CLASS_HID_81d25] = 9,
	[BNXT_ULP_CLASS_HID_809ad] = 10,
	[BNXT_ULP_CLASS_HID_80ae3] = 11,
	[BNXT_ULP_CLASS_HID_8170d] = 12,
	[BNXT_ULP_CLASS_HID_80773] = 13,
	[BNXT_ULP_CLASS_HID_8139d] = 14,
	[BNXT_ULP_CLASS_HID_814d3] = 15,
	[BNXT_ULP_CLASS_HID_8015b] = 16,
	[BNXT_ULP_CLASS_HID_21977] = 17,
	[BNXT_ULP_CLASS_HID_205ef] = 18,
	[BNXT_ULP_CLASS_HID_20735] = 19,
	[BNXT_ULP_CLASS_HID_2134f] = 20,
	[BNXT_ULP_CLASS_HID_61beb] = 21,
	[BNXT_ULP_CLASS_HID_60863] = 22,
	[BNXT_ULP_CLASS_HID_609a9] = 23,
	[BNXT_ULP_CLASS_HID_615c3] = 24,
	[BNXT_ULP_CLASS_HID_00a8] = 25,
	[BNXT_ULP_CLASS_HID_0cd2] = 26,
	[BNXT_ULP_CLASS_HID_10f4] = 27,
	[BNXT_ULP_CLASS_HID_1d1e] = 28,
	[BNXT_ULP_CLASS_HID_1488] = 29,
	[BNXT_ULP_CLASS_HID_0110] = 30,
	[BNXT_ULP_CLASS_HID_0532] = 31,
	[BNXT_ULP_CLASS_HID_115c] = 32,
	[BNXT_ULP_CLASS_HID_0ab8] = 33,
	[BNXT_ULP_CLASS_HID_16a2] = 34,
	[BNXT_ULP_CLASS_HID_1ac4] = 35,
	[BNXT_ULP_CLASS_HID_074c] = 36,
	[BNXT_ULP_CLASS_HID_1e98] = 37,
	[BNXT_ULP_CLASS_HID_0ae0] = 38,
	[BNXT_ULP_CLASS_HID_0f02] = 39,
	[BNXT_ULP_CLASS_HID_1b2c] = 40,
	[BNXT_ULP_CLASS_HID_0296] = 41,
	[BNXT_ULP_CLASS_HID_0e88] = 42,
	[BNXT_ULP_CLASS_HID_1676] = 43,
	[BNXT_ULP_CLASS_HID_02ce] = 44,
	[BNXT_ULP_CLASS_HID_8076e] = 45,
	[BNXT_ULP_CLASS_HID_81380] = 46,
	[BNXT_ULP_CLASS_HID_81b4e] = 47,
	[BNXT_ULP_CLASS_HID_807c6] = 48,
	[BNXT_ULP_CLASS_HID_404ea] = 49,
	[BNXT_ULP_CLASS_HID_4110c] = 50,
	[BNXT_ULP_CLASS_HID_418ca] = 51,
	[BNXT_ULP_CLASS_HID_40542] = 52,
	[BNXT_ULP_CLASS_HID_c09e2] = 53,
	[BNXT_ULP_CLASS_HID_c1604] = 54,
	[BNXT_ULP_CLASS_HID_c1dc2] = 55,
	[BNXT_ULP_CLASS_HID_c0a5a] = 56,
	[BNXT_ULP_CLASS_HID_0098] = 57,
	[BNXT_ULP_CLASS_HID_0ce2] = 58,
	[BNXT_ULP_CLASS_HID_10c4] = 59,
	[BNXT_ULP_CLASS_HID_1d2e] = 60,
	[BNXT_ULP_CLASS_HID_14b8] = 61,
	[BNXT_ULP_CLASS_HID_0120] = 62,
	[BNXT_ULP_CLASS_HID_0502] = 63,
	[BNXT_ULP_CLASS_HID_116c] = 64,
	[BNXT_ULP_CLASS_HID_0a88] = 65,
	[BNXT_ULP_CLASS_HID_1692] = 66,
	[BNXT_ULP_CLASS_HID_1af4] = 67,
	[BNXT_ULP_CLASS_HID_077c] = 68,
	[BNXT_ULP_CLASS_HID_1ea8] = 69,
	[BNXT_ULP_CLASS_HID_0ad0] = 70,
	[BNXT_ULP_CLASS_HID_0f32] = 71,
	[BNXT_ULP_CLASS_HID_1b1c] = 72,
	[BNXT_ULP_CLASS_HID_02a6] = 73,
	[BNXT_ULP_CLASS_HID_0eb8] = 74,
	[BNXT_ULP_CLASS_HID_1646] = 75,
	[BNXT_ULP_CLASS_HID_02fe] = 76,
	[BNXT_ULP_CLASS_HID_8075e] = 77,
	[BNXT_ULP_CLASS_HID_813b0] = 78,
	[BNXT_ULP_CLASS_HID_81b7e] = 79,
	[BNXT_ULP_CLASS_HID_807f6] = 80,
	[BNXT_ULP_CLASS_HID_404da] = 81,
	[BNXT_ULP_CLASS_HID_4113c] = 82,
	[BNXT_ULP_CLASS_HID_418fa] = 83,
	[BNXT_ULP_CLASS_HID_40572] = 84,
	[BNXT_ULP_CLASS_HID_c09d2] = 85,
	[BNXT_ULP_CLASS_HID_c1634] = 86,
	[BNXT_ULP_CLASS_HID_c1df2] = 87,
	[BNXT_ULP_CLASS_HID_c0a6a] = 88,
	[BNXT_ULP_CLASS_HID_81d35] = 89,
	[BNXT_ULP_CLASS_HID_809bd] = 90,
	[BNXT_ULP_CLASS_HID_80af3] = 91,
	[BNXT_ULP_CLASS_HID_8171d] = 92,
	[BNXT_ULP_CLASS_HID_80763] = 93,
	[BNXT_ULP_CLASS_HID_8138d] = 94,
	[BNXT_ULP_CLASS_HID_814c3] = 95,
	[BNXT_ULP_CLASS_HID_8014b] = 96,
	[BNXT_ULP_CLASS_HID_c001f] = 97,
	[BNXT_ULP_CLASS_HID_c0c39] = 98,
	[BNXT_ULP_CLASS_HID_c0d7f] = 99,
	[BNXT_ULP_CLASS_HID_c1999] = 100,
	[BNXT_ULP_CLASS_HID_c09ef] = 101,
	[BNXT_ULP_CLASS_HID_c1609] = 102,
	[BNXT_ULP_CLASS_HID_c174f] = 103,
	[BNXT_ULP_CLASS_HID_c03d7] = 104,
	[BNXT_ULP_CLASS_HID_a1e73] = 105,
	[BNXT_ULP_CLASS_HID_a0afb] = 106,
	[BNXT_ULP_CLASS_HID_a0c31] = 107,
	[BNXT_ULP_CLASS_HID_a185b] = 108,
	[BNXT_ULP_CLASS_HID_a08a1] = 109,
	[BNXT_ULP_CLASS_HID_a14cb] = 110,
	[BNXT_ULP_CLASS_HID_a1601] = 111,
	[BNXT_ULP_CLASS_HID_a0289] = 112,
	[BNXT_ULP_CLASS_HID_e015d] = 113,
	[BNXT_ULP_CLASS_HID_e0d47] = 114,
	[BNXT_ULP_CLASS_HID_e0ebd] = 115,
	[BNXT_ULP_CLASS_HID_e1aa7] = 116,
	[BNXT_ULP_CLASS_HID_e0b2d] = 117,
	[BNXT_ULP_CLASS_HID_e1757] = 118,
	[BNXT_ULP_CLASS_HID_e188d] = 119,
	[BNXT_ULP_CLASS_HID_e0515] = 120,
	[BNXT_ULP_CLASS_HID_21967] = 121,
	[BNXT_ULP_CLASS_HID_205ff] = 122,
	[BNXT_ULP_CLASS_HID_20725] = 123,
	[BNXT_ULP_CLASS_HID_2135f] = 124,
	[BNXT_ULP_CLASS_HID_61bfb] = 125,
	[BNXT_ULP_CLASS_HID_60873] = 126,
	[BNXT_ULP_CLASS_HID_609b9] = 127,
	[BNXT_ULP_CLASS_HID_615d3] = 128,
	[BNXT_ULP_CLASS_HID_30a55] = 129,
	[BNXT_ULP_CLASS_HID_3164f] = 130,
	[BNXT_ULP_CLASS_HID_317b5] = 131,
	[BNXT_ULP_CLASS_HID_3040d] = 132,
	[BNXT_ULP_CLASS_HID_70ca9] = 133,
	[BNXT_ULP_CLASS_HID_718c3] = 134,
	[BNXT_ULP_CLASS_HID_71a09] = 135,
	[BNXT_ULP_CLASS_HID_70681] = 136,
	[BNXT_ULP_CLASS_HID_2821d] = 137,
	[BNXT_ULP_CLASS_HID_28e37] = 138,
	[BNXT_ULP_CLASS_HID_28f7d] = 139,
	[BNXT_ULP_CLASS_HID_29b97] = 140,
	[BNXT_ULP_CLASS_HID_68491] = 141,
	[BNXT_ULP_CLASS_HID_6908b] = 142,
	[BNXT_ULP_CLASS_HID_691f1] = 143,
	[BNXT_ULP_CLASS_HID_69deb] = 144,
	[BNXT_ULP_CLASS_HID_3926d] = 145,
	[BNXT_ULP_CLASS_HID_39e87] = 146,
	[BNXT_ULP_CLASS_HID_38023] = 147,
	[BNXT_ULP_CLASS_HID_38c45] = 148,
	[BNXT_ULP_CLASS_HID_794e1] = 149,
	[BNXT_ULP_CLASS_HID_78179] = 150,
	[BNXT_ULP_CLASS_HID_782a7] = 151,
	[BNXT_ULP_CLASS_HID_78ed9] = 152,
	[BNXT_ULP_CLASS_HID_81d05] = 153,
	[BNXT_ULP_CLASS_HID_8098d] = 154,
	[BNXT_ULP_CLASS_HID_80ac3] = 155,
	[BNXT_ULP_CLASS_HID_8172d] = 156,
	[BNXT_ULP_CLASS_HID_80753] = 157,
	[BNXT_ULP_CLASS_HID_813bd] = 158,
	[BNXT_ULP_CLASS_HID_814f3] = 159,
	[BNXT_ULP_CLASS_HID_8017b] = 160,
	[BNXT_ULP_CLASS_HID_c002f] = 161,
	[BNXT_ULP_CLASS_HID_c0c09] = 162,
	[BNXT_ULP_CLASS_HID_c0d4f] = 163,
	[BNXT_ULP_CLASS_HID_c19a9] = 164,
	[BNXT_ULP_CLASS_HID_c09df] = 165,
	[BNXT_ULP_CLASS_HID_c1639] = 166,
	[BNXT_ULP_CLASS_HID_c177f] = 167,
	[BNXT_ULP_CLASS_HID_c03e7] = 168,
	[BNXT_ULP_CLASS_HID_a1e43] = 169,
	[BNXT_ULP_CLASS_HID_a0acb] = 170,
	[BNXT_ULP_CLASS_HID_a0c01] = 171,
	[BNXT_ULP_CLASS_HID_a186b] = 172,
	[BNXT_ULP_CLASS_HID_a0891] = 173,
	[BNXT_ULP_CLASS_HID_a14fb] = 174,
	[BNXT_ULP_CLASS_HID_a1631] = 175,
	[BNXT_ULP_CLASS_HID_a02b9] = 176,
	[BNXT_ULP_CLASS_HID_e016d] = 177,
	[BNXT_ULP_CLASS_HID_e0d77] = 178,
	[BNXT_ULP_CLASS_HID_e0e8d] = 179,
	[BNXT_ULP_CLASS_HID_e1a97] = 180,
	[BNXT_ULP_CLASS_HID_e0b1d] = 181,
	[BNXT_ULP_CLASS_HID_e1767] = 182,
	[BNXT_ULP_CLASS_HID_e18bd] = 183,
	[BNXT_ULP_CLASS_HID_e0525] = 184,
	[BNXT_ULP_CLASS_HID_21957] = 185,
	[BNXT_ULP_CLASS_HID_205cf] = 186,
	[BNXT_ULP_CLASS_HID_20715] = 187,
	[BNXT_ULP_CLASS_HID_2136f] = 188,
	[BNXT_ULP_CLASS_HID_61bcb] = 189,
	[BNXT_ULP_CLASS_HID_60843] = 190,
	[BNXT_ULP_CLASS_HID_60989] = 191,
	[BNXT_ULP_CLASS_HID_615e3] = 192,
	[BNXT_ULP_CLASS_HID_30a65] = 193,
	[BNXT_ULP_CLASS_HID_3167f] = 194,
	[BNXT_ULP_CLASS_HID_31785] = 195,
	[BNXT_ULP_CLASS_HID_3043d] = 196,
	[BNXT_ULP_CLASS_HID_70c99] = 197,
	[BNXT_ULP_CLASS_HID_718f3] = 198,
	[BNXT_ULP_CLASS_HID_71a39] = 199,
	[BNXT_ULP_CLASS_HID_706b1] = 200,
	[BNXT_ULP_CLASS_HID_2822d] = 201,
	[BNXT_ULP_CLASS_HID_28e07] = 202,
	[BNXT_ULP_CLASS_HID_28f4d] = 203,
	[BNXT_ULP_CLASS_HID_29ba7] = 204,
	[BNXT_ULP_CLASS_HID_684a1] = 205,
	[BNXT_ULP_CLASS_HID_690bb] = 206,
	[BNXT_ULP_CLASS_HID_691c1] = 207,
	[BNXT_ULP_CLASS_HID_69ddb] = 208,
	[BNXT_ULP_CLASS_HID_3925d] = 209,
	[BNXT_ULP_CLASS_HID_39eb7] = 210,
	[BNXT_ULP_CLASS_HID_38013] = 211,
	[BNXT_ULP_CLASS_HID_38c75] = 212,
	[BNXT_ULP_CLASS_HID_794d1] = 213,
	[BNXT_ULP_CLASS_HID_78149] = 214,
	[BNXT_ULP_CLASS_HID_78297] = 215,
	[BNXT_ULP_CLASS_HID_78ee9] = 216,
	[BNXT_ULP_CLASS_HID_0816] = 217,
	[BNXT_ULP_CLASS_HID_1852] = 218,
	[BNXT_ULP_CLASS_HID_09f4] = 219,
	[BNXT_ULP_CLASS_HID_1dd4] = 220,
	[BNXT_ULP_CLASS_HID_804f1] = 221,
	[BNXT_ULP_CLASS_HID_81251] = 222,
	[BNXT_ULP_CLASS_HID_80ee1] = 223,
	[BNXT_ULP_CLASS_HID_81c41] = 224,
	[BNXT_ULP_CLASS_HID_2013b] = 225,
	[BNXT_ULP_CLASS_HID_20e9b] = 226,
	[BNXT_ULP_CLASS_HID_603bf] = 227,
	[BNXT_ULP_CLASS_HID_6111f] = 228,
	[BNXT_ULP_CLASS_HID_0806] = 229,
	[BNXT_ULP_CLASS_HID_1842] = 230,
	[BNXT_ULP_CLASS_HID_1be6] = 231,
	[BNXT_ULP_CLASS_HID_0c80] = 232,
	[BNXT_ULP_CLASS_HID_1216] = 233,
	[BNXT_ULP_CLASS_HID_02b0] = 234,
	[BNXT_ULP_CLASS_HID_0654] = 235,
	[BNXT_ULP_CLASS_HID_1690] = 236,
	[BNXT_ULP_CLASS_HID_09e4] = 237,
	[BNXT_ULP_CLASS_HID_1dc4] = 238,
	[BNXT_ULP_CLASS_HID_80efc] = 239,
	[BNXT_ULP_CLASS_HID_80332] = 240,
	[BNXT_ULP_CLASS_HID_40c78] = 241,
	[BNXT_ULP_CLASS_HID_400be] = 242,
	[BNXT_ULP_CLASS_HID_c1170] = 243,
	[BNXT_ULP_CLASS_HID_c05b6] = 244,
	[BNXT_ULP_CLASS_HID_0836] = 245,
	[BNXT_ULP_CLASS_HID_1872] = 246,
	[BNXT_ULP_CLASS_HID_1bd6] = 247,
	[BNXT_ULP_CLASS_HID_0cb0] = 248,
	[BNXT_ULP_CLASS_HID_1226] = 249,
	[BNXT_ULP_CLASS_HID_0280] = 250,
	[BNXT_ULP_CLASS_HID_0664] = 251,
	[BNXT_ULP_CLASS_HID_16a0] = 252,
	[BNXT_ULP_CLASS_HID_09d4] = 253,
	[BNXT_ULP_CLASS_HID_1df4] = 254,
	[BNXT_ULP_CLASS_HID_80ecc] = 255,
	[BNXT_ULP_CLASS_HID_80302] = 256,
	[BNXT_ULP_CLASS_HID_40c48] = 257,
	[BNXT_ULP_CLASS_HID_4008e] = 258,
	[BNXT_ULP_CLASS_HID_c1140] = 259,
	[BNXT_ULP_CLASS_HID_c0586] = 260,
	[BNXT_ULP_CLASS_HID_804e1] = 261,
	[BNXT_ULP_CLASS_HID_81241] = 262,
	[BNXT_ULP_CLASS_HID_80ef1] = 263,
	[BNXT_ULP_CLASS_HID_81c51] = 264,
	[BNXT_ULP_CLASS_HID_c076d] = 265,
	[BNXT_ULP_CLASS_HID_c14cd] = 266,
	[BNXT_ULP_CLASS_HID_c117d] = 267,
	[BNXT_ULP_CLASS_HID_c1edd] = 268,
	[BNXT_ULP_CLASS_HID_a062f] = 269,
	[BNXT_ULP_CLASS_HID_a138f] = 270,
	[BNXT_ULP_CLASS_HID_a103f] = 271,
	[BNXT_ULP_CLASS_HID_a1d9f] = 272,
	[BNXT_ULP_CLASS_HID_e08ab] = 273,
	[BNXT_ULP_CLASS_HID_e160b] = 274,
	[BNXT_ULP_CLASS_HID_e12bb] = 275,
	[BNXT_ULP_CLASS_HID_e0079] = 276,
	[BNXT_ULP_CLASS_HID_2012b] = 277,
	[BNXT_ULP_CLASS_HID_20e8b] = 278,
	[BNXT_ULP_CLASS_HID_603af] = 279,
	[BNXT_ULP_CLASS_HID_6110f] = 280,
	[BNXT_ULP_CLASS_HID_311bb] = 281,
	[BNXT_ULP_CLASS_HID_31f1b] = 282,
	[BNXT_ULP_CLASS_HID_7143f] = 283,
	[BNXT_ULP_CLASS_HID_701fd] = 284,
	[BNXT_ULP_CLASS_HID_28963] = 285,
	[BNXT_ULP_CLASS_HID_296c3] = 286,
	[BNXT_ULP_CLASS_HID_68be7] = 287,
	[BNXT_ULP_CLASS_HID_69947] = 288,
	[BNXT_ULP_CLASS_HID_399f3] = 289,
	[BNXT_ULP_CLASS_HID_387b1] = 290,
	[BNXT_ULP_CLASS_HID_79c77] = 291,
	[BNXT_ULP_CLASS_HID_78a35] = 292,
	[BNXT_ULP_CLASS_HID_804d1] = 293,
	[BNXT_ULP_CLASS_HID_81271] = 294,
	[BNXT_ULP_CLASS_HID_80ec1] = 295,
	[BNXT_ULP_CLASS_HID_81c61] = 296,
	[BNXT_ULP_CLASS_HID_c075d] = 297,
	[BNXT_ULP_CLASS_HID_c14fd] = 298,
	[BNXT_ULP_CLASS_HID_c114d] = 299,
	[BNXT_ULP_CLASS_HID_c1eed] = 300,
	[BNXT_ULP_CLASS_HID_a061f] = 301,
	[BNXT_ULP_CLASS_HID_a13bf] = 302,
	[BNXT_ULP_CLASS_HID_a100f] = 303,
	[BNXT_ULP_CLASS_HID_a1daf] = 304,
	[BNXT_ULP_CLASS_HID_e089b] = 305,
	[BNXT_ULP_CLASS_HID_e163b] = 306,
	[BNXT_ULP_CLASS_HID_e128b] = 307,
	[BNXT_ULP_CLASS_HID_e0049] = 308,
	[BNXT_ULP_CLASS_HID_2011b] = 309,
	[BNXT_ULP_CLASS_HID_20ebb] = 310,
	[BNXT_ULP_CLASS_HID_6039f] = 311,
	[BNXT_ULP_CLASS_HID_6113f] = 312,
	[BNXT_ULP_CLASS_HID_3118b] = 313,
	[BNXT_ULP_CLASS_HID_31f2b] = 314,
	[BNXT_ULP_CLASS_HID_7140f] = 315,
	[BNXT_ULP_CLASS_HID_701cd] = 316,
	[BNXT_ULP_CLASS_HID_28953] = 317,
	[BNXT_ULP_CLASS_HID_296f3] = 318,
	[BNXT_ULP_CLASS_HID_68bd7] = 319,
	[BNXT_ULP_CLASS_HID_69977] = 320,
	[BNXT_ULP_CLASS_HID_399c3] = 321,
	[BNXT_ULP_CLASS_HID_38781] = 322,
	[BNXT_ULP_CLASS_HID_79c47] = 323,
	[BNXT_ULP_CLASS_HID_78a05] = 324,
	[BNXT_ULP_CLASS_HID_04a4] = 325,
	[BNXT_ULP_CLASS_HID_04a8] = 326,
	[BNXT_ULP_CLASS_HID_04a5] = 327,
	[BNXT_ULP_CLASS_HID_1205] = 328,
	[BNXT_ULP_CLASS_HID_04a9] = 329,
	[BNXT_ULP_CLASS_HID_1209] = 330,
	[BNXT_ULP_CLASS_HID_04b4] = 331,
	[BNXT_ULP_CLASS_HID_04b8] = 332,
	[BNXT_ULP_CLASS_HID_0484] = 333,
	[BNXT_ULP_CLASS_HID_0488] = 334,
	[BNXT_ULP_CLASS_HID_04b5] = 335,
	[BNXT_ULP_CLASS_HID_1215] = 336,
	[BNXT_ULP_CLASS_HID_04b9] = 337,
	[BNXT_ULP_CLASS_HID_1219] = 338,
	[BNXT_ULP_CLASS_HID_0485] = 339,
	[BNXT_ULP_CLASS_HID_1225] = 340,
	[BNXT_ULP_CLASS_HID_0489] = 341,
	[BNXT_ULP_CLASS_HID_1229] = 342,
	[BNXT_ULP_CLASS_HID_0226] = 343,
	[BNXT_ULP_CLASS_HID_4045a] = 344,
	[BNXT_ULP_CLASS_HID_0daa] = 345,
	[BNXT_ULP_CLASS_HID_11b0] = 346,
	[BNXT_ULP_CLASS_HID_403f8] = 347,
	[BNXT_ULP_CLASS_HID_4161e] = 348,
	[BNXT_ULP_CLASS_HID_40439] = 349,
	[BNXT_ULP_CLASS_HID_41405] = 350,
	[BNXT_ULP_CLASS_HID_51449] = 351,
	[BNXT_ULP_CLASS_HID_50b33] = 352,
	[BNXT_ULP_CLASS_HID_48c01] = 353,
	[BNXT_ULP_CLASS_HID_483eb] = 354,
	[BNXT_ULP_CLASS_HID_5833f] = 355,
	[BNXT_ULP_CLASS_HID_5937b] = 356,
	[BNXT_ULP_CLASS_HID_41875] = 357,
	[BNXT_ULP_CLASS_HID_40f5f] = 358,
	[BNXT_ULP_CLASS_HID_50f23] = 359,
	[BNXT_ULP_CLASS_HID_51f6f] = 360,
	[BNXT_ULP_CLASS_HID_4875b] = 361,
	[BNXT_ULP_CLASS_HID_49727] = 362,
	[BNXT_ULP_CLASS_HID_5976b] = 363,
	[BNXT_ULP_CLASS_HID_58655] = 364,
	[BNXT_ULP_CLASS_HID_4125f] = 365,
	[BNXT_ULP_CLASS_HID_401f9] = 366,
	[BNXT_ULP_CLASS_HID_501cd] = 367,
	[BNXT_ULP_CLASS_HID_51149] = 368,
	[BNXT_ULP_CLASS_HID_49a67] = 369,
	[BNXT_ULP_CLASS_HID_489c1] = 370,
	[BNXT_ULP_CLASS_HID_58955] = 371,
	[BNXT_ULP_CLASS_HID_59951] = 372,
	[BNXT_ULP_CLASS_HID_40569] = 373,
	[BNXT_ULP_CLASS_HID_41575] = 374,
	[BNXT_ULP_CLASS_HID_51579] = 375,
	[BNXT_ULP_CLASS_HID_50463] = 376,
	[BNXT_ULP_CLASS_HID_48d71] = 377,
	[BNXT_ULP_CLASS_HID_49d7d] = 378,
	[BNXT_ULP_CLASS_HID_59d41] = 379,
	[BNXT_ULP_CLASS_HID_58c6b] = 380,
	[BNXT_ULP_CLASS_HID_10255] = 381,
	[BNXT_ULP_CLASS_HID_11675] = 382,
	[BNXT_ULP_CLASS_HID_14649] = 383,
	[BNXT_ULP_CLASS_HID_15a69] = 384,
	[BNXT_ULP_CLASS_HID_1205b] = 385,
	[BNXT_ULP_CLASS_HID_1347b] = 386,
	[BNXT_ULP_CLASS_HID_16bbf] = 387,
	[BNXT_ULP_CLASS_HID_1785f] = 388,
	[BNXT_ULP_CLASS_HID_11551] = 389,
	[BNXT_ULP_CLASS_HID_10897] = 390,
	[BNXT_ULP_CLASS_HID_15955] = 391,
	[BNXT_ULP_CLASS_HID_14c8b] = 392,
	[BNXT_ULP_CLASS_HID_13b47] = 393,
	[BNXT_ULP_CLASS_HID_12e85] = 394,
	[BNXT_ULP_CLASS_HID_17f5b] = 395,
	[BNXT_ULP_CLASS_HID_17299] = 396,
	[BNXT_ULP_CLASS_HID_10fe7] = 397,
	[BNXT_ULP_CLASS_HID_10325] = 398,
	[BNXT_ULP_CLASS_HID_153cb] = 399,
	[BNXT_ULP_CLASS_HID_14709] = 400,
	[BNXT_ULP_CLASS_HID_12dc5] = 401,
	[BNXT_ULP_CLASS_HID_1212b] = 402,
	[BNXT_ULP_CLASS_HID_171c9] = 403,
	[BNXT_ULP_CLASS_HID_1650f] = 404,
	[BNXT_ULP_CLASS_HID_10201] = 405,
	[BNXT_ULP_CLASS_HID_116c1] = 406,
	[BNXT_ULP_CLASS_HID_14605] = 407,
	[BNXT_ULP_CLASS_HID_15a05] = 408,
	[BNXT_ULP_CLASS_HID_12007] = 409,
	[BNXT_ULP_CLASS_HID_13407] = 410,
	[BNXT_ULP_CLASS_HID_1640b] = 411,
	[BNXT_ULP_CLASS_HID_1780b] = 412,
	[BNXT_ULP_CLASS_HID_404b0] = 413,
	[BNXT_ULP_CLASS_HID_4148c] = 414,
	[BNXT_ULP_CLASS_HID_514c0] = 415,
	[BNXT_ULP_CLASS_HID_50bba] = 416,
	[BNXT_ULP_CLASS_HID_48c88] = 417,
	[BNXT_ULP_CLASS_HID_48362] = 418,
	[BNXT_ULP_CLASS_HID_583b6] = 419,
	[BNXT_ULP_CLASS_HID_593f2] = 420,
	[BNXT_ULP_CLASS_HID_41f54] = 421,
	[BNXT_ULP_CLASS_HID_40fce] = 422,
	[BNXT_ULP_CLASS_HID_50e02] = 423,
	[BNXT_ULP_CLASS_HID_51e5e] = 424,
	[BNXT_ULP_CLASS_HID_487ca] = 425,
	[BNXT_ULP_CLASS_HID_49606] = 426,
	[BNXT_ULP_CLASS_HID_5965a] = 427,
	[BNXT_ULP_CLASS_HID_58514] = 428,
	[BNXT_ULP_CLASS_HID_412c2] = 429,
	[BNXT_ULP_CLASS_HID_401ac] = 430,
	[BNXT_ULP_CLASS_HID_501e0] = 431,
	[BNXT_ULP_CLASS_HID_511cc] = 432,
	[BNXT_ULP_CLASS_HID_4990a] = 433,
	[BNXT_ULP_CLASS_HID_489e4] = 434,
	[BNXT_ULP_CLASS_HID_589c8] = 435,
	[BNXT_ULP_CLASS_HID_59804] = 436,
	[BNXT_ULP_CLASS_HID_40404] = 437,
	[BNXT_ULP_CLASS_HID_41440] = 438,
	[BNXT_ULP_CLASS_HID_51484] = 439,
	[BNXT_ULP_CLASS_HID_50b0e] = 440,
	[BNXT_ULP_CLASS_HID_48c4c] = 441,
	[BNXT_ULP_CLASS_HID_48306] = 442,
	[BNXT_ULP_CLASS_HID_5830a] = 443,
	[BNXT_ULP_CLASS_HID_59346] = 444,
	[BNXT_ULP_CLASS_HID_102cc] = 445,
	[BNXT_ULP_CLASS_HID_116ec] = 446,
	[BNXT_ULP_CLASS_HID_146d0] = 447,
	[BNXT_ULP_CLASS_HID_15af0] = 448,
	[BNXT_ULP_CLASS_HID_120c2] = 449,
	[BNXT_ULP_CLASS_HID_134e2] = 450,
	[BNXT_ULP_CLASS_HID_16b26] = 451,
	[BNXT_ULP_CLASS_HID_178c6] = 452,
	[BNXT_ULP_CLASS_HID_115c6] = 453,
	[BNXT_ULP_CLASS_HID_10804] = 454,
	[BNXT_ULP_CLASS_HID_15822] = 455,
	[BNXT_ULP_CLASS_HID_14c60] = 456,
	[BNXT_ULP_CLASS_HID_13bd4] = 457,
	[BNXT_ULP_CLASS_HID_12e12] = 458,
	[BNXT_ULP_CLASS_HID_17e30] = 459,
	[BNXT_ULP_CLASS_HID_17276] = 460,
	[BNXT_ULP_CLASS_HID_11f1a] = 461,
	[BNXT_ULP_CLASS_HID_11358] = 462,
	[BNXT_ULP_CLASS_HID_14398] = 463,
	[BNXT_ULP_CLASS_HID_157b8] = 464,
	[BNXT_ULP_CLASS_HID_13d68] = 465,
	[BNXT_ULP_CLASS_HID_131aa] = 466,
	[BNXT_ULP_CLASS_HID_16192] = 467,
	[BNXT_ULP_CLASS_HID_175b2] = 468,
	[BNXT_ULP_CLASS_HID_112b2] = 469,
	[BNXT_ULP_CLASS_HID_106f0] = 470,
	[BNXT_ULP_CLASS_HID_15692] = 471,
	[BNXT_ULP_CLASS_HID_14ad0] = 472,
	[BNXT_ULP_CLASS_HID_13080] = 473,
	[BNXT_ULP_CLASS_HID_124c2] = 474,
	[BNXT_ULP_CLASS_HID_174e0] = 475,
	[BNXT_ULP_CLASS_HID_16f22] = 476,
	[BNXT_ULP_CLASS_HID_4025b] = 477,
	[BNXT_ULP_CLASS_HID_41267] = 478,
	[BNXT_ULP_CLASS_HID_5122b] = 479,
	[BNXT_ULP_CLASS_HID_50d51] = 480,
	[BNXT_ULP_CLASS_HID_48a63] = 481,
	[BNXT_ULP_CLASS_HID_48589] = 482,
	[BNXT_ULP_CLASS_HID_5855d] = 483,
	[BNXT_ULP_CLASS_HID_59519] = 484,
	[BNXT_ULP_CLASS_HID_41e17] = 485,
	[BNXT_ULP_CLASS_HID_4093d] = 486,
	[BNXT_ULP_CLASS_HID_50941] = 487,
	[BNXT_ULP_CLASS_HID_5190d] = 488,
	[BNXT_ULP_CLASS_HID_48139] = 489,
	[BNXT_ULP_CLASS_HID_49145] = 490,
	[BNXT_ULP_CLASS_HID_59109] = 491,
	[BNXT_ULP_CLASS_HID_58037] = 492,
	[BNXT_ULP_CLASS_HID_4143d] = 493,
	[BNXT_ULP_CLASS_HID_4079b] = 494,
	[BNXT_ULP_CLASS_HID_507af] = 495,
	[BNXT_ULP_CLASS_HID_5172b] = 496,
	[BNXT_ULP_CLASS_HID_49c05] = 497,
	[BNXT_ULP_CLASS_HID_48fa3] = 498,
	[BNXT_ULP_CLASS_HID_58f37] = 499,
	[BNXT_ULP_CLASS_HID_59f33] = 500,
	[BNXT_ULP_CLASS_HID_4030b] = 501,
	[BNXT_ULP_CLASS_HID_41317] = 502,
	[BNXT_ULP_CLASS_HID_5131b] = 503,
	[BNXT_ULP_CLASS_HID_50201] = 504,
	[BNXT_ULP_CLASS_HID_48b13] = 505,
	[BNXT_ULP_CLASS_HID_49b1f] = 506,
	[BNXT_ULP_CLASS_HID_59b23] = 507,
	[BNXT_ULP_CLASS_HID_58a09] = 508,
	[BNXT_ULP_CLASS_HID_419bf] = 509,
	[BNXT_ULP_CLASS_HID_40925] = 510,
	[BNXT_ULP_CLASS_HID_508e9] = 511,
	[BNXT_ULP_CLASS_HID_518b5] = 512,
	[BNXT_ULP_CLASS_HID_48121] = 513,
	[BNXT_ULP_CLASS_HID_490ed] = 514,
	[BNXT_ULP_CLASS_HID_590b1] = 515,
	[BNXT_ULP_CLASS_HID_583ff] = 516,
	[BNXT_ULP_CLASS_HID_41475] = 517,
	[BNXT_ULP_CLASS_HID_40473] = 518,
	[BNXT_ULP_CLASS_HID_50427] = 519,
	[BNXT_ULP_CLASS_HID_51763] = 520,
	[BNXT_ULP_CLASS_HID_49c3d] = 521,
	[BNXT_ULP_CLASS_HID_48c3b] = 522,
	[BNXT_ULP_CLASS_HID_58f6f] = 523,
	[BNXT_ULP_CLASS_HID_59f2b] = 524,
	[BNXT_ULP_CLASS_HID_40333] = 525,
	[BNXT_ULP_CLASS_HID_412bf] = 526,
	[BNXT_ULP_CLASS_HID_512a3] = 527,
	[BNXT_ULP_CLASS_HID_50229] = 528,
	[BNXT_ULP_CLASS_HID_48abb] = 529,
	[BNXT_ULP_CLASS_HID_49aa7] = 530,
	[BNXT_ULP_CLASS_HID_59a2b] = 531,
	[BNXT_ULP_CLASS_HID_595b1] = 532,
	[BNXT_ULP_CLASS_HID_41e2f] = 533,
	[BNXT_ULP_CLASS_HID_40e35] = 534,
	[BNXT_ULP_CLASS_HID_50939] = 535,
	[BNXT_ULP_CLASS_HID_51925] = 536,
	[BNXT_ULP_CLASS_HID_48631] = 537,
	[BNXT_ULP_CLASS_HID_4913d] = 538,
	[BNXT_ULP_CLASS_HID_59121] = 539,
	[BNXT_ULP_CLASS_HID_5812f] = 540,
	[BNXT_ULP_CLASS_HID_41429] = 541,
	[BNXT_ULP_CLASS_HID_40747] = 542,
	[BNXT_ULP_CLASS_HID_5070b] = 543,
	[BNXT_ULP_CLASS_HID_51727] = 544,
	[BNXT_ULP_CLASS_HID_49fe1] = 545,
	[BNXT_ULP_CLASS_HID_48f0f] = 546,
	[BNXT_ULP_CLASS_HID_58f23] = 547,
	[BNXT_ULP_CLASS_HID_59eef] = 548,
	[BNXT_ULP_CLASS_HID_40347] = 549,
	[BNXT_ULP_CLASS_HID_41303] = 550,
	[BNXT_ULP_CLASS_HID_51247] = 551,
	[BNXT_ULP_CLASS_HID_5026d] = 552,
	[BNXT_ULP_CLASS_HID_48b0f] = 553,
	[BNXT_ULP_CLASS_HID_49a4b] = 554,
	[BNXT_ULP_CLASS_HID_59a0f] = 555,
	[BNXT_ULP_CLASS_HID_58a05] = 556,
	[BNXT_ULP_CLASS_HID_41983] = 557,
	[BNXT_ULP_CLASS_HID_40929] = 558,
	[BNXT_ULP_CLASS_HID_5092d] = 559,
	[BNXT_ULP_CLASS_HID_518a9] = 560,
	[BNXT_ULP_CLASS_HID_48125] = 561,
	[BNXT_ULP_CLASS_HID_49121] = 562,
	[BNXT_ULP_CLASS_HID_59085] = 563,
	[BNXT_ULP_CLASS_HID_58023] = 564,
	[BNXT_ULP_CLASS_HID_41509] = 565,
	[BNXT_ULP_CLASS_HID_40407] = 566,
	[BNXT_ULP_CLASS_HID_5040b] = 567,
	[BNXT_ULP_CLASS_HID_51407] = 568,
	[BNXT_ULP_CLASS_HID_49d21] = 569,
	[BNXT_ULP_CLASS_HID_48c0f] = 570,
	[BNXT_ULP_CLASS_HID_58c03] = 571,
	[BNXT_ULP_CLASS_HID_59f0f] = 572,
	[BNXT_ULP_CLASS_HID_402ef] = 573,
	[BNXT_ULP_CLASS_HID_412ab] = 574,
	[BNXT_ULP_CLASS_HID_5126f] = 575,
	[BNXT_ULP_CLASS_HID_50de5] = 576,
	[BNXT_ULP_CLASS_HID_48aa7] = 577,
	[BNXT_ULP_CLASS_HID_485ed] = 578,
	[BNXT_ULP_CLASS_HID_585e1] = 579,
	[BNXT_ULP_CLASS_HID_595ad] = 580,
	[BNXT_ULP_CLASS_HID_41e6b] = 581,
	[BNXT_ULP_CLASS_HID_40961] = 582,
	[BNXT_ULP_CLASS_HID_50925] = 583,
	[BNXT_ULP_CLASS_HID_51961] = 584,
	[BNXT_ULP_CLASS_HID_4816d] = 585,
	[BNXT_ULP_CLASS_HID_49129] = 586,
	[BNXT_ULP_CLASS_HID_5916d] = 587,
	[BNXT_ULP_CLASS_HID_5806b] = 588,
	[BNXT_ULP_CLASS_HID_414a1] = 589,
	[BNXT_ULP_CLASS_HID_4042f] = 590,
	[BNXT_ULP_CLASS_HID_507a3] = 591,
	[BNXT_ULP_CLASS_HID_517af] = 592,
	[BNXT_ULP_CLASS_HID_49c29] = 593,
	[BNXT_ULP_CLASS_HID_48fa7] = 594,
	[BNXT_ULP_CLASS_HID_58fab] = 595,
	[BNXT_ULP_CLASS_HID_59f27] = 596,
	[BNXT_ULP_CLASS_HID_4032f] = 597,
	[BNXT_ULP_CLASS_HID_4132b] = 598,
	[BNXT_ULP_CLASS_HID_5132f] = 599,
	[BNXT_ULP_CLASS_HID_50225] = 600,
	[BNXT_ULP_CLASS_HID_48b27] = 601,
	[BNXT_ULP_CLASS_HID_49b23] = 602,
	[BNXT_ULP_CLASS_HID_59b27] = 603,
	[BNXT_ULP_CLASS_HID_58a2d] = 604,
	[BNXT_ULP_CLASS_HID_10437] = 605,
	[BNXT_ULP_CLASS_HID_11017] = 606,
	[BNXT_ULP_CLASS_HID_1402b] = 607,
	[BNXT_ULP_CLASS_HID_15c0b] = 608,
	[BNXT_ULP_CLASS_HID_12639] = 609,
	[BNXT_ULP_CLASS_HID_13219] = 610,
	[BNXT_ULP_CLASS_HID_16ddd] = 611,
	[BNXT_ULP_CLASS_HID_17e3d] = 612,
	[BNXT_ULP_CLASS_HID_11333] = 613,
	[BNXT_ULP_CLASS_HID_10ef5] = 614,
	[BNXT_ULP_CLASS_HID_15f37] = 615,
	[BNXT_ULP_CLASS_HID_14ae9] = 616,
	[BNXT_ULP_CLASS_HID_13d25] = 617,
	[BNXT_ULP_CLASS_HID_128e7] = 618,
	[BNXT_ULP_CLASS_HID_17939] = 619,
	[BNXT_ULP_CLASS_HID_174fb] = 620,
	[BNXT_ULP_CLASS_HID_10985] = 621,
	[BNXT_ULP_CLASS_HID_10547] = 622,
	[BNXT_ULP_CLASS_HID_155a9] = 623,
	[BNXT_ULP_CLASS_HID_1416b] = 624,
	[BNXT_ULP_CLASS_HID_12ba7] = 625,
	[BNXT_ULP_CLASS_HID_12749] = 626,
	[BNXT_ULP_CLASS_HID_177ab] = 627,
	[BNXT_ULP_CLASS_HID_1636d] = 628,
	[BNXT_ULP_CLASS_HID_10463] = 629,
	[BNXT_ULP_CLASS_HID_110a3] = 630,
	[BNXT_ULP_CLASS_HID_14067] = 631,
	[BNXT_ULP_CLASS_HID_15c67] = 632,
	[BNXT_ULP_CLASS_HID_12665] = 633,
	[BNXT_ULP_CLASS_HID_13265] = 634,
	[BNXT_ULP_CLASS_HID_16269] = 635,
	[BNXT_ULP_CLASS_HID_17e69] = 636,
	[BNXT_ULP_CLASS_HID_1133d] = 637,
	[BNXT_ULP_CLASS_HID_10eff] = 638,
	[BNXT_ULP_CLASS_HID_15ed9] = 639,
	[BNXT_ULP_CLASS_HID_14a9b] = 640,
	[BNXT_ULP_CLASS_HID_13d2f] = 641,
	[BNXT_ULP_CLASS_HID_128e9] = 642,
	[BNXT_ULP_CLASS_HID_178cb] = 643,
	[BNXT_ULP_CLASS_HID_1748d] = 644,
	[BNXT_ULP_CLASS_HID_109fb] = 645,
	[BNXT_ULP_CLASS_HID_105bd] = 646,
	[BNXT_ULP_CLASS_HID_155bf] = 647,
	[BNXT_ULP_CLASS_HID_14179] = 648,
	[BNXT_ULP_CLASS_HID_12bed] = 649,
	[BNXT_ULP_CLASS_HID_127af] = 650,
	[BNXT_ULP_CLASS_HID_177a9] = 651,
	[BNXT_ULP_CLASS_HID_1636b] = 652,
	[BNXT_ULP_CLASS_HID_1046d] = 653,
	[BNXT_ULP_CLASS_HID_1104d] = 654,
	[BNXT_ULP_CLASS_HID_14009] = 655,
	[BNXT_ULP_CLASS_HID_15c69] = 656,
	[BNXT_ULP_CLASS_HID_1260f] = 657,
	[BNXT_ULP_CLASS_HID_1326f] = 658,
	[BNXT_ULP_CLASS_HID_1622b] = 659,
	[BNXT_ULP_CLASS_HID_17e0b] = 660,
	[BNXT_ULP_CLASS_HID_11369] = 661,
	[BNXT_ULP_CLASS_HID_10f2b] = 662,
	[BNXT_ULP_CLASS_HID_15f6d] = 663,
	[BNXT_ULP_CLASS_HID_14b2f] = 664,
	[BNXT_ULP_CLASS_HID_13d6b] = 665,
	[BNXT_ULP_CLASS_HID_1292d] = 666,
	[BNXT_ULP_CLASS_HID_1792f] = 667,
	[BNXT_ULP_CLASS_HID_174e9] = 668,
	[BNXT_ULP_CLASS_HID_119e1] = 669,
	[BNXT_ULP_CLASS_HID_115a3] = 670,
	[BNXT_ULP_CLASS_HID_14563] = 671,
	[BNXT_ULP_CLASS_HID_15143] = 672,
	[BNXT_ULP_CLASS_HID_13b93] = 673,
	[BNXT_ULP_CLASS_HID_13751] = 674,
	[BNXT_ULP_CLASS_HID_16769] = 675,
	[BNXT_ULP_CLASS_HID_17349] = 676,
	[BNXT_ULP_CLASS_HID_114ab] = 677,
	[BNXT_ULP_CLASS_HID_10061] = 678,
	[BNXT_ULP_CLASS_HID_15063] = 679,
	[BNXT_ULP_CLASS_HID_14c21] = 680,
	[BNXT_ULP_CLASS_HID_13671] = 681,
	[BNXT_ULP_CLASS_HID_12233] = 682,
	[BNXT_ULP_CLASS_HID_17271] = 683,
	[BNXT_ULP_CLASS_HID_16e33] = 684,
	[BNXT_ULP_CLASS_HID_102c1] = 685,
	[BNXT_ULP_CLASS_HID_11f21] = 686,
	[BNXT_ULP_CLASS_HID_14ee1] = 687,
	[BNXT_ULP_CLASS_HID_15ac1] = 688,
	[BNXT_ULP_CLASS_HID_12cc3] = 689,
	[BNXT_ULP_CLASS_HID_13923] = 690,
	[BNXT_ULP_CLASS_HID_168e3] = 691,
	[BNXT_ULP_CLASS_HID_164a9] = 692,
	[BNXT_ULP_CLASS_HID_11e29] = 693,
	[BNXT_ULP_CLASS_HID_115eb] = 694,
	[BNXT_ULP_CLASS_HID_145a3] = 695,
	[BNXT_ULP_CLASS_HID_151a3] = 696,
	[BNXT_ULP_CLASS_HID_1382b] = 697,
	[BNXT_ULP_CLASS_HID_137e1] = 698,
	[BNXT_ULP_CLASS_HID_167a1] = 699,
	[BNXT_ULP_CLASS_HID_173a1] = 700,
	[BNXT_ULP_CLASS_HID_11449] = 701,
	[BNXT_ULP_CLASS_HID_1000b] = 702,
	[BNXT_ULP_CLASS_HID_15069] = 703,
	[BNXT_ULP_CLASS_HID_14c2b] = 704,
	[BNXT_ULP_CLASS_HID_1367b] = 705,
	[BNXT_ULP_CLASS_HID_12239] = 706,
	[BNXT_ULP_CLASS_HID_1721b] = 707,
	[BNXT_ULP_CLASS_HID_169d9] = 708,
	[BNXT_ULP_CLASS_HID_1033b] = 709,
	[BNXT_ULP_CLASS_HID_11f3b] = 710,
	[BNXT_ULP_CLASS_HID_14f2b] = 711,
	[BNXT_ULP_CLASS_HID_15b2b] = 712,
	[BNXT_ULP_CLASS_HID_12d39] = 713,
	[BNXT_ULP_CLASS_HID_13939] = 714,
	[BNXT_ULP_CLASS_HID_168f9] = 715,
	[BNXT_ULP_CLASS_HID_164bb] = 716,
	[BNXT_ULP_CLASS_HID_119cb] = 717,
	[BNXT_ULP_CLASS_HID_11589] = 718,
	[BNXT_ULP_CLASS_HID_14549] = 719,
	[BNXT_ULP_CLASS_HID_151a9] = 720,
	[BNXT_ULP_CLASS_HID_13bc9] = 721,
	[BNXT_ULP_CLASS_HID_1378b] = 722,
	[BNXT_ULP_CLASS_HID_1674b] = 723,
	[BNXT_ULP_CLASS_HID_173ab] = 724,
	[BNXT_ULP_CLASS_HID_114a9] = 725,
	[BNXT_ULP_CLASS_HID_1006b] = 726,
	[BNXT_ULP_CLASS_HID_150a9] = 727,
	[BNXT_ULP_CLASS_HID_14c6b] = 728,
	[BNXT_ULP_CLASS_HID_136ab] = 729,
	[BNXT_ULP_CLASS_HID_12269] = 730,
	[BNXT_ULP_CLASS_HID_172ab] = 731,
	[BNXT_ULP_CLASS_HID_16e69] = 732,
	[BNXT_ULP_CLASS_HID_402d2] = 733,
	[BNXT_ULP_CLASS_HID_412ee] = 734,
	[BNXT_ULP_CLASS_HID_512a2] = 735,
	[BNXT_ULP_CLASS_HID_50dd8] = 736,
	[BNXT_ULP_CLASS_HID_48aea] = 737,
	[BNXT_ULP_CLASS_HID_48500] = 738,
	[BNXT_ULP_CLASS_HID_585d4] = 739,
	[BNXT_ULP_CLASS_HID_59590] = 740,
	[BNXT_ULP_CLASS_HID_41936] = 741,
	[BNXT_ULP_CLASS_HID_409ac] = 742,
	[BNXT_ULP_CLASS_HID_50860] = 743,
	[BNXT_ULP_CLASS_HID_5183c] = 744,
	[BNXT_ULP_CLASS_HID_481a8] = 745,
	[BNXT_ULP_CLASS_HID_49064] = 746,
	[BNXT_ULP_CLASS_HID_59038] = 747,
	[BNXT_ULP_CLASS_HID_58376] = 748,
	[BNXT_ULP_CLASS_HID_414a0] = 749,
	[BNXT_ULP_CLASS_HID_407ce] = 750,
	[BNXT_ULP_CLASS_HID_50782] = 751,
	[BNXT_ULP_CLASS_HID_517ae] = 752,
	[BNXT_ULP_CLASS_HID_49f68] = 753,
	[BNXT_ULP_CLASS_HID_48f86] = 754,
	[BNXT_ULP_CLASS_HID_58faa] = 755,
	[BNXT_ULP_CLASS_HID_59e66] = 756,
	[BNXT_ULP_CLASS_HID_40266] = 757,
	[BNXT_ULP_CLASS_HID_41222] = 758,
	[BNXT_ULP_CLASS_HID_512e6] = 759,
	[BNXT_ULP_CLASS_HID_50d6c] = 760,
	[BNXT_ULP_CLASS_HID_48a2e] = 761,
	[BNXT_ULP_CLASS_HID_48564] = 762,
	[BNXT_ULP_CLASS_HID_58568] = 763,
	[BNXT_ULP_CLASS_HID_59524] = 764,
	[BNXT_ULP_CLASS_HID_419d8] = 765,
	[BNXT_ULP_CLASS_HID_4087e] = 766,
	[BNXT_ULP_CLASS_HID_5080a] = 767,
	[BNXT_ULP_CLASS_HID_518ce] = 768,
	[BNXT_ULP_CLASS_HID_4807a] = 769,
	[BNXT_ULP_CLASS_HID_4900e] = 770,
	[BNXT_ULP_CLASS_HID_590ca] = 771,
	[BNXT_ULP_CLASS_HID_58378] = 772,
	[BNXT_ULP_CLASS_HID_414be] = 773,
	[BNXT_ULP_CLASS_HID_4073c] = 774,
	[BNXT_ULP_CLASS_HID_507e8] = 775,
	[BNXT_ULP_CLASS_HID_517ac] = 776,
	[BNXT_ULP_CLASS_HID_49f7e] = 777,
	[BNXT_ULP_CLASS_HID_48fec] = 778,
	[BNXT_ULP_CLASS_HID_58fa8] = 779,
	[BNXT_ULP_CLASS_HID_59e7c] = 780,
	[BNXT_ULP_CLASS_HID_40208] = 781,
	[BNXT_ULP_CLASS_HID_412cc] = 782,
	[BNXT_ULP_CLASS_HID_51288] = 783,
	[BNXT_ULP_CLASS_HID_50d2e] = 784,
	[BNXT_ULP_CLASS_HID_48ac8] = 785,
	[BNXT_ULP_CLASS_HID_4856e] = 786,
	[BNXT_ULP_CLASS_HID_5852a] = 787,
	[BNXT_ULP_CLASS_HID_595ce] = 788,
	[BNXT_ULP_CLASS_HID_4196c] = 789,
	[BNXT_ULP_CLASS_HID_409aa] = 790,
	[BNXT_ULP_CLASS_HID_5086e] = 791,
	[BNXT_ULP_CLASS_HID_5182a] = 792,
	[BNXT_ULP_CLASS_HID_481ae] = 793,
	[BNXT_ULP_CLASS_HID_4906a] = 794,
	[BNXT_ULP_CLASS_HID_5902e] = 795,
	[BNXT_ULP_CLASS_HID_580ac] = 796,
	[BNXT_ULP_CLASS_HID_40766] = 797,
	[BNXT_ULP_CLASS_HID_41726] = 798,
	[BNXT_ULP_CLASS_HID_517f6] = 799,
	[BNXT_ULP_CLASS_HID_5066c] = 800,
	[BNXT_ULP_CLASS_HID_48f3e] = 801,
	[BNXT_ULP_CLASS_HID_49ffe] = 802,
	[BNXT_ULP_CLASS_HID_59f8e] = 803,
	[BNXT_ULP_CLASS_HID_58e24] = 804,
	[BNXT_ULP_CLASS_HID_4126e] = 805,
	[BNXT_ULP_CLASS_HID_402e4] = 806,
	[BNXT_ULP_CLASS_HID_502b4] = 807,
	[BNXT_ULP_CLASS_HID_51d74] = 808,
	[BNXT_ULP_CLASS_HID_49a26] = 809,
	[BNXT_ULP_CLASS_HID_48abc] = 810,
	[BNXT_ULP_CLASS_HID_5956c] = 811,
	[BNXT_ULP_CLASS_HID_585ee] = 812,
	[BNXT_ULP_CLASS_HID_409e4] = 813,
	[BNXT_ULP_CLASS_HID_419a4] = 814,
	[BNXT_ULP_CLASS_HID_51844] = 815,
	[BNXT_ULP_CLASS_HID_508e6] = 816,
	[BNXT_ULP_CLASS_HID_4918c] = 817,
	[BNXT_ULP_CLASS_HID_4802e] = 818,
	[BNXT_ULP_CLASS_HID_580ee] = 819,
	[BNXT_ULP_CLASS_HID_590ae] = 820,
	[BNXT_ULP_CLASS_HID_404ae] = 821,
	[BNXT_ULP_CLASS_HID_41766] = 822,
	[BNXT_ULP_CLASS_HID_5172e] = 823,
	[BNXT_ULP_CLASS_HID_507a4] = 824,
	[BNXT_ULP_CLASS_HID_48f66] = 825,
	[BNXT_ULP_CLASS_HID_49f2e] = 826,
	[BNXT_ULP_CLASS_HID_59fe6] = 827,
	[BNXT_ULP_CLASS_HID_58e6c] = 828,
	[BNXT_ULP_CLASS_HID_4126c] = 829,
	[BNXT_ULP_CLASS_HID_4028e] = 830,
	[BNXT_ULP_CLASS_HID_50d5e] = 831,
	[BNXT_ULP_CLASS_HID_51d1e] = 832,
	[BNXT_ULP_CLASS_HID_49a2c] = 833,
	[BNXT_ULP_CLASS_HID_4954e] = 834,
	[BNXT_ULP_CLASS_HID_5951e] = 835,
	[BNXT_ULP_CLASS_HID_5858c] = 836,
	[BNXT_ULP_CLASS_HID_409fe] = 837,
	[BNXT_ULP_CLASS_HID_419ee] = 838,
	[BNXT_ULP_CLASS_HID_519ae] = 839,
	[BNXT_ULP_CLASS_HID_508fc] = 840,
	[BNXT_ULP_CLASS_HID_491ee] = 841,
	[BNXT_ULP_CLASS_HID_4802c] = 842,
	[BNXT_ULP_CLASS_HID_580fc] = 843,
	[BNXT_ULP_CLASS_HID_590bc] = 844,
	[BNXT_ULP_CLASS_HID_4074c] = 845,
	[BNXT_ULP_CLASS_HID_4170c] = 846,
	[BNXT_ULP_CLASS_HID_5172c] = 847,
	[BNXT_ULP_CLASS_HID_5064e] = 848,
	[BNXT_ULP_CLASS_HID_48f0c] = 849,
	[BNXT_ULP_CLASS_HID_49fcc] = 850,
	[BNXT_ULP_CLASS_HID_59fec] = 851,
	[BNXT_ULP_CLASS_HID_58e0e] = 852,
	[BNXT_ULP_CLASS_HID_413ac] = 853,
	[BNXT_ULP_CLASS_HID_402ee] = 854,
	[BNXT_ULP_CLASS_HID_502ae] = 855,
	[BNXT_ULP_CLASS_HID_512ae] = 856,
	[BNXT_ULP_CLASS_HID_49a6c] = 857,
	[BNXT_ULP_CLASS_HID_48aae] = 858,
	[BNXT_ULP_CLASS_HID_58aae] = 859,
	[BNXT_ULP_CLASS_HID_585ec] = 860,
	[BNXT_ULP_CLASS_HID_104ae] = 861,
	[BNXT_ULP_CLASS_HID_1108e] = 862,
	[BNXT_ULP_CLASS_HID_140b2] = 863,
	[BNXT_ULP_CLASS_HID_15c92] = 864,
	[BNXT_ULP_CLASS_HID_126a0] = 865,
	[BNXT_ULP_CLASS_HID_13280] = 866,
	[BNXT_ULP_CLASS_HID_16d44] = 867,
	[BNXT_ULP_CLASS_HID_17ea4] = 868,
	[BNXT_ULP_CLASS_HID_113a4] = 869,
	[BNXT_ULP_CLASS_HID_10e66] = 870,
	[BNXT_ULP_CLASS_HID_15e40] = 871,
	[BNXT_ULP_CLASS_HID_14a02] = 872,
	[BNXT_ULP_CLASS_HID_13db6] = 873,
	[BNXT_ULP_CLASS_HID_12870] = 874,
	[BNXT_ULP_CLASS_HID_17852] = 875,
	[BNXT_ULP_CLASS_HID_17414] = 876,
	[BNXT_ULP_CLASS_HID_11978] = 877,
	[BNXT_ULP_CLASS_HID_1153a] = 878,
	[BNXT_ULP_CLASS_HID_145fa] = 879,
	[BNXT_ULP_CLASS_HID_151da] = 880,
	[BNXT_ULP_CLASS_HID_13b0a] = 881,
	[BNXT_ULP_CLASS_HID_137c8] = 882,
	[BNXT_ULP_CLASS_HID_167f0] = 883,
	[BNXT_ULP_CLASS_HID_173d0] = 884,
	[BNXT_ULP_CLASS_HID_114d0] = 885,
	[BNXT_ULP_CLASS_HID_10092] = 886,
	[BNXT_ULP_CLASS_HID_150f0] = 887,
	[BNXT_ULP_CLASS_HID_14cb2] = 888,
	[BNXT_ULP_CLASS_HID_136e2] = 889,
	[BNXT_ULP_CLASS_HID_122a0] = 890,
	[BNXT_ULP_CLASS_HID_17282] = 891,
	[BNXT_ULP_CLASS_HID_16940] = 892,
	[BNXT_ULP_CLASS_HID_11b90] = 893,
	[BNXT_ULP_CLASS_HID_11654] = 894,
	[BNXT_ULP_CLASS_HID_14618] = 895,
	[BNXT_ULP_CLASS_HID_15278] = 896,
	[BNXT_ULP_CLASS_HID_12404] = 897,
	[BNXT_ULP_CLASS_HID_13064] = 898,
	[BNXT_ULP_CLASS_HID_16028] = 899,
	[BNXT_ULP_CLASS_HID_17c08] = 900,
	[BNXT_ULP_CLASS_HID_11100] = 901,
	[BNXT_ULP_CLASS_HID_10dc4] = 902,
	[BNXT_ULP_CLASS_HID_15d24] = 903,
	[BNXT_ULP_CLASS_HID_149d0] = 904,
	[BNXT_ULP_CLASS_HID_13314] = 905,
	[BNXT_ULP_CLASS_HID_12fd4] = 906,
	[BNXT_ULP_CLASS_HID_17f20] = 907,
	[BNXT_ULP_CLASS_HID_16be0] = 908,
	[BNXT_ULP_CLASS_HID_11cd8] = 909,
	[BNXT_ULP_CLASS_HID_10880] = 910,
	[BNXT_ULP_CLASS_HID_158e0] = 911,
	[BNXT_ULP_CLASS_HID_154a0] = 912,
	[BNXT_ULP_CLASS_HID_13ed0] = 913,
	[BNXT_ULP_CLASS_HID_12a90] = 914,
	[BNXT_ULP_CLASS_HID_16550] = 915,
	[BNXT_ULP_CLASS_HID_176b0] = 916,
	[BNXT_ULP_CLASS_HID_10bb0] = 917,
	[BNXT_ULP_CLASS_HID_10670] = 918,
	[BNXT_ULP_CLASS_HID_15650] = 919,
	[BNXT_ULP_CLASS_HID_14210] = 920,
	[BNXT_ULP_CLASS_HID_13440] = 921,
	[BNXT_ULP_CLASS_HID_12000] = 922,
	[BNXT_ULP_CLASS_HID_17060] = 923,
	[BNXT_ULP_CLASS_HID_16c20] = 924,
	[BNXT_ULP_CLASS_HID_11511] = 925,
	[BNXT_ULP_CLASS_HID_101d3] = 926,
	[BNXT_ULP_CLASS_HID_15135] = 927,
	[BNXT_ULP_CLASS_HID_14df7] = 928,
	[BNXT_ULP_CLASS_HID_13723] = 929,
	[BNXT_ULP_CLASS_HID_123e5] = 930,
	[BNXT_ULP_CLASS_HID_173c7] = 931,
	[BNXT_ULP_CLASS_HID_16f89] = 932,
	[BNXT_ULP_CLASS_HID_10081] = 933,
	[BNXT_ULP_CLASS_HID_11ce1] = 934,
	[BNXT_ULP_CLASS_HID_14ca5] = 935,
	[BNXT_ULP_CLASS_HID_15885] = 936,
	[BNXT_ULP_CLASS_HID_12293] = 937,
	[BNXT_ULP_CLASS_HID_13ef3] = 938,
	[BNXT_ULP_CLASS_HID_16eb7] = 939,
	[BNXT_ULP_CLASS_HID_16561] = 940,
	[BNXT_ULP_CLASS_HID_10e59] = 941,
	[BNXT_ULP_CLASS_HID_11bb9] = 942,
	[BNXT_ULP_CLASS_HID_14a61] = 943,
	[BNXT_ULP_CLASS_HID_14623] = 944,
	[BNXT_ULP_CLASS_HID_1286b] = 945,
	[BNXT_ULP_CLASS_HID_12411] = 946,
	[BNXT_ULP_CLASS_HID_17473] = 947,
	[BNXT_ULP_CLASS_HID_16031] = 948,
	[BNXT_ULP_CLASS_HID_10531] = 949,
	[BNXT_ULP_CLASS_HID_11111] = 950,
	[BNXT_ULP_CLASS_HID_141d1] = 951,
	[BNXT_ULP_CLASS_HID_15d31] = 952,
	[BNXT_ULP_CLASS_HID_127c3] = 953,
	[BNXT_ULP_CLASS_HID_13323] = 954,
	[BNXT_ULP_CLASS_HID_163e3] = 955,
	[BNXT_ULP_CLASS_HID_17fc3] = 956,
	[BNXT_ULP_CLASS_HID_108f5] = 957,
	[BNXT_ULP_CLASS_HID_104b9] = 958,
	[BNXT_ULP_CLASS_HID_15499] = 959,
	[BNXT_ULP_CLASS_HID_1435d] = 960,
	[BNXT_ULP_CLASS_HID_12a89] = 961,
	[BNXT_ULP_CLASS_HID_12149] = 962,
	[BNXT_ULP_CLASS_HID_176ad] = 963,
	[BNXT_ULP_CLASS_HID_16d6d] = 964,
	[BNXT_ULP_CLASS_HID_10665] = 965,
	[BNXT_ULP_CLASS_HID_11245] = 966,
	[BNXT_ULP_CLASS_HID_14271] = 967,
	[BNXT_ULP_CLASS_HID_15e51] = 968,
	[BNXT_ULP_CLASS_HID_12061] = 969,
	[BNXT_ULP_CLASS_HID_13c41] = 970,
	[BNXT_ULP_CLASS_HID_16c05] = 971,
	[BNXT_ULP_CLASS_HID_17865] = 972,
	[BNXT_ULP_CLASS_HID_10d21] = 973,
	[BNXT_ULP_CLASS_HID_11901] = 974,
	[BNXT_ULP_CLASS_HID_149c1] = 975,
	[BNXT_ULP_CLASS_HID_14589] = 976,
	[BNXT_ULP_CLASS_HID_12f31] = 977,
	[BNXT_ULP_CLASS_HID_13b11] = 978,
	[BNXT_ULP_CLASS_HID_16bd9] = 979,
	[BNXT_ULP_CLASS_HID_16799] = 980,
	[BNXT_ULP_CLASS_HID_11831] = 981,
	[BNXT_ULP_CLASS_HID_114f1] = 982,
	[BNXT_ULP_CLASS_HID_144b1] = 983,
	[BNXT_ULP_CLASS_HID_15091] = 984,
	[BNXT_ULP_CLASS_HID_13ac1] = 985,
	[BNXT_ULP_CLASS_HID_13681] = 986,
	[BNXT_ULP_CLASS_HID_166b1] = 987,
	[BNXT_ULP_CLASS_HID_17291] = 988,
	[BNXT_ULP_CLASS_HID_4007d] = 989,
	[BNXT_ULP_CLASS_HID_41041] = 990,
	[BNXT_ULP_CLASS_HID_5100d] = 991,
	[BNXT_ULP_CLASS_HID_50f77] = 992,
	[BNXT_ULP_CLASS_HID_48845] = 993,
	[BNXT_ULP_CLASS_HID_487af] = 994,
	[BNXT_ULP_CLASS_HID_5877b] = 995,
	[BNXT_ULP_CLASS_HID_5973f] = 996,
	[BNXT_ULP_CLASS_HID_41c31] = 997,
	[BNXT_ULP_CLASS_HID_40b1b] = 998,
	[BNXT_ULP_CLASS_HID_50b67] = 999,
	[BNXT_ULP_CLASS_HID_51b2b] = 1000,
	[BNXT_ULP_CLASS_HID_4831f] = 1001,
	[BNXT_ULP_CLASS_HID_49363] = 1002,
	[BNXT_ULP_CLASS_HID_5932f] = 1003,
	[BNXT_ULP_CLASS_HID_58211] = 1004,
	[BNXT_ULP_CLASS_HID_4161b] = 1005,
	[BNXT_ULP_CLASS_HID_405bd] = 1006,
	[BNXT_ULP_CLASS_HID_50589] = 1007,
	[BNXT_ULP_CLASS_HID_5150d] = 1008,
	[BNXT_ULP_CLASS_HID_49e23] = 1009,
	[BNXT_ULP_CLASS_HID_48d85] = 1010,
	[BNXT_ULP_CLASS_HID_58d11] = 1011,
	[BNXT_ULP_CLASS_HID_59d15] = 1012,
	[BNXT_ULP_CLASS_HID_4012d] = 1013,
	[BNXT_ULP_CLASS_HID_41131] = 1014,
	[BNXT_ULP_CLASS_HID_5113d] = 1015,
	[BNXT_ULP_CLASS_HID_50027] = 1016,
	[BNXT_ULP_CLASS_HID_48935] = 1017,
	[BNXT_ULP_CLASS_HID_49939] = 1018,
	[BNXT_ULP_CLASS_HID_59905] = 1019,
	[BNXT_ULP_CLASS_HID_5882f] = 1020,
	[BNXT_ULP_CLASS_HID_41b99] = 1021,
	[BNXT_ULP_CLASS_HID_40b03] = 1022,
	[BNXT_ULP_CLASS_HID_50acf] = 1023,
	[BNXT_ULP_CLASS_HID_51a93] = 1024,
	[BNXT_ULP_CLASS_HID_48307] = 1025,
	[BNXT_ULP_CLASS_HID_492cb] = 1026,
	[BNXT_ULP_CLASS_HID_59297] = 1027,
	[BNXT_ULP_CLASS_HID_581d9] = 1028,
	[BNXT_ULP_CLASS_HID_41653] = 1029,
	[BNXT_ULP_CLASS_HID_40655] = 1030,
	[BNXT_ULP_CLASS_HID_50601] = 1031,
	[BNXT_ULP_CLASS_HID_51545] = 1032,
	[BNXT_ULP_CLASS_HID_49e1b] = 1033,
	[BNXT_ULP_CLASS_HID_48e1d] = 1034,
	[BNXT_ULP_CLASS_HID_58d49] = 1035,
	[BNXT_ULP_CLASS_HID_59d0d] = 1036,
	[BNXT_ULP_CLASS_HID_40115] = 1037,
	[BNXT_ULP_CLASS_HID_41099] = 1038,
	[BNXT_ULP_CLASS_HID_51085] = 1039,
	[BNXT_ULP_CLASS_HID_5000f] = 1040,
	[BNXT_ULP_CLASS_HID_4889d] = 1041,
	[BNXT_ULP_CLASS_HID_49881] = 1042,
	[BNXT_ULP_CLASS_HID_5980d] = 1043,
	[BNXT_ULP_CLASS_HID_59797] = 1044,
	[BNXT_ULP_CLASS_HID_41c09] = 1045,
	[BNXT_ULP_CLASS_HID_40c13] = 1046,
	[BNXT_ULP_CLASS_HID_50b1f] = 1047,
	[BNXT_ULP_CLASS_HID_51b03] = 1048,
	[BNXT_ULP_CLASS_HID_48417] = 1049,
	[BNXT_ULP_CLASS_HID_4931b] = 1050,
	[BNXT_ULP_CLASS_HID_59307] = 1051,
	[BNXT_ULP_CLASS_HID_58309] = 1052,
	[BNXT_ULP_CLASS_HID_4160f] = 1053,
	[BNXT_ULP_CLASS_HID_40561] = 1054,
	[BNXT_ULP_CLASS_HID_5052d] = 1055,
	[BNXT_ULP_CLASS_HID_51501] = 1056,
	[BNXT_ULP_CLASS_HID_49dc7] = 1057,
	[BNXT_ULP_CLASS_HID_48d29] = 1058,
	[BNXT_ULP_CLASS_HID_58d05] = 1059,
	[BNXT_ULP_CLASS_HID_59cc9] = 1060,
	[BNXT_ULP_CLASS_HID_40161] = 1061,
	[BNXT_ULP_CLASS_HID_41125] = 1062,
	[BNXT_ULP_CLASS_HID_51061] = 1063,
	[BNXT_ULP_CLASS_HID_5004b] = 1064,
	[BNXT_ULP_CLASS_HID_48929] = 1065,
	[BNXT_ULP_CLASS_HID_4986d] = 1066,
	[BNXT_ULP_CLASS_HID_59829] = 1067,
	[BNXT_ULP_CLASS_HID_58823] = 1068,
	[BNXT_ULP_CLASS_HID_41ba5] = 1069,
	[BNXT_ULP_CLASS_HID_40b0f] = 1070,
	[BNXT_ULP_CLASS_HID_50b0b] = 1071,
	[BNXT_ULP_CLASS_HID_51a8f] = 1072,
	[BNXT_ULP_CLASS_HID_48303] = 1073,
	[BNXT_ULP_CLASS_HID_49307] = 1074,
	[BNXT_ULP_CLASS_HID_592a3] = 1075,
	[BNXT_ULP_CLASS_HID_58205] = 1076,
	[BNXT_ULP_CLASS_HID_4172f] = 1077,
	[BNXT_ULP_CLASS_HID_40621] = 1078,
	[BNXT_ULP_CLASS_HID_5062d] = 1079,
	[BNXT_ULP_CLASS_HID_51621] = 1080,
	[BNXT_ULP_CLASS_HID_49f07] = 1081,
	[BNXT_ULP_CLASS_HID_48e29] = 1082,
	[BNXT_ULP_CLASS_HID_58e25] = 1083,
	[BNXT_ULP_CLASS_HID_59d29] = 1084,
	[BNXT_ULP_CLASS_HID_400c9] = 1085,
	[BNXT_ULP_CLASS_HID_4108d] = 1086,
	[BNXT_ULP_CLASS_HID_51049] = 1087,
	[BNXT_ULP_CLASS_HID_50fc3] = 1088,
	[BNXT_ULP_CLASS_HID_48881] = 1089,
	[BNXT_ULP_CLASS_HID_487cb] = 1090,
	[BNXT_ULP_CLASS_HID_587c7] = 1091,
	[BNXT_ULP_CLASS_HID_5978b] = 1092,
	[BNXT_ULP_CLASS_HID_41c4d] = 1093,
	[BNXT_ULP_CLASS_HID_40b47] = 1094,
	[BNXT_ULP_CLASS_HID_50b03] = 1095,
	[BNXT_ULP_CLASS_HID_51b47] = 1096,
	[BNXT_ULP_CLASS_HID_4834b] = 1097,
	[BNXT_ULP_CLASS_HID_4930f] = 1098,
	[BNXT_ULP_CLASS_HID_5934b] = 1099,
	[BNXT_ULP_CLASS_HID_5824d] = 1100,
	[BNXT_ULP_CLASS_HID_41687] = 1101,
	[BNXT_ULP_CLASS_HID_40609] = 1102,
	[BNXT_ULP_CLASS_HID_50585] = 1103,
	[BNXT_ULP_CLASS_HID_51589] = 1104,
	[BNXT_ULP_CLASS_HID_49e0f] = 1105,
	[BNXT_ULP_CLASS_HID_48d81] = 1106,
	[BNXT_ULP_CLASS_HID_58d8d] = 1107,
	[BNXT_ULP_CLASS_HID_59d01] = 1108,
	[BNXT_ULP_CLASS_HID_40109] = 1109,
	[BNXT_ULP_CLASS_HID_4110d] = 1110,
	[BNXT_ULP_CLASS_HID_51109] = 1111,
	[BNXT_ULP_CLASS_HID_50003] = 1112,
	[BNXT_ULP_CLASS_HID_48901] = 1113,
	[BNXT_ULP_CLASS_HID_49905] = 1114,
	[BNXT_ULP_CLASS_HID_59901] = 1115,
	[BNXT_ULP_CLASS_HID_5880b] = 1116,
	[BNXT_ULP_CLASS_HID_10619] = 1117,
	[BNXT_ULP_CLASS_HID_11239] = 1118,
	[BNXT_ULP_CLASS_HID_14205] = 1119,
	[BNXT_ULP_CLASS_HID_15e25] = 1120,
	[BNXT_ULP_CLASS_HID_12417] = 1121,
	[BNXT_ULP_CLASS_HID_13037] = 1122,
	[BNXT_ULP_CLASS_HID_16ff3] = 1123,
	[BNXT_ULP_CLASS_HID_17c13] = 1124,
	[BNXT_ULP_CLASS_HID_1111d] = 1125,
	[BNXT_ULP_CLASS_HID_10cdb] = 1126,
	[BNXT_ULP_CLASS_HID_15d19] = 1127,
	[BNXT_ULP_CLASS_HID_148c7] = 1128,
	[BNXT_ULP_CLASS_HID_13f0b] = 1129,
	[BNXT_ULP_CLASS_HID_12ac9] = 1130,
	[BNXT_ULP_CLASS_HID_17b17] = 1131,
	[BNXT_ULP_CLASS_HID_176d5] = 1132,
	[BNXT_ULP_CLASS_HID_10bab] = 1133,
	[BNXT_ULP_CLASS_HID_10769] = 1134,
	[BNXT_ULP_CLASS_HID_15787] = 1135,
	[BNXT_ULP_CLASS_HID_14345] = 1136,
	[BNXT_ULP_CLASS_HID_12989] = 1137,
	[BNXT_ULP_CLASS_HID_12567] = 1138,
	[BNXT_ULP_CLASS_HID_17585] = 1139,
	[BNXT_ULP_CLASS_HID_16143] = 1140,
	[BNXT_ULP_CLASS_HID_1064d] = 1141,
	[BNXT_ULP_CLASS_HID_1128d] = 1142,
	[BNXT_ULP_CLASS_HID_14249] = 1143,
	[BNXT_ULP_CLASS_HID_15e49] = 1144,
	[BNXT_ULP_CLASS_HID_1244b] = 1145,
	[BNXT_ULP_CLASS_HID_1304b] = 1146,
	[BNXT_ULP_CLASS_HID_16047] = 1147,
	[BNXT_ULP_CLASS_HID_17c47] = 1148,
	[BNXT_ULP_CLASS_HID_11113] = 1149,
	[BNXT_ULP_CLASS_HID_10cd1] = 1150,
	[BNXT_ULP_CLASS_HID_15cf7] = 1151,
	[BNXT_ULP_CLASS_HID_148b5] = 1152,
	[BNXT_ULP_CLASS_HID_13f01] = 1153,
	[BNXT_ULP_CLASS_HID_12ac7] = 1154,
	[BNXT_ULP_CLASS_HID_17ae5] = 1155,
	[BNXT_ULP_CLASS_HID_176a3] = 1156,
	[BNXT_ULP_CLASS_HID_10bd5] = 1157,
	[BNXT_ULP_CLASS_HID_10793] = 1158,
	[BNXT_ULP_CLASS_HID_15791] = 1159,
	[BNXT_ULP_CLASS_HID_14357] = 1160,
	[BNXT_ULP_CLASS_HID_129c3] = 1161,
	[BNXT_ULP_CLASS_HID_12581] = 1162,
	[BNXT_ULP_CLASS_HID_17587] = 1163,
	[BNXT_ULP_CLASS_HID_16145] = 1164,
	[BNXT_ULP_CLASS_HID_10643] = 1165,
	[BNXT_ULP_CLASS_HID_11263] = 1166,
	[BNXT_ULP_CLASS_HID_14227] = 1167,
	[BNXT_ULP_CLASS_HID_15e47] = 1168,
	[BNXT_ULP_CLASS_HID_12421] = 1169,
	[BNXT_ULP_CLASS_HID_13041] = 1170,
	[BNXT_ULP_CLASS_HID_16005] = 1171,
	[BNXT_ULP_CLASS_HID_17c25] = 1172,
	[BNXT_ULP_CLASS_HID_11147] = 1173,
	[BNXT_ULP_CLASS_HID_10d05] = 1174,
	[BNXT_ULP_CLASS_HID_15d43] = 1175,
	[BNXT_ULP_CLASS_HID_14901] = 1176,
	[BNXT_ULP_CLASS_HID_13f45] = 1177,
	[BNXT_ULP_CLASS_HID_12b03] = 1178,
	[BNXT_ULP_CLASS_HID_17b01] = 1179,
	[BNXT_ULP_CLASS_HID_176c7] = 1180,
	[BNXT_ULP_CLASS_HID_11bcf] = 1181,
	[BNXT_ULP_CLASS_HID_1178d] = 1182,
	[BNXT_ULP_CLASS_HID_1474d] = 1183,
	[BNXT_ULP_CLASS_HID_1536d] = 1184,
	[BNXT_ULP_CLASS_HID_139bd] = 1185,
	[BNXT_ULP_CLASS_HID_1357f] = 1186,
	[BNXT_ULP_CLASS_HID_16547] = 1187,
	[BNXT_ULP_CLASS_HID_17167] = 1188,
	[BNXT_ULP_CLASS_HID_11685] = 1189,
	[BNXT_ULP_CLASS_HID_1024f] = 1190,
	[BNXT_ULP_CLASS_HID_1524d] = 1191,
	[BNXT_ULP_CLASS_HID_14e0f] = 1192,
	[BNXT_ULP_CLASS_HID_1345f] = 1193,
	[BNXT_ULP_CLASS_HID_1201d] = 1194,
	[BNXT_ULP_CLASS_HID_1705f] = 1195,
	[BNXT_ULP_CLASS_HID_16c1d] = 1196,
	[BNXT_ULP_CLASS_HID_100ef] = 1197,
	[BNXT_ULP_CLASS_HID_11d0f] = 1198,
	[BNXT_ULP_CLASS_HID_14ccf] = 1199,
	[BNXT_ULP_CLASS_HID_158ef] = 1200,
	[BNXT_ULP_CLASS_HID_12eed] = 1201,
	[BNXT_ULP_CLASS_HID_13b0d] = 1202,
	[BNXT_ULP_CLASS_HID_16acd] = 1203,
	[BNXT_ULP_CLASS_HID_16687] = 1204,
	[BNXT_ULP_CLASS_HID_11c07] = 1205,
	[BNXT_ULP_CLASS_HID_117c5] = 1206,
	[BNXT_ULP_CLASS_HID_1478d] = 1207,
	[BNXT_ULP_CLASS_HID_1538d] = 1208,
	[BNXT_ULP_CLASS_HID_13a05] = 1209,
	[BNXT_ULP_CLASS_HID_135cf] = 1210,
	[BNXT_ULP_CLASS_HID_1658f] = 1211,
	[BNXT_ULP_CLASS_HID_1718f] = 1212,
	[BNXT_ULP_CLASS_HID_11667] = 1213,
	[BNXT_ULP_CLASS_HID_10225] = 1214,
	[BNXT_ULP_CLASS_HID_15247] = 1215,
	[BNXT_ULP_CLASS_HID_14e05] = 1216,
	[BNXT_ULP_CLASS_HID_13455] = 1217,
	[BNXT_ULP_CLASS_HID_12017] = 1218,
	[BNXT_ULP_CLASS_HID_17035] = 1219,
	[BNXT_ULP_CLASS_HID_16bf7] = 1220,
	[BNXT_ULP_CLASS_HID_10115] = 1221,
	[BNXT_ULP_CLASS_HID_11d15] = 1222,
	[BNXT_ULP_CLASS_HID_14d05] = 1223,
	[BNXT_ULP_CLASS_HID_15905] = 1224,
	[BNXT_ULP_CLASS_HID_12f17] = 1225,
	[BNXT_ULP_CLASS_HID_13b17] = 1226,
	[BNXT_ULP_CLASS_HID_16ad7] = 1227,
	[BNXT_ULP_CLASS_HID_16695] = 1228,
	[BNXT_ULP_CLASS_HID_11be5] = 1229,
	[BNXT_ULP_CLASS_HID_117a7] = 1230,
	[BNXT_ULP_CLASS_HID_14767] = 1231,
	[BNXT_ULP_CLASS_HID_15387] = 1232,
	[BNXT_ULP_CLASS_HID_139e7] = 1233,
	[BNXT_ULP_CLASS_HID_135a5] = 1234,
	[BNXT_ULP_CLASS_HID_16565] = 1235,
	[BNXT_ULP_CLASS_HID_17185] = 1236,
	[BNXT_ULP_CLASS_HID_11687] = 1237,
	[BNXT_ULP_CLASS_HID_10245] = 1238,
	[BNXT_ULP_CLASS_HID_15287] = 1239,
	[BNXT_ULP_CLASS_HID_14e45] = 1240,
	[BNXT_ULP_CLASS_HID_13485] = 1241,
	[BNXT_ULP_CLASS_HID_12047] = 1242,
	[BNXT_ULP_CLASS_HID_17085] = 1243,
	[BNXT_ULP_CLASS_HID_16c47] = 1244,
	[BNXT_ULP_CLASS_HID_400f4] = 1245,
	[BNXT_ULP_CLASS_HID_410c8] = 1246,
	[BNXT_ULP_CLASS_HID_51084] = 1247,
	[BNXT_ULP_CLASS_HID_50ffe] = 1248,
	[BNXT_ULP_CLASS_HID_488cc] = 1249,
	[BNXT_ULP_CLASS_HID_48726] = 1250,
	[BNXT_ULP_CLASS_HID_587f2] = 1251,
	[BNXT_ULP_CLASS_HID_597b6] = 1252,
	[BNXT_ULP_CLASS_HID_41b10] = 1253,
	[BNXT_ULP_CLASS_HID_40b8a] = 1254,
	[BNXT_ULP_CLASS_HID_50a46] = 1255,
	[BNXT_ULP_CLASS_HID_51a1a] = 1256,
	[BNXT_ULP_CLASS_HID_4838e] = 1257,
	[BNXT_ULP_CLASS_HID_49242] = 1258,
	[BNXT_ULP_CLASS_HID_5921e] = 1259,
	[BNXT_ULP_CLASS_HID_58150] = 1260,
	[BNXT_ULP_CLASS_HID_41686] = 1261,
	[BNXT_ULP_CLASS_HID_405e8] = 1262,
	[BNXT_ULP_CLASS_HID_505a4] = 1263,
	[BNXT_ULP_CLASS_HID_51588] = 1264,
	[BNXT_ULP_CLASS_HID_49d4e] = 1265,
	[BNXT_ULP_CLASS_HID_48da0] = 1266,
	[BNXT_ULP_CLASS_HID_58d8c] = 1267,
	[BNXT_ULP_CLASS_HID_59c40] = 1268,
	[BNXT_ULP_CLASS_HID_40040] = 1269,
	[BNXT_ULP_CLASS_HID_41004] = 1270,
	[BNXT_ULP_CLASS_HID_510c0] = 1271,
	[BNXT_ULP_CLASS_HID_50f4a] = 1272,
	[BNXT_ULP_CLASS_HID_48808] = 1273,
	[BNXT_ULP_CLASS_HID_48742] = 1274,
	[BNXT_ULP_CLASS_HID_5874e] = 1275,
	[BNXT_ULP_CLASS_HID_59702] = 1276,
	[BNXT_ULP_CLASS_HID_41bfe] = 1277,
	[BNXT_ULP_CLASS_HID_40a58] = 1278,
	[BNXT_ULP_CLASS_HID_50a2c] = 1279,
	[BNXT_ULP_CLASS_HID_51ae8] = 1280,
	[BNXT_ULP_CLASS_HID_4825c] = 1281,
	[BNXT_ULP_CLASS_HID_49228] = 1282,
	[BNXT_ULP_CLASS_HID_592ec] = 1283,
	[BNXT_ULP_CLASS_HID_5815e] = 1284,
	[BNXT_ULP_CLASS_HID_41698] = 1285,
	[BNXT_ULP_CLASS_HID_4051a] = 1286,
	[BNXT_ULP_CLASS_HID_505ce] = 1287,
	[BNXT_ULP_CLASS_HID_5158a] = 1288,
	[BNXT_ULP_CLASS_HID_49d58] = 1289,
	[BNXT_ULP_CLASS_HID_48dca] = 1290,
	[BNXT_ULP_CLASS_HID_58d8e] = 1291,
	[BNXT_ULP_CLASS_HID_59c5a] = 1292,
	[BNXT_ULP_CLASS_HID_4002e] = 1293,
	[BNXT_ULP_CLASS_HID_410ea] = 1294,
	[BNXT_ULP_CLASS_HID_510ae] = 1295,
	[BNXT_ULP_CLASS_HID_50f08] = 1296,
	[BNXT_ULP_CLASS_HID_488ee] = 1297,
	[BNXT_ULP_CLASS_HID_48748] = 1298,
	[BNXT_ULP_CLASS_HID_5870c] = 1299,
	[BNXT_ULP_CLASS_HID_597e8] = 1300,
	[BNXT_ULP_CLASS_HID_41b4a] = 1301,
	[BNXT_ULP_CLASS_HID_40b8c] = 1302,
	[BNXT_ULP_CLASS_HID_50a48] = 1303,
	[BNXT_ULP_CLASS_HID_51a0c] = 1304,
	[BNXT_ULP_CLASS_HID_48388] = 1305,
	[BNXT_ULP_CLASS_HID_4924c] = 1306,
	[BNXT_ULP_CLASS_HID_59208] = 1307,
	[BNXT_ULP_CLASS_HID_5828a] = 1308,
	[BNXT_ULP_CLASS_HID_40540] = 1309,
	[BNXT_ULP_CLASS_HID_41500] = 1310,
	[BNXT_ULP_CLASS_HID_515d0] = 1311,
	[BNXT_ULP_CLASS_HID_5044a] = 1312,
	[BNXT_ULP_CLASS_HID_48d18] = 1313,
	[BNXT_ULP_CLASS_HID_49dd8] = 1314,
	[BNXT_ULP_CLASS_HID_59da8] = 1315,
	[BNXT_ULP_CLASS_HID_58c02] = 1316,
	[BNXT_ULP_CLASS_HID_41048] = 1317,
	[BNXT_ULP_CLASS_HID_400c2] = 1318,
	[BNXT_ULP_CLASS_HID_50092] = 1319,
	[BNXT_ULP_CLASS_HID_51f52] = 1320,
	[BNXT_ULP_CLASS_HID_49800] = 1321,
	[BNXT_ULP_CLASS_HID_4889a] = 1322,
	[BNXT_ULP_CLASS_HID_5974a] = 1323,
	[BNXT_ULP_CLASS_HID_587c8] = 1324,
	[BNXT_ULP_CLASS_HID_40bc2] = 1325,
	[BNXT_ULP_CLASS_HID_41b82] = 1326,
	[BNXT_ULP_CLASS_HID_51a62] = 1327,
	[BNXT_ULP_CLASS_HID_50ac0] = 1328,
	[BNXT_ULP_CLASS_HID_493aa] = 1329,
	[BNXT_ULP_CLASS_HID_48208] = 1330,
	[BNXT_ULP_CLASS_HID_582c8] = 1331,
	[BNXT_ULP_CLASS_HID_59288] = 1332,
	[BNXT_ULP_CLASS_HID_40688] = 1333,
	[BNXT_ULP_CLASS_HID_41540] = 1334,
	[BNXT_ULP_CLASS_HID_51508] = 1335,
	[BNXT_ULP_CLASS_HID_50582] = 1336,
	[BNXT_ULP_CLASS_HID_48d40] = 1337,
	[BNXT_ULP_CLASS_HID_49d08] = 1338,
	[BNXT_ULP_CLASS_HID_59dc0] = 1339,
	[BNXT_ULP_CLASS_HID_58c4a] = 1340,
	[BNXT_ULP_CLASS_HID_4104a] = 1341,
	[BNXT_ULP_CLASS_HID_400a8] = 1342,
	[BNXT_ULP_CLASS_HID_50f78] = 1343,
	[BNXT_ULP_CLASS_HID_51f38] = 1344,
	[BNXT_ULP_CLASS_HID_4980a] = 1345,
	[BNXT_ULP_CLASS_HID_49768] = 1346,
	[BNXT_ULP_CLASS_HID_59738] = 1347,
	[BNXT_ULP_CLASS_HID_587aa] = 1348,
	[BNXT_ULP_CLASS_HID_40bd8] = 1349,
	[BNXT_ULP_CLASS_HID_41bc8] = 1350,
	[BNXT_ULP_CLASS_HID_51b88] = 1351,
	[BNXT_ULP_CLASS_HID_50ada] = 1352,
	[BNXT_ULP_CLASS_HID_493c8] = 1353,
	[BNXT_ULP_CLASS_HID_4820a] = 1354,
	[BNXT_ULP_CLASS_HID_582da] = 1355,
	[BNXT_ULP_CLASS_HID_5929a] = 1356,
	[BNXT_ULP_CLASS_HID_4056a] = 1357,
	[BNXT_ULP_CLASS_HID_4152a] = 1358,
	[BNXT_ULP_CLASS_HID_5150a] = 1359,
	[BNXT_ULP_CLASS_HID_50468] = 1360,
	[BNXT_ULP_CLASS_HID_48d2a] = 1361,
	[BNXT_ULP_CLASS_HID_49dea] = 1362,
	[BNXT_ULP_CLASS_HID_59dca] = 1363,
	[BNXT_ULP_CLASS_HID_58c28] = 1364,
	[BNXT_ULP_CLASS_HID_4118a] = 1365,
	[BNXT_ULP_CLASS_HID_400c8] = 1366,
	[BNXT_ULP_CLASS_HID_50088] = 1367,
	[BNXT_ULP_CLASS_HID_51088] = 1368,
	[BNXT_ULP_CLASS_HID_4984a] = 1369,
	[BNXT_ULP_CLASS_HID_48888] = 1370,
	[BNXT_ULP_CLASS_HID_58888] = 1371,
	[BNXT_ULP_CLASS_HID_587ca] = 1372,
	[BNXT_ULP_CLASS_HID_10690] = 1373,
	[BNXT_ULP_CLASS_HID_112b0] = 1374,
	[BNXT_ULP_CLASS_HID_1428c] = 1375,
	[BNXT_ULP_CLASS_HID_15eac] = 1376,
	[BNXT_ULP_CLASS_HID_1249e] = 1377,
	[BNXT_ULP_CLASS_HID_130be] = 1378,
	[BNXT_ULP_CLASS_HID_16f7a] = 1379,
	[BNXT_ULP_CLASS_HID_17c9a] = 1380,
	[BNXT_ULP_CLASS_HID_1119a] = 1381,
	[BNXT_ULP_CLASS_HID_10c58] = 1382,
	[BNXT_ULP_CLASS_HID_15c7e] = 1383,
	[BNXT_ULP_CLASS_HID_1483c] = 1384,
	[BNXT_ULP_CLASS_HID_13f88] = 1385,
	[BNXT_ULP_CLASS_HID_12a4e] = 1386,
	[BNXT_ULP_CLASS_HID_17a6c] = 1387,
	[BNXT_ULP_CLASS_HID_1762a] = 1388,
	[BNXT_ULP_CLASS_HID_11b46] = 1389,
	[BNXT_ULP_CLASS_HID_11704] = 1390,
	[BNXT_ULP_CLASS_HID_147c4] = 1391,
	[BNXT_ULP_CLASS_HID_153e4] = 1392,
	[BNXT_ULP_CLASS_HID_13934] = 1393,
	[BNXT_ULP_CLASS_HID_135f6] = 1394,
	[BNXT_ULP_CLASS_HID_165ce] = 1395,
	[BNXT_ULP_CLASS_HID_171ee] = 1396,
	[BNXT_ULP_CLASS_HID_116ee] = 1397,
	[BNXT_ULP_CLASS_HID_102ac] = 1398,
	[BNXT_ULP_CLASS_HID_152ce] = 1399,
	[BNXT_ULP_CLASS_HID_14e8c] = 1400,
	[BNXT_ULP_CLASS_HID_134dc] = 1401,
	[BNXT_ULP_CLASS_HID_1209e] = 1402,
	[BNXT_ULP_CLASS_HID_170bc] = 1403,
	[BNXT_ULP_CLASS_HID_16b7e] = 1404,
	[BNXT_ULP_CLASS_HID_119ae] = 1405,
	[BNXT_ULP_CLASS_HID_1146a] = 1406,
	[BNXT_ULP_CLASS_HID_14426] = 1407,
	[BNXT_ULP_CLASS_HID_15046] = 1408,
	[BNXT_ULP_CLASS_HID_1263a] = 1409,
	[BNXT_ULP_CLASS_HID_1325a] = 1410,
	[BNXT_ULP_CLASS_HID_16216] = 1411,
	[BNXT_ULP_CLASS_HID_17e36] = 1412,
	[BNXT_ULP_CLASS_HID_1133e] = 1413,
	[BNXT_ULP_CLASS_HID_10ffa] = 1414,
	[BNXT_ULP_CLASS_HID_15f1a] = 1415,
	[BNXT_ULP_CLASS_HID_14bee] = 1416,
	[BNXT_ULP_CLASS_HID_1312a] = 1417,
	[BNXT_ULP_CLASS_HID_12dea] = 1418,
	[BNXT_ULP_CLASS_HID_17d1e] = 1419,
	[BNXT_ULP_CLASS_HID_169de] = 1420,
	[BNXT_ULP_CLASS_HID_11ee6] = 1421,
	[BNXT_ULP_CLASS_HID_10abe] = 1422,
	[BNXT_ULP_CLASS_HID_15ade] = 1423,
	[BNXT_ULP_CLASS_HID_1569e] = 1424,
	[BNXT_ULP_CLASS_HID_13cee] = 1425,
	[BNXT_ULP_CLASS_HID_128ae] = 1426,
	[BNXT_ULP_CLASS_HID_1676e] = 1427,
	[BNXT_ULP_CLASS_HID_1748e] = 1428,
	[BNXT_ULP_CLASS_HID_1098e] = 1429,
	[BNXT_ULP_CLASS_HID_1044e] = 1430,
	[BNXT_ULP_CLASS_HID_1546e] = 1431,
	[BNXT_ULP_CLASS_HID_1402e] = 1432,
	[BNXT_ULP_CLASS_HID_1367e] = 1433,
	[BNXT_ULP_CLASS_HID_1223e] = 1434,
	[BNXT_ULP_CLASS_HID_1725e] = 1435,
	[BNXT_ULP_CLASS_HID_16e1e] = 1436,
	[BNXT_ULP_CLASS_HID_1172f] = 1437,
	[BNXT_ULP_CLASS_HID_103ed] = 1438,
	[BNXT_ULP_CLASS_HID_1530b] = 1439,
	[BNXT_ULP_CLASS_HID_14fc9] = 1440,
	[BNXT_ULP_CLASS_HID_1351d] = 1441,
	[BNXT_ULP_CLASS_HID_121db] = 1442,
	[BNXT_ULP_CLASS_HID_171f9] = 1443,
	[BNXT_ULP_CLASS_HID_16db7] = 1444,
	[BNXT_ULP_CLASS_HID_102bf] = 1445,
	[BNXT_ULP_CLASS_HID_11edf] = 1446,
	[BNXT_ULP_CLASS_HID_14e9b] = 1447,
	[BNXT_ULP_CLASS_HID_15abb] = 1448,
	[BNXT_ULP_CLASS_HID_120ad] = 1449,
	[BNXT_ULP_CLASS_HID_13ccd] = 1450,
	[BNXT_ULP_CLASS_HID_16c89] = 1451,
	[BNXT_ULP_CLASS_HID_1675f] = 1452,
	[BNXT_ULP_CLASS_HID_10c67] = 1453,
	[BNXT_ULP_CLASS_HID_11987] = 1454,
	[BNXT_ULP_CLASS_HID_1485f] = 1455,
	[BNXT_ULP_CLASS_HID_1441d] = 1456,
	[BNXT_ULP_CLASS_HID_12a55] = 1457,
	[BNXT_ULP_CLASS_HID_1262f] = 1458,
	[BNXT_ULP_CLASS_HID_1764d] = 1459,
	[BNXT_ULP_CLASS_HID_1620f] = 1460,
	[BNXT_ULP_CLASS_HID_1070f] = 1461,
	[BNXT_ULP_CLASS_HID_1132f] = 1462,
	[BNXT_ULP_CLASS_HID_143ef] = 1463,
	[BNXT_ULP_CLASS_HID_15f0f] = 1464,
	[BNXT_ULP_CLASS_HID_125fd] = 1465,
	[BNXT_ULP_CLASS_HID_1311d] = 1466,
	[BNXT_ULP_CLASS_HID_161dd] = 1467,
	[BNXT_ULP_CLASS_HID_17dfd] = 1468,
	[BNXT_ULP_CLASS_HID_10acb] = 1469,
	[BNXT_ULP_CLASS_HID_10687] = 1470,
	[BNXT_ULP_CLASS_HID_156a7] = 1471,
	[BNXT_ULP_CLASS_HID_14163] = 1472,
	[BNXT_ULP_CLASS_HID_128b7] = 1473,
	[BNXT_ULP_CLASS_HID_12377] = 1474,
	[BNXT_ULP_CLASS_HID_17493] = 1475,
	[BNXT_ULP_CLASS_HID_16f53] = 1476,
	[BNXT_ULP_CLASS_HID_1045b] = 1477,
	[BNXT_ULP_CLASS_HID_1107b] = 1478,
	[BNXT_ULP_CLASS_HID_1404f] = 1479,
	[BNXT_ULP_CLASS_HID_15c6f] = 1480,
	[BNXT_ULP_CLASS_HID_1225f] = 1481,
	[BNXT_ULP_CLASS_HID_13e7f] = 1482,
	[BNXT_ULP_CLASS_HID_16e3b] = 1483,
	[BNXT_ULP_CLASS_HID_17a5b] = 1484,
	[BNXT_ULP_CLASS_HID_10f1f] = 1485,
	[BNXT_ULP_CLASS_HID_11b3f] = 1486,
	[BNXT_ULP_CLASS_HID_14bff] = 1487,
	[BNXT_ULP_CLASS_HID_147b7] = 1488,
	[BNXT_ULP_CLASS_HID_12d0f] = 1489,
	[BNXT_ULP_CLASS_HID_1392f] = 1490,
	[BNXT_ULP_CLASS_HID_169e7] = 1491,
	[BNXT_ULP_CLASS_HID_165a7] = 1492,
	[BNXT_ULP_CLASS_HID_11a0f] = 1493,
	[BNXT_ULP_CLASS_HID_116cf] = 1494,
	[BNXT_ULP_CLASS_HID_1468f] = 1495,
	[BNXT_ULP_CLASS_HID_152af] = 1496,
	[BNXT_ULP_CLASS_HID_138ff] = 1497,
	[BNXT_ULP_CLASS_HID_134bf] = 1498,
	[BNXT_ULP_CLASS_HID_1648f] = 1499,
	[BNXT_ULP_CLASS_HID_170af] = 1500,
	[BNXT_ULP_CLASS_HID_40c38] = 1501,
	[BNXT_ULP_CLASS_HID_41c04] = 1502,
	[BNXT_ULP_CLASS_HID_51c48] = 1503,
	[BNXT_ULP_CLASS_HID_50332] = 1504,
	[BNXT_ULP_CLASS_HID_48400] = 1505,
	[BNXT_ULP_CLASS_HID_48bea] = 1506,
	[BNXT_ULP_CLASS_HID_58b3e] = 1507,
	[BNXT_ULP_CLASS_HID_59b7a] = 1508,
	[BNXT_ULP_CLASS_HID_417dc] = 1509,
	[BNXT_ULP_CLASS_HID_40746] = 1510,
	[BNXT_ULP_CLASS_HID_5068a] = 1511,
	[BNXT_ULP_CLASS_HID_516d6] = 1512,
	[BNXT_ULP_CLASS_HID_48f42] = 1513,
	[BNXT_ULP_CLASS_HID_49e8e] = 1514,
	[BNXT_ULP_CLASS_HID_59ed2] = 1515,
	[BNXT_ULP_CLASS_HID_58d9c] = 1516,
	[BNXT_ULP_CLASS_HID_41a4a] = 1517,
	[BNXT_ULP_CLASS_HID_40924] = 1518,
	[BNXT_ULP_CLASS_HID_50968] = 1519,
	[BNXT_ULP_CLASS_HID_51944] = 1520,
	[BNXT_ULP_CLASS_HID_49182] = 1521,
	[BNXT_ULP_CLASS_HID_4816c] = 1522,
	[BNXT_ULP_CLASS_HID_58140] = 1523,
	[BNXT_ULP_CLASS_HID_5908c] = 1524,
	[BNXT_ULP_CLASS_HID_40c8c] = 1525,
	[BNXT_ULP_CLASS_HID_41cc8] = 1526,
	[BNXT_ULP_CLASS_HID_51c0c] = 1527,
	[BNXT_ULP_CLASS_HID_50386] = 1528,
	[BNXT_ULP_CLASS_HID_484c4] = 1529,
	[BNXT_ULP_CLASS_HID_48b8e] = 1530,
	[BNXT_ULP_CLASS_HID_58b82] = 1531,
	[BNXT_ULP_CLASS_HID_59bce] = 1532,
	[BNXT_ULP_CLASS_HID_10a54] = 1533,
	[BNXT_ULP_CLASS_HID_11e74] = 1534,
	[BNXT_ULP_CLASS_HID_14e48] = 1535,
	[BNXT_ULP_CLASS_HID_15268] = 1536,
	[BNXT_ULP_CLASS_HID_1285a] = 1537,
	[BNXT_ULP_CLASS_HID_13c7a] = 1538,
	[BNXT_ULP_CLASS_HID_163be] = 1539,
	[BNXT_ULP_CLASS_HID_1705e] = 1540,
	[BNXT_ULP_CLASS_HID_11d5e] = 1541,
	[BNXT_ULP_CLASS_HID_1009c] = 1542,
	[BNXT_ULP_CLASS_HID_150ba] = 1543,
	[BNXT_ULP_CLASS_HID_144f8] = 1544,
	[BNXT_ULP_CLASS_HID_1334c] = 1545,
	[BNXT_ULP_CLASS_HID_1268a] = 1546,
	[BNXT_ULP_CLASS_HID_176a8] = 1547,
	[BNXT_ULP_CLASS_HID_17aee] = 1548,
	[BNXT_ULP_CLASS_HID_11782] = 1549,
	[BNXT_ULP_CLASS_HID_11bc0] = 1550,
	[BNXT_ULP_CLASS_HID_14b00] = 1551,
	[BNXT_ULP_CLASS_HID_15f20] = 1552,
	[BNXT_ULP_CLASS_HID_135f0] = 1553,
	[BNXT_ULP_CLASS_HID_13932] = 1554,
	[BNXT_ULP_CLASS_HID_1690a] = 1555,
	[BNXT_ULP_CLASS_HID_17d2a] = 1556,
	[BNXT_ULP_CLASS_HID_11a2a] = 1557,
	[BNXT_ULP_CLASS_HID_10e68] = 1558,
	[BNXT_ULP_CLASS_HID_15e0a] = 1559,
	[BNXT_ULP_CLASS_HID_14248] = 1560,
	[BNXT_ULP_CLASS_HID_13818] = 1561,
	[BNXT_ULP_CLASS_HID_12c5a] = 1562,
	[BNXT_ULP_CLASS_HID_17c78] = 1563,
	[BNXT_ULP_CLASS_HID_167ba] = 1564,
	[BNXT_ULP_CLASS_HID_1f91] = 1565,
	[BNXT_ULP_CLASS_HID_0763] = 1566,
	[BNXT_ULP_CLASS_HID_0f7b] = 1567,
	[BNXT_ULP_CLASS_HID_16af] = 1568,
	[BNXT_ULP_CLASS_HID_1daf] = 1569,
	[BNXT_ULP_CLASS_HID_0539] = 1570,
	[BNXT_ULP_CLASS_HID_01ed] = 1571,
	[BNXT_ULP_CLASS_HID_097f] = 1572,
	[BNXT_ULP_CLASS_HID_81ab8] = 1573,
	[BNXT_ULP_CLASS_HID_8020e] = 1574,
	[BNXT_ULP_CLASS_HID_815d8] = 1575,
	[BNXT_ULP_CLASS_HID_81cae] = 1576,
	[BNXT_ULP_CLASS_HID_810a8] = 1577,
	[BNXT_ULP_CLASS_HID_8183e] = 1578,
	[BNXT_ULP_CLASS_HID_8036a] = 1579,
	[BNXT_ULP_CLASS_HID_80af8] = 1580,
	[BNXT_ULP_CLASS_HID_206fe] = 1581,
	[BNXT_ULP_CLASS_HID_20e4c] = 1582,
	[BNXT_ULP_CLASS_HID_2111e] = 1583,
	[BNXT_ULP_CLASS_HID_218ec] = 1584,
	[BNXT_ULP_CLASS_HID_60472] = 1585,
	[BNXT_ULP_CLASS_HID_603c0] = 1586,
	[BNXT_ULP_CLASS_HID_61692] = 1587,
	[BNXT_ULP_CLASS_HID_61e60] = 1588,
	[BNXT_ULP_CLASS_HID_1f81] = 1589,
	[BNXT_ULP_CLASS_HID_0773] = 1590,
	[BNXT_ULP_CLASS_HID_0f6b] = 1591,
	[BNXT_ULP_CLASS_HID_16bf] = 1592,
	[BNXT_ULP_CLASS_HID_03cf] = 1593,
	[BNXT_ULP_CLASS_HID_0ab1] = 1594,
	[BNXT_ULP_CLASS_HID_130b] = 1595,
	[BNXT_ULP_CLASS_HID_1afd] = 1596,
	[BNXT_ULP_CLASS_HID_1591] = 1597,
	[BNXT_ULP_CLASS_HID_1d03] = 1598,
	[BNXT_ULP_CLASS_HID_057b] = 1599,
	[BNXT_ULP_CLASS_HID_0ced] = 1600,
	[BNXT_ULP_CLASS_HID_19df] = 1601,
	[BNXT_ULP_CLASS_HID_0141] = 1602,
	[BNXT_ULP_CLASS_HID_08b9] = 1603,
	[BNXT_ULP_CLASS_HID_108d] = 1604,
	[BNXT_ULP_CLASS_HID_1dbf] = 1605,
	[BNXT_ULP_CLASS_HID_0529] = 1606,
	[BNXT_ULP_CLASS_HID_01fd] = 1607,
	[BNXT_ULP_CLASS_HID_096f] = 1608,
	[BNXT_ULP_CLASS_HID_810b7] = 1609,
	[BNXT_ULP_CLASS_HID_81821] = 1610,
	[BNXT_ULP_CLASS_HID_804f5] = 1611,
	[BNXT_ULP_CLASS_HID_80c67] = 1612,
	[BNXT_ULP_CLASS_HID_41333] = 1613,
	[BNXT_ULP_CLASS_HID_41aad] = 1614,
	[BNXT_ULP_CLASS_HID_40771] = 1615,
	[BNXT_ULP_CLASS_HID_40ee3] = 1616,
	[BNXT_ULP_CLASS_HID_c16cb] = 1617,
	[BNXT_ULP_CLASS_HID_c1da5] = 1618,
	[BNXT_ULP_CLASS_HID_c1a09] = 1619,
	[BNXT_ULP_CLASS_HID_c01fb] = 1620,
	[BNXT_ULP_CLASS_HID_1ff1] = 1621,
	[BNXT_ULP_CLASS_HID_0703] = 1622,
	[BNXT_ULP_CLASS_HID_0f1b] = 1623,
	[BNXT_ULP_CLASS_HID_16cf] = 1624,
	[BNXT_ULP_CLASS_HID_03bf] = 1625,
	[BNXT_ULP_CLASS_HID_0ac1] = 1626,
	[BNXT_ULP_CLASS_HID_137b] = 1627,
	[BNXT_ULP_CLASS_HID_1a8d] = 1628,
	[BNXT_ULP_CLASS_HID_15e1] = 1629,
	[BNXT_ULP_CLASS_HID_1d73] = 1630,
	[BNXT_ULP_CLASS_HID_050b] = 1631,
	[BNXT_ULP_CLASS_HID_0c9d] = 1632,
	[BNXT_ULP_CLASS_HID_19af] = 1633,
	[BNXT_ULP_CLASS_HID_0131] = 1634,
	[BNXT_ULP_CLASS_HID_08c9] = 1635,
	[BNXT_ULP_CLASS_HID_10fd] = 1636,
	[BNXT_ULP_CLASS_HID_1dcf] = 1637,
	[BNXT_ULP_CLASS_HID_0559] = 1638,
	[BNXT_ULP_CLASS_HID_018d] = 1639,
	[BNXT_ULP_CLASS_HID_091f] = 1640,
	[BNXT_ULP_CLASS_HID_810c7] = 1641,
	[BNXT_ULP_CLASS_HID_81851] = 1642,
	[BNXT_ULP_CLASS_HID_80485] = 1643,
	[BNXT_ULP_CLASS_HID_80c17] = 1644,
	[BNXT_ULP_CLASS_HID_41343] = 1645,
	[BNXT_ULP_CLASS_HID_41add] = 1646,
	[BNXT_ULP_CLASS_HID_40701] = 1647,
	[BNXT_ULP_CLASS_HID_40e93] = 1648,
	[BNXT_ULP_CLASS_HID_c16bb] = 1649,
	[BNXT_ULP_CLASS_HID_c1dd5] = 1650,
	[BNXT_ULP_CLASS_HID_c1a79] = 1651,
	[BNXT_ULP_CLASS_HID_c018b] = 1652,
	[BNXT_ULP_CLASS_HID_81aa8] = 1653,
	[BNXT_ULP_CLASS_HID_8021e] = 1654,
	[BNXT_ULP_CLASS_HID_815c8] = 1655,
	[BNXT_ULP_CLASS_HID_81cbe] = 1656,
	[BNXT_ULP_CLASS_HID_810b8] = 1657,
	[BNXT_ULP_CLASS_HID_8182e] = 1658,
	[BNXT_ULP_CLASS_HID_8037a] = 1659,
	[BNXT_ULP_CLASS_HID_80ae8] = 1660,
	[BNXT_ULP_CLASS_HID_c1834] = 1661,
	[BNXT_ULP_CLASS_HID_c079a] = 1662,
	[BNXT_ULP_CLASS_HID_c0af6] = 1663,
	[BNXT_ULP_CLASS_HID_c123a] = 1664,
	[BNXT_ULP_CLASS_HID_c16c4] = 1665,
	[BNXT_ULP_CLASS_HID_c1daa] = 1666,
	[BNXT_ULP_CLASS_HID_c0086] = 1667,
	[BNXT_ULP_CLASS_HID_c0874] = 1668,
	[BNXT_ULP_CLASS_HID_a19ea] = 1669,
	[BNXT_ULP_CLASS_HID_a0158] = 1670,
	[BNXT_ULP_CLASS_HID_a0bb4] = 1671,
	[BNXT_ULP_CLASS_HID_a13f8] = 1672,
	[BNXT_ULP_CLASS_HID_a17fa] = 1673,
	[BNXT_ULP_CLASS_HID_a1f68] = 1674,
	[BNXT_ULP_CLASS_HID_a0244] = 1675,
	[BNXT_ULP_CLASS_HID_a092a] = 1676,
	[BNXT_ULP_CLASS_HID_e1f76] = 1677,
	[BNXT_ULP_CLASS_HID_e06e4] = 1678,
	[BNXT_ULP_CLASS_HID_e0930] = 1679,
	[BNXT_ULP_CLASS_HID_e1104] = 1680,
	[BNXT_ULP_CLASS_HID_e1506] = 1681,
	[BNXT_ULP_CLASS_HID_e1cf4] = 1682,
	[BNXT_ULP_CLASS_HID_e07c0] = 1683,
	[BNXT_ULP_CLASS_HID_e0eb6] = 1684,
	[BNXT_ULP_CLASS_HID_206ee] = 1685,
	[BNXT_ULP_CLASS_HID_20e5c] = 1686,
	[BNXT_ULP_CLASS_HID_2110e] = 1687,
	[BNXT_ULP_CLASS_HID_218fc] = 1688,
	[BNXT_ULP_CLASS_HID_60462] = 1689,
	[BNXT_ULP_CLASS_HID_603d0] = 1690,
	[BNXT_ULP_CLASS_HID_61682] = 1691,
	[BNXT_ULP_CLASS_HID_61e70] = 1692,
	[BNXT_ULP_CLASS_HID_3167e] = 1693,
	[BNXT_ULP_CLASS_HID_31dec] = 1694,
	[BNXT_ULP_CLASS_HID_30030] = 1695,
	[BNXT_ULP_CLASS_HID_30fae] = 1696,
	[BNXT_ULP_CLASS_HID_70b14] = 1697,
	[BNXT_ULP_CLASS_HID_71360] = 1698,
	[BNXT_ULP_CLASS_HID_705b4] = 1699,
	[BNXT_ULP_CLASS_HID_70d22] = 1700,
	[BNXT_ULP_CLASS_HID_29e26] = 1701,
	[BNXT_ULP_CLASS_HID_28594] = 1702,
	[BNXT_ULP_CLASS_HID_288f8] = 1703,
	[BNXT_ULP_CLASS_HID_29034] = 1704,
	[BNXT_ULP_CLASS_HID_693ba] = 1705,
	[BNXT_ULP_CLASS_HID_69b28] = 1706,
	[BNXT_ULP_CLASS_HID_68e7c] = 1707,
	[BNXT_ULP_CLASS_HID_69648] = 1708,
	[BNXT_ULP_CLASS_HID_38de8] = 1709,
	[BNXT_ULP_CLASS_HID_39524] = 1710,
	[BNXT_ULP_CLASS_HID_39808] = 1711,
	[BNXT_ULP_CLASS_HID_387e6] = 1712,
	[BNXT_ULP_CLASS_HID_7836c] = 1713,
	[BNXT_ULP_CLASS_HID_78ada] = 1714,
	[BNXT_ULP_CLASS_HID_79d8c] = 1715,
	[BNXT_ULP_CLASS_HID_7857a] = 1716,
	[BNXT_ULP_CLASS_HID_81ad8] = 1717,
	[BNXT_ULP_CLASS_HID_8026e] = 1718,
	[BNXT_ULP_CLASS_HID_815b8] = 1719,
	[BNXT_ULP_CLASS_HID_81cce] = 1720,
	[BNXT_ULP_CLASS_HID_810c8] = 1721,
	[BNXT_ULP_CLASS_HID_8185e] = 1722,
	[BNXT_ULP_CLASS_HID_8030a] = 1723,
	[BNXT_ULP_CLASS_HID_80a98] = 1724,
	[BNXT_ULP_CLASS_HID_c1844] = 1725,
	[BNXT_ULP_CLASS_HID_c07ea] = 1726,
	[BNXT_ULP_CLASS_HID_c0a86] = 1727,
	[BNXT_ULP_CLASS_HID_c124a] = 1728,
	[BNXT_ULP_CLASS_HID_c16b4] = 1729,
	[BNXT_ULP_CLASS_HID_c1dda] = 1730,
	[BNXT_ULP_CLASS_HID_c00f6] = 1731,
	[BNXT_ULP_CLASS_HID_c0804] = 1732,
	[BNXT_ULP_CLASS_HID_a199a] = 1733,
	[BNXT_ULP_CLASS_HID_a0128] = 1734,
	[BNXT_ULP_CLASS_HID_a0bc4] = 1735,
	[BNXT_ULP_CLASS_HID_a1388] = 1736,
	[BNXT_ULP_CLASS_HID_a178a] = 1737,
	[BNXT_ULP_CLASS_HID_a1f18] = 1738,
	[BNXT_ULP_CLASS_HID_a0234] = 1739,
	[BNXT_ULP_CLASS_HID_a095a] = 1740,
	[BNXT_ULP_CLASS_HID_e1f06] = 1741,
	[BNXT_ULP_CLASS_HID_e0694] = 1742,
	[BNXT_ULP_CLASS_HID_e0940] = 1743,
	[BNXT_ULP_CLASS_HID_e1174] = 1744,
	[BNXT_ULP_CLASS_HID_e1576] = 1745,
	[BNXT_ULP_CLASS_HID_e1c84] = 1746,
	[BNXT_ULP_CLASS_HID_e07b0] = 1747,
	[BNXT_ULP_CLASS_HID_e0ec6] = 1748,
	[BNXT_ULP_CLASS_HID_2069e] = 1749,
	[BNXT_ULP_CLASS_HID_20e2c] = 1750,
	[BNXT_ULP_CLASS_HID_2117e] = 1751,
	[BNXT_ULP_CLASS_HID_2188c] = 1752,
	[BNXT_ULP_CLASS_HID_60412] = 1753,
	[BNXT_ULP_CLASS_HID_603a0] = 1754,
	[BNXT_ULP_CLASS_HID_616f2] = 1755,
	[BNXT_ULP_CLASS_HID_61e00] = 1756,
	[BNXT_ULP_CLASS_HID_3160e] = 1757,
	[BNXT_ULP_CLASS_HID_31d9c] = 1758,
	[BNXT_ULP_CLASS_HID_30040] = 1759,
	[BNXT_ULP_CLASS_HID_30fde] = 1760,
	[BNXT_ULP_CLASS_HID_70b64] = 1761,
	[BNXT_ULP_CLASS_HID_71310] = 1762,
	[BNXT_ULP_CLASS_HID_705c4] = 1763,
	[BNXT_ULP_CLASS_HID_70d52] = 1764,
	[BNXT_ULP_CLASS_HID_29e56] = 1765,
	[BNXT_ULP_CLASS_HID_285e4] = 1766,
	[BNXT_ULP_CLASS_HID_28888] = 1767,
	[BNXT_ULP_CLASS_HID_29044] = 1768,
	[BNXT_ULP_CLASS_HID_693ca] = 1769,
	[BNXT_ULP_CLASS_HID_69b58] = 1770,
	[BNXT_ULP_CLASS_HID_68e0c] = 1771,
	[BNXT_ULP_CLASS_HID_69638] = 1772,
	[BNXT_ULP_CLASS_HID_38d98] = 1773,
	[BNXT_ULP_CLASS_HID_39554] = 1774,
	[BNXT_ULP_CLASS_HID_39878] = 1775,
	[BNXT_ULP_CLASS_HID_38796] = 1776,
	[BNXT_ULP_CLASS_HID_7831c] = 1777,
	[BNXT_ULP_CLASS_HID_78aaa] = 1778,
	[BNXT_ULP_CLASS_HID_79dfc] = 1779,
	[BNXT_ULP_CLASS_HID_7850a] = 1780,
	[BNXT_ULP_CLASS_HID_03b7] = 1781,
	[BNXT_ULP_CLASS_HID_13f3] = 1782,
	[BNXT_ULP_CLASS_HID_0255] = 1783,
	[BNXT_ULP_CLASS_HID_1675] = 1784,
	[BNXT_ULP_CLASS_HID_80f52] = 1785,
	[BNXT_ULP_CLASS_HID_819f2] = 1786,
	[BNXT_ULP_CLASS_HID_80542] = 1787,
	[BNXT_ULP_CLASS_HID_817e2] = 1788,
	[BNXT_ULP_CLASS_HID_20a98] = 1789,
	[BNXT_ULP_CLASS_HID_20538] = 1790,
	[BNXT_ULP_CLASS_HID_6081c] = 1791,
	[BNXT_ULP_CLASS_HID_61abc] = 1792,
	[BNXT_ULP_CLASS_HID_03a7] = 1793,
	[BNXT_ULP_CLASS_HID_13e3] = 1794,
	[BNXT_ULP_CLASS_HID_1047] = 1795,
	[BNXT_ULP_CLASS_HID_0721] = 1796,
	[BNXT_ULP_CLASS_HID_19b7] = 1797,
	[BNXT_ULP_CLASS_HID_0911] = 1798,
	[BNXT_ULP_CLASS_HID_0df5] = 1799,
	[BNXT_ULP_CLASS_HID_1d31] = 1800,
	[BNXT_ULP_CLASS_HID_0245] = 1801,
	[BNXT_ULP_CLASS_HID_1665] = 1802,
	[BNXT_ULP_CLASS_HID_8055d] = 1803,
	[BNXT_ULP_CLASS_HID_80893] = 1804,
	[BNXT_ULP_CLASS_HID_407d9] = 1805,
	[BNXT_ULP_CLASS_HID_40b1f] = 1806,
	[BNXT_ULP_CLASS_HID_c1ad1] = 1807,
	[BNXT_ULP_CLASS_HID_c0e17] = 1808,
	[BNXT_ULP_CLASS_HID_03d7] = 1809,
	[BNXT_ULP_CLASS_HID_1393] = 1810,
	[BNXT_ULP_CLASS_HID_1037] = 1811,
	[BNXT_ULP_CLASS_HID_0751] = 1812,
	[BNXT_ULP_CLASS_HID_19c7] = 1813,
	[BNXT_ULP_CLASS_HID_0961] = 1814,
	[BNXT_ULP_CLASS_HID_0d85] = 1815,
	[BNXT_ULP_CLASS_HID_1d41] = 1816,
	[BNXT_ULP_CLASS_HID_0235] = 1817,
	[BNXT_ULP_CLASS_HID_1615] = 1818,
	[BNXT_ULP_CLASS_HID_8052d] = 1819,
	[BNXT_ULP_CLASS_HID_808e3] = 1820,
	[BNXT_ULP_CLASS_HID_407a9] = 1821,
	[BNXT_ULP_CLASS_HID_40b6f] = 1822,
	[BNXT_ULP_CLASS_HID_c1aa1] = 1823,
	[BNXT_ULP_CLASS_HID_c0e67] = 1824,
	[BNXT_ULP_CLASS_HID_80f42] = 1825,
	[BNXT_ULP_CLASS_HID_819e2] = 1826,
	[BNXT_ULP_CLASS_HID_80552] = 1827,
	[BNXT_ULP_CLASS_HID_817f2] = 1828,
	[BNXT_ULP_CLASS_HID_c0cce] = 1829,
	[BNXT_ULP_CLASS_HID_c1f6e] = 1830,
	[BNXT_ULP_CLASS_HID_c1ade] = 1831,
	[BNXT_ULP_CLASS_HID_c157e] = 1832,
	[BNXT_ULP_CLASS_HID_a0d8c] = 1833,
	[BNXT_ULP_CLASS_HID_a182c] = 1834,
	[BNXT_ULP_CLASS_HID_a1b9c] = 1835,
	[BNXT_ULP_CLASS_HID_a163c] = 1836,
	[BNXT_ULP_CLASS_HID_e0308] = 1837,
	[BNXT_ULP_CLASS_HID_e1da8] = 1838,
	[BNXT_ULP_CLASS_HID_e1918] = 1839,
	[BNXT_ULP_CLASS_HID_e0bda] = 1840,
	[BNXT_ULP_CLASS_HID_20a88] = 1841,
	[BNXT_ULP_CLASS_HID_20528] = 1842,
	[BNXT_ULP_CLASS_HID_6080c] = 1843,
	[BNXT_ULP_CLASS_HID_61aac] = 1844,
	[BNXT_ULP_CLASS_HID_31a18] = 1845,
	[BNXT_ULP_CLASS_HID_314b8] = 1846,
	[BNXT_ULP_CLASS_HID_71f9c] = 1847,
	[BNXT_ULP_CLASS_HID_70a5e] = 1848,
	[BNXT_ULP_CLASS_HID_282c0] = 1849,
	[BNXT_ULP_CLASS_HID_29d60] = 1850,
	[BNXT_ULP_CLASS_HID_68044] = 1851,
	[BNXT_ULP_CLASS_HID_692e4] = 1852,
	[BNXT_ULP_CLASS_HID_39250] = 1853,
	[BNXT_ULP_CLASS_HID_38c12] = 1854,
	[BNXT_ULP_CLASS_HID_797d4] = 1855,
	[BNXT_ULP_CLASS_HID_78196] = 1856,
	[BNXT_ULP_CLASS_HID_80f32] = 1857,
	[BNXT_ULP_CLASS_HID_81992] = 1858,
	[BNXT_ULP_CLASS_HID_80522] = 1859,
	[BNXT_ULP_CLASS_HID_81782] = 1860,
	[BNXT_ULP_CLASS_HID_c0cbe] = 1861,
	[BNXT_ULP_CLASS_HID_c1f1e] = 1862,
	[BNXT_ULP_CLASS_HID_c1aae] = 1863,
	[BNXT_ULP_CLASS_HID_c150e] = 1864,
	[BNXT_ULP_CLASS_HID_a0dfc] = 1865,
	[BNXT_ULP_CLASS_HID_a185c] = 1866,
	[BNXT_ULP_CLASS_HID_a1bec] = 1867,
	[BNXT_ULP_CLASS_HID_a164c] = 1868,
	[BNXT_ULP_CLASS_HID_e0378] = 1869,
	[BNXT_ULP_CLASS_HID_e1dd8] = 1870,
	[BNXT_ULP_CLASS_HID_e1968] = 1871,
	[BNXT_ULP_CLASS_HID_e0baa] = 1872,
	[BNXT_ULP_CLASS_HID_20af8] = 1873,
	[BNXT_ULP_CLASS_HID_20558] = 1874,
	[BNXT_ULP_CLASS_HID_6087c] = 1875,
	[BNXT_ULP_CLASS_HID_61adc] = 1876,
	[BNXT_ULP_CLASS_HID_31a68] = 1877,
	[BNXT_ULP_CLASS_HID_314c8] = 1878,
	[BNXT_ULP_CLASS_HID_71fec] = 1879,
	[BNXT_ULP_CLASS_HID_70a2e] = 1880,
	[BNXT_ULP_CLASS_HID_282b0] = 1881,
	[BNXT_ULP_CLASS_HID_29d10] = 1882,
	[BNXT_ULP_CLASS_HID_68034] = 1883,
	[BNXT_ULP_CLASS_HID_69294] = 1884,
	[BNXT_ULP_CLASS_HID_39220] = 1885,
	[BNXT_ULP_CLASS_HID_38c62] = 1886,
	[BNXT_ULP_CLASS_HID_797a4] = 1887,
	[BNXT_ULP_CLASS_HID_781e6] = 1888,
	[BNXT_ULP_CLASS_HID_0f05] = 1889,
	[BNXT_ULP_CLASS_HID_0f09] = 1890,
	[BNXT_ULP_CLASS_HID_0f06] = 1891,
	[BNXT_ULP_CLASS_HID_19a6] = 1892,
	[BNXT_ULP_CLASS_HID_0f0a] = 1893,
	[BNXT_ULP_CLASS_HID_19aa] = 1894,
	[BNXT_ULP_CLASS_HID_0f15] = 1895,
	[BNXT_ULP_CLASS_HID_0f19] = 1896,
	[BNXT_ULP_CLASS_HID_0f65] = 1897,
	[BNXT_ULP_CLASS_HID_0f69] = 1898,
	[BNXT_ULP_CLASS_HID_0f16] = 1899,
	[BNXT_ULP_CLASS_HID_19b6] = 1900,
	[BNXT_ULP_CLASS_HID_0f1a] = 1901,
	[BNXT_ULP_CLASS_HID_19ba] = 1902,
	[BNXT_ULP_CLASS_HID_0f66] = 1903,
	[BNXT_ULP_CLASS_HID_19c6] = 1904,
	[BNXT_ULP_CLASS_HID_0f6a] = 1905,
	[BNXT_ULP_CLASS_HID_19ca] = 1906
};

/* Array for the proto matcher list */
struct bnxt_ulp_class_match_info ulp_class_match_list[] = {
	[1] = {
	.class_hid = BNXT_ULP_CLASS_HID_00b8,
	.class_tid = 1,
	.hdr_sig_id = 0,
	.flow_sig_id = 4096UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_0_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_DST_ADDR }
	},
	[2] = {
	.class_hid = BNXT_ULP_CLASS_HID_0cc2,
	.class_tid = 1,
	.hdr_sig_id = 0,
	.flow_sig_id = 4104UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_0_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_0_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_DST_ADDR }
	},
	[3] = {
	.class_hid = BNXT_ULP_CLASS_HID_10e4,
	.class_tid = 1,
	.hdr_sig_id = 0,
	.flow_sig_id = 6144UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_0_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_DST_ADDR }
	},
	[4] = {
	.class_hid = BNXT_ULP_CLASS_HID_1d0e,
	.class_tid = 1,
	.hdr_sig_id = 0,
	.flow_sig_id = 6152UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_0_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_0_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_DST_ADDR }
	},
	[5] = {
	.class_hid = BNXT_ULP_CLASS_HID_0286,
	.class_tid = 1,
	.hdr_sig_id = 1,
	.flow_sig_id = 16384UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_1_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_DST_ADDR }
	},
	[6] = {
	.class_hid = BNXT_ULP_CLASS_HID_0e98,
	.class_tid = 1,
	.hdr_sig_id = 1,
	.flow_sig_id = 16392UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_1_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_1_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_DST_ADDR }
	},
	[7] = {
	.class_hid = BNXT_ULP_CLASS_HID_1666,
	.class_tid = 1,
	.hdr_sig_id = 1,
	.flow_sig_id = 24576UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_1_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_DST_ADDR }
	},
	[8] = {
	.class_hid = BNXT_ULP_CLASS_HID_02de,
	.class_tid = 1,
	.hdr_sig_id = 1,
	.flow_sig_id = 24584UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_1_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_1_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_DST_ADDR }
	},
	[9] = {
	.class_hid = BNXT_ULP_CLASS_HID_81d25,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 32768UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[10] = {
	.class_hid = BNXT_ULP_CLASS_HID_809ad,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 32776UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[11] = {
	.class_hid = BNXT_ULP_CLASS_HID_80ae3,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 32832UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[12] = {
	.class_hid = BNXT_ULP_CLASS_HID_8170d,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 32840UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[13] = {
	.class_hid = BNXT_ULP_CLASS_HID_80773,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[14] = {
	.class_hid = BNXT_ULP_CLASS_HID_8139d,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 49160UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[15] = {
	.class_hid = BNXT_ULP_CLASS_HID_814d3,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 49216UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[16] = {
	.class_hid = BNXT_ULP_CLASS_HID_8015b,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 49224UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[17] = {
	.class_hid = BNXT_ULP_CLASS_HID_21977,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 131072UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[18] = {
	.class_hid = BNXT_ULP_CLASS_HID_205ef,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 131080UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[19] = {
	.class_hid = BNXT_ULP_CLASS_HID_20735,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 131136UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[20] = {
	.class_hid = BNXT_ULP_CLASS_HID_2134f,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 131144UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[21] = {
	.class_hid = BNXT_ULP_CLASS_HID_61beb,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 196608UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[22] = {
	.class_hid = BNXT_ULP_CLASS_HID_60863,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 196616UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[23] = {
	.class_hid = BNXT_ULP_CLASS_HID_609a9,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 196672UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[24] = {
	.class_hid = BNXT_ULP_CLASS_HID_615c3,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 196680UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[25] = {
	.class_hid = BNXT_ULP_CLASS_HID_00a8,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 4096UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR }
	},
	[26] = {
	.class_hid = BNXT_ULP_CLASS_HID_0cd2,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 4104UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR }
	},
	[27] = {
	.class_hid = BNXT_ULP_CLASS_HID_10f4,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 6144UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR }
	},
	[28] = {
	.class_hid = BNXT_ULP_CLASS_HID_1d1e,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 6152UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR }
	},
	[29] = {
	.class_hid = BNXT_ULP_CLASS_HID_1488,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 12288UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT }
	},
	[30] = {
	.class_hid = BNXT_ULP_CLASS_HID_0110,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 12296UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT }
	},
	[31] = {
	.class_hid = BNXT_ULP_CLASS_HID_0532,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 14336UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT }
	},
	[32] = {
	.class_hid = BNXT_ULP_CLASS_HID_115c,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 14344UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT }
	},
	[33] = {
	.class_hid = BNXT_ULP_CLASS_HID_0ab8,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 20480UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[34] = {
	.class_hid = BNXT_ULP_CLASS_HID_16a2,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 20488UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[35] = {
	.class_hid = BNXT_ULP_CLASS_HID_1ac4,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 22528UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[36] = {
	.class_hid = BNXT_ULP_CLASS_HID_074c,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 22536UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[37] = {
	.class_hid = BNXT_ULP_CLASS_HID_1e98,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 28672UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[38] = {
	.class_hid = BNXT_ULP_CLASS_HID_0ae0,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 28680UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[39] = {
	.class_hid = BNXT_ULP_CLASS_HID_0f02,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 30720UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[40] = {
	.class_hid = BNXT_ULP_CLASS_HID_1b2c,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 30728UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[41] = {
	.class_hid = BNXT_ULP_CLASS_HID_0296,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 16384UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR }
	},
	[42] = {
	.class_hid = BNXT_ULP_CLASS_HID_0e88,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 16392UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR }
	},
	[43] = {
	.class_hid = BNXT_ULP_CLASS_HID_1676,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 24576UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR }
	},
	[44] = {
	.class_hid = BNXT_ULP_CLASS_HID_02ce,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 24584UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR }
	},
	[45] = {
	.class_hid = BNXT_ULP_CLASS_HID_8076e,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT }
	},
	[46] = {
	.class_hid = BNXT_ULP_CLASS_HID_81380,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 49160UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT }
	},
	[47] = {
	.class_hid = BNXT_ULP_CLASS_HID_81b4e,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 57344UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT }
	},
	[48] = {
	.class_hid = BNXT_ULP_CLASS_HID_807c6,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 57352UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT }
	},
	[49] = {
	.class_hid = BNXT_ULP_CLASS_HID_404ea,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 81920UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[50] = {
	.class_hid = BNXT_ULP_CLASS_HID_4110c,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 81928UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[51] = {
	.class_hid = BNXT_ULP_CLASS_HID_418ca,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 90112UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[52] = {
	.class_hid = BNXT_ULP_CLASS_HID_40542,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 90120UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[53] = {
	.class_hid = BNXT_ULP_CLASS_HID_c09e2,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 114688UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[54] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1604,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 114696UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[55] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1dc2,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 122880UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[56] = {
	.class_hid = BNXT_ULP_CLASS_HID_c0a5a,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 122888UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[57] = {
	.class_hid = BNXT_ULP_CLASS_HID_0098,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 4096UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR }
	},
	[58] = {
	.class_hid = BNXT_ULP_CLASS_HID_0ce2,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 4104UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR }
	},
	[59] = {
	.class_hid = BNXT_ULP_CLASS_HID_10c4,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 6144UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR }
	},
	[60] = {
	.class_hid = BNXT_ULP_CLASS_HID_1d2e,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 6152UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR }
	},
	[61] = {
	.class_hid = BNXT_ULP_CLASS_HID_14b8,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 12288UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT }
	},
	[62] = {
	.class_hid = BNXT_ULP_CLASS_HID_0120,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 12296UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT }
	},
	[63] = {
	.class_hid = BNXT_ULP_CLASS_HID_0502,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 14336UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT }
	},
	[64] = {
	.class_hid = BNXT_ULP_CLASS_HID_116c,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 14344UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT }
	},
	[65] = {
	.class_hid = BNXT_ULP_CLASS_HID_0a88,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 20480UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[66] = {
	.class_hid = BNXT_ULP_CLASS_HID_1692,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 20488UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[67] = {
	.class_hid = BNXT_ULP_CLASS_HID_1af4,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 22528UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[68] = {
	.class_hid = BNXT_ULP_CLASS_HID_077c,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 22536UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[69] = {
	.class_hid = BNXT_ULP_CLASS_HID_1ea8,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 28672UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[70] = {
	.class_hid = BNXT_ULP_CLASS_HID_0ad0,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 28680UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[71] = {
	.class_hid = BNXT_ULP_CLASS_HID_0f32,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 30720UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[72] = {
	.class_hid = BNXT_ULP_CLASS_HID_1b1c,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 30728UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[73] = {
	.class_hid = BNXT_ULP_CLASS_HID_02a6,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 16384UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR }
	},
	[74] = {
	.class_hid = BNXT_ULP_CLASS_HID_0eb8,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 16392UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR }
	},
	[75] = {
	.class_hid = BNXT_ULP_CLASS_HID_1646,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 24576UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR }
	},
	[76] = {
	.class_hid = BNXT_ULP_CLASS_HID_02fe,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 24584UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR }
	},
	[77] = {
	.class_hid = BNXT_ULP_CLASS_HID_8075e,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT }
	},
	[78] = {
	.class_hid = BNXT_ULP_CLASS_HID_813b0,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 49160UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT }
	},
	[79] = {
	.class_hid = BNXT_ULP_CLASS_HID_81b7e,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 57344UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT }
	},
	[80] = {
	.class_hid = BNXT_ULP_CLASS_HID_807f6,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 57352UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT }
	},
	[81] = {
	.class_hid = BNXT_ULP_CLASS_HID_404da,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 81920UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[82] = {
	.class_hid = BNXT_ULP_CLASS_HID_4113c,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 81928UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[83] = {
	.class_hid = BNXT_ULP_CLASS_HID_418fa,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 90112UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[84] = {
	.class_hid = BNXT_ULP_CLASS_HID_40572,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 90120UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[85] = {
	.class_hid = BNXT_ULP_CLASS_HID_c09d2,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 114688UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[86] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1634,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 114696UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[87] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1df2,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 122880UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[88] = {
	.class_hid = BNXT_ULP_CLASS_HID_c0a6a,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 122888UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[89] = {
	.class_hid = BNXT_ULP_CLASS_HID_81d35,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 32768UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[90] = {
	.class_hid = BNXT_ULP_CLASS_HID_809bd,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 32776UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[91] = {
	.class_hid = BNXT_ULP_CLASS_HID_80af3,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 32832UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[92] = {
	.class_hid = BNXT_ULP_CLASS_HID_8171d,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 32840UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[93] = {
	.class_hid = BNXT_ULP_CLASS_HID_80763,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[94] = {
	.class_hid = BNXT_ULP_CLASS_HID_8138d,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 49160UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[95] = {
	.class_hid = BNXT_ULP_CLASS_HID_814c3,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 49216UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[96] = {
	.class_hid = BNXT_ULP_CLASS_HID_8014b,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 49224UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[97] = {
	.class_hid = BNXT_ULP_CLASS_HID_c001f,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 98304UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[98] = {
	.class_hid = BNXT_ULP_CLASS_HID_c0c39,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 98312UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[99] = {
	.class_hid = BNXT_ULP_CLASS_HID_c0d7f,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 98368UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[100] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1999,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 98376UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[101] = {
	.class_hid = BNXT_ULP_CLASS_HID_c09ef,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 114688UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[102] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1609,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 114696UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[103] = {
	.class_hid = BNXT_ULP_CLASS_HID_c174f,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 114752UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[104] = {
	.class_hid = BNXT_ULP_CLASS_HID_c03d7,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 114760UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[105] = {
	.class_hid = BNXT_ULP_CLASS_HID_a1e73,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 163840UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[106] = {
	.class_hid = BNXT_ULP_CLASS_HID_a0afb,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 163848UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[107] = {
	.class_hid = BNXT_ULP_CLASS_HID_a0c31,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 163904UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[108] = {
	.class_hid = BNXT_ULP_CLASS_HID_a185b,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 163912UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[109] = {
	.class_hid = BNXT_ULP_CLASS_HID_a08a1,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 180224UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[110] = {
	.class_hid = BNXT_ULP_CLASS_HID_a14cb,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 180232UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[111] = {
	.class_hid = BNXT_ULP_CLASS_HID_a1601,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 180288UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[112] = {
	.class_hid = BNXT_ULP_CLASS_HID_a0289,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 180296UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[113] = {
	.class_hid = BNXT_ULP_CLASS_HID_e015d,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 229376UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[114] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0d47,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 229384UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[115] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0ebd,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 229440UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[116] = {
	.class_hid = BNXT_ULP_CLASS_HID_e1aa7,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 229448UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[117] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0b2d,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 245760UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[118] = {
	.class_hid = BNXT_ULP_CLASS_HID_e1757,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 245768UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[119] = {
	.class_hid = BNXT_ULP_CLASS_HID_e188d,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 245824UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[120] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0515,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 245832UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[121] = {
	.class_hid = BNXT_ULP_CLASS_HID_21967,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 131072UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[122] = {
	.class_hid = BNXT_ULP_CLASS_HID_205ff,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 131080UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[123] = {
	.class_hid = BNXT_ULP_CLASS_HID_20725,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 131136UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[124] = {
	.class_hid = BNXT_ULP_CLASS_HID_2135f,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 131144UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[125] = {
	.class_hid = BNXT_ULP_CLASS_HID_61bfb,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 196608UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[126] = {
	.class_hid = BNXT_ULP_CLASS_HID_60873,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 196616UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[127] = {
	.class_hid = BNXT_ULP_CLASS_HID_609b9,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 196672UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[128] = {
	.class_hid = BNXT_ULP_CLASS_HID_615d3,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 196680UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[129] = {
	.class_hid = BNXT_ULP_CLASS_HID_30a55,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 393216UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[130] = {
	.class_hid = BNXT_ULP_CLASS_HID_3164f,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 393224UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[131] = {
	.class_hid = BNXT_ULP_CLASS_HID_317b5,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 393280UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[132] = {
	.class_hid = BNXT_ULP_CLASS_HID_3040d,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 393288UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[133] = {
	.class_hid = BNXT_ULP_CLASS_HID_70ca9,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 458752UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[134] = {
	.class_hid = BNXT_ULP_CLASS_HID_718c3,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 458760UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[135] = {
	.class_hid = BNXT_ULP_CLASS_HID_71a09,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 458816UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[136] = {
	.class_hid = BNXT_ULP_CLASS_HID_70681,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 458824UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[137] = {
	.class_hid = BNXT_ULP_CLASS_HID_2821d,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 655360UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[138] = {
	.class_hid = BNXT_ULP_CLASS_HID_28e37,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 655368UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[139] = {
	.class_hid = BNXT_ULP_CLASS_HID_28f7d,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 655424UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[140] = {
	.class_hid = BNXT_ULP_CLASS_HID_29b97,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 655432UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[141] = {
	.class_hid = BNXT_ULP_CLASS_HID_68491,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 720896UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[142] = {
	.class_hid = BNXT_ULP_CLASS_HID_6908b,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 720904UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[143] = {
	.class_hid = BNXT_ULP_CLASS_HID_691f1,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 720960UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[144] = {
	.class_hid = BNXT_ULP_CLASS_HID_69deb,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 720968UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[145] = {
	.class_hid = BNXT_ULP_CLASS_HID_3926d,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 917504UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[146] = {
	.class_hid = BNXT_ULP_CLASS_HID_39e87,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 917512UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[147] = {
	.class_hid = BNXT_ULP_CLASS_HID_38023,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 917568UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[148] = {
	.class_hid = BNXT_ULP_CLASS_HID_38c45,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 917576UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[149] = {
	.class_hid = BNXT_ULP_CLASS_HID_794e1,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 983040UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[150] = {
	.class_hid = BNXT_ULP_CLASS_HID_78179,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 983048UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[151] = {
	.class_hid = BNXT_ULP_CLASS_HID_782a7,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 983104UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[152] = {
	.class_hid = BNXT_ULP_CLASS_HID_78ed9,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 983112UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[153] = {
	.class_hid = BNXT_ULP_CLASS_HID_81d05,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 32768UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[154] = {
	.class_hid = BNXT_ULP_CLASS_HID_8098d,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 32776UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[155] = {
	.class_hid = BNXT_ULP_CLASS_HID_80ac3,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 32832UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[156] = {
	.class_hid = BNXT_ULP_CLASS_HID_8172d,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 32840UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[157] = {
	.class_hid = BNXT_ULP_CLASS_HID_80753,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[158] = {
	.class_hid = BNXT_ULP_CLASS_HID_813bd,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 49160UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[159] = {
	.class_hid = BNXT_ULP_CLASS_HID_814f3,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 49216UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[160] = {
	.class_hid = BNXT_ULP_CLASS_HID_8017b,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 49224UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[161] = {
	.class_hid = BNXT_ULP_CLASS_HID_c002f,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 98304UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[162] = {
	.class_hid = BNXT_ULP_CLASS_HID_c0c09,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 98312UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[163] = {
	.class_hid = BNXT_ULP_CLASS_HID_c0d4f,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 98368UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[164] = {
	.class_hid = BNXT_ULP_CLASS_HID_c19a9,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 98376UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[165] = {
	.class_hid = BNXT_ULP_CLASS_HID_c09df,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 114688UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[166] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1639,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 114696UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[167] = {
	.class_hid = BNXT_ULP_CLASS_HID_c177f,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 114752UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[168] = {
	.class_hid = BNXT_ULP_CLASS_HID_c03e7,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 114760UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[169] = {
	.class_hid = BNXT_ULP_CLASS_HID_a1e43,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 163840UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[170] = {
	.class_hid = BNXT_ULP_CLASS_HID_a0acb,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 163848UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[171] = {
	.class_hid = BNXT_ULP_CLASS_HID_a0c01,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 163904UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[172] = {
	.class_hid = BNXT_ULP_CLASS_HID_a186b,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 163912UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[173] = {
	.class_hid = BNXT_ULP_CLASS_HID_a0891,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 180224UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[174] = {
	.class_hid = BNXT_ULP_CLASS_HID_a14fb,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 180232UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[175] = {
	.class_hid = BNXT_ULP_CLASS_HID_a1631,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 180288UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[176] = {
	.class_hid = BNXT_ULP_CLASS_HID_a02b9,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 180296UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[177] = {
	.class_hid = BNXT_ULP_CLASS_HID_e016d,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 229376UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[178] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0d77,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 229384UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[179] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0e8d,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 229440UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[180] = {
	.class_hid = BNXT_ULP_CLASS_HID_e1a97,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 229448UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[181] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0b1d,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 245760UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[182] = {
	.class_hid = BNXT_ULP_CLASS_HID_e1767,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 245768UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[183] = {
	.class_hid = BNXT_ULP_CLASS_HID_e18bd,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 245824UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[184] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0525,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 245832UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[185] = {
	.class_hid = BNXT_ULP_CLASS_HID_21957,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 131072UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[186] = {
	.class_hid = BNXT_ULP_CLASS_HID_205cf,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 131080UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[187] = {
	.class_hid = BNXT_ULP_CLASS_HID_20715,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 131136UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[188] = {
	.class_hid = BNXT_ULP_CLASS_HID_2136f,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 131144UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[189] = {
	.class_hid = BNXT_ULP_CLASS_HID_61bcb,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 196608UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[190] = {
	.class_hid = BNXT_ULP_CLASS_HID_60843,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 196616UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[191] = {
	.class_hid = BNXT_ULP_CLASS_HID_60989,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 196672UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[192] = {
	.class_hid = BNXT_ULP_CLASS_HID_615e3,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 196680UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[193] = {
	.class_hid = BNXT_ULP_CLASS_HID_30a65,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 393216UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[194] = {
	.class_hid = BNXT_ULP_CLASS_HID_3167f,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 393224UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[195] = {
	.class_hid = BNXT_ULP_CLASS_HID_31785,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 393280UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[196] = {
	.class_hid = BNXT_ULP_CLASS_HID_3043d,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 393288UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[197] = {
	.class_hid = BNXT_ULP_CLASS_HID_70c99,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 458752UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[198] = {
	.class_hid = BNXT_ULP_CLASS_HID_718f3,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 458760UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[199] = {
	.class_hid = BNXT_ULP_CLASS_HID_71a39,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 458816UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[200] = {
	.class_hid = BNXT_ULP_CLASS_HID_706b1,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 458824UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[201] = {
	.class_hid = BNXT_ULP_CLASS_HID_2822d,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 655360UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[202] = {
	.class_hid = BNXT_ULP_CLASS_HID_28e07,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 655368UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[203] = {
	.class_hid = BNXT_ULP_CLASS_HID_28f4d,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 655424UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[204] = {
	.class_hid = BNXT_ULP_CLASS_HID_29ba7,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 655432UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[205] = {
	.class_hid = BNXT_ULP_CLASS_HID_684a1,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 720896UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[206] = {
	.class_hid = BNXT_ULP_CLASS_HID_690bb,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 720904UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[207] = {
	.class_hid = BNXT_ULP_CLASS_HID_691c1,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 720960UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[208] = {
	.class_hid = BNXT_ULP_CLASS_HID_69ddb,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 720968UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[209] = {
	.class_hid = BNXT_ULP_CLASS_HID_3925d,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 917504UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[210] = {
	.class_hid = BNXT_ULP_CLASS_HID_39eb7,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 917512UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[211] = {
	.class_hid = BNXT_ULP_CLASS_HID_38013,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 917568UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[212] = {
	.class_hid = BNXT_ULP_CLASS_HID_38c75,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 917576UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[213] = {
	.class_hid = BNXT_ULP_CLASS_HID_794d1,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 983040UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[214] = {
	.class_hid = BNXT_ULP_CLASS_HID_78149,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 983048UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[215] = {
	.class_hid = BNXT_ULP_CLASS_HID_78297,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 983104UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[216] = {
	.class_hid = BNXT_ULP_CLASS_HID_78ee9,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 983112UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[217] = {
	.class_hid = BNXT_ULP_CLASS_HID_0816,
	.class_tid = 1,
	.hdr_sig_id = 0,
	.flow_sig_id = 4096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_DST_ADDR }
	},
	[218] = {
	.class_hid = BNXT_ULP_CLASS_HID_1852,
	.class_tid = 1,
	.hdr_sig_id = 0,
	.flow_sig_id = 6144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_0_BITMASK_O_IPV6_DST_ADDR }
	},
	[219] = {
	.class_hid = BNXT_ULP_CLASS_HID_09f4,
	.class_tid = 1,
	.hdr_sig_id = 1,
	.flow_sig_id = 16384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_DST_ADDR }
	},
	[220] = {
	.class_hid = BNXT_ULP_CLASS_HID_1dd4,
	.class_tid = 1,
	.hdr_sig_id = 1,
	.flow_sig_id = 24576UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_1_BITMASK_O_IPV4_DST_ADDR }
	},
	[221] = {
	.class_hid = BNXT_ULP_CLASS_HID_804f1,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 32768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[222] = {
	.class_hid = BNXT_ULP_CLASS_HID_81251,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 32832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[223] = {
	.class_hid = BNXT_ULP_CLASS_HID_80ee1,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[224] = {
	.class_hid = BNXT_ULP_CLASS_HID_81c41,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 49216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_2_BITMASK_O_IPV6_DST_ADDR }
	},
	[225] = {
	.class_hid = BNXT_ULP_CLASS_HID_2013b,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 131072UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[226] = {
	.class_hid = BNXT_ULP_CLASS_HID_20e9b,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 131136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[227] = {
	.class_hid = BNXT_ULP_CLASS_HID_603bf,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 196608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[228] = {
	.class_hid = BNXT_ULP_CLASS_HID_6111f,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 196672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_3_BITMASK_O_IPV4_DST_ADDR }
	},
	[229] = {
	.class_hid = BNXT_ULP_CLASS_HID_0806,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 4096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR }
	},
	[230] = {
	.class_hid = BNXT_ULP_CLASS_HID_1842,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 6144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR }
	},
	[231] = {
	.class_hid = BNXT_ULP_CLASS_HID_1be6,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 12288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT }
	},
	[232] = {
	.class_hid = BNXT_ULP_CLASS_HID_0c80,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 14336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT }
	},
	[233] = {
	.class_hid = BNXT_ULP_CLASS_HID_1216,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 20480UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[234] = {
	.class_hid = BNXT_ULP_CLASS_HID_02b0,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 22528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[235] = {
	.class_hid = BNXT_ULP_CLASS_HID_0654,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 28672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[236] = {
	.class_hid = BNXT_ULP_CLASS_HID_1690,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 30720UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_4_BITMASK_O_TCP_DST_PORT }
	},
	[237] = {
	.class_hid = BNXT_ULP_CLASS_HID_09e4,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 16384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR }
	},
	[238] = {
	.class_hid = BNXT_ULP_CLASS_HID_1dc4,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 24576UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR }
	},
	[239] = {
	.class_hid = BNXT_ULP_CLASS_HID_80efc,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT }
	},
	[240] = {
	.class_hid = BNXT_ULP_CLASS_HID_80332,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 57344UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT }
	},
	[241] = {
	.class_hid = BNXT_ULP_CLASS_HID_40c78,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 81920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[242] = {
	.class_hid = BNXT_ULP_CLASS_HID_400be,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 90112UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[243] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1170,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 114688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[244] = {
	.class_hid = BNXT_ULP_CLASS_HID_c05b6,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 122880UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_5_BITMASK_O_TCP_DST_PORT }
	},
	[245] = {
	.class_hid = BNXT_ULP_CLASS_HID_0836,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 4096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR }
	},
	[246] = {
	.class_hid = BNXT_ULP_CLASS_HID_1872,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 6144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR }
	},
	[247] = {
	.class_hid = BNXT_ULP_CLASS_HID_1bd6,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 12288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT }
	},
	[248] = {
	.class_hid = BNXT_ULP_CLASS_HID_0cb0,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 14336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT }
	},
	[249] = {
	.class_hid = BNXT_ULP_CLASS_HID_1226,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 20480UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[250] = {
	.class_hid = BNXT_ULP_CLASS_HID_0280,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 22528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[251] = {
	.class_hid = BNXT_ULP_CLASS_HID_0664,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 28672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[252] = {
	.class_hid = BNXT_ULP_CLASS_HID_16a0,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 30720UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_6_BITMASK_O_UDP_DST_PORT }
	},
	[253] = {
	.class_hid = BNXT_ULP_CLASS_HID_09d4,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 16384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR }
	},
	[254] = {
	.class_hid = BNXT_ULP_CLASS_HID_1df4,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 24576UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR }
	},
	[255] = {
	.class_hid = BNXT_ULP_CLASS_HID_80ecc,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT }
	},
	[256] = {
	.class_hid = BNXT_ULP_CLASS_HID_80302,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 57344UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT }
	},
	[257] = {
	.class_hid = BNXT_ULP_CLASS_HID_40c48,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 81920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[258] = {
	.class_hid = BNXT_ULP_CLASS_HID_4008e,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 90112UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[259] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1140,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 114688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[260] = {
	.class_hid = BNXT_ULP_CLASS_HID_c0586,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 122880UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_7_BITMASK_O_UDP_DST_PORT }
	},
	[261] = {
	.class_hid = BNXT_ULP_CLASS_HID_804e1,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 32768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[262] = {
	.class_hid = BNXT_ULP_CLASS_HID_81241,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 32832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[263] = {
	.class_hid = BNXT_ULP_CLASS_HID_80ef1,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[264] = {
	.class_hid = BNXT_ULP_CLASS_HID_81c51,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 49216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR }
	},
	[265] = {
	.class_hid = BNXT_ULP_CLASS_HID_c076d,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 98304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[266] = {
	.class_hid = BNXT_ULP_CLASS_HID_c14cd,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 98368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[267] = {
	.class_hid = BNXT_ULP_CLASS_HID_c117d,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 114688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[268] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1edd,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 114752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT }
	},
	[269] = {
	.class_hid = BNXT_ULP_CLASS_HID_a062f,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 163840UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[270] = {
	.class_hid = BNXT_ULP_CLASS_HID_a138f,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 163904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[271] = {
	.class_hid = BNXT_ULP_CLASS_HID_a103f,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 180224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[272] = {
	.class_hid = BNXT_ULP_CLASS_HID_a1d9f,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 180288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[273] = {
	.class_hid = BNXT_ULP_CLASS_HID_e08ab,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 229376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[274] = {
	.class_hid = BNXT_ULP_CLASS_HID_e160b,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 229440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[275] = {
	.class_hid = BNXT_ULP_CLASS_HID_e12bb,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 245760UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[276] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0079,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 245824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_8_BITMASK_O_TCP_DST_PORT }
	},
	[277] = {
	.class_hid = BNXT_ULP_CLASS_HID_2012b,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 131072UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[278] = {
	.class_hid = BNXT_ULP_CLASS_HID_20e8b,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 131136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[279] = {
	.class_hid = BNXT_ULP_CLASS_HID_603af,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 196608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[280] = {
	.class_hid = BNXT_ULP_CLASS_HID_6110f,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 196672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR }
	},
	[281] = {
	.class_hid = BNXT_ULP_CLASS_HID_311bb,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 393216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[282] = {
	.class_hid = BNXT_ULP_CLASS_HID_31f1b,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 393280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[283] = {
	.class_hid = BNXT_ULP_CLASS_HID_7143f,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 458752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[284] = {
	.class_hid = BNXT_ULP_CLASS_HID_701fd,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 458816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT }
	},
	[285] = {
	.class_hid = BNXT_ULP_CLASS_HID_28963,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 655360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[286] = {
	.class_hid = BNXT_ULP_CLASS_HID_296c3,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 655424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[287] = {
	.class_hid = BNXT_ULP_CLASS_HID_68be7,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 720896UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[288] = {
	.class_hid = BNXT_ULP_CLASS_HID_69947,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 720960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[289] = {
	.class_hid = BNXT_ULP_CLASS_HID_399f3,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 917504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[290] = {
	.class_hid = BNXT_ULP_CLASS_HID_387b1,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 917568UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[291] = {
	.class_hid = BNXT_ULP_CLASS_HID_79c77,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 983040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[292] = {
	.class_hid = BNXT_ULP_CLASS_HID_78a35,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 983104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF_0_1_9_BITMASK_O_TCP_DST_PORT }
	},
	[293] = {
	.class_hid = BNXT_ULP_CLASS_HID_804d1,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 32768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[294] = {
	.class_hid = BNXT_ULP_CLASS_HID_81271,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 32832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[295] = {
	.class_hid = BNXT_ULP_CLASS_HID_80ec1,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 49152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[296] = {
	.class_hid = BNXT_ULP_CLASS_HID_81c61,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 49216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR }
	},
	[297] = {
	.class_hid = BNXT_ULP_CLASS_HID_c075d,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 98304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[298] = {
	.class_hid = BNXT_ULP_CLASS_HID_c14fd,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 98368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[299] = {
	.class_hid = BNXT_ULP_CLASS_HID_c114d,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 114688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[300] = {
	.class_hid = BNXT_ULP_CLASS_HID_c1eed,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 114752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT }
	},
	[301] = {
	.class_hid = BNXT_ULP_CLASS_HID_a061f,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 163840UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[302] = {
	.class_hid = BNXT_ULP_CLASS_HID_a13bf,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 163904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[303] = {
	.class_hid = BNXT_ULP_CLASS_HID_a100f,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 180224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[304] = {
	.class_hid = BNXT_ULP_CLASS_HID_a1daf,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 180288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[305] = {
	.class_hid = BNXT_ULP_CLASS_HID_e089b,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 229376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[306] = {
	.class_hid = BNXT_ULP_CLASS_HID_e163b,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 229440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[307] = {
	.class_hid = BNXT_ULP_CLASS_HID_e128b,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 245760UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[308] = {
	.class_hid = BNXT_ULP_CLASS_HID_e0049,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 245824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_10_BITMASK_O_UDP_DST_PORT }
	},
	[309] = {
	.class_hid = BNXT_ULP_CLASS_HID_2011b,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 131072UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[310] = {
	.class_hid = BNXT_ULP_CLASS_HID_20ebb,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 131136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[311] = {
	.class_hid = BNXT_ULP_CLASS_HID_6039f,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 196608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[312] = {
	.class_hid = BNXT_ULP_CLASS_HID_6113f,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 196672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR }
	},
	[313] = {
	.class_hid = BNXT_ULP_CLASS_HID_3118b,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 393216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[314] = {
	.class_hid = BNXT_ULP_CLASS_HID_31f2b,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 393280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[315] = {
	.class_hid = BNXT_ULP_CLASS_HID_7140f,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 458752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[316] = {
	.class_hid = BNXT_ULP_CLASS_HID_701cd,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 458816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT }
	},
	[317] = {
	.class_hid = BNXT_ULP_CLASS_HID_28953,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 655360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[318] = {
	.class_hid = BNXT_ULP_CLASS_HID_296f3,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 655424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[319] = {
	.class_hid = BNXT_ULP_CLASS_HID_68bd7,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 720896UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[320] = {
	.class_hid = BNXT_ULP_CLASS_HID_69977,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 720960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[321] = {
	.class_hid = BNXT_ULP_CLASS_HID_399c3,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 917504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[322] = {
	.class_hid = BNXT_ULP_CLASS_HID_38781,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 917568UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[323] = {
	.class_hid = BNXT_ULP_CLASS_HID_79c47,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 983040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[324] = {
	.class_hid = BNXT_ULP_CLASS_HID_78a05,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 983104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF_0_1_11_BITMASK_O_UDP_DST_PORT }
	},
	[325] = {
	.class_hid = BNXT_ULP_CLASS_HID_04a4,
	.class_tid = 1,
	.hdr_sig_id = 0,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_0_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_0_BITMASK_O_ETH_SMAC }
	},
	[326] = {
	.class_hid = BNXT_ULP_CLASS_HID_04a8,
	.class_tid = 1,
	.hdr_sig_id = 1,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_1_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_1_BITMASK_O_ETH_SMAC }
	},
	[327] = {
	.class_hid = BNXT_ULP_CLASS_HID_04a5,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_SMAC }
	},
	[328] = {
	.class_hid = BNXT_ULP_CLASS_HID_1205,
	.class_tid = 1,
	.hdr_sig_id = 2,
	.flow_sig_id = 72UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_2_BITMASK_OO_VLAN_VID }
	},
	[329] = {
	.class_hid = BNXT_ULP_CLASS_HID_04a9,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_SMAC }
	},
	[330] = {
	.class_hid = BNXT_ULP_CLASS_HID_1209,
	.class_tid = 1,
	.hdr_sig_id = 3,
	.flow_sig_id = 72UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_3_BITMASK_OO_VLAN_VID }
	},
	[331] = {
	.class_hid = BNXT_ULP_CLASS_HID_04b4,
	.class_tid = 1,
	.hdr_sig_id = 4,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_4_BITMASK_O_ETH_SMAC }
	},
	[332] = {
	.class_hid = BNXT_ULP_CLASS_HID_04b8,
	.class_tid = 1,
	.hdr_sig_id = 5,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_5_BITMASK_O_ETH_SMAC }
	},
	[333] = {
	.class_hid = BNXT_ULP_CLASS_HID_0484,
	.class_tid = 1,
	.hdr_sig_id = 6,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_6_BITMASK_O_ETH_SMAC }
	},
	[334] = {
	.class_hid = BNXT_ULP_CLASS_HID_0488,
	.class_tid = 1,
	.hdr_sig_id = 7,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_7_BITMASK_O_ETH_SMAC }
	},
	[335] = {
	.class_hid = BNXT_ULP_CLASS_HID_04b5,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC }
	},
	[336] = {
	.class_hid = BNXT_ULP_CLASS_HID_1215,
	.class_tid = 1,
	.hdr_sig_id = 8,
	.flow_sig_id = 72UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_8_BITMASK_OO_VLAN_VID }
	},
	[337] = {
	.class_hid = BNXT_ULP_CLASS_HID_04b9,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC }
	},
	[338] = {
	.class_hid = BNXT_ULP_CLASS_HID_1219,
	.class_tid = 1,
	.hdr_sig_id = 9,
	.flow_sig_id = 72UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_9_BITMASK_OO_VLAN_VID }
	},
	[339] = {
	.class_hid = BNXT_ULP_CLASS_HID_0485,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC }
	},
	[340] = {
	.class_hid = BNXT_ULP_CLASS_HID_1225,
	.class_tid = 1,
	.hdr_sig_id = 10,
	.flow_sig_id = 72UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_10_BITMASK_OO_VLAN_VID }
	},
	[341] = {
	.class_hid = BNXT_ULP_CLASS_HID_0489,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 8UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC }
	},
	[342] = {
	.class_hid = BNXT_ULP_CLASS_HID_1229,
	.class_tid = 1,
	.hdr_sig_id = 11,
	.flow_sig_id = 72UL,
	.flow_pattern_id = 2,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_1_11_BITMASK_OO_VLAN_VID }
	},
	[343] = {
	.class_hid = BNXT_ULP_CLASS_HID_0226,
	.class_tid = 1,
	.hdr_sig_id = 12,
	.flow_sig_id = 16384UL,
	.flow_pattern_id = 3,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_12_BITMASK_O_IPV4_DST_ADDR }
	},
	[344] = {
	.class_hid = BNXT_ULP_CLASS_HID_4045a,
	.class_tid = 1,
	.hdr_sig_id = 12,
	.flow_sig_id = 81920UL,
	.flow_pattern_id = 3,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_1_12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_1_12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_1_12_BITMASK_O_UDP_DST_PORT }
	},
	[345] = {
	.class_hid = BNXT_ULP_CLASS_HID_0daa,
	.class_tid = 2,
	.hdr_sig_id = 0,
	.flow_sig_id = 20480UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_0_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_2_0_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_0_BITMASK_O_UDP_DST_PORT }
	},
	[346] = {
	.class_hid = BNXT_ULP_CLASS_HID_11b0,
	.class_tid = 2,
	.hdr_sig_id = 0,
	.flow_sig_id = 20488UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_0_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_2_0_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_2_0_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_0_BITMASK_O_UDP_DST_PORT }
	},
	[347] = {
	.class_hid = BNXT_ULP_CLASS_HID_403f8,
	.class_tid = 2,
	.hdr_sig_id = 1,
	.flow_sig_id = 81920UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_1_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_2_1_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_1_BITMASK_O_UDP_DST_PORT }
	},
	[348] = {
	.class_hid = BNXT_ULP_CLASS_HID_4161e,
	.class_tid = 2,
	.hdr_sig_id = 1,
	.flow_sig_id = 81928UL,
	.flow_pattern_id = 0,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_1_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF_0_2_1_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF_0_2_1_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_1_BITMASK_O_UDP_DST_PORT }
	},
	[349] = {
	.class_hid = BNXT_ULP_CLASS_HID_40439,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 66304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI }
	},
	[350] = {
	.class_hid = BNXT_ULP_CLASS_HID_41405,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 68352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI }
	},
	[351] = {
	.class_hid = BNXT_ULP_CLASS_HID_51449,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 328448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC }
	},
	[352] = {
	.class_hid = BNXT_ULP_CLASS_HID_50b33,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 330496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC }
	},
	[353] = {
	.class_hid = BNXT_ULP_CLASS_HID_48c01,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 590592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC }
	},
	[354] = {
	.class_hid = BNXT_ULP_CLASS_HID_483eb,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 592640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC }
	},
	[355] = {
	.class_hid = BNXT_ULP_CLASS_HID_5833f,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 852736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC }
	},
	[356] = {
	.class_hid = BNXT_ULP_CLASS_HID_5937b,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 854784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC }
	},
	[357] = {
	.class_hid = BNXT_ULP_CLASS_HID_41875,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 134284032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR }
	},
	[358] = {
	.class_hid = BNXT_ULP_CLASS_HID_40f5f,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 134286080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR }
	},
	[359] = {
	.class_hid = BNXT_ULP_CLASS_HID_50f23,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 134546176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR }
	},
	[360] = {
	.class_hid = BNXT_ULP_CLASS_HID_51f6f,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 134548224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR }
	},
	[361] = {
	.class_hid = BNXT_ULP_CLASS_HID_4875b,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 134808320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR }
	},
	[362] = {
	.class_hid = BNXT_ULP_CLASS_HID_49727,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 134810368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR }
	},
	[363] = {
	.class_hid = BNXT_ULP_CLASS_HID_5976b,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 135070464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR }
	},
	[364] = {
	.class_hid = BNXT_ULP_CLASS_HID_58655,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 135072512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR }
	},
	[365] = {
	.class_hid = BNXT_ULP_CLASS_HID_4125f,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 268501760UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[366] = {
	.class_hid = BNXT_ULP_CLASS_HID_401f9,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 268503808UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[367] = {
	.class_hid = BNXT_ULP_CLASS_HID_501cd,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 268763904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[368] = {
	.class_hid = BNXT_ULP_CLASS_HID_51149,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 268765952UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[369] = {
	.class_hid = BNXT_ULP_CLASS_HID_49a67,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 269026048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[370] = {
	.class_hid = BNXT_ULP_CLASS_HID_489c1,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 269028096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[371] = {
	.class_hid = BNXT_ULP_CLASS_HID_58955,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 269288192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[372] = {
	.class_hid = BNXT_ULP_CLASS_HID_59951,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 269290240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[373] = {
	.class_hid = BNXT_ULP_CLASS_HID_40569,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 402719488UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[374] = {
	.class_hid = BNXT_ULP_CLASS_HID_41575,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 402721536UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[375] = {
	.class_hid = BNXT_ULP_CLASS_HID_51579,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 402981632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[376] = {
	.class_hid = BNXT_ULP_CLASS_HID_50463,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 402983680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[377] = {
	.class_hid = BNXT_ULP_CLASS_HID_48d71,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 403243776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[378] = {
	.class_hid = BNXT_ULP_CLASS_HID_49d7d,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 403245824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[379] = {
	.class_hid = BNXT_ULP_CLASS_HID_59d41,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 403505920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[380] = {
	.class_hid = BNXT_ULP_CLASS_HID_58c6b,
	.class_tid = 2,
	.hdr_sig_id = 2,
	.flow_sig_id = 403507968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_2_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_2_BITMASK_I_IPV6_DST_ADDR }
	},
	[381] = {
	.class_hid = BNXT_ULP_CLASS_HID_10255,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 265216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI }
	},
	[382] = {
	.class_hid = BNXT_ULP_CLASS_HID_11675,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 273408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI }
	},
	[383] = {
	.class_hid = BNXT_ULP_CLASS_HID_14649,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1313792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC }
	},
	[384] = {
	.class_hid = BNXT_ULP_CLASS_HID_15a69,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1321984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC }
	},
	[385] = {
	.class_hid = BNXT_ULP_CLASS_HID_1205b,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 2362368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC }
	},
	[386] = {
	.class_hid = BNXT_ULP_CLASS_HID_1347b,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 2370560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC }
	},
	[387] = {
	.class_hid = BNXT_ULP_CLASS_HID_16bbf,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 3410944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC }
	},
	[388] = {
	.class_hid = BNXT_ULP_CLASS_HID_1785f,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 3419136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC }
	},
	[389] = {
	.class_hid = BNXT_ULP_CLASS_HID_11551,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 537136128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR }
	},
	[390] = {
	.class_hid = BNXT_ULP_CLASS_HID_10897,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 537144320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR }
	},
	[391] = {
	.class_hid = BNXT_ULP_CLASS_HID_15955,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 538184704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR }
	},
	[392] = {
	.class_hid = BNXT_ULP_CLASS_HID_14c8b,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 538192896UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR }
	},
	[393] = {
	.class_hid = BNXT_ULP_CLASS_HID_13b47,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 539233280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR }
	},
	[394] = {
	.class_hid = BNXT_ULP_CLASS_HID_12e85,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 539241472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR }
	},
	[395] = {
	.class_hid = BNXT_ULP_CLASS_HID_17f5b,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 540281856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR }
	},
	[396] = {
	.class_hid = BNXT_ULP_CLASS_HID_17299,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 540290048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR }
	},
	[397] = {
	.class_hid = BNXT_ULP_CLASS_HID_10fe7,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1074007040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[398] = {
	.class_hid = BNXT_ULP_CLASS_HID_10325,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1074015232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[399] = {
	.class_hid = BNXT_ULP_CLASS_HID_153cb,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1075055616UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[400] = {
	.class_hid = BNXT_ULP_CLASS_HID_14709,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1075063808UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[401] = {
	.class_hid = BNXT_ULP_CLASS_HID_12dc5,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1076104192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[402] = {
	.class_hid = BNXT_ULP_CLASS_HID_1212b,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1076112384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[403] = {
	.class_hid = BNXT_ULP_CLASS_HID_171c9,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1077152768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[404] = {
	.class_hid = BNXT_ULP_CLASS_HID_1650f,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1077160960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[405] = {
	.class_hid = BNXT_ULP_CLASS_HID_10201,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1610877952UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[406] = {
	.class_hid = BNXT_ULP_CLASS_HID_116c1,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1610886144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[407] = {
	.class_hid = BNXT_ULP_CLASS_HID_14605,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1611926528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[408] = {
	.class_hid = BNXT_ULP_CLASS_HID_15a05,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1611934720UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[409] = {
	.class_hid = BNXT_ULP_CLASS_HID_12007,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1612975104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[410] = {
	.class_hid = BNXT_ULP_CLASS_HID_13407,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1612983296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[411] = {
	.class_hid = BNXT_ULP_CLASS_HID_1640b,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1614023680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[412] = {
	.class_hid = BNXT_ULP_CLASS_HID_1780b,
	.class_tid = 2,
	.hdr_sig_id = 3,
	.flow_sig_id = 1614031872UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_3_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_3_BITMASK_I_IPV6_DST_ADDR }
	},
	[413] = {
	.class_hid = BNXT_ULP_CLASS_HID_404b0,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 66304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI }
	},
	[414] = {
	.class_hid = BNXT_ULP_CLASS_HID_4148c,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 68352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI }
	},
	[415] = {
	.class_hid = BNXT_ULP_CLASS_HID_514c0,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 328448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC }
	},
	[416] = {
	.class_hid = BNXT_ULP_CLASS_HID_50bba,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 330496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC }
	},
	[417] = {
	.class_hid = BNXT_ULP_CLASS_HID_48c88,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 590592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC }
	},
	[418] = {
	.class_hid = BNXT_ULP_CLASS_HID_48362,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 592640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC }
	},
	[419] = {
	.class_hid = BNXT_ULP_CLASS_HID_583b6,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 852736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC }
	},
	[420] = {
	.class_hid = BNXT_ULP_CLASS_HID_593f2,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 854784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC }
	},
	[421] = {
	.class_hid = BNXT_ULP_CLASS_HID_41f54,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 536937216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR }
	},
	[422] = {
	.class_hid = BNXT_ULP_CLASS_HID_40fce,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 536939264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR }
	},
	[423] = {
	.class_hid = BNXT_ULP_CLASS_HID_50e02,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 537199360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR }
	},
	[424] = {
	.class_hid = BNXT_ULP_CLASS_HID_51e5e,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 537201408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR }
	},
	[425] = {
	.class_hid = BNXT_ULP_CLASS_HID_487ca,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 537461504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR }
	},
	[426] = {
	.class_hid = BNXT_ULP_CLASS_HID_49606,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 537463552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR }
	},
	[427] = {
	.class_hid = BNXT_ULP_CLASS_HID_5965a,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 537723648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR }
	},
	[428] = {
	.class_hid = BNXT_ULP_CLASS_HID_58514,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 537725696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR }
	},
	[429] = {
	.class_hid = BNXT_ULP_CLASS_HID_412c2,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1073808128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[430] = {
	.class_hid = BNXT_ULP_CLASS_HID_401ac,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1073810176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[431] = {
	.class_hid = BNXT_ULP_CLASS_HID_501e0,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1074070272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[432] = {
	.class_hid = BNXT_ULP_CLASS_HID_511cc,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1074072320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[433] = {
	.class_hid = BNXT_ULP_CLASS_HID_4990a,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1074332416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[434] = {
	.class_hid = BNXT_ULP_CLASS_HID_489e4,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1074334464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[435] = {
	.class_hid = BNXT_ULP_CLASS_HID_589c8,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1074594560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[436] = {
	.class_hid = BNXT_ULP_CLASS_HID_59804,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1074596608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[437] = {
	.class_hid = BNXT_ULP_CLASS_HID_40404,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1610679040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[438] = {
	.class_hid = BNXT_ULP_CLASS_HID_41440,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1610681088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[439] = {
	.class_hid = BNXT_ULP_CLASS_HID_51484,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1610941184UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[440] = {
	.class_hid = BNXT_ULP_CLASS_HID_50b0e,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1610943232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[441] = {
	.class_hid = BNXT_ULP_CLASS_HID_48c4c,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1611203328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[442] = {
	.class_hid = BNXT_ULP_CLASS_HID_48306,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1611205376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[443] = {
	.class_hid = BNXT_ULP_CLASS_HID_5830a,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1611465472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[444] = {
	.class_hid = BNXT_ULP_CLASS_HID_59346,
	.class_tid = 2,
	.hdr_sig_id = 4,
	.flow_sig_id = 1611467520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_4_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_4_BITMASK_I_IPV4_DST_ADDR }
	},
	[445] = {
	.class_hid = BNXT_ULP_CLASS_HID_102cc,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 265216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI }
	},
	[446] = {
	.class_hid = BNXT_ULP_CLASS_HID_116ec,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 273408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI }
	},
	[447] = {
	.class_hid = BNXT_ULP_CLASS_HID_146d0,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 1313792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC }
	},
	[448] = {
	.class_hid = BNXT_ULP_CLASS_HID_15af0,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 1321984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC }
	},
	[449] = {
	.class_hid = BNXT_ULP_CLASS_HID_120c2,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2362368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC }
	},
	[450] = {
	.class_hid = BNXT_ULP_CLASS_HID_134e2,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2370560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC }
	},
	[451] = {
	.class_hid = BNXT_ULP_CLASS_HID_16b26,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 3410944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC }
	},
	[452] = {
	.class_hid = BNXT_ULP_CLASS_HID_178c6,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 3419136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC }
	},
	[453] = {
	.class_hid = BNXT_ULP_CLASS_HID_115c6,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2147748864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR }
	},
	[454] = {
	.class_hid = BNXT_ULP_CLASS_HID_10804,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2147757056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR }
	},
	[455] = {
	.class_hid = BNXT_ULP_CLASS_HID_15822,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2148797440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR }
	},
	[456] = {
	.class_hid = BNXT_ULP_CLASS_HID_14c60,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2148805632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR }
	},
	[457] = {
	.class_hid = BNXT_ULP_CLASS_HID_13bd4,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2149846016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR }
	},
	[458] = {
	.class_hid = BNXT_ULP_CLASS_HID_12e12,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2149854208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR }
	},
	[459] = {
	.class_hid = BNXT_ULP_CLASS_HID_17e30,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2150894592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR }
	},
	[460] = {
	.class_hid = BNXT_ULP_CLASS_HID_17276,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 2150902784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR }
	},
	[461] = {
	.class_hid = BNXT_ULP_CLASS_HID_11f1a,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 4295232512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[462] = {
	.class_hid = BNXT_ULP_CLASS_HID_11358,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 4295240704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[463] = {
	.class_hid = BNXT_ULP_CLASS_HID_14398,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 4296281088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[464] = {
	.class_hid = BNXT_ULP_CLASS_HID_157b8,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 4296289280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[465] = {
	.class_hid = BNXT_ULP_CLASS_HID_13d68,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 4297329664UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[466] = {
	.class_hid = BNXT_ULP_CLASS_HID_131aa,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 4297337856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[467] = {
	.class_hid = BNXT_ULP_CLASS_HID_16192,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 4298378240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[468] = {
	.class_hid = BNXT_ULP_CLASS_HID_175b2,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 4298386432UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[469] = {
	.class_hid = BNXT_ULP_CLASS_HID_112b2,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 6442716160UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[470] = {
	.class_hid = BNXT_ULP_CLASS_HID_106f0,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 6442724352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[471] = {
	.class_hid = BNXT_ULP_CLASS_HID_15692,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 6443764736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[472] = {
	.class_hid = BNXT_ULP_CLASS_HID_14ad0,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 6443772928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[473] = {
	.class_hid = BNXT_ULP_CLASS_HID_13080,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 6444813312UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[474] = {
	.class_hid = BNXT_ULP_CLASS_HID_124c2,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 6444821504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[475] = {
	.class_hid = BNXT_ULP_CLASS_HID_174e0,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 6445861888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[476] = {
	.class_hid = BNXT_ULP_CLASS_HID_16f22,
	.class_tid = 2,
	.hdr_sig_id = 5,
	.flow_sig_id = 6445870080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_5_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_5_BITMASK_I_IPV4_DST_ADDR }
	},
	[477] = {
	.class_hid = BNXT_ULP_CLASS_HID_4025b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 66304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI }
	},
	[478] = {
	.class_hid = BNXT_ULP_CLASS_HID_41267,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 68352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI }
	},
	[479] = {
	.class_hid = BNXT_ULP_CLASS_HID_5122b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 328448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC }
	},
	[480] = {
	.class_hid = BNXT_ULP_CLASS_HID_50d51,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 330496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC }
	},
	[481] = {
	.class_hid = BNXT_ULP_CLASS_HID_48a63,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 590592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC }
	},
	[482] = {
	.class_hid = BNXT_ULP_CLASS_HID_48589,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 592640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC }
	},
	[483] = {
	.class_hid = BNXT_ULP_CLASS_HID_5855d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 852736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC }
	},
	[484] = {
	.class_hid = BNXT_ULP_CLASS_HID_59519,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 854784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC }
	},
	[485] = {
	.class_hid = BNXT_ULP_CLASS_HID_41e17,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 134284032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR }
	},
	[486] = {
	.class_hid = BNXT_ULP_CLASS_HID_4093d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 134286080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR }
	},
	[487] = {
	.class_hid = BNXT_ULP_CLASS_HID_50941,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 134546176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR }
	},
	[488] = {
	.class_hid = BNXT_ULP_CLASS_HID_5190d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 134548224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR }
	},
	[489] = {
	.class_hid = BNXT_ULP_CLASS_HID_48139,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 134808320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR }
	},
	[490] = {
	.class_hid = BNXT_ULP_CLASS_HID_49145,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 134810368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR }
	},
	[491] = {
	.class_hid = BNXT_ULP_CLASS_HID_59109,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 135070464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR }
	},
	[492] = {
	.class_hid = BNXT_ULP_CLASS_HID_58037,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 135072512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR }
	},
	[493] = {
	.class_hid = BNXT_ULP_CLASS_HID_4143d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 268501760UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[494] = {
	.class_hid = BNXT_ULP_CLASS_HID_4079b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 268503808UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[495] = {
	.class_hid = BNXT_ULP_CLASS_HID_507af,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 268763904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[496] = {
	.class_hid = BNXT_ULP_CLASS_HID_5172b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 268765952UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[497] = {
	.class_hid = BNXT_ULP_CLASS_HID_49c05,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 269026048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[498] = {
	.class_hid = BNXT_ULP_CLASS_HID_48fa3,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 269028096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[499] = {
	.class_hid = BNXT_ULP_CLASS_HID_58f37,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 269288192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[500] = {
	.class_hid = BNXT_ULP_CLASS_HID_59f33,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 269290240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[501] = {
	.class_hid = BNXT_ULP_CLASS_HID_4030b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 402719488UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[502] = {
	.class_hid = BNXT_ULP_CLASS_HID_41317,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 402721536UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[503] = {
	.class_hid = BNXT_ULP_CLASS_HID_5131b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 402981632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[504] = {
	.class_hid = BNXT_ULP_CLASS_HID_50201,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 402983680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[505] = {
	.class_hid = BNXT_ULP_CLASS_HID_48b13,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 403243776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[506] = {
	.class_hid = BNXT_ULP_CLASS_HID_49b1f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 403245824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[507] = {
	.class_hid = BNXT_ULP_CLASS_HID_59b23,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 403505920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[508] = {
	.class_hid = BNXT_ULP_CLASS_HID_58a09,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 403507968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR }
	},
	[509] = {
	.class_hid = BNXT_ULP_CLASS_HID_419bf,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 536937216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[510] = {
	.class_hid = BNXT_ULP_CLASS_HID_40925,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 536939264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[511] = {
	.class_hid = BNXT_ULP_CLASS_HID_508e9,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 537199360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[512] = {
	.class_hid = BNXT_ULP_CLASS_HID_518b5,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 537201408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[513] = {
	.class_hid = BNXT_ULP_CLASS_HID_48121,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 537461504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[514] = {
	.class_hid = BNXT_ULP_CLASS_HID_490ed,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 537463552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[515] = {
	.class_hid = BNXT_ULP_CLASS_HID_590b1,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 537723648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[516] = {
	.class_hid = BNXT_ULP_CLASS_HID_583ff,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 537725696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[517] = {
	.class_hid = BNXT_ULP_CLASS_HID_41475,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 671154944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[518] = {
	.class_hid = BNXT_ULP_CLASS_HID_40473,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 671156992UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[519] = {
	.class_hid = BNXT_ULP_CLASS_HID_50427,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 671417088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[520] = {
	.class_hid = BNXT_ULP_CLASS_HID_51763,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 671419136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[521] = {
	.class_hid = BNXT_ULP_CLASS_HID_49c3d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 671679232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[522] = {
	.class_hid = BNXT_ULP_CLASS_HID_48c3b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 671681280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[523] = {
	.class_hid = BNXT_ULP_CLASS_HID_58f6f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 671941376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[524] = {
	.class_hid = BNXT_ULP_CLASS_HID_59f2b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 671943424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[525] = {
	.class_hid = BNXT_ULP_CLASS_HID_40333,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 805372672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[526] = {
	.class_hid = BNXT_ULP_CLASS_HID_412bf,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 805374720UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[527] = {
	.class_hid = BNXT_ULP_CLASS_HID_512a3,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 805634816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[528] = {
	.class_hid = BNXT_ULP_CLASS_HID_50229,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 805636864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[529] = {
	.class_hid = BNXT_ULP_CLASS_HID_48abb,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 805896960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[530] = {
	.class_hid = BNXT_ULP_CLASS_HID_49aa7,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 805899008UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[531] = {
	.class_hid = BNXT_ULP_CLASS_HID_59a2b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 806159104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[532] = {
	.class_hid = BNXT_ULP_CLASS_HID_595b1,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 806161152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[533] = {
	.class_hid = BNXT_ULP_CLASS_HID_41e2f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 939590400UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[534] = {
	.class_hid = BNXT_ULP_CLASS_HID_40e35,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 939592448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[535] = {
	.class_hid = BNXT_ULP_CLASS_HID_50939,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 939852544UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[536] = {
	.class_hid = BNXT_ULP_CLASS_HID_51925,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 939854592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[537] = {
	.class_hid = BNXT_ULP_CLASS_HID_48631,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 940114688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[538] = {
	.class_hid = BNXT_ULP_CLASS_HID_4913d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 940116736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[539] = {
	.class_hid = BNXT_ULP_CLASS_HID_59121,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 940376832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[540] = {
	.class_hid = BNXT_ULP_CLASS_HID_5812f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 940378880UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT }
	},
	[541] = {
	.class_hid = BNXT_ULP_CLASS_HID_41429,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1073808128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[542] = {
	.class_hid = BNXT_ULP_CLASS_HID_40747,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1073810176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[543] = {
	.class_hid = BNXT_ULP_CLASS_HID_5070b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1074070272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[544] = {
	.class_hid = BNXT_ULP_CLASS_HID_51727,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1074072320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[545] = {
	.class_hid = BNXT_ULP_CLASS_HID_49fe1,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1074332416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[546] = {
	.class_hid = BNXT_ULP_CLASS_HID_48f0f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1074334464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[547] = {
	.class_hid = BNXT_ULP_CLASS_HID_58f23,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1074594560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[548] = {
	.class_hid = BNXT_ULP_CLASS_HID_59eef,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1074596608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[549] = {
	.class_hid = BNXT_ULP_CLASS_HID_40347,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1208025856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[550] = {
	.class_hid = BNXT_ULP_CLASS_HID_41303,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1208027904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[551] = {
	.class_hid = BNXT_ULP_CLASS_HID_51247,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1208288000UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[552] = {
	.class_hid = BNXT_ULP_CLASS_HID_5026d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1208290048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[553] = {
	.class_hid = BNXT_ULP_CLASS_HID_48b0f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1208550144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[554] = {
	.class_hid = BNXT_ULP_CLASS_HID_49a4b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1208552192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[555] = {
	.class_hid = BNXT_ULP_CLASS_HID_59a0f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1208812288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[556] = {
	.class_hid = BNXT_ULP_CLASS_HID_58a05,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1208814336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[557] = {
	.class_hid = BNXT_ULP_CLASS_HID_41983,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1342243584UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[558] = {
	.class_hid = BNXT_ULP_CLASS_HID_40929,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1342245632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[559] = {
	.class_hid = BNXT_ULP_CLASS_HID_5092d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1342505728UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[560] = {
	.class_hid = BNXT_ULP_CLASS_HID_518a9,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1342507776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[561] = {
	.class_hid = BNXT_ULP_CLASS_HID_48125,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1342767872UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[562] = {
	.class_hid = BNXT_ULP_CLASS_HID_49121,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1342769920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[563] = {
	.class_hid = BNXT_ULP_CLASS_HID_59085,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1343030016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[564] = {
	.class_hid = BNXT_ULP_CLASS_HID_58023,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1343032064UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[565] = {
	.class_hid = BNXT_ULP_CLASS_HID_41509,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1476461312UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[566] = {
	.class_hid = BNXT_ULP_CLASS_HID_40407,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1476463360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[567] = {
	.class_hid = BNXT_ULP_CLASS_HID_5040b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1476723456UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[568] = {
	.class_hid = BNXT_ULP_CLASS_HID_51407,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1476725504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[569] = {
	.class_hid = BNXT_ULP_CLASS_HID_49d21,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1476985600UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[570] = {
	.class_hid = BNXT_ULP_CLASS_HID_48c0f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1476987648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[571] = {
	.class_hid = BNXT_ULP_CLASS_HID_58c03,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1477247744UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[572] = {
	.class_hid = BNXT_ULP_CLASS_HID_59f0f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1477249792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[573] = {
	.class_hid = BNXT_ULP_CLASS_HID_402ef,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1610679040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[574] = {
	.class_hid = BNXT_ULP_CLASS_HID_412ab,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1610681088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[575] = {
	.class_hid = BNXT_ULP_CLASS_HID_5126f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1610941184UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[576] = {
	.class_hid = BNXT_ULP_CLASS_HID_50de5,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1610943232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[577] = {
	.class_hid = BNXT_ULP_CLASS_HID_48aa7,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1611203328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[578] = {
	.class_hid = BNXT_ULP_CLASS_HID_485ed,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1611205376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[579] = {
	.class_hid = BNXT_ULP_CLASS_HID_585e1,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1611465472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[580] = {
	.class_hid = BNXT_ULP_CLASS_HID_595ad,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1611467520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[581] = {
	.class_hid = BNXT_ULP_CLASS_HID_41e6b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1744896768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[582] = {
	.class_hid = BNXT_ULP_CLASS_HID_40961,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1744898816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[583] = {
	.class_hid = BNXT_ULP_CLASS_HID_50925,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1745158912UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[584] = {
	.class_hid = BNXT_ULP_CLASS_HID_51961,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1745160960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[585] = {
	.class_hid = BNXT_ULP_CLASS_HID_4816d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1745421056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[586] = {
	.class_hid = BNXT_ULP_CLASS_HID_49129,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1745423104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[587] = {
	.class_hid = BNXT_ULP_CLASS_HID_5916d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1745683200UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[588] = {
	.class_hid = BNXT_ULP_CLASS_HID_5806b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1745685248UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[589] = {
	.class_hid = BNXT_ULP_CLASS_HID_414a1,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1879114496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[590] = {
	.class_hid = BNXT_ULP_CLASS_HID_4042f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1879116544UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[591] = {
	.class_hid = BNXT_ULP_CLASS_HID_507a3,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1879376640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[592] = {
	.class_hid = BNXT_ULP_CLASS_HID_517af,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1879378688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[593] = {
	.class_hid = BNXT_ULP_CLASS_HID_49c29,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1879638784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[594] = {
	.class_hid = BNXT_ULP_CLASS_HID_48fa7,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1879640832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[595] = {
	.class_hid = BNXT_ULP_CLASS_HID_58fab,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1879900928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[596] = {
	.class_hid = BNXT_ULP_CLASS_HID_59f27,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 1879902976UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[597] = {
	.class_hid = BNXT_ULP_CLASS_HID_4032f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 2013332224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[598] = {
	.class_hid = BNXT_ULP_CLASS_HID_4132b,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 2013334272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[599] = {
	.class_hid = BNXT_ULP_CLASS_HID_5132f,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 2013594368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[600] = {
	.class_hid = BNXT_ULP_CLASS_HID_50225,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 2013596416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[601] = {
	.class_hid = BNXT_ULP_CLASS_HID_48b27,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 2013856512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[602] = {
	.class_hid = BNXT_ULP_CLASS_HID_49b23,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 2013858560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[603] = {
	.class_hid = BNXT_ULP_CLASS_HID_59b27,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 2014118656UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[604] = {
	.class_hid = BNXT_ULP_CLASS_HID_58a2d,
	.class_tid = 2,
	.hdr_sig_id = 6,
	.flow_sig_id = 2014120704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_6_BITMASK_I_TCP_DST_PORT }
	},
	[605] = {
	.class_hid = BNXT_ULP_CLASS_HID_10437,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 265216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI }
	},
	[606] = {
	.class_hid = BNXT_ULP_CLASS_HID_11017,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 273408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI }
	},
	[607] = {
	.class_hid = BNXT_ULP_CLASS_HID_1402b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1313792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC }
	},
	[608] = {
	.class_hid = BNXT_ULP_CLASS_HID_15c0b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1321984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC }
	},
	[609] = {
	.class_hid = BNXT_ULP_CLASS_HID_12639,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2362368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC }
	},
	[610] = {
	.class_hid = BNXT_ULP_CLASS_HID_13219,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2370560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC }
	},
	[611] = {
	.class_hid = BNXT_ULP_CLASS_HID_16ddd,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3410944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC }
	},
	[612] = {
	.class_hid = BNXT_ULP_CLASS_HID_17e3d,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3419136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC }
	},
	[613] = {
	.class_hid = BNXT_ULP_CLASS_HID_11333,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 537136128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR }
	},
	[614] = {
	.class_hid = BNXT_ULP_CLASS_HID_10ef5,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 537144320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR }
	},
	[615] = {
	.class_hid = BNXT_ULP_CLASS_HID_15f37,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 538184704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR }
	},
	[616] = {
	.class_hid = BNXT_ULP_CLASS_HID_14ae9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 538192896UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR }
	},
	[617] = {
	.class_hid = BNXT_ULP_CLASS_HID_13d25,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 539233280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR }
	},
	[618] = {
	.class_hid = BNXT_ULP_CLASS_HID_128e7,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 539241472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR }
	},
	[619] = {
	.class_hid = BNXT_ULP_CLASS_HID_17939,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 540281856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR }
	},
	[620] = {
	.class_hid = BNXT_ULP_CLASS_HID_174fb,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 540290048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR }
	},
	[621] = {
	.class_hid = BNXT_ULP_CLASS_HID_10985,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1074007040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[622] = {
	.class_hid = BNXT_ULP_CLASS_HID_10547,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1074015232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[623] = {
	.class_hid = BNXT_ULP_CLASS_HID_155a9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1075055616UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[624] = {
	.class_hid = BNXT_ULP_CLASS_HID_1416b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1075063808UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[625] = {
	.class_hid = BNXT_ULP_CLASS_HID_12ba7,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1076104192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[626] = {
	.class_hid = BNXT_ULP_CLASS_HID_12749,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1076112384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[627] = {
	.class_hid = BNXT_ULP_CLASS_HID_177ab,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1077152768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[628] = {
	.class_hid = BNXT_ULP_CLASS_HID_1636d,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1077160960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[629] = {
	.class_hid = BNXT_ULP_CLASS_HID_10463,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1610877952UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[630] = {
	.class_hid = BNXT_ULP_CLASS_HID_110a3,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1610886144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[631] = {
	.class_hid = BNXT_ULP_CLASS_HID_14067,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1611926528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[632] = {
	.class_hid = BNXT_ULP_CLASS_HID_15c67,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1611934720UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[633] = {
	.class_hid = BNXT_ULP_CLASS_HID_12665,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1612975104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[634] = {
	.class_hid = BNXT_ULP_CLASS_HID_13265,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1612983296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[635] = {
	.class_hid = BNXT_ULP_CLASS_HID_16269,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1614023680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[636] = {
	.class_hid = BNXT_ULP_CLASS_HID_17e69,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 1614031872UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR }
	},
	[637] = {
	.class_hid = BNXT_ULP_CLASS_HID_1133d,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2147748864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[638] = {
	.class_hid = BNXT_ULP_CLASS_HID_10eff,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2147757056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[639] = {
	.class_hid = BNXT_ULP_CLASS_HID_15ed9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2148797440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[640] = {
	.class_hid = BNXT_ULP_CLASS_HID_14a9b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2148805632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[641] = {
	.class_hid = BNXT_ULP_CLASS_HID_13d2f,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2149846016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[642] = {
	.class_hid = BNXT_ULP_CLASS_HID_128e9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2149854208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[643] = {
	.class_hid = BNXT_ULP_CLASS_HID_178cb,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2150894592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[644] = {
	.class_hid = BNXT_ULP_CLASS_HID_1748d,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2150902784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[645] = {
	.class_hid = BNXT_ULP_CLASS_HID_109fb,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2684619776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[646] = {
	.class_hid = BNXT_ULP_CLASS_HID_105bd,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2684627968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[647] = {
	.class_hid = BNXT_ULP_CLASS_HID_155bf,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2685668352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[648] = {
	.class_hid = BNXT_ULP_CLASS_HID_14179,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2685676544UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[649] = {
	.class_hid = BNXT_ULP_CLASS_HID_12bed,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2686716928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[650] = {
	.class_hid = BNXT_ULP_CLASS_HID_127af,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2686725120UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[651] = {
	.class_hid = BNXT_ULP_CLASS_HID_177a9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2687765504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[652] = {
	.class_hid = BNXT_ULP_CLASS_HID_1636b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 2687773696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[653] = {
	.class_hid = BNXT_ULP_CLASS_HID_1046d,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3221490688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[654] = {
	.class_hid = BNXT_ULP_CLASS_HID_1104d,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3221498880UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[655] = {
	.class_hid = BNXT_ULP_CLASS_HID_14009,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3222539264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[656] = {
	.class_hid = BNXT_ULP_CLASS_HID_15c69,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3222547456UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[657] = {
	.class_hid = BNXT_ULP_CLASS_HID_1260f,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3223587840UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[658] = {
	.class_hid = BNXT_ULP_CLASS_HID_1326f,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3223596032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[659] = {
	.class_hid = BNXT_ULP_CLASS_HID_1622b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3224636416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[660] = {
	.class_hid = BNXT_ULP_CLASS_HID_17e0b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3224644608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[661] = {
	.class_hid = BNXT_ULP_CLASS_HID_11369,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3758361600UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[662] = {
	.class_hid = BNXT_ULP_CLASS_HID_10f2b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3758369792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[663] = {
	.class_hid = BNXT_ULP_CLASS_HID_15f6d,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3759410176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[664] = {
	.class_hid = BNXT_ULP_CLASS_HID_14b2f,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3759418368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[665] = {
	.class_hid = BNXT_ULP_CLASS_HID_13d6b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3760458752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[666] = {
	.class_hid = BNXT_ULP_CLASS_HID_1292d,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3760466944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[667] = {
	.class_hid = BNXT_ULP_CLASS_HID_1792f,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3761507328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[668] = {
	.class_hid = BNXT_ULP_CLASS_HID_174e9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 3761515520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT }
	},
	[669] = {
	.class_hid = BNXT_ULP_CLASS_HID_119e1,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4295232512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[670] = {
	.class_hid = BNXT_ULP_CLASS_HID_115a3,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4295240704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[671] = {
	.class_hid = BNXT_ULP_CLASS_HID_14563,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4296281088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[672] = {
	.class_hid = BNXT_ULP_CLASS_HID_15143,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4296289280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[673] = {
	.class_hid = BNXT_ULP_CLASS_HID_13b93,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4297329664UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[674] = {
	.class_hid = BNXT_ULP_CLASS_HID_13751,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4297337856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[675] = {
	.class_hid = BNXT_ULP_CLASS_HID_16769,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4298378240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[676] = {
	.class_hid = BNXT_ULP_CLASS_HID_17349,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4298386432UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[677] = {
	.class_hid = BNXT_ULP_CLASS_HID_114ab,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4832103424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[678] = {
	.class_hid = BNXT_ULP_CLASS_HID_10061,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4832111616UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[679] = {
	.class_hid = BNXT_ULP_CLASS_HID_15063,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4833152000UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[680] = {
	.class_hid = BNXT_ULP_CLASS_HID_14c21,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4833160192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[681] = {
	.class_hid = BNXT_ULP_CLASS_HID_13671,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4834200576UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[682] = {
	.class_hid = BNXT_ULP_CLASS_HID_12233,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4834208768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[683] = {
	.class_hid = BNXT_ULP_CLASS_HID_17271,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4835249152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[684] = {
	.class_hid = BNXT_ULP_CLASS_HID_16e33,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 4835257344UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[685] = {
	.class_hid = BNXT_ULP_CLASS_HID_102c1,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5368974336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[686] = {
	.class_hid = BNXT_ULP_CLASS_HID_11f21,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5368982528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[687] = {
	.class_hid = BNXT_ULP_CLASS_HID_14ee1,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5370022912UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[688] = {
	.class_hid = BNXT_ULP_CLASS_HID_15ac1,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5370031104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[689] = {
	.class_hid = BNXT_ULP_CLASS_HID_12cc3,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5371071488UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[690] = {
	.class_hid = BNXT_ULP_CLASS_HID_13923,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5371079680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[691] = {
	.class_hid = BNXT_ULP_CLASS_HID_168e3,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5372120064UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[692] = {
	.class_hid = BNXT_ULP_CLASS_HID_164a9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5372128256UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[693] = {
	.class_hid = BNXT_ULP_CLASS_HID_11e29,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5905845248UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[694] = {
	.class_hid = BNXT_ULP_CLASS_HID_115eb,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5905853440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[695] = {
	.class_hid = BNXT_ULP_CLASS_HID_145a3,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5906893824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[696] = {
	.class_hid = BNXT_ULP_CLASS_HID_151a3,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5906902016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[697] = {
	.class_hid = BNXT_ULP_CLASS_HID_1382b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5907942400UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[698] = {
	.class_hid = BNXT_ULP_CLASS_HID_137e1,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5907950592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[699] = {
	.class_hid = BNXT_ULP_CLASS_HID_167a1,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5908990976UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[700] = {
	.class_hid = BNXT_ULP_CLASS_HID_173a1,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 5908999168UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[701] = {
	.class_hid = BNXT_ULP_CLASS_HID_11449,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6442716160UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[702] = {
	.class_hid = BNXT_ULP_CLASS_HID_1000b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6442724352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[703] = {
	.class_hid = BNXT_ULP_CLASS_HID_15069,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6443764736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[704] = {
	.class_hid = BNXT_ULP_CLASS_HID_14c2b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6443772928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[705] = {
	.class_hid = BNXT_ULP_CLASS_HID_1367b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6444813312UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[706] = {
	.class_hid = BNXT_ULP_CLASS_HID_12239,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6444821504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[707] = {
	.class_hid = BNXT_ULP_CLASS_HID_1721b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6445861888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[708] = {
	.class_hid = BNXT_ULP_CLASS_HID_169d9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6445870080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[709] = {
	.class_hid = BNXT_ULP_CLASS_HID_1033b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6979587072UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[710] = {
	.class_hid = BNXT_ULP_CLASS_HID_11f3b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6979595264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[711] = {
	.class_hid = BNXT_ULP_CLASS_HID_14f2b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6980635648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[712] = {
	.class_hid = BNXT_ULP_CLASS_HID_15b2b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6980643840UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[713] = {
	.class_hid = BNXT_ULP_CLASS_HID_12d39,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6981684224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[714] = {
	.class_hid = BNXT_ULP_CLASS_HID_13939,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6981692416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[715] = {
	.class_hid = BNXT_ULP_CLASS_HID_168f9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6982732800UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[716] = {
	.class_hid = BNXT_ULP_CLASS_HID_164bb,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 6982740992UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[717] = {
	.class_hid = BNXT_ULP_CLASS_HID_119cb,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 7516457984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[718] = {
	.class_hid = BNXT_ULP_CLASS_HID_11589,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 7516466176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[719] = {
	.class_hid = BNXT_ULP_CLASS_HID_14549,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 7517506560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[720] = {
	.class_hid = BNXT_ULP_CLASS_HID_151a9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 7517514752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[721] = {
	.class_hid = BNXT_ULP_CLASS_HID_13bc9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 7518555136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[722] = {
	.class_hid = BNXT_ULP_CLASS_HID_1378b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 7518563328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[723] = {
	.class_hid = BNXT_ULP_CLASS_HID_1674b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 7519603712UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[724] = {
	.class_hid = BNXT_ULP_CLASS_HID_173ab,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 7519611904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[725] = {
	.class_hid = BNXT_ULP_CLASS_HID_114a9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 8053328896UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[726] = {
	.class_hid = BNXT_ULP_CLASS_HID_1006b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 8053337088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[727] = {
	.class_hid = BNXT_ULP_CLASS_HID_150a9,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 8054377472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[728] = {
	.class_hid = BNXT_ULP_CLASS_HID_14c6b,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 8054385664UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[729] = {
	.class_hid = BNXT_ULP_CLASS_HID_136ab,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 8055426048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[730] = {
	.class_hid = BNXT_ULP_CLASS_HID_12269,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 8055434240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[731] = {
	.class_hid = BNXT_ULP_CLASS_HID_172ab,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 8056474624UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[732] = {
	.class_hid = BNXT_ULP_CLASS_HID_16e69,
	.class_tid = 2,
	.hdr_sig_id = 7,
	.flow_sig_id = 8056482816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_7_BITMASK_I_TCP_DST_PORT }
	},
	[733] = {
	.class_hid = BNXT_ULP_CLASS_HID_402d2,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 66304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI }
	},
	[734] = {
	.class_hid = BNXT_ULP_CLASS_HID_412ee,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 68352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI }
	},
	[735] = {
	.class_hid = BNXT_ULP_CLASS_HID_512a2,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 328448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC }
	},
	[736] = {
	.class_hid = BNXT_ULP_CLASS_HID_50dd8,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 330496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC }
	},
	[737] = {
	.class_hid = BNXT_ULP_CLASS_HID_48aea,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 590592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC }
	},
	[738] = {
	.class_hid = BNXT_ULP_CLASS_HID_48500,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 592640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC }
	},
	[739] = {
	.class_hid = BNXT_ULP_CLASS_HID_585d4,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 852736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC }
	},
	[740] = {
	.class_hid = BNXT_ULP_CLASS_HID_59590,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 854784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC }
	},
	[741] = {
	.class_hid = BNXT_ULP_CLASS_HID_41936,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 536937216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR }
	},
	[742] = {
	.class_hid = BNXT_ULP_CLASS_HID_409ac,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 536939264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR }
	},
	[743] = {
	.class_hid = BNXT_ULP_CLASS_HID_50860,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 537199360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR }
	},
	[744] = {
	.class_hid = BNXT_ULP_CLASS_HID_5183c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 537201408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR }
	},
	[745] = {
	.class_hid = BNXT_ULP_CLASS_HID_481a8,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 537461504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR }
	},
	[746] = {
	.class_hid = BNXT_ULP_CLASS_HID_49064,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 537463552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR }
	},
	[747] = {
	.class_hid = BNXT_ULP_CLASS_HID_59038,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 537723648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR }
	},
	[748] = {
	.class_hid = BNXT_ULP_CLASS_HID_58376,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 537725696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR }
	},
	[749] = {
	.class_hid = BNXT_ULP_CLASS_HID_414a0,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1073808128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[750] = {
	.class_hid = BNXT_ULP_CLASS_HID_407ce,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1073810176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[751] = {
	.class_hid = BNXT_ULP_CLASS_HID_50782,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1074070272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[752] = {
	.class_hid = BNXT_ULP_CLASS_HID_517ae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1074072320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[753] = {
	.class_hid = BNXT_ULP_CLASS_HID_49f68,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1074332416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[754] = {
	.class_hid = BNXT_ULP_CLASS_HID_48f86,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1074334464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[755] = {
	.class_hid = BNXT_ULP_CLASS_HID_58faa,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1074594560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[756] = {
	.class_hid = BNXT_ULP_CLASS_HID_59e66,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1074596608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[757] = {
	.class_hid = BNXT_ULP_CLASS_HID_40266,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1610679040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[758] = {
	.class_hid = BNXT_ULP_CLASS_HID_41222,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1610681088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[759] = {
	.class_hid = BNXT_ULP_CLASS_HID_512e6,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1610941184UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[760] = {
	.class_hid = BNXT_ULP_CLASS_HID_50d6c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1610943232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[761] = {
	.class_hid = BNXT_ULP_CLASS_HID_48a2e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1611203328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[762] = {
	.class_hid = BNXT_ULP_CLASS_HID_48564,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1611205376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[763] = {
	.class_hid = BNXT_ULP_CLASS_HID_58568,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1611465472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[764] = {
	.class_hid = BNXT_ULP_CLASS_HID_59524,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 1611467520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR }
	},
	[765] = {
	.class_hid = BNXT_ULP_CLASS_HID_419d8,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2147549952UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[766] = {
	.class_hid = BNXT_ULP_CLASS_HID_4087e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2147552000UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[767] = {
	.class_hid = BNXT_ULP_CLASS_HID_5080a,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2147812096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[768] = {
	.class_hid = BNXT_ULP_CLASS_HID_518ce,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2147814144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[769] = {
	.class_hid = BNXT_ULP_CLASS_HID_4807a,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2148074240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[770] = {
	.class_hid = BNXT_ULP_CLASS_HID_4900e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2148076288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[771] = {
	.class_hid = BNXT_ULP_CLASS_HID_590ca,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2148336384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[772] = {
	.class_hid = BNXT_ULP_CLASS_HID_58378,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2148338432UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[773] = {
	.class_hid = BNXT_ULP_CLASS_HID_414be,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2684420864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[774] = {
	.class_hid = BNXT_ULP_CLASS_HID_4073c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2684422912UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[775] = {
	.class_hid = BNXT_ULP_CLASS_HID_507e8,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2684683008UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[776] = {
	.class_hid = BNXT_ULP_CLASS_HID_517ac,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2684685056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[777] = {
	.class_hid = BNXT_ULP_CLASS_HID_49f7e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2684945152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[778] = {
	.class_hid = BNXT_ULP_CLASS_HID_48fec,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2684947200UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[779] = {
	.class_hid = BNXT_ULP_CLASS_HID_58fa8,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2685207296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[780] = {
	.class_hid = BNXT_ULP_CLASS_HID_59e7c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 2685209344UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[781] = {
	.class_hid = BNXT_ULP_CLASS_HID_40208,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3221291776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[782] = {
	.class_hid = BNXT_ULP_CLASS_HID_412cc,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3221293824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[783] = {
	.class_hid = BNXT_ULP_CLASS_HID_51288,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3221553920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[784] = {
	.class_hid = BNXT_ULP_CLASS_HID_50d2e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3221555968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[785] = {
	.class_hid = BNXT_ULP_CLASS_HID_48ac8,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3221816064UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[786] = {
	.class_hid = BNXT_ULP_CLASS_HID_4856e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3221818112UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[787] = {
	.class_hid = BNXT_ULP_CLASS_HID_5852a,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3222078208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[788] = {
	.class_hid = BNXT_ULP_CLASS_HID_595ce,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3222080256UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[789] = {
	.class_hid = BNXT_ULP_CLASS_HID_4196c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3758162688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[790] = {
	.class_hid = BNXT_ULP_CLASS_HID_409aa,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3758164736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[791] = {
	.class_hid = BNXT_ULP_CLASS_HID_5086e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3758424832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[792] = {
	.class_hid = BNXT_ULP_CLASS_HID_5182a,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3758426880UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[793] = {
	.class_hid = BNXT_ULP_CLASS_HID_481ae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3758686976UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[794] = {
	.class_hid = BNXT_ULP_CLASS_HID_4906a,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3758689024UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[795] = {
	.class_hid = BNXT_ULP_CLASS_HID_5902e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3758949120UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[796] = {
	.class_hid = BNXT_ULP_CLASS_HID_580ac,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 3758951168UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT }
	},
	[797] = {
	.class_hid = BNXT_ULP_CLASS_HID_40766,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4295033600UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[798] = {
	.class_hid = BNXT_ULP_CLASS_HID_41726,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4295035648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[799] = {
	.class_hid = BNXT_ULP_CLASS_HID_517f6,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4295295744UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[800] = {
	.class_hid = BNXT_ULP_CLASS_HID_5066c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4295297792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[801] = {
	.class_hid = BNXT_ULP_CLASS_HID_48f3e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4295557888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[802] = {
	.class_hid = BNXT_ULP_CLASS_HID_49ffe,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4295559936UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[803] = {
	.class_hid = BNXT_ULP_CLASS_HID_59f8e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4295820032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[804] = {
	.class_hid = BNXT_ULP_CLASS_HID_58e24,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4295822080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[805] = {
	.class_hid = BNXT_ULP_CLASS_HID_4126e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4831904512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[806] = {
	.class_hid = BNXT_ULP_CLASS_HID_402e4,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4831906560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[807] = {
	.class_hid = BNXT_ULP_CLASS_HID_502b4,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4832166656UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[808] = {
	.class_hid = BNXT_ULP_CLASS_HID_51d74,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4832168704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[809] = {
	.class_hid = BNXT_ULP_CLASS_HID_49a26,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4832428800UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[810] = {
	.class_hid = BNXT_ULP_CLASS_HID_48abc,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4832430848UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[811] = {
	.class_hid = BNXT_ULP_CLASS_HID_5956c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4832690944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[812] = {
	.class_hid = BNXT_ULP_CLASS_HID_585ee,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 4832692992UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[813] = {
	.class_hid = BNXT_ULP_CLASS_HID_409e4,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5368775424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[814] = {
	.class_hid = BNXT_ULP_CLASS_HID_419a4,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5368777472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[815] = {
	.class_hid = BNXT_ULP_CLASS_HID_51844,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5369037568UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[816] = {
	.class_hid = BNXT_ULP_CLASS_HID_508e6,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5369039616UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[817] = {
	.class_hid = BNXT_ULP_CLASS_HID_4918c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5369299712UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[818] = {
	.class_hid = BNXT_ULP_CLASS_HID_4802e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5369301760UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[819] = {
	.class_hid = BNXT_ULP_CLASS_HID_580ee,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5369561856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[820] = {
	.class_hid = BNXT_ULP_CLASS_HID_590ae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5369563904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[821] = {
	.class_hid = BNXT_ULP_CLASS_HID_404ae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5905646336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[822] = {
	.class_hid = BNXT_ULP_CLASS_HID_41766,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5905648384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[823] = {
	.class_hid = BNXT_ULP_CLASS_HID_5172e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5905908480UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[824] = {
	.class_hid = BNXT_ULP_CLASS_HID_507a4,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5905910528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[825] = {
	.class_hid = BNXT_ULP_CLASS_HID_48f66,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5906170624UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[826] = {
	.class_hid = BNXT_ULP_CLASS_HID_49f2e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5906172672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[827] = {
	.class_hid = BNXT_ULP_CLASS_HID_59fe6,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5906432768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[828] = {
	.class_hid = BNXT_ULP_CLASS_HID_58e6c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 5906434816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[829] = {
	.class_hid = BNXT_ULP_CLASS_HID_4126c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6442517248UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[830] = {
	.class_hid = BNXT_ULP_CLASS_HID_4028e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6442519296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[831] = {
	.class_hid = BNXT_ULP_CLASS_HID_50d5e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6442779392UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[832] = {
	.class_hid = BNXT_ULP_CLASS_HID_51d1e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6442781440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[833] = {
	.class_hid = BNXT_ULP_CLASS_HID_49a2c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6443041536UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[834] = {
	.class_hid = BNXT_ULP_CLASS_HID_4954e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6443043584UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[835] = {
	.class_hid = BNXT_ULP_CLASS_HID_5951e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6443303680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[836] = {
	.class_hid = BNXT_ULP_CLASS_HID_5858c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6443305728UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[837] = {
	.class_hid = BNXT_ULP_CLASS_HID_409fe,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6979388160UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[838] = {
	.class_hid = BNXT_ULP_CLASS_HID_419ee,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6979390208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[839] = {
	.class_hid = BNXT_ULP_CLASS_HID_519ae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6979650304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[840] = {
	.class_hid = BNXT_ULP_CLASS_HID_508fc,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6979652352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[841] = {
	.class_hid = BNXT_ULP_CLASS_HID_491ee,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6979912448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[842] = {
	.class_hid = BNXT_ULP_CLASS_HID_4802c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6979914496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[843] = {
	.class_hid = BNXT_ULP_CLASS_HID_580fc,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6980174592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[844] = {
	.class_hid = BNXT_ULP_CLASS_HID_590bc,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 6980176640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[845] = {
	.class_hid = BNXT_ULP_CLASS_HID_4074c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 7516259072UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[846] = {
	.class_hid = BNXT_ULP_CLASS_HID_4170c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 7516261120UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[847] = {
	.class_hid = BNXT_ULP_CLASS_HID_5172c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 7516521216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[848] = {
	.class_hid = BNXT_ULP_CLASS_HID_5064e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 7516523264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[849] = {
	.class_hid = BNXT_ULP_CLASS_HID_48f0c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 7516783360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[850] = {
	.class_hid = BNXT_ULP_CLASS_HID_49fcc,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 7516785408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[851] = {
	.class_hid = BNXT_ULP_CLASS_HID_59fec,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 7517045504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[852] = {
	.class_hid = BNXT_ULP_CLASS_HID_58e0e,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 7517047552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[853] = {
	.class_hid = BNXT_ULP_CLASS_HID_413ac,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 8053129984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[854] = {
	.class_hid = BNXT_ULP_CLASS_HID_402ee,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 8053132032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[855] = {
	.class_hid = BNXT_ULP_CLASS_HID_502ae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 8053392128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[856] = {
	.class_hid = BNXT_ULP_CLASS_HID_512ae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 8053394176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[857] = {
	.class_hid = BNXT_ULP_CLASS_HID_49a6c,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 8053654272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[858] = {
	.class_hid = BNXT_ULP_CLASS_HID_48aae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 8053656320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[859] = {
	.class_hid = BNXT_ULP_CLASS_HID_58aae,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 8053916416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[860] = {
	.class_hid = BNXT_ULP_CLASS_HID_585ec,
	.class_tid = 2,
	.hdr_sig_id = 8,
	.flow_sig_id = 8053918464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_8_BITMASK_I_TCP_DST_PORT }
	},
	[861] = {
	.class_hid = BNXT_ULP_CLASS_HID_104ae,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 265216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI }
	},
	[862] = {
	.class_hid = BNXT_ULP_CLASS_HID_1108e,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 273408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI }
	},
	[863] = {
	.class_hid = BNXT_ULP_CLASS_HID_140b2,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 1313792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC }
	},
	[864] = {
	.class_hid = BNXT_ULP_CLASS_HID_15c92,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 1321984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC }
	},
	[865] = {
	.class_hid = BNXT_ULP_CLASS_HID_126a0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2362368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC }
	},
	[866] = {
	.class_hid = BNXT_ULP_CLASS_HID_13280,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2370560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC }
	},
	[867] = {
	.class_hid = BNXT_ULP_CLASS_HID_16d44,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 3410944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC }
	},
	[868] = {
	.class_hid = BNXT_ULP_CLASS_HID_17ea4,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 3419136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC }
	},
	[869] = {
	.class_hid = BNXT_ULP_CLASS_HID_113a4,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2147748864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR }
	},
	[870] = {
	.class_hid = BNXT_ULP_CLASS_HID_10e66,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2147757056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR }
	},
	[871] = {
	.class_hid = BNXT_ULP_CLASS_HID_15e40,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2148797440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR }
	},
	[872] = {
	.class_hid = BNXT_ULP_CLASS_HID_14a02,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2148805632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR }
	},
	[873] = {
	.class_hid = BNXT_ULP_CLASS_HID_13db6,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2149846016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR }
	},
	[874] = {
	.class_hid = BNXT_ULP_CLASS_HID_12870,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2149854208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR }
	},
	[875] = {
	.class_hid = BNXT_ULP_CLASS_HID_17852,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2150894592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR }
	},
	[876] = {
	.class_hid = BNXT_ULP_CLASS_HID_17414,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 2150902784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR }
	},
	[877] = {
	.class_hid = BNXT_ULP_CLASS_HID_11978,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 4295232512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[878] = {
	.class_hid = BNXT_ULP_CLASS_HID_1153a,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 4295240704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[879] = {
	.class_hid = BNXT_ULP_CLASS_HID_145fa,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 4296281088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[880] = {
	.class_hid = BNXT_ULP_CLASS_HID_151da,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 4296289280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[881] = {
	.class_hid = BNXT_ULP_CLASS_HID_13b0a,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 4297329664UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[882] = {
	.class_hid = BNXT_ULP_CLASS_HID_137c8,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 4297337856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[883] = {
	.class_hid = BNXT_ULP_CLASS_HID_167f0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 4298378240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[884] = {
	.class_hid = BNXT_ULP_CLASS_HID_173d0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 4298386432UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[885] = {
	.class_hid = BNXT_ULP_CLASS_HID_114d0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 6442716160UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[886] = {
	.class_hid = BNXT_ULP_CLASS_HID_10092,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 6442724352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[887] = {
	.class_hid = BNXT_ULP_CLASS_HID_150f0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 6443764736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[888] = {
	.class_hid = BNXT_ULP_CLASS_HID_14cb2,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 6443772928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[889] = {
	.class_hid = BNXT_ULP_CLASS_HID_136e2,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 6444813312UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[890] = {
	.class_hid = BNXT_ULP_CLASS_HID_122a0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 6444821504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[891] = {
	.class_hid = BNXT_ULP_CLASS_HID_17282,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 6445861888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[892] = {
	.class_hid = BNXT_ULP_CLASS_HID_16940,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 6445870080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR }
	},
	[893] = {
	.class_hid = BNXT_ULP_CLASS_HID_11b90,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 8590199808UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[894] = {
	.class_hid = BNXT_ULP_CLASS_HID_11654,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 8590208000UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[895] = {
	.class_hid = BNXT_ULP_CLASS_HID_14618,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 8591248384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[896] = {
	.class_hid = BNXT_ULP_CLASS_HID_15278,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 8591256576UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[897] = {
	.class_hid = BNXT_ULP_CLASS_HID_12404,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 8592296960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[898] = {
	.class_hid = BNXT_ULP_CLASS_HID_13064,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 8592305152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[899] = {
	.class_hid = BNXT_ULP_CLASS_HID_16028,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 8593345536UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[900] = {
	.class_hid = BNXT_ULP_CLASS_HID_17c08,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 8593353728UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[901] = {
	.class_hid = BNXT_ULP_CLASS_HID_11100,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 10737683456UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[902] = {
	.class_hid = BNXT_ULP_CLASS_HID_10dc4,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 10737691648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[903] = {
	.class_hid = BNXT_ULP_CLASS_HID_15d24,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 10738732032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[904] = {
	.class_hid = BNXT_ULP_CLASS_HID_149d0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 10738740224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[905] = {
	.class_hid = BNXT_ULP_CLASS_HID_13314,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 10739780608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[906] = {
	.class_hid = BNXT_ULP_CLASS_HID_12fd4,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 10739788800UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[907] = {
	.class_hid = BNXT_ULP_CLASS_HID_17f20,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 10740829184UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[908] = {
	.class_hid = BNXT_ULP_CLASS_HID_16be0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 10740837376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[909] = {
	.class_hid = BNXT_ULP_CLASS_HID_11cd8,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 12885167104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[910] = {
	.class_hid = BNXT_ULP_CLASS_HID_10880,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 12885175296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[911] = {
	.class_hid = BNXT_ULP_CLASS_HID_158e0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 12886215680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[912] = {
	.class_hid = BNXT_ULP_CLASS_HID_154a0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 12886223872UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[913] = {
	.class_hid = BNXT_ULP_CLASS_HID_13ed0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 12887264256UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[914] = {
	.class_hid = BNXT_ULP_CLASS_HID_12a90,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 12887272448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[915] = {
	.class_hid = BNXT_ULP_CLASS_HID_16550,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 12888312832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[916] = {
	.class_hid = BNXT_ULP_CLASS_HID_176b0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 12888321024UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[917] = {
	.class_hid = BNXT_ULP_CLASS_HID_10bb0,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 15032650752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[918] = {
	.class_hid = BNXT_ULP_CLASS_HID_10670,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 15032658944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[919] = {
	.class_hid = BNXT_ULP_CLASS_HID_15650,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 15033699328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[920] = {
	.class_hid = BNXT_ULP_CLASS_HID_14210,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 15033707520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[921] = {
	.class_hid = BNXT_ULP_CLASS_HID_13440,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 15034747904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[922] = {
	.class_hid = BNXT_ULP_CLASS_HID_12000,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 15034756096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[923] = {
	.class_hid = BNXT_ULP_CLASS_HID_17060,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 15035796480UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[924] = {
	.class_hid = BNXT_ULP_CLASS_HID_16c20,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 15035804672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT }
	},
	[925] = {
	.class_hid = BNXT_ULP_CLASS_HID_11511,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 17180134400UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[926] = {
	.class_hid = BNXT_ULP_CLASS_HID_101d3,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 17180142592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[927] = {
	.class_hid = BNXT_ULP_CLASS_HID_15135,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 17181182976UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[928] = {
	.class_hid = BNXT_ULP_CLASS_HID_14df7,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 17181191168UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[929] = {
	.class_hid = BNXT_ULP_CLASS_HID_13723,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 17182231552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[930] = {
	.class_hid = BNXT_ULP_CLASS_HID_123e5,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 17182239744UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[931] = {
	.class_hid = BNXT_ULP_CLASS_HID_173c7,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 17183280128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[932] = {
	.class_hid = BNXT_ULP_CLASS_HID_16f89,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 17183288320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[933] = {
	.class_hid = BNXT_ULP_CLASS_HID_10081,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 19327618048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[934] = {
	.class_hid = BNXT_ULP_CLASS_HID_11ce1,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 19327626240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[935] = {
	.class_hid = BNXT_ULP_CLASS_HID_14ca5,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 19328666624UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[936] = {
	.class_hid = BNXT_ULP_CLASS_HID_15885,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 19328674816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[937] = {
	.class_hid = BNXT_ULP_CLASS_HID_12293,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 19329715200UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[938] = {
	.class_hid = BNXT_ULP_CLASS_HID_13ef3,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 19329723392UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[939] = {
	.class_hid = BNXT_ULP_CLASS_HID_16eb7,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 19330763776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[940] = {
	.class_hid = BNXT_ULP_CLASS_HID_16561,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 19330771968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[941] = {
	.class_hid = BNXT_ULP_CLASS_HID_10e59,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 21475101696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[942] = {
	.class_hid = BNXT_ULP_CLASS_HID_11bb9,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 21475109888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[943] = {
	.class_hid = BNXT_ULP_CLASS_HID_14a61,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 21476150272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[944] = {
	.class_hid = BNXT_ULP_CLASS_HID_14623,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 21476158464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[945] = {
	.class_hid = BNXT_ULP_CLASS_HID_1286b,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 21477198848UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[946] = {
	.class_hid = BNXT_ULP_CLASS_HID_12411,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 21477207040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[947] = {
	.class_hid = BNXT_ULP_CLASS_HID_17473,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 21478247424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[948] = {
	.class_hid = BNXT_ULP_CLASS_HID_16031,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 21478255616UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[949] = {
	.class_hid = BNXT_ULP_CLASS_HID_10531,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 23622585344UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[950] = {
	.class_hid = BNXT_ULP_CLASS_HID_11111,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 23622593536UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[951] = {
	.class_hid = BNXT_ULP_CLASS_HID_141d1,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 23623633920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[952] = {
	.class_hid = BNXT_ULP_CLASS_HID_15d31,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 23623642112UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[953] = {
	.class_hid = BNXT_ULP_CLASS_HID_127c3,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 23624682496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[954] = {
	.class_hid = BNXT_ULP_CLASS_HID_13323,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 23624690688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[955] = {
	.class_hid = BNXT_ULP_CLASS_HID_163e3,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 23625731072UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[956] = {
	.class_hid = BNXT_ULP_CLASS_HID_17fc3,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 23625739264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[957] = {
	.class_hid = BNXT_ULP_CLASS_HID_108f5,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 25770068992UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[958] = {
	.class_hid = BNXT_ULP_CLASS_HID_104b9,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 25770077184UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[959] = {
	.class_hid = BNXT_ULP_CLASS_HID_15499,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 25771117568UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[960] = {
	.class_hid = BNXT_ULP_CLASS_HID_1435d,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 25771125760UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[961] = {
	.class_hid = BNXT_ULP_CLASS_HID_12a89,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 25772166144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[962] = {
	.class_hid = BNXT_ULP_CLASS_HID_12149,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 25772174336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[963] = {
	.class_hid = BNXT_ULP_CLASS_HID_176ad,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 25773214720UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[964] = {
	.class_hid = BNXT_ULP_CLASS_HID_16d6d,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 25773222912UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[965] = {
	.class_hid = BNXT_ULP_CLASS_HID_10665,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 27917552640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[966] = {
	.class_hid = BNXT_ULP_CLASS_HID_11245,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 27917560832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[967] = {
	.class_hid = BNXT_ULP_CLASS_HID_14271,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 27918601216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[968] = {
	.class_hid = BNXT_ULP_CLASS_HID_15e51,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 27918609408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[969] = {
	.class_hid = BNXT_ULP_CLASS_HID_12061,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 27919649792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[970] = {
	.class_hid = BNXT_ULP_CLASS_HID_13c41,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 27919657984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[971] = {
	.class_hid = BNXT_ULP_CLASS_HID_16c05,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 27920698368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[972] = {
	.class_hid = BNXT_ULP_CLASS_HID_17865,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 27920706560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[973] = {
	.class_hid = BNXT_ULP_CLASS_HID_10d21,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 30065036288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[974] = {
	.class_hid = BNXT_ULP_CLASS_HID_11901,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 30065044480UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[975] = {
	.class_hid = BNXT_ULP_CLASS_HID_149c1,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 30066084864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[976] = {
	.class_hid = BNXT_ULP_CLASS_HID_14589,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 30066093056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[977] = {
	.class_hid = BNXT_ULP_CLASS_HID_12f31,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 30067133440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[978] = {
	.class_hid = BNXT_ULP_CLASS_HID_13b11,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 30067141632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[979] = {
	.class_hid = BNXT_ULP_CLASS_HID_16bd9,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 30068182016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[980] = {
	.class_hid = BNXT_ULP_CLASS_HID_16799,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 30068190208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[981] = {
	.class_hid = BNXT_ULP_CLASS_HID_11831,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 32212519936UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[982] = {
	.class_hid = BNXT_ULP_CLASS_HID_114f1,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 32212528128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[983] = {
	.class_hid = BNXT_ULP_CLASS_HID_144b1,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 32213568512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[984] = {
	.class_hid = BNXT_ULP_CLASS_HID_15091,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 32213576704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[985] = {
	.class_hid = BNXT_ULP_CLASS_HID_13ac1,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 32214617088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[986] = {
	.class_hid = BNXT_ULP_CLASS_HID_13681,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 32214625280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[987] = {
	.class_hid = BNXT_ULP_CLASS_HID_166b1,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 32215665664UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[988] = {
	.class_hid = BNXT_ULP_CLASS_HID_17291,
	.class_tid = 2,
	.hdr_sig_id = 9,
	.flow_sig_id = 32215673856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_SRC_PORT |
		BNXT_ULP_HF_0_2_9_BITMASK_I_TCP_DST_PORT }
	},
	[989] = {
	.class_hid = BNXT_ULP_CLASS_HID_4007d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 66304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI }
	},
	[990] = {
	.class_hid = BNXT_ULP_CLASS_HID_41041,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 68352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI }
	},
	[991] = {
	.class_hid = BNXT_ULP_CLASS_HID_5100d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 328448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC }
	},
	[992] = {
	.class_hid = BNXT_ULP_CLASS_HID_50f77,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 330496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC }
	},
	[993] = {
	.class_hid = BNXT_ULP_CLASS_HID_48845,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 590592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC }
	},
	[994] = {
	.class_hid = BNXT_ULP_CLASS_HID_487af,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 592640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC }
	},
	[995] = {
	.class_hid = BNXT_ULP_CLASS_HID_5877b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 852736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC }
	},
	[996] = {
	.class_hid = BNXT_ULP_CLASS_HID_5973f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 854784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC }
	},
	[997] = {
	.class_hid = BNXT_ULP_CLASS_HID_41c31,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 134284032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR }
	},
	[998] = {
	.class_hid = BNXT_ULP_CLASS_HID_40b1b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 134286080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR }
	},
	[999] = {
	.class_hid = BNXT_ULP_CLASS_HID_50b67,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 134546176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1000] = {
	.class_hid = BNXT_ULP_CLASS_HID_51b2b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 134548224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1001] = {
	.class_hid = BNXT_ULP_CLASS_HID_4831f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 134808320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1002] = {
	.class_hid = BNXT_ULP_CLASS_HID_49363,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 134810368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1003] = {
	.class_hid = BNXT_ULP_CLASS_HID_5932f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 135070464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1004] = {
	.class_hid = BNXT_ULP_CLASS_HID_58211,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 135072512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1005] = {
	.class_hid = BNXT_ULP_CLASS_HID_4161b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 268501760UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1006] = {
	.class_hid = BNXT_ULP_CLASS_HID_405bd,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 268503808UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1007] = {
	.class_hid = BNXT_ULP_CLASS_HID_50589,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 268763904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1008] = {
	.class_hid = BNXT_ULP_CLASS_HID_5150d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 268765952UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1009] = {
	.class_hid = BNXT_ULP_CLASS_HID_49e23,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 269026048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1010] = {
	.class_hid = BNXT_ULP_CLASS_HID_48d85,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 269028096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1011] = {
	.class_hid = BNXT_ULP_CLASS_HID_58d11,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 269288192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1012] = {
	.class_hid = BNXT_ULP_CLASS_HID_59d15,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 269290240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1013] = {
	.class_hid = BNXT_ULP_CLASS_HID_4012d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 402719488UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1014] = {
	.class_hid = BNXT_ULP_CLASS_HID_41131,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 402721536UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1015] = {
	.class_hid = BNXT_ULP_CLASS_HID_5113d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 402981632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1016] = {
	.class_hid = BNXT_ULP_CLASS_HID_50027,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 402983680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1017] = {
	.class_hid = BNXT_ULP_CLASS_HID_48935,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 403243776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1018] = {
	.class_hid = BNXT_ULP_CLASS_HID_49939,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 403245824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1019] = {
	.class_hid = BNXT_ULP_CLASS_HID_59905,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 403505920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1020] = {
	.class_hid = BNXT_ULP_CLASS_HID_5882f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 403507968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR }
	},
	[1021] = {
	.class_hid = BNXT_ULP_CLASS_HID_41b99,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 536937216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1022] = {
	.class_hid = BNXT_ULP_CLASS_HID_40b03,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 536939264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1023] = {
	.class_hid = BNXT_ULP_CLASS_HID_50acf,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 537199360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1024] = {
	.class_hid = BNXT_ULP_CLASS_HID_51a93,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 537201408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1025] = {
	.class_hid = BNXT_ULP_CLASS_HID_48307,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 537461504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1026] = {
	.class_hid = BNXT_ULP_CLASS_HID_492cb,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 537463552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1027] = {
	.class_hid = BNXT_ULP_CLASS_HID_59297,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 537723648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1028] = {
	.class_hid = BNXT_ULP_CLASS_HID_581d9,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 537725696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1029] = {
	.class_hid = BNXT_ULP_CLASS_HID_41653,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 671154944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1030] = {
	.class_hid = BNXT_ULP_CLASS_HID_40655,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 671156992UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1031] = {
	.class_hid = BNXT_ULP_CLASS_HID_50601,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 671417088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1032] = {
	.class_hid = BNXT_ULP_CLASS_HID_51545,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 671419136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1033] = {
	.class_hid = BNXT_ULP_CLASS_HID_49e1b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 671679232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1034] = {
	.class_hid = BNXT_ULP_CLASS_HID_48e1d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 671681280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1035] = {
	.class_hid = BNXT_ULP_CLASS_HID_58d49,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 671941376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1036] = {
	.class_hid = BNXT_ULP_CLASS_HID_59d0d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 671943424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1037] = {
	.class_hid = BNXT_ULP_CLASS_HID_40115,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 805372672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1038] = {
	.class_hid = BNXT_ULP_CLASS_HID_41099,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 805374720UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1039] = {
	.class_hid = BNXT_ULP_CLASS_HID_51085,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 805634816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1040] = {
	.class_hid = BNXT_ULP_CLASS_HID_5000f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 805636864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1041] = {
	.class_hid = BNXT_ULP_CLASS_HID_4889d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 805896960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1042] = {
	.class_hid = BNXT_ULP_CLASS_HID_49881,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 805899008UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1043] = {
	.class_hid = BNXT_ULP_CLASS_HID_5980d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 806159104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1044] = {
	.class_hid = BNXT_ULP_CLASS_HID_59797,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 806161152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1045] = {
	.class_hid = BNXT_ULP_CLASS_HID_41c09,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 939590400UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1046] = {
	.class_hid = BNXT_ULP_CLASS_HID_40c13,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 939592448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1047] = {
	.class_hid = BNXT_ULP_CLASS_HID_50b1f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 939852544UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1048] = {
	.class_hid = BNXT_ULP_CLASS_HID_51b03,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 939854592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1049] = {
	.class_hid = BNXT_ULP_CLASS_HID_48417,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 940114688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1050] = {
	.class_hid = BNXT_ULP_CLASS_HID_4931b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 940116736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1051] = {
	.class_hid = BNXT_ULP_CLASS_HID_59307,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 940376832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1052] = {
	.class_hid = BNXT_ULP_CLASS_HID_58309,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 940378880UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT }
	},
	[1053] = {
	.class_hid = BNXT_ULP_CLASS_HID_4160f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1073808128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1054] = {
	.class_hid = BNXT_ULP_CLASS_HID_40561,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1073810176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1055] = {
	.class_hid = BNXT_ULP_CLASS_HID_5052d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1074070272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1056] = {
	.class_hid = BNXT_ULP_CLASS_HID_51501,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1074072320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1057] = {
	.class_hid = BNXT_ULP_CLASS_HID_49dc7,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1074332416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1058] = {
	.class_hid = BNXT_ULP_CLASS_HID_48d29,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1074334464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1059] = {
	.class_hid = BNXT_ULP_CLASS_HID_58d05,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1074594560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1060] = {
	.class_hid = BNXT_ULP_CLASS_HID_59cc9,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1074596608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1061] = {
	.class_hid = BNXT_ULP_CLASS_HID_40161,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1208025856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1062] = {
	.class_hid = BNXT_ULP_CLASS_HID_41125,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1208027904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1063] = {
	.class_hid = BNXT_ULP_CLASS_HID_51061,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1208288000UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1064] = {
	.class_hid = BNXT_ULP_CLASS_HID_5004b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1208290048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1065] = {
	.class_hid = BNXT_ULP_CLASS_HID_48929,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1208550144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1066] = {
	.class_hid = BNXT_ULP_CLASS_HID_4986d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1208552192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1067] = {
	.class_hid = BNXT_ULP_CLASS_HID_59829,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1208812288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1068] = {
	.class_hid = BNXT_ULP_CLASS_HID_58823,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1208814336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1069] = {
	.class_hid = BNXT_ULP_CLASS_HID_41ba5,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1342243584UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1070] = {
	.class_hid = BNXT_ULP_CLASS_HID_40b0f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1342245632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1071] = {
	.class_hid = BNXT_ULP_CLASS_HID_50b0b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1342505728UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1072] = {
	.class_hid = BNXT_ULP_CLASS_HID_51a8f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1342507776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1073] = {
	.class_hid = BNXT_ULP_CLASS_HID_48303,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1342767872UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1074] = {
	.class_hid = BNXT_ULP_CLASS_HID_49307,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1342769920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1075] = {
	.class_hid = BNXT_ULP_CLASS_HID_592a3,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1343030016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1076] = {
	.class_hid = BNXT_ULP_CLASS_HID_58205,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1343032064UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1077] = {
	.class_hid = BNXT_ULP_CLASS_HID_4172f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1476461312UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1078] = {
	.class_hid = BNXT_ULP_CLASS_HID_40621,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1476463360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1079] = {
	.class_hid = BNXT_ULP_CLASS_HID_5062d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1476723456UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1080] = {
	.class_hid = BNXT_ULP_CLASS_HID_51621,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1476725504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1081] = {
	.class_hid = BNXT_ULP_CLASS_HID_49f07,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1476985600UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1082] = {
	.class_hid = BNXT_ULP_CLASS_HID_48e29,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1476987648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1083] = {
	.class_hid = BNXT_ULP_CLASS_HID_58e25,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1477247744UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1084] = {
	.class_hid = BNXT_ULP_CLASS_HID_59d29,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1477249792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1085] = {
	.class_hid = BNXT_ULP_CLASS_HID_400c9,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1610679040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1086] = {
	.class_hid = BNXT_ULP_CLASS_HID_4108d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1610681088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1087] = {
	.class_hid = BNXT_ULP_CLASS_HID_51049,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1610941184UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1088] = {
	.class_hid = BNXT_ULP_CLASS_HID_50fc3,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1610943232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1089] = {
	.class_hid = BNXT_ULP_CLASS_HID_48881,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1611203328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1090] = {
	.class_hid = BNXT_ULP_CLASS_HID_487cb,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1611205376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1091] = {
	.class_hid = BNXT_ULP_CLASS_HID_587c7,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1611465472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1092] = {
	.class_hid = BNXT_ULP_CLASS_HID_5978b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1611467520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1093] = {
	.class_hid = BNXT_ULP_CLASS_HID_41c4d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1744896768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1094] = {
	.class_hid = BNXT_ULP_CLASS_HID_40b47,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1744898816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1095] = {
	.class_hid = BNXT_ULP_CLASS_HID_50b03,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1745158912UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1096] = {
	.class_hid = BNXT_ULP_CLASS_HID_51b47,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1745160960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1097] = {
	.class_hid = BNXT_ULP_CLASS_HID_4834b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1745421056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1098] = {
	.class_hid = BNXT_ULP_CLASS_HID_4930f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1745423104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1099] = {
	.class_hid = BNXT_ULP_CLASS_HID_5934b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1745683200UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1100] = {
	.class_hid = BNXT_ULP_CLASS_HID_5824d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1745685248UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1101] = {
	.class_hid = BNXT_ULP_CLASS_HID_41687,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1879114496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1102] = {
	.class_hid = BNXT_ULP_CLASS_HID_40609,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1879116544UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1103] = {
	.class_hid = BNXT_ULP_CLASS_HID_50585,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1879376640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1104] = {
	.class_hid = BNXT_ULP_CLASS_HID_51589,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1879378688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1105] = {
	.class_hid = BNXT_ULP_CLASS_HID_49e0f,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1879638784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1106] = {
	.class_hid = BNXT_ULP_CLASS_HID_48d81,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1879640832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1107] = {
	.class_hid = BNXT_ULP_CLASS_HID_58d8d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1879900928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1108] = {
	.class_hid = BNXT_ULP_CLASS_HID_59d01,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 1879902976UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1109] = {
	.class_hid = BNXT_ULP_CLASS_HID_40109,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 2013332224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1110] = {
	.class_hid = BNXT_ULP_CLASS_HID_4110d,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 2013334272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1111] = {
	.class_hid = BNXT_ULP_CLASS_HID_51109,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 2013594368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1112] = {
	.class_hid = BNXT_ULP_CLASS_HID_50003,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 2013596416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1113] = {
	.class_hid = BNXT_ULP_CLASS_HID_48901,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 2013856512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1114] = {
	.class_hid = BNXT_ULP_CLASS_HID_49905,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 2013858560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1115] = {
	.class_hid = BNXT_ULP_CLASS_HID_59901,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 2014118656UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1116] = {
	.class_hid = BNXT_ULP_CLASS_HID_5880b,
	.class_tid = 2,
	.hdr_sig_id = 10,
	.flow_sig_id = 2014120704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_10_BITMASK_I_UDP_DST_PORT }
	},
	[1117] = {
	.class_hid = BNXT_ULP_CLASS_HID_10619,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 265216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI }
	},
	[1118] = {
	.class_hid = BNXT_ULP_CLASS_HID_11239,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 273408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI }
	},
	[1119] = {
	.class_hid = BNXT_ULP_CLASS_HID_14205,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1313792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC }
	},
	[1120] = {
	.class_hid = BNXT_ULP_CLASS_HID_15e25,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1321984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC }
	},
	[1121] = {
	.class_hid = BNXT_ULP_CLASS_HID_12417,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2362368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC }
	},
	[1122] = {
	.class_hid = BNXT_ULP_CLASS_HID_13037,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2370560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC }
	},
	[1123] = {
	.class_hid = BNXT_ULP_CLASS_HID_16ff3,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3410944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC }
	},
	[1124] = {
	.class_hid = BNXT_ULP_CLASS_HID_17c13,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3419136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC }
	},
	[1125] = {
	.class_hid = BNXT_ULP_CLASS_HID_1111d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 537136128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1126] = {
	.class_hid = BNXT_ULP_CLASS_HID_10cdb,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 537144320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1127] = {
	.class_hid = BNXT_ULP_CLASS_HID_15d19,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 538184704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1128] = {
	.class_hid = BNXT_ULP_CLASS_HID_148c7,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 538192896UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1129] = {
	.class_hid = BNXT_ULP_CLASS_HID_13f0b,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 539233280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1130] = {
	.class_hid = BNXT_ULP_CLASS_HID_12ac9,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 539241472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1131] = {
	.class_hid = BNXT_ULP_CLASS_HID_17b17,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 540281856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1132] = {
	.class_hid = BNXT_ULP_CLASS_HID_176d5,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 540290048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR }
	},
	[1133] = {
	.class_hid = BNXT_ULP_CLASS_HID_10bab,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1074007040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1134] = {
	.class_hid = BNXT_ULP_CLASS_HID_10769,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1074015232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1135] = {
	.class_hid = BNXT_ULP_CLASS_HID_15787,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1075055616UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1136] = {
	.class_hid = BNXT_ULP_CLASS_HID_14345,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1075063808UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1137] = {
	.class_hid = BNXT_ULP_CLASS_HID_12989,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1076104192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1138] = {
	.class_hid = BNXT_ULP_CLASS_HID_12567,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1076112384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1139] = {
	.class_hid = BNXT_ULP_CLASS_HID_17585,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1077152768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1140] = {
	.class_hid = BNXT_ULP_CLASS_HID_16143,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1077160960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1141] = {
	.class_hid = BNXT_ULP_CLASS_HID_1064d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1610877952UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1142] = {
	.class_hid = BNXT_ULP_CLASS_HID_1128d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1610886144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1143] = {
	.class_hid = BNXT_ULP_CLASS_HID_14249,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1611926528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1144] = {
	.class_hid = BNXT_ULP_CLASS_HID_15e49,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1611934720UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1145] = {
	.class_hid = BNXT_ULP_CLASS_HID_1244b,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1612975104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1146] = {
	.class_hid = BNXT_ULP_CLASS_HID_1304b,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1612983296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1147] = {
	.class_hid = BNXT_ULP_CLASS_HID_16047,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1614023680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1148] = {
	.class_hid = BNXT_ULP_CLASS_HID_17c47,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 1614031872UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR }
	},
	[1149] = {
	.class_hid = BNXT_ULP_CLASS_HID_11113,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2147748864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1150] = {
	.class_hid = BNXT_ULP_CLASS_HID_10cd1,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2147757056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1151] = {
	.class_hid = BNXT_ULP_CLASS_HID_15cf7,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2148797440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1152] = {
	.class_hid = BNXT_ULP_CLASS_HID_148b5,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2148805632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1153] = {
	.class_hid = BNXT_ULP_CLASS_HID_13f01,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2149846016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1154] = {
	.class_hid = BNXT_ULP_CLASS_HID_12ac7,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2149854208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1155] = {
	.class_hid = BNXT_ULP_CLASS_HID_17ae5,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2150894592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1156] = {
	.class_hid = BNXT_ULP_CLASS_HID_176a3,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2150902784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1157] = {
	.class_hid = BNXT_ULP_CLASS_HID_10bd5,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2684619776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1158] = {
	.class_hid = BNXT_ULP_CLASS_HID_10793,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2684627968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1159] = {
	.class_hid = BNXT_ULP_CLASS_HID_15791,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2685668352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1160] = {
	.class_hid = BNXT_ULP_CLASS_HID_14357,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2685676544UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1161] = {
	.class_hid = BNXT_ULP_CLASS_HID_129c3,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2686716928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1162] = {
	.class_hid = BNXT_ULP_CLASS_HID_12581,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2686725120UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1163] = {
	.class_hid = BNXT_ULP_CLASS_HID_17587,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2687765504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1164] = {
	.class_hid = BNXT_ULP_CLASS_HID_16145,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 2687773696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1165] = {
	.class_hid = BNXT_ULP_CLASS_HID_10643,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3221490688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1166] = {
	.class_hid = BNXT_ULP_CLASS_HID_11263,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3221498880UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1167] = {
	.class_hid = BNXT_ULP_CLASS_HID_14227,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3222539264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1168] = {
	.class_hid = BNXT_ULP_CLASS_HID_15e47,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3222547456UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1169] = {
	.class_hid = BNXT_ULP_CLASS_HID_12421,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3223587840UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1170] = {
	.class_hid = BNXT_ULP_CLASS_HID_13041,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3223596032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1171] = {
	.class_hid = BNXT_ULP_CLASS_HID_16005,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3224636416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1172] = {
	.class_hid = BNXT_ULP_CLASS_HID_17c25,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3224644608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1173] = {
	.class_hid = BNXT_ULP_CLASS_HID_11147,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3758361600UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1174] = {
	.class_hid = BNXT_ULP_CLASS_HID_10d05,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3758369792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1175] = {
	.class_hid = BNXT_ULP_CLASS_HID_15d43,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3759410176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1176] = {
	.class_hid = BNXT_ULP_CLASS_HID_14901,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3759418368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1177] = {
	.class_hid = BNXT_ULP_CLASS_HID_13f45,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3760458752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1178] = {
	.class_hid = BNXT_ULP_CLASS_HID_12b03,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3760466944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1179] = {
	.class_hid = BNXT_ULP_CLASS_HID_17b01,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3761507328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1180] = {
	.class_hid = BNXT_ULP_CLASS_HID_176c7,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 3761515520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT }
	},
	[1181] = {
	.class_hid = BNXT_ULP_CLASS_HID_11bcf,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4295232512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1182] = {
	.class_hid = BNXT_ULP_CLASS_HID_1178d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4295240704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1183] = {
	.class_hid = BNXT_ULP_CLASS_HID_1474d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4296281088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1184] = {
	.class_hid = BNXT_ULP_CLASS_HID_1536d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4296289280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1185] = {
	.class_hid = BNXT_ULP_CLASS_HID_139bd,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4297329664UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1186] = {
	.class_hid = BNXT_ULP_CLASS_HID_1357f,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4297337856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1187] = {
	.class_hid = BNXT_ULP_CLASS_HID_16547,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4298378240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1188] = {
	.class_hid = BNXT_ULP_CLASS_HID_17167,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4298386432UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1189] = {
	.class_hid = BNXT_ULP_CLASS_HID_11685,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4832103424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1190] = {
	.class_hid = BNXT_ULP_CLASS_HID_1024f,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4832111616UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1191] = {
	.class_hid = BNXT_ULP_CLASS_HID_1524d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4833152000UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1192] = {
	.class_hid = BNXT_ULP_CLASS_HID_14e0f,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4833160192UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1193] = {
	.class_hid = BNXT_ULP_CLASS_HID_1345f,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4834200576UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1194] = {
	.class_hid = BNXT_ULP_CLASS_HID_1201d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4834208768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1195] = {
	.class_hid = BNXT_ULP_CLASS_HID_1705f,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4835249152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1196] = {
	.class_hid = BNXT_ULP_CLASS_HID_16c1d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 4835257344UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1197] = {
	.class_hid = BNXT_ULP_CLASS_HID_100ef,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5368974336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1198] = {
	.class_hid = BNXT_ULP_CLASS_HID_11d0f,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5368982528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1199] = {
	.class_hid = BNXT_ULP_CLASS_HID_14ccf,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5370022912UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1200] = {
	.class_hid = BNXT_ULP_CLASS_HID_158ef,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5370031104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1201] = {
	.class_hid = BNXT_ULP_CLASS_HID_12eed,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5371071488UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1202] = {
	.class_hid = BNXT_ULP_CLASS_HID_13b0d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5371079680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1203] = {
	.class_hid = BNXT_ULP_CLASS_HID_16acd,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5372120064UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1204] = {
	.class_hid = BNXT_ULP_CLASS_HID_16687,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5372128256UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1205] = {
	.class_hid = BNXT_ULP_CLASS_HID_11c07,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5905845248UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1206] = {
	.class_hid = BNXT_ULP_CLASS_HID_117c5,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5905853440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1207] = {
	.class_hid = BNXT_ULP_CLASS_HID_1478d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5906893824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1208] = {
	.class_hid = BNXT_ULP_CLASS_HID_1538d,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5906902016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1209] = {
	.class_hid = BNXT_ULP_CLASS_HID_13a05,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5907942400UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1210] = {
	.class_hid = BNXT_ULP_CLASS_HID_135cf,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5907950592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1211] = {
	.class_hid = BNXT_ULP_CLASS_HID_1658f,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5908990976UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1212] = {
	.class_hid = BNXT_ULP_CLASS_HID_1718f,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 5908999168UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1213] = {
	.class_hid = BNXT_ULP_CLASS_HID_11667,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6442716160UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1214] = {
	.class_hid = BNXT_ULP_CLASS_HID_10225,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6442724352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1215] = {
	.class_hid = BNXT_ULP_CLASS_HID_15247,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6443764736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1216] = {
	.class_hid = BNXT_ULP_CLASS_HID_14e05,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6443772928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1217] = {
	.class_hid = BNXT_ULP_CLASS_HID_13455,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6444813312UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1218] = {
	.class_hid = BNXT_ULP_CLASS_HID_12017,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6444821504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1219] = {
	.class_hid = BNXT_ULP_CLASS_HID_17035,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6445861888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1220] = {
	.class_hid = BNXT_ULP_CLASS_HID_16bf7,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6445870080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1221] = {
	.class_hid = BNXT_ULP_CLASS_HID_10115,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6979587072UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1222] = {
	.class_hid = BNXT_ULP_CLASS_HID_11d15,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6979595264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1223] = {
	.class_hid = BNXT_ULP_CLASS_HID_14d05,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6980635648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1224] = {
	.class_hid = BNXT_ULP_CLASS_HID_15905,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6980643840UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1225] = {
	.class_hid = BNXT_ULP_CLASS_HID_12f17,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6981684224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1226] = {
	.class_hid = BNXT_ULP_CLASS_HID_13b17,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6981692416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1227] = {
	.class_hid = BNXT_ULP_CLASS_HID_16ad7,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6982732800UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1228] = {
	.class_hid = BNXT_ULP_CLASS_HID_16695,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 6982740992UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1229] = {
	.class_hid = BNXT_ULP_CLASS_HID_11be5,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 7516457984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1230] = {
	.class_hid = BNXT_ULP_CLASS_HID_117a7,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 7516466176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1231] = {
	.class_hid = BNXT_ULP_CLASS_HID_14767,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 7517506560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1232] = {
	.class_hid = BNXT_ULP_CLASS_HID_15387,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 7517514752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1233] = {
	.class_hid = BNXT_ULP_CLASS_HID_139e7,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 7518555136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1234] = {
	.class_hid = BNXT_ULP_CLASS_HID_135a5,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 7518563328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1235] = {
	.class_hid = BNXT_ULP_CLASS_HID_16565,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 7519603712UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1236] = {
	.class_hid = BNXT_ULP_CLASS_HID_17185,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 7519611904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1237] = {
	.class_hid = BNXT_ULP_CLASS_HID_11687,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 8053328896UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1238] = {
	.class_hid = BNXT_ULP_CLASS_HID_10245,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 8053337088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1239] = {
	.class_hid = BNXT_ULP_CLASS_HID_15287,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 8054377472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1240] = {
	.class_hid = BNXT_ULP_CLASS_HID_14e45,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 8054385664UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1241] = {
	.class_hid = BNXT_ULP_CLASS_HID_13485,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 8055426048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1242] = {
	.class_hid = BNXT_ULP_CLASS_HID_12047,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 8055434240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1243] = {
	.class_hid = BNXT_ULP_CLASS_HID_17085,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 8056474624UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1244] = {
	.class_hid = BNXT_ULP_CLASS_HID_16c47,
	.class_tid = 2,
	.hdr_sig_id = 11,
	.flow_sig_id = 8056482816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_11_BITMASK_I_UDP_DST_PORT }
	},
	[1245] = {
	.class_hid = BNXT_ULP_CLASS_HID_400f4,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 66304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI }
	},
	[1246] = {
	.class_hid = BNXT_ULP_CLASS_HID_410c8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 68352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI }
	},
	[1247] = {
	.class_hid = BNXT_ULP_CLASS_HID_51084,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 328448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC }
	},
	[1248] = {
	.class_hid = BNXT_ULP_CLASS_HID_50ffe,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 330496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC }
	},
	[1249] = {
	.class_hid = BNXT_ULP_CLASS_HID_488cc,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 590592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC }
	},
	[1250] = {
	.class_hid = BNXT_ULP_CLASS_HID_48726,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 592640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC }
	},
	[1251] = {
	.class_hid = BNXT_ULP_CLASS_HID_587f2,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 852736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC }
	},
	[1252] = {
	.class_hid = BNXT_ULP_CLASS_HID_597b6,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 854784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC }
	},
	[1253] = {
	.class_hid = BNXT_ULP_CLASS_HID_41b10,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 536937216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1254] = {
	.class_hid = BNXT_ULP_CLASS_HID_40b8a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 536939264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1255] = {
	.class_hid = BNXT_ULP_CLASS_HID_50a46,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 537199360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1256] = {
	.class_hid = BNXT_ULP_CLASS_HID_51a1a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 537201408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1257] = {
	.class_hid = BNXT_ULP_CLASS_HID_4838e,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 537461504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1258] = {
	.class_hid = BNXT_ULP_CLASS_HID_49242,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 537463552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1259] = {
	.class_hid = BNXT_ULP_CLASS_HID_5921e,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 537723648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1260] = {
	.class_hid = BNXT_ULP_CLASS_HID_58150,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 537725696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1261] = {
	.class_hid = BNXT_ULP_CLASS_HID_41686,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1073808128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1262] = {
	.class_hid = BNXT_ULP_CLASS_HID_405e8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1073810176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1263] = {
	.class_hid = BNXT_ULP_CLASS_HID_505a4,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1074070272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1264] = {
	.class_hid = BNXT_ULP_CLASS_HID_51588,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1074072320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1265] = {
	.class_hid = BNXT_ULP_CLASS_HID_49d4e,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1074332416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1266] = {
	.class_hid = BNXT_ULP_CLASS_HID_48da0,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1074334464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1267] = {
	.class_hid = BNXT_ULP_CLASS_HID_58d8c,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1074594560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1268] = {
	.class_hid = BNXT_ULP_CLASS_HID_59c40,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1074596608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1269] = {
	.class_hid = BNXT_ULP_CLASS_HID_40040,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1610679040UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1270] = {
	.class_hid = BNXT_ULP_CLASS_HID_41004,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1610681088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1271] = {
	.class_hid = BNXT_ULP_CLASS_HID_510c0,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1610941184UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1272] = {
	.class_hid = BNXT_ULP_CLASS_HID_50f4a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1610943232UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1273] = {
	.class_hid = BNXT_ULP_CLASS_HID_48808,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1611203328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1274] = {
	.class_hid = BNXT_ULP_CLASS_HID_48742,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1611205376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1275] = {
	.class_hid = BNXT_ULP_CLASS_HID_5874e,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1611465472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1276] = {
	.class_hid = BNXT_ULP_CLASS_HID_59702,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 1611467520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR }
	},
	[1277] = {
	.class_hid = BNXT_ULP_CLASS_HID_41bfe,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2147549952UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1278] = {
	.class_hid = BNXT_ULP_CLASS_HID_40a58,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2147552000UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1279] = {
	.class_hid = BNXT_ULP_CLASS_HID_50a2c,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2147812096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1280] = {
	.class_hid = BNXT_ULP_CLASS_HID_51ae8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2147814144UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1281] = {
	.class_hid = BNXT_ULP_CLASS_HID_4825c,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2148074240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1282] = {
	.class_hid = BNXT_ULP_CLASS_HID_49228,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2148076288UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1283] = {
	.class_hid = BNXT_ULP_CLASS_HID_592ec,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2148336384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1284] = {
	.class_hid = BNXT_ULP_CLASS_HID_5815e,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2148338432UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1285] = {
	.class_hid = BNXT_ULP_CLASS_HID_41698,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2684420864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1286] = {
	.class_hid = BNXT_ULP_CLASS_HID_4051a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2684422912UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1287] = {
	.class_hid = BNXT_ULP_CLASS_HID_505ce,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2684683008UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1288] = {
	.class_hid = BNXT_ULP_CLASS_HID_5158a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2684685056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1289] = {
	.class_hid = BNXT_ULP_CLASS_HID_49d58,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2684945152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1290] = {
	.class_hid = BNXT_ULP_CLASS_HID_48dca,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2684947200UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1291] = {
	.class_hid = BNXT_ULP_CLASS_HID_58d8e,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2685207296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1292] = {
	.class_hid = BNXT_ULP_CLASS_HID_59c5a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 2685209344UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1293] = {
	.class_hid = BNXT_ULP_CLASS_HID_4002e,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3221291776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1294] = {
	.class_hid = BNXT_ULP_CLASS_HID_410ea,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3221293824UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1295] = {
	.class_hid = BNXT_ULP_CLASS_HID_510ae,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3221553920UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1296] = {
	.class_hid = BNXT_ULP_CLASS_HID_50f08,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3221555968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1297] = {
	.class_hid = BNXT_ULP_CLASS_HID_488ee,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3221816064UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1298] = {
	.class_hid = BNXT_ULP_CLASS_HID_48748,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3221818112UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1299] = {
	.class_hid = BNXT_ULP_CLASS_HID_5870c,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3222078208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1300] = {
	.class_hid = BNXT_ULP_CLASS_HID_597e8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3222080256UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1301] = {
	.class_hid = BNXT_ULP_CLASS_HID_41b4a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3758162688UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1302] = {
	.class_hid = BNXT_ULP_CLASS_HID_40b8c,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3758164736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1303] = {
	.class_hid = BNXT_ULP_CLASS_HID_50a48,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3758424832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1304] = {
	.class_hid = BNXT_ULP_CLASS_HID_51a0c,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3758426880UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1305] = {
	.class_hid = BNXT_ULP_CLASS_HID_48388,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3758686976UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1306] = {
	.class_hid = BNXT_ULP_CLASS_HID_4924c,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3758689024UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1307] = {
	.class_hid = BNXT_ULP_CLASS_HID_59208,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3758949120UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1308] = {
	.class_hid = BNXT_ULP_CLASS_HID_5828a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 3758951168UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT }
	},
	[1309] = {
	.class_hid = BNXT_ULP_CLASS_HID_40540,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4295033600UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1310] = {
	.class_hid = BNXT_ULP_CLASS_HID_41500,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4295035648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1311] = {
	.class_hid = BNXT_ULP_CLASS_HID_515d0,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4295295744UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1312] = {
	.class_hid = BNXT_ULP_CLASS_HID_5044a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4295297792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1313] = {
	.class_hid = BNXT_ULP_CLASS_HID_48d18,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4295557888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1314] = {
	.class_hid = BNXT_ULP_CLASS_HID_49dd8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4295559936UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1315] = {
	.class_hid = BNXT_ULP_CLASS_HID_59da8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4295820032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1316] = {
	.class_hid = BNXT_ULP_CLASS_HID_58c02,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4295822080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1317] = {
	.class_hid = BNXT_ULP_CLASS_HID_41048,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4831904512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1318] = {
	.class_hid = BNXT_ULP_CLASS_HID_400c2,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4831906560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1319] = {
	.class_hid = BNXT_ULP_CLASS_HID_50092,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4832166656UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1320] = {
	.class_hid = BNXT_ULP_CLASS_HID_51f52,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4832168704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1321] = {
	.class_hid = BNXT_ULP_CLASS_HID_49800,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4832428800UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1322] = {
	.class_hid = BNXT_ULP_CLASS_HID_4889a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4832430848UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1323] = {
	.class_hid = BNXT_ULP_CLASS_HID_5974a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4832690944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1324] = {
	.class_hid = BNXT_ULP_CLASS_HID_587c8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 4832692992UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1325] = {
	.class_hid = BNXT_ULP_CLASS_HID_40bc2,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5368775424UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1326] = {
	.class_hid = BNXT_ULP_CLASS_HID_41b82,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5368777472UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1327] = {
	.class_hid = BNXT_ULP_CLASS_HID_51a62,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5369037568UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1328] = {
	.class_hid = BNXT_ULP_CLASS_HID_50ac0,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5369039616UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1329] = {
	.class_hid = BNXT_ULP_CLASS_HID_493aa,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5369299712UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1330] = {
	.class_hid = BNXT_ULP_CLASS_HID_48208,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5369301760UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1331] = {
	.class_hid = BNXT_ULP_CLASS_HID_582c8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5369561856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1332] = {
	.class_hid = BNXT_ULP_CLASS_HID_59288,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5369563904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1333] = {
	.class_hid = BNXT_ULP_CLASS_HID_40688,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5905646336UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1334] = {
	.class_hid = BNXT_ULP_CLASS_HID_41540,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5905648384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1335] = {
	.class_hid = BNXT_ULP_CLASS_HID_51508,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5905908480UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1336] = {
	.class_hid = BNXT_ULP_CLASS_HID_50582,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5905910528UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1337] = {
	.class_hid = BNXT_ULP_CLASS_HID_48d40,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5906170624UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1338] = {
	.class_hid = BNXT_ULP_CLASS_HID_49d08,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5906172672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1339] = {
	.class_hid = BNXT_ULP_CLASS_HID_59dc0,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5906432768UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1340] = {
	.class_hid = BNXT_ULP_CLASS_HID_58c4a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 5906434816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1341] = {
	.class_hid = BNXT_ULP_CLASS_HID_4104a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6442517248UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1342] = {
	.class_hid = BNXT_ULP_CLASS_HID_400a8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6442519296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1343] = {
	.class_hid = BNXT_ULP_CLASS_HID_50f78,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6442779392UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1344] = {
	.class_hid = BNXT_ULP_CLASS_HID_51f38,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6442781440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1345] = {
	.class_hid = BNXT_ULP_CLASS_HID_4980a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6443041536UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1346] = {
	.class_hid = BNXT_ULP_CLASS_HID_49768,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6443043584UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1347] = {
	.class_hid = BNXT_ULP_CLASS_HID_59738,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6443303680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1348] = {
	.class_hid = BNXT_ULP_CLASS_HID_587aa,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6443305728UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1349] = {
	.class_hid = BNXT_ULP_CLASS_HID_40bd8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6979388160UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1350] = {
	.class_hid = BNXT_ULP_CLASS_HID_41bc8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6979390208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1351] = {
	.class_hid = BNXT_ULP_CLASS_HID_51b88,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6979650304UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1352] = {
	.class_hid = BNXT_ULP_CLASS_HID_50ada,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6979652352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1353] = {
	.class_hid = BNXT_ULP_CLASS_HID_493c8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6979912448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1354] = {
	.class_hid = BNXT_ULP_CLASS_HID_4820a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6979914496UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1355] = {
	.class_hid = BNXT_ULP_CLASS_HID_582da,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6980174592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1356] = {
	.class_hid = BNXT_ULP_CLASS_HID_5929a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 6980176640UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1357] = {
	.class_hid = BNXT_ULP_CLASS_HID_4056a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 7516259072UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1358] = {
	.class_hid = BNXT_ULP_CLASS_HID_4152a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 7516261120UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1359] = {
	.class_hid = BNXT_ULP_CLASS_HID_5150a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 7516521216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1360] = {
	.class_hid = BNXT_ULP_CLASS_HID_50468,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 7516523264UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1361] = {
	.class_hid = BNXT_ULP_CLASS_HID_48d2a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 7516783360UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1362] = {
	.class_hid = BNXT_ULP_CLASS_HID_49dea,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 7516785408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1363] = {
	.class_hid = BNXT_ULP_CLASS_HID_59dca,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 7517045504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1364] = {
	.class_hid = BNXT_ULP_CLASS_HID_58c28,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 7517047552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1365] = {
	.class_hid = BNXT_ULP_CLASS_HID_4118a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 8053129984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1366] = {
	.class_hid = BNXT_ULP_CLASS_HID_400c8,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 8053132032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1367] = {
	.class_hid = BNXT_ULP_CLASS_HID_50088,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 8053392128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1368] = {
	.class_hid = BNXT_ULP_CLASS_HID_51088,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 8053394176UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1369] = {
	.class_hid = BNXT_ULP_CLASS_HID_4984a,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 8053654272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1370] = {
	.class_hid = BNXT_ULP_CLASS_HID_48888,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 8053656320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1371] = {
	.class_hid = BNXT_ULP_CLASS_HID_58888,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 8053916416UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1372] = {
	.class_hid = BNXT_ULP_CLASS_HID_587ca,
	.class_tid = 2,
	.hdr_sig_id = 12,
	.flow_sig_id = 8053918464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_SRC_PORT |
		BNXT_ULP_HF_0_2_12_BITMASK_I_UDP_DST_PORT }
	},
	[1373] = {
	.class_hid = BNXT_ULP_CLASS_HID_10690,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 265216UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI }
	},
	[1374] = {
	.class_hid = BNXT_ULP_CLASS_HID_112b0,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 273408UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI }
	},
	[1375] = {
	.class_hid = BNXT_ULP_CLASS_HID_1428c,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 1313792UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC }
	},
	[1376] = {
	.class_hid = BNXT_ULP_CLASS_HID_15eac,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 1321984UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC }
	},
	[1377] = {
	.class_hid = BNXT_ULP_CLASS_HID_1249e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2362368UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC }
	},
	[1378] = {
	.class_hid = BNXT_ULP_CLASS_HID_130be,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2370560UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC }
	},
	[1379] = {
	.class_hid = BNXT_ULP_CLASS_HID_16f7a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 3410944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC }
	},
	[1380] = {
	.class_hid = BNXT_ULP_CLASS_HID_17c9a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 3419136UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC }
	},
	[1381] = {
	.class_hid = BNXT_ULP_CLASS_HID_1119a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2147748864UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1382] = {
	.class_hid = BNXT_ULP_CLASS_HID_10c58,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2147757056UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1383] = {
	.class_hid = BNXT_ULP_CLASS_HID_15c7e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2148797440UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1384] = {
	.class_hid = BNXT_ULP_CLASS_HID_1483c,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2148805632UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1385] = {
	.class_hid = BNXT_ULP_CLASS_HID_13f88,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2149846016UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1386] = {
	.class_hid = BNXT_ULP_CLASS_HID_12a4e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2149854208UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1387] = {
	.class_hid = BNXT_ULP_CLASS_HID_17a6c,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2150894592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1388] = {
	.class_hid = BNXT_ULP_CLASS_HID_1762a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 2150902784UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR }
	},
	[1389] = {
	.class_hid = BNXT_ULP_CLASS_HID_11b46,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 4295232512UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1390] = {
	.class_hid = BNXT_ULP_CLASS_HID_11704,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 4295240704UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1391] = {
	.class_hid = BNXT_ULP_CLASS_HID_147c4,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 4296281088UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1392] = {
	.class_hid = BNXT_ULP_CLASS_HID_153e4,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 4296289280UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1393] = {
	.class_hid = BNXT_ULP_CLASS_HID_13934,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 4297329664UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1394] = {
	.class_hid = BNXT_ULP_CLASS_HID_135f6,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 4297337856UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1395] = {
	.class_hid = BNXT_ULP_CLASS_HID_165ce,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 4298378240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1396] = {
	.class_hid = BNXT_ULP_CLASS_HID_171ee,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 4298386432UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1397] = {
	.class_hid = BNXT_ULP_CLASS_HID_116ee,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 6442716160UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1398] = {
	.class_hid = BNXT_ULP_CLASS_HID_102ac,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 6442724352UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1399] = {
	.class_hid = BNXT_ULP_CLASS_HID_152ce,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 6443764736UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1400] = {
	.class_hid = BNXT_ULP_CLASS_HID_14e8c,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 6443772928UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1401] = {
	.class_hid = BNXT_ULP_CLASS_HID_134dc,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 6444813312UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1402] = {
	.class_hid = BNXT_ULP_CLASS_HID_1209e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 6444821504UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1403] = {
	.class_hid = BNXT_ULP_CLASS_HID_170bc,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 6445861888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1404] = {
	.class_hid = BNXT_ULP_CLASS_HID_16b7e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 6445870080UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR }
	},
	[1405] = {
	.class_hid = BNXT_ULP_CLASS_HID_119ae,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 8590199808UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1406] = {
	.class_hid = BNXT_ULP_CLASS_HID_1146a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 8590208000UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1407] = {
	.class_hid = BNXT_ULP_CLASS_HID_14426,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 8591248384UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1408] = {
	.class_hid = BNXT_ULP_CLASS_HID_15046,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 8591256576UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1409] = {
	.class_hid = BNXT_ULP_CLASS_HID_1263a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 8592296960UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1410] = {
	.class_hid = BNXT_ULP_CLASS_HID_1325a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 8592305152UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1411] = {
	.class_hid = BNXT_ULP_CLASS_HID_16216,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 8593345536UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1412] = {
	.class_hid = BNXT_ULP_CLASS_HID_17e36,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 8593353728UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1413] = {
	.class_hid = BNXT_ULP_CLASS_HID_1133e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 10737683456UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1414] = {
	.class_hid = BNXT_ULP_CLASS_HID_10ffa,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 10737691648UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1415] = {
	.class_hid = BNXT_ULP_CLASS_HID_15f1a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 10738732032UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1416] = {
	.class_hid = BNXT_ULP_CLASS_HID_14bee,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 10738740224UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1417] = {
	.class_hid = BNXT_ULP_CLASS_HID_1312a,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 10739780608UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1418] = {
	.class_hid = BNXT_ULP_CLASS_HID_12dea,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 10739788800UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1419] = {
	.class_hid = BNXT_ULP_CLASS_HID_17d1e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 10740829184UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1420] = {
	.class_hid = BNXT_ULP_CLASS_HID_169de,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 10740837376UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1421] = {
	.class_hid = BNXT_ULP_CLASS_HID_11ee6,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 12885167104UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1422] = {
	.class_hid = BNXT_ULP_CLASS_HID_10abe,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 12885175296UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1423] = {
	.class_hid = BNXT_ULP_CLASS_HID_15ade,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 12886215680UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1424] = {
	.class_hid = BNXT_ULP_CLASS_HID_1569e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 12886223872UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1425] = {
	.class_hid = BNXT_ULP_CLASS_HID_13cee,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 12887264256UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1426] = {
	.class_hid = BNXT_ULP_CLASS_HID_128ae,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 12887272448UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1427] = {
	.class_hid = BNXT_ULP_CLASS_HID_1676e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 12888312832UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1428] = {
	.class_hid = BNXT_ULP_CLASS_HID_1748e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 12888321024UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1429] = {
	.class_hid = BNXT_ULP_CLASS_HID_1098e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 15032650752UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1430] = {
	.class_hid = BNXT_ULP_CLASS_HID_1044e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 15032658944UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1431] = {
	.class_hid = BNXT_ULP_CLASS_HID_1546e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 15033699328UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1432] = {
	.class_hid = BNXT_ULP_CLASS_HID_1402e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 15033707520UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1433] = {
	.class_hid = BNXT_ULP_CLASS_HID_1367e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 15034747904UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1434] = {
	.class_hid = BNXT_ULP_CLASS_HID_1223e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 15034756096UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1435] = {
	.class_hid = BNXT_ULP_CLASS_HID_1725e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 15035796480UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1436] = {
	.class_hid = BNXT_ULP_CLASS_HID_16e1e,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 15035804672UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_SRC_PORT }
	},
	[1437] = {
	.class_hid = BNXT_ULP_CLASS_HID_1172f,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 17180134400UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1438] = {
	.class_hid = BNXT_ULP_CLASS_HID_103ed,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 17180142592UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1439] = {
	.class_hid = BNXT_ULP_CLASS_HID_1530b,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 17181182976UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1440] = {
	.class_hid = BNXT_ULP_CLASS_HID_14fc9,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 17181191168UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1441] = {
	.class_hid = BNXT_ULP_CLASS_HID_1351d,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 17182231552UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1442] = {
	.class_hid = BNXT_ULP_CLASS_HID_121db,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 17182239744UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1443] = {
	.class_hid = BNXT_ULP_CLASS_HID_171f9,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 17183280128UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1444] = {
	.class_hid = BNXT_ULP_CLASS_HID_16db7,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 17183288320UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1445] = {
	.class_hid = BNXT_ULP_CLASS_HID_102bf,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 19327618048UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1446] = {
	.class_hid = BNXT_ULP_CLASS_HID_11edf,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 19327626240UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1447] = {
	.class_hid = BNXT_ULP_CLASS_HID_14e9b,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 19328666624UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1448] = {
	.class_hid = BNXT_ULP_CLASS_HID_15abb,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 19328674816UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1449] = {
	.class_hid = BNXT_ULP_CLASS_HID_120ad,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 19329715200UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1450] = {
	.class_hid = BNXT_ULP_CLASS_HID_13ccd,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 19329723392UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1451] = {
	.class_hid = BNXT_ULP_CLASS_HID_16c89,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 19330763776UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1452] = {
	.class_hid = BNXT_ULP_CLASS_HID_1675f,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 19330771968UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1453] = {
	.class_hid = BNXT_ULP_CLASS_HID_10c67,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 21475101696UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1454] = {
	.class_hid = BNXT_ULP_CLASS_HID_11987,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 21475109888UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1455] = {
	.class_hid = BNXT_ULP_CLASS_HID_1485f,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 21476150272UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF_0_2_13_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF_0_2_13_BITMASK_I_IPV4_DST_ADDR |
		BNXT_ULP_HF_0_2_13_BITMASK_I_UDP_DST_PORT }
	},
	[1456] = {
	.class_hid = BNXT_ULP_CLASS_HID_1441d,
	.class_tid = 2,
	.hdr_sig_id = 13,
	.flow_sig_id = 21476158464UL,
	.flow_pattern_id = 1,
	.app_sig = 0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXL