/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={CallableStatement.class, PreparedStatement.class, Statement.class, OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class, oracle.jdbc.internal.OracleCallableStatement.class, oracle.jdbc.internal.OraclePreparedStatement.class, oracle.jdbc.internal.OracleStatement.class})
public abstract class NonTxnReplayableStatement
extends NonTxnReplayableBase
implements Replayable {
    private static final String STMT_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableStatement";
    private static Logger STMT_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected void preForExecute(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        try {
            oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleStatement.SqlKind sqlKind = oracleStatement.getSqlKind();
            STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
            if (sqlKind.isSELECT() || sqlKind.isPlsqlOrCall() || sqlKind == OracleStatement.SqlKind.ALTER_SESSION || sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                this.preForAll(method, object, objectArray);
            } else if (sqlKind.isDML()) {
                if (this.failoverMngr != null) {
                    this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
                } else {
                    STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
                }
            } else if (sqlKind.isOTHER()) {
                if (this.failoverMngr != null) {
                    this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
                } else {
                    STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
                }
            }
        }
        catch (SQLException sQLException) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sQLException});
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preForExecuteUpdate(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, preForExecuteUpdate", this);
        try {
            oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleStatement.SqlKind sqlKind = oracleStatement.getSqlKind();
            STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
            if (sqlKind.isPlsqlOrCall()) {
                this.preForAll(method, object, objectArray);
            } else if (this.failoverMngr != null) {
                this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
            } else {
                STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
            }
        }
        catch (SQLException sQLException) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sQLException});
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeBatch", args={})})
    protected void preForExecuteBatch(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, preForExecuteBatch", this);
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="setAsciiStream", args={String.class, InputStream.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class})})
    protected void preForSetStreams(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, preForSetStreams", this);
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
        }
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected boolean postForExecute(Method method, boolean bl) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingExecutes(method, bl, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplayingExecutes(method, bl, null);
            }
        }
        return bl;
    }

    @Post
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected int postForExecuteUpdate(Method method, int n2) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingExecutes(method, n2, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplayingExecutes(method, n2, null);
            }
        }
        return n2;
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected ResultSet postForExecuteQuery(Method method, ResultSet resultSet) {
        Object object;
        if (resultSet instanceof NonTxnReplayableBase) {
            object = (NonTxnReplayableBase)((Object)resultSet);
            ((NonTxnReplayableBase)object).setFailoverManager(this.getFailoverManager());
        }
        object = this.failoverMngr.getReplayLifecycle();
        switch (1.$SwitchMap$oracle$jdbc$replay$driver$FailoverManagerImpl$ReplayLifecycle[((Enum)object).ordinal()]) {
            case 1: 
            case 2: {
                this.doPostWhenRecordingExecutes(method, resultSet, null);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                this.doPostWhenReplayingExecutes(method, resultSet, null);
            }
        }
        return resultSet;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.doPostWhenRecordingClose(method, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
        }
        this.isClosedAndNoReplay = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onErrorVoidForClose(Method method, SQLException sQLException) throws SQLException {
        if (sQLException instanceof SQLRecoverableException) {
            return;
        }
        super.onErrorVoidForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected boolean onErrorForExecute(Method method, SQLException sQLException) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw sQLException;
        }
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (sQLException instanceof SQLRecoverableException && replayLifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            try {
                oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                OracleStatement.SqlKind sqlKind = oracleStatement.getSqlKind();
                STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
                if (sqlKind.isPlsqlOrCall()) {
                    STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, last call is PL/SQL", this);
                    this.failoverMngr.disableReplayInternal(method, 373, "Replay disabled because outage occurred during PL/SQL execution", null);
                } else if (sqlKind.isDML()) {
                    if (this.failoverMngr != null) {
                        this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
                    } else {
                        STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
                    }
                } else if (sqlKind.isOTHER() && sqlKind != OracleStatement.SqlKind.ALTER_SESSION) {
                    if (this.failoverMngr != null) {
                        this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
                    } else {
                        STMT_REPLAY_LOGGER.log(Level.SEVERE, "On statement {0}, failover manager not set", this);
                    }
                }
            }
            catch (SQLException sQLException2) {
                STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sQLException2});
            }
        }
        return (Boolean)super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) throws SQLException {
        oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
        long l2 = oracleStatement.getChecksum();
        String string = callHistoryEntry == null || callHistoryEntry.method == null ? "NULL METHOD" : callHistoryEntry.method.getName();
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On proxy {0}, method {1}, filling in checksum: {2}", new Object[]{callHistoryEntry.jdbcProxy, string, l2});
        this.failoverMngr.update(this, callHistoryEntry, callHistoryEntry.result, callHistoryEntry.callStatus, l2, callHistoryEntry.scn, callHistoryEntry.callException);
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (callHistoryEntry.scn != -1L) {
            oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            oracleStatement.setSnapshotSCN(callHistoryEntry.scn);
            String string = callHistoryEntry == null || callHistoryEntry.method == null ? "NULL METHOD" : callHistoryEntry.method.getName();
            STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, replaying method {1}, set original SCN: {2}", new Object[]{callHistoryEntry.jdbcProxy, string, callHistoryEntry.scn});
        }
        return super.replayOneCall(callHistoryEntry, sQLRecoverableException);
    }

    @Override
    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
        try {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case REPLAYING: {
                    if (this.replayingCallEntry.checksum == 0L) break;
                    oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    long l2 = oracleStatement.getChecksum();
                    String string = this.replayingCallEntry == null || this.replayingCallEntry.method == null ? "NULL METHOD" : this.replayingCallEntry.method.getName();
                    STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", new Object[]{this.replayingCallEntry.jdbcProxy, string, l2, this.replayingCallEntry.checksum});
                    if (this.replayingCallEntry.checksum != l2) {
                        this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 386, "Replay failed because of checksum mismatch", this.originalError);
                    }
                    break;
                }
            }
        }
        catch (SQLException sQLException2) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, doPostWhenReplaying exception: {1}", new Object[]{this, sQLException2});
        }
    }

    protected void doPostWhenReplayingExecutes(Method method, Object object, SQLException sQLException) {
        try {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case REPLAYING: {
                    this.doPostWhenReplaying(method, object, sQLException);
                    break;
                }
                case REPLAYING_LASTCALL: {
                    oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    OracleStatement.SqlKind sqlKind = oracleStatement.getSqlKind();
                    if (!sqlKind.isPlsqlOrCall()) break;
                    STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, last call is PL/SQL", this.replayingCallEntry.jdbcProxy);
                    this.failoverMngr.disableReplayInternal(this.replayingCallEntry.method, 373, "Replay disabled because outage occurred during PL/SQL execution", this.originalError);
                }
            }
        }
        catch (SQLException sQLException2) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, doPostWhenReplayingExecutes exception: {1}", new Object[]{this, sQLException2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean okToPurgeSameProxyList() {
        boolean bl;
        block7: {
            bl = false;
            try {
                oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                OracleStatement.SqlKind sqlKind = oracleStatement.getSqlKind();
                if (sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                    bl = true;
                    break block7;
                }
                if (!sqlKind.isSELECT() || sqlKind == OracleStatement.SqlKind.SELECT_FOR_UPDATE) break block7;
                FailoverManagerImpl.CallHistoryEntry callHistoryEntry = this.headSameProxy;
                while (callHistoryEntry != null) {
                    String string;
                    String string2 = string = callHistoryEntry.method == null ? "NULL METHOD" : callHistoryEntry.method.getName();
                    if (("execute".equals(string) || "executeQuery".equals(string)) && callHistoryEntry.scn > 0L) {
                        bl = true;
                        break;
                    }
                    callHistoryEntry = callHistoryEntry.nextEntrySameProxy;
                }
            }
            catch (SQLException sQLException) {
                try {
                    STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sQLException});
                    bl = false;
                }
                catch (Throwable throwable) {
                    STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, bl});
                    return bl;
                }
                STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, bl});
                return bl;
            }
        }
        STMT_REPLAY_LOGGER.log(Level.FINEST, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, bl});
        return bl;
    }

    protected void doPostWhenRecordingClose(Method method, SQLException sQLException) {
        if (this.okToPurgeSameProxyList()) {
            this.purgeSameProxyList();
        }
    }

    protected void doPostWhenRecordingExecutes(Method method, Object object, SQLException sQLException) {
        try {
            String string;
            oracle.jdbc.internal.OracleStatement oracleStatement = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            OracleConnection oracleConnection = (OracleConnection)oracleStatement.getConnection();
            OracleStatement.SqlKind sqlKind = oracleStatement.getSqlKind();
            long l2 = 0L;
            long l3 = -1L;
            String string2 = string = method == null ? "NULL METHOD" : method.getName();
            if (sqlKind.isSELECT() || sqlKind.isPlsqlOrCall() || sqlKind == OracleStatement.SqlKind.ALTER_SESSION) {
                EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
                STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, method {1}, transaction state: {2}", new Object[]{this, string, enumSet});
                if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_INTENTION) || enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                    this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of transaction", null);
                } else {
                    l2 = 0L;
                    if (!this.failoverMngr.isReplayInCurrentMode() && sqlKind.isPlsqlOrCall()) {
                        this.failoverMngr.setReplayInCurrentMode();
                    }
                    l3 = this.failoverMngr.isReplayInCurrentMode() ? -1L : oracleConnection.getCurrentSCN();
                    STMT_REPLAY_LOGGER.log(Level.FINER, "On proxy {0}, method {1}, SCN to record: {2}", new Object[]{this, string, l3});
                }
                if (this.failoverMngr.getReplayLifecycle() == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    this.failoverMngr.update(this, null, object, "completed", l2, l3, sQLException);
                }
            } else {
                this.failoverMngr.update(this, null, object, "completed", l2, l3, sQLException);
                this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
            }
        }
        catch (SQLException sQLException2) {
            STMT_REPLAY_LOGGER.log(Level.WARNING, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sQLException2});
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() {
        return (Connection)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return (T)this.getDelegate();
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract ResultSet executeQuery(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract ResultSet executeQuery() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Array getArray(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Array getArray(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Blob getBlob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Blob getBlob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Clob getClob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Clob getClob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract NClob getNClob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract NClob getNClob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Ref getRef(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Ref getRef(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract RowId getRowId(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract RowId getRowId(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Struct getStruct(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Struct getStruct(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract SQLXML getSQLXML(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract SQLXML getSQLXML(String var1) throws SQLException;

    static {
        if (STMT_REPLAY_LOGGER == null) {
            STMT_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(STMT_FEATURE_LOGGER_NAME);
        }
    }
}

