/* key_data.h
 *
 * Copyright (C) 2006-2021 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */
#include "key_data.h"
#include "wolfssl_demo.h"

/*******************************************************************************
 * SCE Key Information
 *******************************************************************************/
const st_user_key_block_data_t g_key_block_data =
{
    /* uint8_t encrypted_provisioning_key[R_TSIP_AES_CBC_IV_BYTE_SIZE * 2]; */
    {
        0xE7, 0x1C, 0xEB, 0xCA, 0x3A, 0x64, 0x0B, 0xD2, 0xC5, 0xB8, 0xF2, 0xD0, 
        0xF7, 0x1B, 0xA9, 0x4A, 0x98, 0xFF, 0xF3, 0x48, 0x81, 0xAD, 0xAF, 0x63, 
        0x19, 0x24, 0x4B, 0x2B, 0xC0, 0x8B, 0x9C, 0x6B
    },
    /* uint8_t iv[R_TSIP_AES_CBC_IV_BYTE_SIZE]; */
    {
        0xD7, 0x97, 0x56, 0x82, 0x5B, 0x4B, 0x7F, 0xB2, 0x1C, 0x1F, 0xEE, 0x85, 
        0x02, 0xC5, 0xD0, 0xBA
    },
    /* uint8_t encrypted_user_rsa2048_ne_key[R_TSIP_RSA2048_NE_KEY_BYTE_SIZE + 16]; */
    {
        0x3F, 0xA5, 0xBE, 0xBF, 0x86, 0xEC, 0x23, 0x37, 0x82, 0x37, 0x71, 0x0C, 
        0x83, 0xA7, 0x8E, 0x86, 0xF0, 0x16, 0xD3, 0x7B, 0xF1, 0x25, 0xA4, 0x37, 
        0x7A, 0x2D, 0x16, 0xF2, 0xFF, 0x3D, 0xEE, 0x46, 0xE0, 0x05, 0x58, 0x56, 
        0xC2, 0xE7, 0x9D, 0x2C, 0x01, 0x84, 0x59, 0x8E, 0xA8, 0x9E, 0xEE, 0x3F,
        0x22, 0x83, 0x68, 0xDA, 0x9E, 0xCE, 0xEA, 0x99, 0xFD, 0xAF, 0xDF, 0x67,
        0x1E, 0x73, 0x25, 0x68, 0xBF, 0x0A, 0xDF, 0xAF, 0xC4, 0x3D, 0xF1, 0xBD, 
        0x41, 0xF5, 0xAC, 0xAC, 0xA4, 0x36, 0xF8, 0x96, 0xC0, 0x8C, 0x2F, 0x1A, 
        0x79, 0x75, 0x28, 0xAE, 0x67, 0xC9, 0x5A, 0xDE, 0x2A, 0xB4, 0x99, 0xDB,
        0x8C, 0x25, 0x53, 0x58, 0x8C, 0xDC, 0xA8, 0x0D, 0xFE, 0xEE, 0x0F, 0x6C, 
        0x61, 0xE6, 0x43, 0x66, 0xE8, 0x4A, 0xE3, 0xEB, 0xAB, 0xA2, 0x52, 0xE4, 
        0x67, 0xC2, 0x9A, 0x57, 0xA4, 0x1F, 0xE0, 0xFC, 0x2B, 0xBE, 0x25, 0xBF, 
        0xF0, 0x70, 0x18, 0x88, 0x93, 0xB7, 0x2F, 0x74, 0xF8, 0xF3, 0x88, 0xB8,
        0xFA, 0x18, 0xBE, 0xC1, 0xB2, 0x24, 0x4B, 0xBC, 0x89, 0x2D, 0xC4, 0x02, 
        0xB3, 0x82, 0xEC, 0xDB, 0xC9, 0xF0, 0xA9, 0xC3, 0x30, 0x7C, 0xF5, 0x15, 
        0xEB, 0x9B, 0x16, 0x8C, 0x9D, 0xEF, 0x42, 0x8A, 0xCA, 0x5D, 0x28, 0xDF, 
        0x68, 0xEA, 0xE0, 0xB8, 0x76, 0x7C, 0xBB, 0x4A, 0x51, 0xDD, 0x55, 0x14,
        0xB7, 0xAB, 0xD2, 0xF1, 0xB9, 0x51, 0x19, 0x05, 0x26, 0x87, 0xF7, 0x5C, 
        0x69, 0x45, 0x3C, 0x82, 0xE8, 0x82, 0x05, 0x5D, 0x33, 0x8E, 0xD1, 0x42, 
        0x71, 0xD6, 0x96, 0xDA, 0xAB, 0xB8, 0xC0, 0x0F, 0xF7, 0x85, 0x8A, 0x12, 
        0xEF, 0xB9, 0x53, 0xFF, 0xD2, 0x95, 0x18, 0x2F, 0x0C, 0xA6, 0x72, 0x98,
        0xC3, 0xC6, 0x9B, 0x95, 0x70, 0x69, 0xC5, 0xB7, 0xD5, 0x24, 0x77, 0x05, 
        0xD0, 0x68, 0x85, 0x36, 0xB8, 0x57, 0xE3, 0xED, 0x2E, 0x4D, 0x95, 0xD3, 
        0xFC, 0x24, 0x1B, 0x22, 0xFA, 0x43, 0xD8, 0x62, 0x28, 0x57, 0x6B, 0x34, 
        0xBF, 0xD1, 0x63, 0x4B, 0xB5, 0xF5, 0x88, 0xBC, 0xB8, 0x69, 0xF3, 0xB5
    },
};

#ifndef USE_CERT_BUFFERS_256
/* ca-cert.der.sign,  
 * ca-cert.der signed by RSA2048 PSS with SHA256 
 * This is used for Root Certificate verify by SCE */
const unsigned char ca_cert_der_sign[] =
{
        0x07, 0x1A, 0x68, 0xF4, 0x53, 0x2A, 0x9B, 0x1F, 0xF7, 0x7B,
        0x5C, 0x70, 0x88, 0x46, 0x03, 0x10, 0x35, 0x0C, 0x84, 0x4F,
        0xDC, 0x09, 0x8D, 0xD8, 0x97, 0x10, 0xFA, 0xC7, 0x1D, 0x7F,
        0xCC, 0xF2, 0xC9, 0x41, 0x27, 0xBA, 0x0C, 0x93, 0x77, 0x64,
        0x46, 0x89, 0xC3, 0x36, 0x45, 0x5B, 0x2E, 0xC7, 0xCF, 0xE7,
        0xDF, 0x61, 0x95, 0x12, 0x7B, 0x9B, 0x6B, 0x8B, 0xD8, 0xBD,
        0xEA, 0x7B, 0xCD, 0xF9, 0x74, 0xA1, 0x1B, 0x41, 0x91, 0x9D,
        0xC8, 0x08, 0xBA, 0xA4, 0x69, 0x19, 0xAD, 0xE0, 0x41, 0x54,
        0xC6, 0x1A, 0x4A, 0x0E, 0xDB, 0x36, 0x23, 0xD9, 0xAC, 0xF6,
        0x1B, 0x49, 0x6D, 0x74, 0x4D, 0x67, 0x5D, 0x36, 0xB9, 0xED,
        0xC6, 0x09, 0x25, 0x13, 0x3A, 0x88, 0x3D, 0x83, 0x41, 0x16,
        0x49, 0x94, 0xC5, 0x24, 0xFC, 0xD4, 0x81, 0xAE, 0x3F, 0x03,
        0x1D, 0x9D, 0x76, 0x1F, 0x44, 0x1A, 0x91, 0xFB, 0xD7, 0x7E,
        0xB7, 0x29, 0xA3, 0x73, 0x4D, 0x72, 0x21, 0xE4, 0x70, 0x02,
        0x6F, 0xBE, 0xE0, 0x73, 0x5F, 0x44, 0x91, 0x34, 0xBC, 0x5B,
        0x93, 0x27, 0x37, 0x05, 0x48, 0x19, 0x3B, 0x50, 0x19, 0x53,
        0xC0, 0xE9, 0xA1, 0x1C, 0x26, 0xA5, 0x16, 0x80, 0xE8, 0x61,
        0x39, 0xFF, 0x8B, 0x52, 0x10, 0xF7, 0x6B, 0x7A, 0x8F, 0xEC,
        0x95, 0x1B, 0x30, 0xA4, 0xA0, 0xD7, 0xDB, 0x3F, 0xEB, 0xA5,
        0x74, 0x48, 0xBA, 0x34, 0xB3, 0x34, 0xA5, 0xC1, 0x46, 0x65,
        0x2E, 0xEA, 0xF1, 0xB9, 0x00, 0xF6, 0x13, 0xC9, 0x15, 0xC6,
        0xB0, 0x4A, 0x18, 0xA8, 0x10, 0x57, 0xDF, 0x8E, 0x09, 0x67,
        0xCC, 0xCA, 0x03, 0x15, 0x04, 0x17, 0x0A, 0xAC, 0x47, 0x8F,
        0x1B, 0x0F, 0x0B, 0x6C, 0x91, 0x98, 0xFF, 0xFD, 0xC5, 0x10,
        0x3F, 0x0A, 0xE7, 0x5D, 0x48, 0xE1, 0xD9, 0x79, 0xEB, 0xEA,
        0x8D, 0x03, 0x96, 0x44, 0xB0, 0x0B
};

const int sizeof_ca_cert_der_sign = sizeof(ca_cert_der_sign);
#else
/* ca-ecc-cert.der.sign,  
 * ca-ecc-cert.der signed by RSA2048 PSS with SHA256 
 * This is used for Root Certificate verify by SCE
 */
const unsigned char ca_ecc_cert_der_sign[] =
{
        0x07, 0xCA, 0x3B, 0x8F, 0x49, 0x26, 0x33, 0x80, 0x46, 0xFE,
        0x07, 0x91, 0x75, 0x5B, 0xC3, 0x98, 0x5F, 0x0E, 0x93, 0x0B,
        0xDF, 0x1B, 0x1B, 0x01, 0x00, 0xD0, 0x5A, 0x48, 0x81, 0x05,
        0xFC, 0x57, 0xB6, 0x0F, 0xF4, 0x6E, 0x4E, 0x7D, 0xB4, 0x14,
        0x88, 0xFF, 0x8D, 0x75, 0x7A, 0xF5, 0xDE, 0x7B, 0x74, 0xF0,
        0x98, 0x0B, 0xE2, 0x7A, 0xCB, 0xF3, 0x41, 0x70, 0xBC, 0xE2,
        0x07, 0xF7, 0x3D, 0x69, 0xAF, 0xA8, 0xDA, 0xC5, 0x92, 0xAA,
        0xE6, 0xA6, 0xF9, 0x1A, 0xED, 0x12, 0x76, 0x06, 0x1E, 0x4D,
        0x43, 0xD9, 0x27, 0xEF, 0x30, 0x3D, 0x07, 0xAF, 0x63, 0x39,
        0x3F, 0x95, 0x5F, 0xA5, 0x54, 0xFC, 0x26, 0x52, 0xFB, 0xDC,
        0x8C, 0xA6, 0x64, 0x20, 0x39, 0x35, 0x6A, 0xB9, 0xFD, 0x52,
        0x81, 0xAE, 0x56, 0x52, 0x61, 0xDD, 0xC0, 0xCE, 0x92, 0x4F,
        0xEC, 0x0C, 0x72, 0x28, 0x2E, 0x3E, 0xB3, 0x29, 0xAA, 0x8B,
        0xF1, 0xE9, 0xC7, 0x40, 0x57, 0x3C, 0xF1, 0x5D, 0xA8, 0x43,
        0x17, 0xDB, 0x6A, 0x88, 0x36, 0x1E, 0x84, 0x88, 0xA4, 0x5D,
        0x20, 0x64, 0xD5, 0x7D, 0x48, 0x72, 0xF5, 0x1E, 0x50, 0xF7,
        0xB5, 0x49, 0x07, 0xD3, 0x9C, 0xB8, 0x2C, 0x0E, 0x9D, 0x0E,
        0x4F, 0xFA, 0xB8, 0xCC, 0x4E, 0x14, 0xFD, 0xC1, 0xA4, 0x8E,
        0x6F, 0x57, 0xA8, 0x75, 0x29, 0x25, 0xD3, 0x93, 0xD6, 0xF0,
        0x22, 0xE6, 0x1A, 0x73, 0x51, 0xFA, 0x92, 0x3D, 0x0A, 0x04,
        0xCB, 0x62, 0x8C, 0x9E, 0x50, 0x65, 0x11, 0x2A, 0xB9, 0xB8,
        0x8B, 0x5C, 0x86, 0x6C, 0x37, 0x96, 0x5F, 0xEE, 0x50, 0xC0,
        0x30, 0x9E, 0x54, 0x9E, 0xB5, 0xD8, 0xBB, 0xC5, 0x1B, 0x16,
        0xB6, 0x54, 0x6B, 0x5E, 0xA4, 0x54, 0xA7, 0x04, 0xB3, 0x30,
        0x7E, 0xE9, 0xB0, 0xAB, 0x10, 0x95, 0x6C, 0xE5, 0x76, 0x75,
        0x5B, 0x52, 0xFB, 0x37, 0x4E, 0x23
};
static const int sizeof_ca_ecc_cert_der_sign = sizeof(ca_ecc_cert_der_sign);
#endif /*  USE_CERT_BUFFERS_256 */
