#pragma once
#include "Options.h"
#include "Image.h"

namespace graphics {

	/**
	 * JPEG options.
	 */
	class JPEGOptions : public FormatOptions {
		STORM_CLASS;
	public:
		// Create, default options.
		STORM_CTOR JPEGOptions();

		// Create, specify image.
		STORM_CTOR JPEGOptions(Nat quality);

		// Quality of the image (0-100).
		// Note: This value is *not* updated when loading an image. It is not stored in the file itself.
		Nat quality;

		// Load an image, set options.
		virtual Image *STORM_FN load(IStream *from);
		using FormatOptions::load;

		// Save an image according to options.
		virtual void STORM_FN save(Image *image, OStream *to);
		using FormatOptions::save;

		// Output.
		virtual void STORM_FN toS(StrBuf *to) const;
	};


	// Create an ImageFormat. For internal use.
	ImageFormat *jpegFormat(Engine &e);

}
